/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.JournalSyncHepler;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.business.journal.AbstractBookJournalBuilder;
import kd.fi.cas.business.journal.BookJournalLogger;
import kd.fi.cas.business.journal.JournalEntryInfo;
import kd.fi.cas.business.journal.JournalInfo;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SimpleBeanFactory;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.helper.VoucherBookHelper;
import kd.fi.cas.util.EmptyUtil;

public class VoucherBookJournalBuilder
extends AbstractBookJournalBuilder {
    private VoucherBookHelper voucherBookHelper = (VoucherBookHelper)SimpleBeanFactory.getBean(VoucherBookHelper.class);
    private static final Log log = LogFactory.getLog(VoucherBookJournalBuilder.class);

    public void setConsistency(boolean isConsistency) {
        this.isConsistency = isConsistency;
    }

    @Override
    public List<JournalInfo> getJournalInfoList(DynamicObject voucher) {
        ArrayList<JournalInfo> journals = new ArrayList<JournalInfo>();
        DynamicObject bookType = voucher.getDynamicObject("booktype");
        DynamicObject org = voucher.getDynamicObject("org");
        boolean voucherBookJournal = SystemParameterHelper.isVoucherBookJournal((long)org.getLong("id"));
        boolean isVoucherMixBookJournal = SystemParameterHelper.isVoucherMixBookJournal((long)org.getLong("id"));
        String sourceType = voucher.getString("sourcetype");
        DynamicObject voucherSourceBill = voucher.getDynamicObject("sourcebilltype");
        String voucherSourceEntityName = "";
        if (voucherSourceBill != null) {
            voucherSourceEntityName = voucherSourceBill.getString("number");
        }
        boolean fromCashCount = "cas_cash_verification".equals(voucherSourceEntityName);
        if (!(voucherBookJournal || isVoucherMixBookJournal || fromCashCount)) {
            BookJournalLogger.log("not voucherbook " + voucher.getLong("id"));
            return journals;
        }
        if (isVoucherMixBookJournal && !JournalSyncHepler.isCheckVoucherMixBook(sourceType).booleanValue()) {
            BookJournalLogger.log("sourcetype not voucherbook " + voucher.getLong("id"));
            return journals;
        }
        if (!this.voucherBookHelper.isMainBookType(bookType)) {
            BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u4e0d\u5c5e\u4e8e\u4e3b\u8d26\u7c3f\uff1a%s\u3002", (String)"VoucherBookJournalBuilder_0", (String)"fi-cas-business", (Object[])new Object[0]), voucher.getLong("id")));
            return journals;
        }
        DynamicObject bill = null;
        HashMap<Long, Set<Long>> voucherBills = new HashMap<Long, Set<Long>>(8);
        if (!super.getIsValidata().booleanValue()) {
            bill = this.getSourceBill(voucher.getPkValue(), voucher.getDynamicObject("sourcebilltype"), voucherBills);
        }
        Map<String, String> map = JournalSyncHepler.getConfigMap();
        String bankCheckFlag = "";
        Date avdDate = null;
        Date pdDate = null;
        String feepayer = "";
        if (bill != null && map.containsKey(bill.getDataEntityType().getName())) {
            String entityName = bill.getDataEntityType().getName();
            String value = map.get(entityName);
            bankCheckFlag = bill.getString(value);
            if ("cas_paybill".equals(entityName)) {
                pdDate = bill.getDate("paydate");
                avdDate = bill.getDate("expectdate");
                feepayer = bill.getString("feepayer");
            }
            if ("cas_agentpaybill".equals(entityName)) {
                pdDate = bill.getDate("paytime");
            }
        }
        DynamicObjectCollection entry = voucher.getDynamicObjectCollection("entries");
        Set voucherEntryIds = entry.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)"gl_voucher").and("sourcebillid", "=", (Object)voucher.getLong("id")).and("sourcebillentryid", "in", voucherEntryIds).and("ischeck", "=", (Object)"1");
        DynamicObjectCollection bankJournals = QueryServiceHelper.query((String)"cas_bankjournal", (String)"sourcebillentryid", (QFilter[])filter.toArray());
        Set checkedVoucherEntryIds = bankJournals.stream().map(v -> v.getLong("sourcebillentryid")).collect(Collectors.toSet());
        boolean canSetPayeeInfo = this.isSetPayeeInfo(voucherBills, voucher);
        int i = 0;
        for (DynamicObject row : entry) {
            ++i;
            DynamicObject account = this.getAccount(row);
            if (account == null) {
                BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u7b2c%1$s%2$s", (String)"VoucherBookJournalBuilder_1", (String)"fi-cas-business", (Object[])new Object[0]), i, ResManager.loadKDString((String)"\u5206\u5f55\uff0c\u6838\u7b97\u7ef4\u5ea6\u4e0d\u662f\u94f6\u884c\u8d26\u6237\u6216\u8005\u73b0\u91d1\u8d26\u6237", (String)"VoucherBookJournalBuilder_2", (String)"fi-cas-business", (Object[])new Object[0])));
                continue;
            }
            JournalInfo journal = new JournalInfo();
            String accountType = account.getDataEntityType().getName();
            if ("bd_accountbanks".equals(accountType)) {
                journal.setAccountBank(account);
            } else if ("cas_accountcash".equals(accountType)) {
                journal.setAccountCash(account);
            } else {
                BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u7b2c%1$s%2$s", (String)"VoucherBookJournalBuilder_1", (String)"fi-cas-business", (Object[])new Object[0]), i, ResManager.loadKDString((String)"\u5206\u5f55\uff0c\u7c7b\u522b\u4e0d\u662f\u94f6\u884c\u8d26\u6237\u548c\u73b0\u91d1\u8d26\u6237", (String)"VoucherBookJournalBuilder_8", (String)"fi-cas-business", (Object[])new Object[0])));
                continue;
            }
            BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u8d26\u6237ID=%1$s,\u7ec4\u7ec7ID=%2$s", (String)"VoucherBookJournalBuilder_3", (String)"fi-cas-business", (Object[])new Object[0]), account.getPkValue(), org.getPkValue()));
            BigDecimal debitori = row.getBigDecimal("debitori");
            BigDecimal creditori = row.getBigDecimal("creditori");
            BigDecimal debitLocal = row.getBigDecimal("debitlocal");
            BigDecimal creditLocal = row.getBigDecimal("creditlocal");
            if (debitori.compareTo(BigDecimal.ZERO) == 0 && creditori.compareTo(BigDecimal.ZERO) == 0) {
                BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u7b2c%1$s%2$s", (String)"VoucherBookJournalBuilder_1", (String)"fi-cas-business", (Object[])new Object[0]), i, ResManager.loadKDString((String)"\u5206\u5f55\uff0c\u501f\u8d37\u65b9\u91d1\u989d\u4e3a0", (String)"VoucherBookJournalBuilder_10", (String)"fi-cas-business", (Object[])new Object[0])));
                continue;
            }
            if (checkedVoucherEntryIds.contains(row.getLong("id"))) {
                log.info("\u51ed\u8bc1\u5206\u5f55\u5df2\u5b58\u5728\u5df2\u52fe\u5bf9\u7684\u94f6\u884c\u5bf9\u8d26\u5355\uff1a" + row.getLong("id"));
                continue;
            }
            journal.setSourceBillTypeOfSourceBill(voucherSourceEntityName);
            journal.setBizDate(voucher.getDate("bizdate"));
            journal.setBookDate(voucher.getDate("bookeddate"));
            journal.setPreparationdate(voucher.getDate("createtime"));
            journal.setPd(pdDate);
            journal.setAvd(avdDate);
            journal.setFeepayer(feepayer);
            journal.setOrg(org);
            journal.setCurrency(row.getDynamicObject("currency"));
            journal.setDebitAmount(debitori);
            journal.setCreditAmount(creditori);
            journal.setExchangeRate(row.getBigDecimal("localrate"));
            journal.setDescription(row.getString("edescription"));
            journal.setSource(4);
            if (!CasHelper.isEmpty((Object)bankCheckFlag)) {
                journal.setBankCheckFlag(bankCheckFlag);
                journal.setBatchNo(bankCheckFlag);
                journal.setSynccheck("1");
            }
            BigDecimal amt = BigDecimal.ZERO;
            BigDecimal localAmount = BigDecimal.ZERO;
            if (CasHelper.isEmpty((Object)debitori)) {
                journal.setDirection(2);
                amt = creditori;
                localAmount = creditLocal;
            } else {
                journal.setDirection(1);
                amt = debitori;
                localAmount = debitLocal;
            }
            this.setValueBySouceBill(journal, bill, canSetPayeeInfo);
            journal.setLocalAmount(localAmount);
            journal.setSourceBillType("gl_voucher");
            journal.setSourceBillId((Long)voucher.getPkValue());
            journal.setSourceBillEntryId((Long)row.getPkValue());
            journal.setSourceBillNumber(voucher.getString("billno"));
            journal.setBillno(voucher.getString("billno"));
            String userId = RequestContext.get().getUserId();
            DynamicObject user = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_user"), (Object)userId);
            journal.setCashier(user);
            ArrayList<JournalEntryInfo> journalEntrys = new ArrayList<JournalEntryInfo>();
            JournalEntryInfo journalEntry = new JournalEntryInfo();
            journalEntry.setOppUnit("");
            journalEntry.setAmount(amt);
            journalEntry.setLocalAmount(localAmount);
            journalEntry.setFundFlowItem(null);
            journalEntrys.add(journalEntry);
            journal.setEntry(journalEntrys);
            journals.add(journal);
        }
        return journals;
    }

    @Override
    public List<JournalInfo> getJournalInfoList(DynamicObjectCollection billColl) {
        return null;
    }

    @Override
    public Map<Long, List<JournalInfo>> getJournalInfoLists(DynamicObjectCollection billColl, Map<Long, Exception> result) {
        long startTime = System.currentTimeMillis();
        log.info("getJournalInfoLists perform data start." + startTime);
        DynamicObject bill = null;
        HashMap<Object, Object> resultMapOfResource = new HashMap();
        HashMap<String, List<String>> resultMapOfResourceCheckFlag = new HashMap<String, List<String>>(6);
        HashMap<Long, Set<Long>> voucherBills = new HashMap<Long, Set<Long>>(8);
        if (!super.getIsValidata().booleanValue()) {
            resultMapOfResource = this.getSourceBills(billColl, resultMapOfResourceCheckFlag, voucherBills);
            if (resultMapOfResourceCheckFlag.size() < 5) {
                log.info("resultMapOfResourceCheckFlag is :" + SerializationUtils.toJsonString(resultMapOfResourceCheckFlag));
            }
        }
        HashSet<Long> accountsList = new HashSet<Long>();
        HashSet<String> assgrpsList = new HashSet<String>();
        HashSet<Long> orgIdSet = new HashSet<Long>();
        HashSet<Long> voucherIds = new HashSet<Long>(billColl.size());
        HashSet<Long> voucherEntryIds = new HashSet<Long>();
        for (DynamicObject bills : billColl) {
            orgIdSet.add(bills.getDynamicObject("org").getLong("id"));
            DynamicObjectCollection dynamicObjectCollection = bills.getDynamicObjectCollection("entries");
            voucherIds.add(bills.getLong("id"));
            for (DynamicObject entry : dynamicObjectCollection) {
                DynamicObject assgrp;
                voucherEntryIds.add(entry.getLong("id"));
                DynamicObject account = entry.getDynamicObject("account");
                if (null != account) {
                    accountsList.add(account.getLong("id"));
                }
                if (null == (assgrp = entry.getDynamicObject("assgrp")) || null == assgrp.getString("value")) continue;
                assgrpsList.add(assgrp.getString("value"));
            }
        }
        log.info("accountsList size:{},assgrpsList size:{}", (Object)accountsList.size(), (Object)assgrpsList.size());
        if (accountsList.size() > 0) {
            this.voucherBookHelper.getCachedAccountViewsBatch(accountsList, "bd_accountview");
        }
        HashMap<Long, Exception> resultOfAssgrp = new HashMap<Long, Exception>();
        if (assgrpsList.size() > 0) {
            Map errorMap = this.voucherBookHelper.readBasedatasByEntry(assgrpsList);
            this.fillErrorData(billColl, orgIdSet, resultOfAssgrp, errorMap);
        }
        long startTime1 = System.currentTimeMillis();
        log.info("getSystemParamsByOrgIds start:" + startTime1);
        Map systemParamsMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList<Long>(orgIdSet));
        Map orgInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIdSet);
        log.info("getSystemParamsByOrgIds end:" + (System.currentTimeMillis() - startTime1));
        String userId = RequestContext.get().getUserId();
        DynamicObject user = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_user"), (Object)userId);
        Map<String, String> map = JournalSyncHepler.getConfigMap();
        HashMap<Long, List<JournalInfo>> voucherJournalsMap = new HashMap<Long, List<JournalInfo>>();
        long startTime2 = System.currentTimeMillis();
        log.info("getJournalInfoLists perform data end that" + (startTime2 - startTime1));
        HashMap<Long, Boolean> bankRollOrgIdMap = new HashMap<Long, Boolean>(6);
        if (orgIdSet.size() > 0) {
            DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrg", (String)"bos_org", (String)"id,fisbankroll", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIdSet)}, null);
            while (ds.hasNext()) {
                Row row = ds.next();
                bankRollOrgIdMap.put(row.getLong("id"), row.getBoolean("fisbankroll"));
            }
            ds.close();
        }
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)"gl_voucher").and("sourcebillid", "in", voucherIds).and("sourcebillentryid", "in", voucherEntryIds).and("ischeck", "=", (Object)"1");
        DynamicObjectCollection bankJournals = QueryServiceHelper.query((String)"cas_bankjournal", (String)"sourcebillentryid", (QFilter[])filter.toArray());
        Set checkedVoucherEntryIds = bankJournals.stream().map(v -> v.getLong("sourcebillentryid")).collect(Collectors.toSet());
        for (DynamicObject voucher : billColl) {
            try {
                String error;
                DynamicObject bookType = voucher.getDynamicObject("booktype");
                DynamicObject org = voucher.getDynamicObject("org");
                boolean fisbankroll = bankRollOrgIdMap.getOrDefault(org.getLong("id"), false);
                if (!fisbankroll) {
                    String error2 = String.format(ResManager.loadKDString((String)"\u975e\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u767b\u8d26\u3002", (String)"VoucherBookJournalBuilder_7_1", (String)"fi-cas-business", (Object[])new Object[0]), voucher.getString("billno"));
                    BookJournalLogger.log(error2);
                    if (!this.isConsistency) continue;
                    result.put((Long)voucher.getPkValue(), (Exception)((Object)new KDBizException(error2)));
                    continue;
                }
                Map paraMap = (Map)systemParamsMap.get(org.get("id").toString());
                if (null == paraMap) {
                    String error3 = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u9002\u914d\u7cfb\u7edf\u53c2\u6570! %s", (String)"VoucherBookJournalBuilder_7_2", (String)"fi-cas-business", (Object[])new Object[0]), voucher.getString("billno"));
                    BookJournalLogger.log(error3);
                    if (!this.isConsistency) continue;
                    result.put((Long)voucher.getPkValue(), (Exception)((Object)new KDBizException(error3)));
                    continue;
                }
                Object voucherBookObject = paraMap.get("cs105");
                boolean voucherBookJournal = "1".equals(voucherBookObject);
                boolean isVoucherMixBookJournal = "3".equals(voucherBookObject);
                String sourceType = voucher.getString("sourcetype");
                DynamicObject voucherSourceBill = voucher.getDynamicObject("sourcebilltype");
                String voucherSourceEntityName = "";
                if (voucherSourceBill != null) {
                    voucherSourceEntityName = voucherSourceBill.getString("number");
                }
                Date voucherEnddate = voucher.getDynamicObject("period").getDate("enddate");
                DynamicObject orgInit = (DynamicObject)orgInitMap.get(org.get("id").toString());
                if (null == orgInit) {
                    String error4 = String.format(ResManager.loadKDString((String)"\u51fa\u7eb3\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\u4e3a\u7a7a\uff01%s", (String)"VoucherBookJournalBuilder_7_3", (String)"fi-cas-business", (Object[])new Object[0]), voucher.getString("billno"));
                    BookJournalLogger.log(error4);
                    if (!this.isConsistency) continue;
                    result.put((Long)voucher.getPkValue(), (Exception)((Object)new KDBizException(error4)));
                    continue;
                }
                DynamicObject startPeriod = orgInit.getDynamicObject("startperiod");
                if (null == startPeriod || null == startPeriod.getDate("begindate")) {
                    String error5 = String.format(ResManager.loadKDString((String)"\u51fa\u7eb3\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\u4e3a\u7a7a\uff01%s", (String)"VoucherBookJournalBuilder_7_3", (String)"fi-cas-business", (Object[])new Object[0]), voucher.getString("billno"));
                    BookJournalLogger.log(error5);
                    if (!this.isConsistency) continue;
                    result.put((Long)voucher.getPkValue(), (Exception)((Object)new KDBizException(error5)));
                    continue;
                }
                Date orgStartPeriodStartdate = startPeriod.getDate("begindate");
                if (voucherEnddate.before(orgStartPeriodStartdate)) {
                    error = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u6240\u5728\u671f\u95f4\u6700\u540e\u4e00\u5929\u4e0d\u80fd\u65e9\u4e8e\u8d44\u91d1\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\u7b2c\u4e00\u5929\uff01%s", (String)"VoucherBookJournalBuilder_15", (String)"fi-cas-business", (Object[])new Object[0]), voucher.getString("billno"));
                    BookJournalLogger.log(error);
                    if (!this.isConsistency) continue;
                    result.put((Long)voucher.getPkValue(), (Exception)((Object)new KDBizException(error)));
                    continue;
                }
                boolean fromCashCount = "cas_cash_verification".equals(voucherSourceEntityName);
                if (!voucherBookJournal && !isVoucherMixBookJournal) {
                    BookJournalLogger.log("not voucherbook " + voucher.getLong("id"));
                    error = ResManager.loadKDString((String)"\u975e\u51ed\u8bc1\u767b\u8d26\u4e14\u975e\u6df7\u5408\u767b\u8d26\u5219\u4e0d\u767b\u8d26", (String)"VoucherBookJournalBuilder_17", (String)"fi-cas-business", (Object[])new Object[0]);
                    BookJournalLogger.log(error);
                    if (!this.isConsistency) continue;
                    result.put((Long)voucher.getPkValue(), (Exception)((Object)new KDBizException(error)));
                    continue;
                }
                if (isVoucherMixBookJournal && !JournalSyncHepler.isCheckVoucherMixBook(sourceType).booleanValue()) {
                    BookJournalLogger.log("sourcetype not voucherbook " + voucher.getLong("id"));
                    error = ResManager.loadKDString((String)"\u4e0d\u5728\u201c\u5916\u90e8\u5bfc\u5165/\u624b\u5de5\u51ed\u8bc1/\u6a21\u5f0f\u51ed\u8bc1/\u626b\u63cf\u751f\u6210\u201d \u7684\u6df7\u5408\u767b\u8d26\u4e0d\u767b\u8d26\u3002", (String)"VoucherBookJournalBuilder_18", (String)"fi-cas-business", (Object[])new Object[0]);
                    BookJournalLogger.log(error);
                    if (!this.isConsistency) continue;
                    result.put((Long)voucher.getPkValue(), (Exception)((Object)new KDBizException(error)));
                    continue;
                }
                if (!this.voucherBookHelper.isMainBookType(bookType)) {
                    error = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u4e0d\u5c5e\u4e8e\u4e3b\u8d26\u7c3f\uff1a%s\u3002", (String)"VoucherBookJournalBuilder_0", (String)"fi-cas-business", (Object[])new Object[0]), voucher.getLong("id"));
                    BookJournalLogger.log(error);
                    if (!this.isConsistency) continue;
                    result.put((Long)voucher.getPkValue(), (Exception)((Object)new KDBizException(error)));
                    continue;
                }
                if (!super.getIsValidata().booleanValue()) {
                    String keyString = voucher.getString("sourcebill") + "_" + voucherSourceEntityName;
                    log.info("keyString is:" + keyString + "and key is:" + SerializationUtils.toJsonString(resultMapOfResource.keySet()));
                    bill = (DynamicObject)resultMapOfResource.get(keyString);
                }
                String bankCheckFlag = "";
                Date avdDate = null;
                Date pdDate = null;
                String feepayer = "";
                String voucherIdStr = voucher.getString("id");
                if (null != resultMapOfResourceCheckFlag.get(voucherIdStr)) {
                    List sourceIdList = (List)resultMapOfResourceCheckFlag.get(voucherIdStr);
                    StringJoiner stringJoiner = new StringJoiner(",");
                    for (String sourceIdStr : sourceIdList) {
                        String entityName;
                        String value;
                        String bankcheckStr;
                        DynamicObject resourceDy = (DynamicObject)resultMapOfResource.get(sourceIdStr);
                        if (null == resourceDy || !EmptyUtil.isNoEmpty((String)(bankcheckStr = resourceDy.getString(value = map.get(entityName = resourceDy.getDataEntityType().getName()))))) continue;
                        stringJoiner.add(bankcheckStr);
                    }
                    String stringJoin = stringJoiner.toString();
                    if (EmptyUtil.isNoEmpty((String)stringJoin) && stringJoin.endsWith(",")) {
                        stringJoin = stringJoin.substring(0, stringJoin.getBytes().length - 1);
                    }
                    bankCheckFlag = stringJoin;
                }
                log.info("bankCheckFlag is:" + bankCheckFlag);
                if (bill != null && map.containsKey(bill.getDataEntityType().getName())) {
                    String entityName = bill.getDataEntityType().getName();
                    if ("cas_paybill".equals(entityName)) {
                        pdDate = bill.getDate("paydate");
                        avdDate = bill.getDate("expectdate");
                        feepayer = bill.getString("feepayer");
                    }
                    if ("cas_agentpaybill".equals(entityName)) {
                        pdDate = bill.getDate("paytime");
                    }
                }
                DynamicObjectCollection entry = voucher.getDynamicObjectCollection("entries");
                if (resultOfAssgrp.size() > 0 && resultOfAssgrp.containsKey(voucher.getLong("id"))) {
                    throw resultOfAssgrp.get(voucher.getLong("id"));
                }
                int i = 0;
                ArrayList<JournalInfo> journals = new ArrayList<JournalInfo>();
                boolean canSetPayeeInfo = this.isSetPayeeInfo(voucherBills, voucher);
                for (DynamicObject row : entry) {
                    Long id;
                    DynamicObject bank;
                    DynamicObject bankLoad;
                    DynamicObject bankCate;
                    ++i;
                    DynamicObject account = this.getAccounts(row);
                    if (account == null) {
                        String error6 = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1ID%1$s%2$s%3$s", (String)"VoucherBookJournalBuilder_16", (String)"fi-cas-business", (Object[])new Object[0]), voucher.getLong("id"), String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u7b2c%s", (String)"VoucherBookJournalBuilder_1_2", (String)"fi-cas-business", (Object[])new Object[0]), i), ResManager.loadKDString((String)"\u5206\u5f55\uff0c\u6838\u7b97\u7ef4\u5ea6\u4e0d\u662f\u94f6\u884c\u8d26\u6237\u6216\u8005\u73b0\u91d1\u8d26\u6237", (String)"VoucherBookJournalBuilder_2", (String)"fi-cas-business", (Object[])new Object[0]));
                        BookJournalLogger.log(error6);
                        if (!this.isConsistency) continue;
                        result.put((Long)voucher.getPkValue(), (Exception)((Object)new KDBizException(error6)));
                        continue;
                    }
                    if (checkedVoucherEntryIds.contains(row.getLong("id"))) {
                        log.info("\u51ed\u8bc1\u5206\u5f55\u5df2\u5b58\u5728\u5df2\u52fe\u5bf9\u7684\u94f6\u884c\u5bf9\u8d26\u5355\uff1a" + row.getLong("id"));
                        continue;
                    }
                    JournalInfo journal = new JournalInfo();
                    String accountType = account.getDataEntityType().getName();
                    if ("bd_accountbanks".equals(accountType)) {
                        journal.setAccountBank(account);
                    } else if ("cas_accountcash".equals(accountType)) {
                        journal.setAccountCash(account);
                    } else {
                        String error7 = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1ID%1$s%2$s%3$s", (String)"VoucherBookJournalBuilder_16", (String)"fi-cas-business", (Object[])new Object[0]), voucher.getLong("id"), String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u7b2c%s", (String)"VoucherBookJournalBuilder_1_2", (String)"fi-cas-business", (Object[])new Object[0]), i), ResManager.loadKDString((String)"\u5206\u5f55\uff0c\u7c7b\u522b\u4e0d\u662f\u94f6\u884c\u8d26\u6237\u548c\u73b0\u91d1\u8d26\u6237", (String)"VoucherBookJournalBuilder_8", (String)"fi-cas-business", (Object[])new Object[0]));
                        BookJournalLogger.log(error7);
                        if (!this.isConsistency) continue;
                        result.put((Long)voucher.getPkValue(), (Exception)((Object)new KDBizException(error7)));
                        continue;
                    }
                    BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u8d26\u6237ID=%1$s,\u7ec4\u7ec7ID=%2$s", (String)"VoucherBookJournalBuilder_3", (String)"fi-cas-business", (Object[])new Object[0]), account.getPkValue(), org.getPkValue()));
                    BigDecimal debitori = row.getBigDecimal("debitori");
                    BigDecimal creditori = row.getBigDecimal("creditori");
                    BigDecimal debitLocal = row.getBigDecimal("debitlocal");
                    BigDecimal creditLocal = row.getBigDecimal("creditlocal");
                    if (debitori.compareTo(BigDecimal.ZERO) == 0 && creditori.compareTo(BigDecimal.ZERO) == 0) {
                        String error8 = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1ID%1$s%2$s%3$s", (String)"VoucherBookJournalBuilder_16", (String)"fi-cas-business", (Object[])new Object[0]), voucher.getLong("id"), String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u7b2c%s", (String)"VoucherBookJournalBuilder_1_2", (String)"fi-cas-business", (Object[])new Object[0]), i), ResManager.loadKDString((String)"\u5206\u5f55\uff0c\u501f\u8d37\u65b9\u91d1\u989d\u4e3a0", (String)"VoucherBookJournalBuilder_10", (String)"fi-cas-business", (Object[])new Object[0]));
                        BookJournalLogger.log(error8);
                        if (!this.isConsistency) continue;
                        result.put((Long)voucher.getPkValue(), (Exception)((Object)new KDBizException(error8)));
                        continue;
                    }
                    DynamicObject bankAcct = journal.getAccountBank();
                    if (CasHelper.isNotEmpty((Object)bankAcct) && CasHelper.isNotEmpty((Object)(bankCate = (bankLoad = BusinessDataServiceHelper.loadSingle((Object)(bank = bankAcct.getDynamicObject("bank")).getPkValue(), (String)"bd_finorginfo")).getDynamicObject("bank_cate"))) && CasHelper.isNotEmpty((Object)(id = (Long)bankCate.getPkValue())) && Boolean.TRUE.equals(VisibleVirtualAcctHelper.checkVirtualAcct(id))) {
                        String error9 = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1ID %s :\u865a\u62df\u94f6\u884c\u4e0d\u767b\u8bb0\u65e5\u8bb0\u8d26\uff01", (String)"VoucherBookJournalBuilder_1_1", (String)"fi-cas-business", (Object[])new Object[0]), voucher.getLong("id"));
                        BookJournalLogger.log(error9);
                        if (!this.isConsistency) continue;
                        result.put((Long)voucher.getPkValue(), (Exception)((Object)new KDBizException(error9)));
                        continue;
                    }
                    journal.setSourceBillTypeOfSourceBill(voucherSourceEntityName);
                    journal.setBizDate(voucher.getDate("bizdate"));
                    journal.setBookDate(voucher.getDate("bookeddate"));
                    journal.setPreparationdate(voucher.getDate("createtime"));
                    journal.setPd(pdDate);
                    journal.setAvd(avdDate);
                    journal.setFeepayer(feepayer);
                    journal.setOrg(org);
                    journal.setCurrency(row.getDynamicObject("currency"));
                    journal.setDebitAmount(debitori);
                    journal.setCreditAmount(creditori);
                    journal.setExchangeRate(row.getBigDecimal("localrate"));
                    journal.setDescription(row.getString("edescription"));
                    journal.setSource(4);
                    if (!CasHelper.isEmpty((Object)bankCheckFlag)) {
                        journal.setBankCheckFlag(bankCheckFlag);
                        journal.setBatchNo(bankCheckFlag);
                        journal.setSynccheck("1");
                    }
                    BigDecimal amt = BigDecimal.ZERO;
                    BigDecimal localAmount = BigDecimal.ZERO;
                    if (CasHelper.isEmpty((Object)debitori)) {
                        journal.setDirection(2);
                        amt = creditori;
                        localAmount = creditLocal;
                    } else {
                        journal.setDirection(1);
                        amt = debitori;
                        localAmount = debitLocal;
                    }
                    this.setValueBySouceBill(journal, bill, canSetPayeeInfo);
                    journal.setLocalAmount(localAmount);
                    journal.setSourceBillType("gl_voucher");
                    journal.setSourceBillId((Long)voucher.getPkValue());
                    journal.setSourceBillEntryId((Long)row.getPkValue());
                    journal.setSourceBillNumber(voucher.getDynamicObject("vouchertype").getString("name") + " " + voucher.getString("billno"));
                    journal.setBillno(voucher.getString("billno"));
                    journal.setCashier(user);
                    ArrayList<JournalEntryInfo> journalEntrys = new ArrayList<JournalEntryInfo>();
                    JournalEntryInfo journalEntry = new JournalEntryInfo();
                    journalEntry.setOppUnit("");
                    journalEntry.setAmount(amt);
                    journalEntry.setLocalAmount(localAmount);
                    journalEntry.setFundFlowItem(null);
                    journalEntrys.add(journalEntry);
                    journal.setEntry(journalEntrys);
                    journals.add(journal);
                }
                if (!EmptyUtil.isNoEmpty(journals)) continue;
                voucherJournalsMap.put(voucher.getLong("id"), journals);
            }
            catch (Exception e) {
                log.error("getJournalInfoLists process error", (Throwable)e);
                result.put((Long)voucher.getPkValue(), e);
            }
        }
        log.info("getJournalInfoLists process data end" + (System.currentTimeMillis() - startTime2));
        return voucherJournalsMap;
    }

    private boolean isSetPayeeInfo(Map<Long, Set<Long>> voucherBills, DynamicObject voucher) {
        boolean setPayeeInfo = true;
        Set<Long> sourceIds = voucherBills.get(voucher.getLong("id"));
        if (voucherBills.size() == 0 || sourceIds == null) {
            return setPayeeInfo;
        }
        if (sourceIds.size() > 1) {
            setPayeeInfo = false;
        }
        return setPayeeInfo;
    }

    private DynamicObject getAccount(DynamicObject voucherEntryRow) {
        return this.voucherBookHelper.getCasAccount(voucherEntryRow);
    }

    private DynamicObject getSourceBill(Object voucherId, DynamicObject sourceType, Map<Long, Set<Long>> voucherBills) {
        if (voucherId == null || sourceType == null) {
            return null;
        }
        String entityName = sourceType.getString("number");
        if (CasHelper.isEmpty((Object)entityName)) {
            return null;
        }
        QFilter filter = new QFilter("voucherid", "=", voucherId).and(new QFilter("billtype", "=", (Object)entityName));
        DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid,billtype", (QFilter[])new QFilter[]{filter});
        this.setVoucherSourceBills(voucherBills, vouchersDaps);
        if (vouchersDaps != null && vouchersDaps.size() == 1) {
            String sourceBillId = ((DynamicObject)vouchersDaps.get(0)).getString("sourcebillid");
            String fields = JournalSyncHepler.getFields().get(entityName);
            if (CasHelper.isEmpty((Object)fields) || CasHelper.isEmpty((Object)sourceBillId)) {
                return null;
            }
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sourceBillId), (String)entityName, (String)("id,bankcheckflag_tag,bankCheckFlag,acttradedate" + fields + this.getSourceFileName(entityName)));
            return bill;
        }
        return null;
    }

    private void setVoucherSourceBills(Map<Long, Set<Long>> voucherBills, DynamicObjectCollection vouchersDaps) {
        for (DynamicObject voucher : vouchersDaps) {
            Long vId = voucher.getLong("voucherid");
            Long sId = voucher.getLong("sourcebillid");
            Set<Long> sIds = voucherBills.get(vId);
            if (sIds == null) {
                sIds = new HashSet<Long>(4);
                voucherBills.put(vId, sIds);
            }
            sIds.add(sId);
        }
    }

    private String getSourceFileName(String entityName) {
        String fileName = "";
        switch (entityName) {
            case "cas_paybill": {
                fileName = ",paydate,expectdate";
                break;
            }
            case "cas_recbill": {
                fileName = ",payeedate";
                break;
            }
            case "cas_agentpaybill": {
                fileName = ",paytime";
                break;
            }
            case "cas_exchangebill": {
                fileName = ",exchangedate";
            }
        }
        return fileName;
    }

    private void setValueBySouceBill(JournalInfo journal, DynamicObject bill, boolean canSetPayeeInfo) {
        if (bill == null) {
            log.info("bill is null");
            return;
        }
        log.info("bill id:" + bill.getPkValue());
        String billType = bill.getDataEntityType().getName();
        if (!JournalSyncHepler.isCommitbe(bill, billType).booleanValue()) {
            journal.setSynccheck("1");
        }
        VoucherBookJournalBuilder.setOppBySourceBill(bill, journal, billType, canSetPayeeInfo);
    }

    public static void setOppBySourceBill(DynamicObject info, JournalInfo journal, String billType, boolean canSetPayeeInfo) {
        if (JournalSyncHepler.getFields().containsKey(billType)) {
            int direction = journal.getDirection();
            log.info("setOppBySourceBill is start billType :" + billType + ", direction is:" + direction);
            switch (billType) {
                case "cas_paybill": {
                    if (1 == direction) {
                        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"));
                        DynamicObject payerAcctBank = info.getDynamicObject("payeracctbank");
                        DynamicObject accountCash = info.getDynamicObject("payeracctcash");
                        String v_payeebanknum = "";
                        if (accountCash != null) {
                            v_payeebanknum = accountCash.getString("number");
                        } else if (payerAcctBank != null) {
                            v_payeebanknum = payerAcctBank.getString("bankaccountnumber");
                        }
                        if (canSetPayeeInfo) {
                            journal.setOppUnit(info.getDynamicObject("org").getString("name"));
                            journal.setOppAcctNumber(v_payeebanknum);
                            DynamicObject payerBank = info.getDynamicObject("payerbank");
                            if (payerBank != null) {
                                journal.setOppBank(payerBank.getLocaleString("name").getLocaleValue());
                            }
                        }
                    } else if (canSetPayeeInfo) {
                        journal.setOppUnit(info.getString("payeename"));
                        journal.setOppAcctNumber(info.getString("payeebanknum"));
                        DynamicObject payeeBank = info.getDynamicObject("payeebank");
                        if (payeeBank != null) {
                            journal.setOppBank(payeeBank.getLocaleString("name").getLocaleValue());
                        } else {
                            journal.setOppBank(info.getString("payeebankname"));
                        }
                    }
                    journal.setTraceDate(info.getDate("acttradedate"));
                    break;
                }
                case "cas_recbill": {
                    if (2 == direction) {
                        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"));
                        DynamicObject payerAcctBank = info.getDynamicObject("accountbank");
                        DynamicObject accountCash = info.getDynamicObject("accountcash");
                        String v_payerbanknum = "";
                        if (isCash && accountCash != null) {
                            v_payerbanknum = accountCash.getString("number");
                        } else if (!isCash && payerAcctBank != null) {
                            v_payerbanknum = payerAcctBank.getString("bankaccountnumber");
                        }
                        if (canSetPayeeInfo) {
                            journal.setOppUnit(info.getDynamicObject("org").getString("name"));
                            journal.setOppAcctNumber(v_payerbanknum);
                            DynamicObject payeeBank = info.getDynamicObject("payeebank");
                            if (payeeBank != null) {
                                journal.setOppBank(payeeBank.getLocaleString("name").getLocaleValue());
                            }
                        }
                    } else if (canSetPayeeInfo) {
                        journal.setOppUnit(info.getString("payername"));
                        journal.setOppAcctNumber(info.getString("payeracctbanknum"));
                        DynamicObject payerBank = info.getDynamicObject("f7_payerbank");
                        if (payerBank != null) {
                            journal.setOppBank(payerBank.getString("name"));
                        } else {
                            journal.setOppBank(info.getString("payerbankname"));
                        }
                    }
                    journal.setTraceDate(info.getDate("acttradedate"));
                    break;
                }
                case "cas_agentpaybill": {
                    journal.setTraceDate(info.getDate("acttradedate"));
                    break;
                }
                case "cas_exchangebill": {
                    journal.setTraceDate(info.getDate("acttradedate"));
                }
            }
        }
    }

    private HashMap<String, DynamicObject> getSourceBills(DynamicObjectCollection vouchers, Map<String, List<String>> resultMapOfResourceCheckFlag, Map<Long, Set<Long>> voucherBills) {
        HashMap<String, DynamicObject> resultMapOfResource = new HashMap<String, DynamicObject>();
        List voucherId = vouchers.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        List sourceType = vouchers.stream().map(e -> e.getDynamicObject("sourcebilltype")).collect(Collectors.toList());
        if (voucherId == null || sourceType == null) {
            return resultMapOfResource;
        }
        List entityName = sourceType.stream().map(e -> e.getString("number")).collect(Collectors.toList());
        if (CasHelper.isEmpty(entityName)) {
            return resultMapOfResource;
        }
        Long startTime = System.currentTimeMillis();
        log.info("getSourceBills start is:" + startTime);
        QFilter filter = new QFilter("voucherid", "in", voucherId);
        DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid,billtype", (QFilter[])new QFilter[]{filter});
        log.info("getSourceBills end:" + vouchersDaps.size());
        this.setVoucherSourceBills(voucherBills, vouchersDaps);
        Map<String, List<DynamicObject>> resultIdMap = vouchersDaps.stream().collect(Collectors.groupingBy(e -> e.getString("voucherid")));
        HashMap<String, Set<Long>> entryNameBillsMap = new HashMap<String, Set<Long>>();
        for (DynamicObject voucher : vouchers) {
            String voucherIdStr = voucher.getPkValue().toString();
            if (!resultIdMap.containsKey(voucherIdStr) || resultIdMap.get(voucherIdStr).size() == 0) continue;
            List<DynamicObject> dynamicObjectList = resultIdMap.get(voucherIdStr);
            for (DynamicObject dapDy : dynamicObjectList) {
                Long sourceBillId = dapDy.getLong("sourcebillid");
                String entryNameStr = dapDy.getString("billtype");
                String fields = JournalSyncHepler.getFields().get(entryNameStr);
                if (CasHelper.isEmpty((Object)fields) || CasHelper.isEmpty((Object)sourceBillId)) continue;
                if (entryNameBillsMap.containsKey(entryNameStr)) {
                    ((Set)entryNameBillsMap.get(entryNameStr)).add(sourceBillId);
                } else {
                    HashSet<Long> list = new HashSet<Long>();
                    list.add(sourceBillId);
                    entryNameBillsMap.put(entryNameStr, list);
                }
                String keyStr = sourceBillId + "_" + entryNameStr;
                if (resultMapOfResourceCheckFlag.containsKey(voucherIdStr) && null != resultMapOfResourceCheckFlag.get(voucherIdStr)) {
                    resultMapOfResourceCheckFlag.get(voucherIdStr).add(keyStr);
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(keyStr);
                resultMapOfResourceCheckFlag.put(voucherIdStr, list);
            }
        }
        if (entryNameBillsMap.size() > 0) {
            if (entryNameBillsMap.containsKey("cas_paybill")) {
                this.putSrcBill("cas_paybill", "id,bankcheckflag_tag,bankCheckFlag,org,payeracctbank,payeracctcash,payerbank,settletype,acttradedate", entryNameBillsMap, resultMapOfResource);
            }
            if (entryNameBillsMap.containsKey("cas_recbill")) {
                this.putSrcBill("cas_recbill", "id,bankcheckflag_tag,bankCheckFlag,org,payeebank,accountbank,accountcash,settletype,acttradedate", entryNameBillsMap, resultMapOfResource);
            }
            if (entryNameBillsMap.containsKey("cas_agentpaybill")) {
                this.putSrcBill("cas_agentpaybill", "id,bankcheckflag_tag,bankCheckFlag,acttradedate", entryNameBillsMap, resultMapOfResource);
            }
            if (entryNameBillsMap.containsKey("cas_exchangebill")) {
                this.putSrcBill("cas_exchangebill", "id,bankcheckflag_tag,bankCheckFlag,acttradedate", entryNameBillsMap, resultMapOfResource);
            }
        }
        return resultMapOfResource;
    }

    private void putSrcBill(String entryNameStr, String selectField, Map<String, Set<Long>> entryNameBillsMap, HashMap<String, DynamicObject> resultMapOfResource) {
        String fields = JournalSyncHepler.getFields().get(entryNameStr);
        QFilter qFilter = new QFilter("id", "in", entryNameBillsMap.get(entryNameStr));
        DynamicObject[] bill = BusinessDataServiceHelper.load((String)entryNameStr, (String)(selectField + fields + this.getSourceFileName(entryNameStr)), (QFilter[])new QFilter[]{qFilter});
        Map<String, DynamicObject> cas_paybillData = Arrays.stream(bill).collect(Collectors.toMap(e -> e.getLong("id") + "_" + entryNameStr, e -> e));
        resultMapOfResource.putAll(cas_paybillData);
    }

    private void fillErrorData(DynamicObjectCollection billColl, Set<Long> orgIdSet, HashMap<Long, Exception> resultOfAssgrp, Map<String, Exception> errorMap) {
        if (errorMap.size() > 0) {
            Set<String> errorStr = errorMap.keySet();
            for (DynamicObject bills : billColl) {
                orgIdSet.add(bills.getDynamicObject("org").getLong("id"));
                DynamicObjectCollection dynamicObjectCollection = bills.getDynamicObjectCollection("entries");
                for (DynamicObject entry : dynamicObjectCollection) {
                    DynamicObject assgrp = entry.getDynamicObject("assgrp");
                    if (null == assgrp || null == assgrp.getString("value")) continue;
                    JSONObject jsonObject = JSONObject.parseObject((String)assgrp.getString("value"));
                    for (String keyStr : jsonObject.keySet()) {
                        if (!errorStr.contains(keyStr)) continue;
                        resultOfAssgrp.put(bills.getLong("id"), errorMap.get(keyStr));
                    }
                }
            }
        }
    }

    private DynamicObject getAccounts(DynamicObject voucherEntryRow) {
        return this.voucherBookHelper.getCasAccounts(voucherEntryRow);
    }
}

