/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.extplugin.PluginProxy;
import kd.bos.isv.ISVService;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.journal.SourceNumber;
import kd.fi.cas.business.journal.VoucherBookJournalBuilder;
import kd.fi.cas.business.journal.VoucherMatcher;
import kd.fi.cas.business.journal.VoucherProcessService;
import kd.fi.cas.util.EmptyUtil;
import kd.sdk.fi.cas.extpoint.journal.IJournalVoucherBookInterface;

public class VoucherBookService {
    private static final String SELECTFIELDSMORE = "id,billno,sourcebilltype.number,org.id,entries.id,entries.account,entries.account.isbank,entries.account.iscash,entries.account.iscashequivalent,entries.account.isjournal,booktype.name,booktype.accounttype,sourcetype,sourcebill,period.enddate,vouchertype.name,bizdate,bookeddate,createtime,entries.debitori,entries.creditlocal,entries.debitlocal,entries.creditori,entries.currency,entries.localrate,entries.edescription,ischeck";
    private static final String SELECTFIELDS = "id,entries.id,entries.assgrp,entries.assgrp.value";
    private static final Log logger = LogFactory.getLog(VoucherBookService.class);
    protected boolean isConsistency = false;

    public Map<Long, String> validate(Long[] voucherPks, String action, String opkey) {
        long startTime = System.currentTimeMillis();
        logger.info("is start to book cost time :" + startTime);
        HashMap<Long, String> result = new HashMap<Long, String>();
        if ("book".equals(action)) {
            this.process(voucherPks, vouchers -> {
                HashMap<Long, Exception> errorResult = new HashMap<Long, Exception>();
                Map<Long, String> mapOfIdAndBillno = vouchers.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("billno"), (e1, e2) -> e1));
                JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
                VoucherBookJournalBuilder builder = new VoucherBookJournalBuilder();
                builder.setIsValidata(Boolean.TRUE);
                journalServiceAdapter.validateBooks(builder, vouchers, errorResult);
                if (errorResult.size() > 0) {
                    for (Map.Entry voucherId : errorResult.entrySet()) {
                        String billno = mapOfIdAndBillno.get(voucherId.getKey());
                        result.put((Long)voucherId.getKey(), billno + ":" + ((Exception)voucherId.getValue()).getMessage());
                        logger.info("validateBook error:" + voucherId.getKey() + "," + ((Exception)voucherId.getValue()).getMessage());
                    }
                }
            });
        } else if ("delete".equals(action)) {
            ArrayList<String> ids = new ArrayList<String>(voucherPks.length);
            HashSet<Long> voucherPksSet = new HashSet<Long>(voucherPks.length);
            for (Long id : voucherPks) {
                ids.add(String.valueOf(id));
                voucherPksSet.add(id);
            }
            List lockedIds = TxCheckUtil.getLocked(ids);
            if (lockedIds.size() > 0) {
                for (String id : lockedIds) {
                    Long removeId = Long.valueOf(id);
                    voucherPksSet.remove(removeId);
                    String error = ResManager.loadKDString((String)"\u201c%1$s\u201d\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u53cd\u590d\u6838\u3002", (String)"VoucherBookService_01", (String)"fi-ai-common", (Object[])new Object[0]);
                    result.put(removeId, error);
                    logger.info("validateBook error:\u3010{}\u3011,{}", (Object)removeId, (Object)error);
                }
            }
            HashMap<Long, Exception> errorResult = new HashMap<Long, Exception>();
            QFilter qFilter = new QFilter("id", "in", voucherPksSet);
            DynamicObject[] voucherDeletes = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,org.id,billno,period.enddate", (QFilter[])new QFilter[]{qFilter});
            JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
            Map<Long, DynamicObject> vouvcherMap = Arrays.stream(voucherDeletes).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            boolean noNeedCheck = "delete".equals(opkey) || "disable".equals(opkey);
            journalServiceAdapter.validateCancelBooks(vouvcherMap, errorResult, new HashMap<Long, Boolean>(), noNeedCheck);
            if (errorResult.size() > 0) {
                for (Map.Entry voucherId : errorResult.entrySet()) {
                    result.put((Long)voucherId.getKey(), ((Exception)voucherId.getValue()).getMessage());
                    logger.info("validateCancelBooks error:" + voucherId.getKey() + "," + ((Exception)voucherId.getValue()).getMessage());
                }
            }
        }
        return result;
    }

    public Map<Long, Set<Long>> getCheckedVoucherEntryIds(Map<Long, Collection<Long>> voucherData) {
        Set<Long> voucherIds = voucherData.keySet();
        HashSet voucherEntryIds = new HashSet(16);
        voucherData.values().forEach(voucherEntryIds::addAll);
        QFilter qFilter = new QFilter("ischeck", "=", (Object)"1");
        qFilter.and("sourcebillid", "in", voucherIds);
        qFilter.and("sourcebillentryid", "in", voucherEntryIds);
        DynamicObjectCollection bankJournals = QueryServiceHelper.query((String)"cas_bankjournal", (String)"sourcebillid,sourcebillentryid", (QFilter[])qFilter.toArray());
        return bankJournals.stream().collect(Collectors.groupingBy(s -> s.getLong("sourcebillid"), Collectors.mapping(s -> s.getLong("sourcebillentryid"), Collectors.toSet())));
    }

    public Set<DynamicObject> book(Long[] voucherPks) {
        HashSet<DynamicObject> errorBooks = new HashSet<DynamicObject>();
        this.process(voucherPks, vouchers -> {
            JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
            VoucherBookJournalBuilder builder = new VoucherBookJournalBuilder();
            builder.setConsistency(this.isConsistency);
            List<DynamicObject> voucherPksNew = vouchers.stream().filter(e -> e.getString("ischeck").equalsIgnoreCase("c")).collect(Collectors.toList());
            HashMap<Long, Exception> errorResult = new HashMap<Long, Exception>();
            Map<Long, List<DynamicObject>> journalList = journalServiceAdapter.validateBooks(builder, voucherPksNew, errorResult);
            journalServiceAdapter.book(errorResult, journalList);
            if (errorResult.size() > 0) {
                for (Map.Entry voucherId : errorResult.entrySet()) {
                    errorBooks.add(JournalServiceAdapter.getVoucherBook((Long)voucherId.getKey(), "KD", "BOOK", (Exception)voucherId.getValue()));
                }
            }
            this.voucherBookSave(errorBooks, true);
        });
        return errorBooks;
    }

    private void process(Long[] voucherPks, VoucherProcessService service) {
        QFilter qFilterIds = new QFilter("id", "in", (Object)voucherPks);
        String cashAccountExt = this.voucherBookCashAccountExt(true);
        DataSet vouchers = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_voucher", (String)(EmptyUtil.isEmpty((String)cashAccountExt) ? SELECTFIELDSMORE : "id,billno,sourcebilltype.number,org.id,entries.id,entries.account,entries.account.isbank,entries.account.iscash,entries.account.iscashequivalent,entries.account.isjournal,booktype.name,booktype.accounttype,sourcetype,sourcebill,period.enddate,vouchertype.name,bizdate,bookeddate,createtime,entries.debitori,entries.creditlocal,entries.debitlocal,entries.creditori,entries.currency,entries.localrate,entries.edescription,ischeck," + cashAccountExt), (QFilter[])new QFilter[]{qFilterIds}, (String)"id");
        Map<String, DynamicObject> resultMap = this.getVoucherEntryIdMap(qFilterIds);
        int voucherSize = resultMap.size();
        logger.info("resultMap size:" + voucherSize);
        DynamicObjectCollection voucherColl = new DynamicObjectCollection();
        Long currentId = 0L;
        int currentIndex = 1;
        int index = 0;
        DynamicObject glVoucherDy = null;
        int MAX_BOOT_COUNT = 5000;
        if (resultMap.size() > 1000000) {
            MAX_BOOT_COUNT = 20000;
        }
        for (Row voucher : vouchers) {
            ++index;
            if (!currentId.equals(voucher.getLong("id"))) {
                if (currentId != 0L) {
                    voucherColl.add((Object)glVoucherDy);
                    currentIndex = 1;
                }
                currentId = voucher.getLong("id");
                glVoucherDy = this.buildVoucher(voucher);
                this.buildVoucherEntry(voucher, glVoucherDy, resultMap);
            } else {
                ++currentIndex;
                if (glVoucherDy == null) {
                    glVoucherDy = this.buildVoucher(voucher);
                }
                this.buildVoucherEntry(voucher, glVoucherDy, resultMap);
            }
            if (index != voucherSize && currentIndex < MAX_BOOT_COUNT) continue;
            voucherColl.add((Object)glVoucherDy);
            currentId = 0L;
            currentIndex = 1;
            service.process((List<DynamicObject>)voucherColl);
            voucherColl.clear();
            glVoucherDy = this.buildVoucher(voucher);
        }
    }

    private DynamicObject buildVoucher(Row voucher) {
        DynamicObject glVoucherDy = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucher");
        glVoucherDy.set("id", (Object)voucher.getLong("id"));
        glVoucherDy.set("billno", (Object)voucher.getString("billno"));
        DynamicObject periodDy = BusinessDataServiceHelper.newDynamicObject((String)"bd_period");
        periodDy.set("enddate", (Object)voucher.getDate("period.enddate"));
        glVoucherDy.set("period", (Object)periodDy);
        DynamicObject ntityobject = BusinessDataServiceHelper.newDynamicObject((String)"bos_entityobject");
        ntityobject.set("number", (Object)voucher.getString("sourcebilltype.number"));
        glVoucherDy.set("sourcebilltype", (Object)ntityobject);
        DynamicObject bos_org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
        bos_org.set("id", (Object)voucher.getLong("org.id"));
        glVoucherDy.set("org", (Object)bos_org);
        DynamicObject bd_accountbookstype = BusinessDataServiceHelper.newDynamicObject((String)"bd_accountbookstype");
        bd_accountbookstype.set("name", (Object)voucher.getString("booktype.name"));
        bd_accountbookstype.set("accounttype", (Object)voucher.getString("booktype.accounttype"));
        glVoucherDy.set("booktype", (Object)bd_accountbookstype);
        glVoucherDy.set("sourcetype", (Object)voucher.getString("sourcetype"));
        glVoucherDy.set("sourcebill", (Object)voucher.getLong("sourcebill"));
        glVoucherDy.set("bizdate", (Object)voucher.getDate("bizdate"));
        glVoucherDy.set("bookeddate", (Object)voucher.getDate("bookeddate"));
        glVoucherDy.set("createtime", (Object)voucher.getDate("createtime"));
        glVoucherDy.set("ischeck", (Object)voucher.getString("ischeck"));
        DynamicObject vouchertypeDy = BusinessDataServiceHelper.newDynamicObject((String)"gl_vouchertype");
        vouchertypeDy.set("name", (Object)voucher.getString("vouchertype.name"));
        glVoucherDy.set("vouchertype", (Object)vouchertypeDy);
        return glVoucherDy;
    }

    private void buildVoucherEntry(Row voucher, DynamicObject glVoucherDy, Map<String, DynamicObject> resultMap) {
        DynamicObjectCollection entries = glVoucherDy.getDynamicObjectCollection("entries");
        DynamicObject entryDy = entries.addNew();
        DynamicObject bdAccountView = BusinessDataServiceHelper.newDynamicObject((String)"bd_accountview");
        bdAccountView.set("id", (Object)voucher.getLong("entries.account"));
        bdAccountView.set("isbank", (Object)voucher.getBoolean("entries.account.isbank"));
        bdAccountView.set("iscash", (Object)voucher.getBoolean("entries.account.iscash"));
        bdAccountView.set("iscashequivalent", (Object)voucher.getBoolean("entries.account.iscashequivalent"));
        bdAccountView.set("isjournal", (Object)voucher.getBoolean("entries.account.isjournal"));
        entryDy.set("account", (Object)bdAccountView);
        entryDy.set("id", (Object)voucher.getLong("entries.id"));
        String key = voucher.getLong("id") + "_" + voucher.getLong("entries.id");
        DynamicObject assgrp = resultMap.get(key);
        entryDy.set("assgrp", (Object)assgrp);
        entryDy.set("debitori", (Object)voucher.getBigDecimal("entries.debitori"));
        entryDy.set("creditori", (Object)voucher.getBigDecimal("entries.creditori"));
        entryDy.set("creditlocal", (Object)voucher.getBigDecimal("entries.creditlocal"));
        entryDy.set("debitlocal", (Object)voucher.getBigDecimal("entries.debitlocal"));
        DynamicObject currency = BusinessDataServiceHelper.newDynamicObject((String)"bd_currency");
        currency.set("id", (Object)voucher.getLong("entries.currency"));
        entryDy.set("currency", (Object)currency);
        entryDy.set("localrate", (Object)voucher.getBigDecimal("entries.localrate"));
        entryDy.set("edescription", (Object)voucher.getString("entries.edescription"));
        String cashAccountExt = this.voucherBookCashAccountExt(false);
        if (EmptyUtil.isNoEmpty((String)cashAccountExt)) {
            entryDy.set(cashAccountExt, voucher.get("entries." + cashAccountExt));
        }
    }

    private Map<String, DynamicObject> getVoucherEntryIdMap(QFilter qFilterIds) {
        DynamicObject[] vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)SELECTFIELDS, (QFilter[])new QFilter[]{qFilterIds});
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>();
        for (DynamicObject voucher : vouchers) {
            DynamicObjectCollection entries = voucher.getDynamicObjectCollection("entries");
            for (DynamicObject entry : entries) {
                String key = voucher.getLong("id") + "_" + entry.getLong("id");
                resultMap.put(key, entry.getDynamicObject("assgrp"));
            }
        }
        return resultMap;
    }

    public Set<DynamicObject> delete(Long[] voucherPks) throws Exception {
        String queryProp = "id,org.id,billno,period.enddate,ischeck";
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)"gl_voucher", Arrays.asList(queryProp.split(",")));
        DynamicObject[] vouchers = BusinessDataServiceHelper.load((Object[])voucherPks, (DynamicObjectType)subDataEntityType);
        Map<Long, DynamicObject> voucherMap = Arrays.stream(vouchers).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn, (e1, e2) -> e1));
        JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
        journalServiceAdapter.setConsistency(this.isConsistency);
        HashSet<DynamicObject> errorVcancelBooks = new HashSet<DynamicObject>();
        HashMap<Long, DynamicObject> voucherMapNew = new HashMap<Long, DynamicObject>();
        HashMap<Long, Boolean> isNullVoucher = new HashMap<Long, Boolean>();
        HashMap<Long, Exception> errorResult = new HashMap<Long, Exception>();
        for (Long voucherId : voucherPks) {
            DynamicObject voucher = voucherMap.get(voucherId);
            if (voucher == null) {
                voucher = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucher");
                voucher.set("id", (Object)voucherId);
                voucher.set("ischeck", (Object)"b");
                isNullVoucher.put(voucherId, true);
            }
            if ("c".equals(voucher.getString("ischeck"))) continue;
            voucherMapNew.put(voucherId, voucher);
        }
        journalServiceAdapter.validateCancelBooks(voucherMapNew, errorResult, isNullVoucher, false);
        if (errorResult.size() > 0) {
            for (Map.Entry entry : errorResult.entrySet()) {
                errorVcancelBooks.add(JournalServiceAdapter.getVoucherBook((Long)entry.getKey(), "KD", "CANCELBOOK", (Exception)entry.getValue()));
                logger.info("delete error:" + entry.getKey() + "," + ((Exception)entry.getValue()).getMessage());
            }
            voucherMapNew.keySet().removeAll(errorResult.keySet());
        }
        ArrayList<Long> willDeleteData = new ArrayList<Long>(voucherMapNew.keySet());
        journalServiceAdapter.cancelBooks(willDeleteData);
        this.voucherBookSave(errorVcancelBooks, false);
        return errorVcancelBooks;
    }

    public void voucherBookSave(Set<DynamicObject> voucherBooks, boolean isBook) {
        if (voucherBooks.size() > 0) {
            try (TXHandle tx = TX.required();){
                try {
                    DeleteServiceHelper.delete((String)"cas_voucherbook", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", voucherBooks.stream().map(p -> p.getLong("sourcebillid")).collect(Collectors.toList())), new QFilter("businesstype", "=", (Object)(isBook ? "BOOK" : "CANCELBOOK"))});
                    SaveServiceHelper.save((DynamicObject[])voucherBooks.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error((Throwable)e);
                }
            }
        }
    }

    public Map<DynamicObject, SourceNumber> getSourceNumbers(Collection<DynamicObject> journals, String journalType) {
        Map<DynamicObject, Collection<Long>> voucherJournalMap = new VoucherMatcher().findRelatedVouchers(journals, journalType);
        HashMap<DynamicObject, SourceNumber> result = new HashMap<DynamicObject, SourceNumber>();
        Map<Long, DynamicObject> voucherMap = this.queryVouchers(voucherJournalMap);
        voucherJournalMap.forEach((journal, voucherPks) -> {
            ArrayList voucherTypeNos = new ArrayList();
            LinkedList voucherBillNos = new LinkedList();
            voucherPks.forEach(voucherPk -> {
                DynamicObject voucher = (DynamicObject)voucherMap.get(voucherPk);
                if (voucher != null) {
                    String voucherType = voucher.getString("vouchertype.name");
                    String voucherNumber = voucher.getString("billno");
                    String voucherTypeNumber = voucherType + " " + voucherNumber;
                    voucherTypeNos.add(voucherTypeNumber);
                    voucherBillNos.add(voucherNumber);
                }
            });
            String sourceBillType = journal.getString("sourcebilltype");
            SourceNumber sourceNumber = new SourceNumber();
            sourceNumber.setSourceType(sourceBillType);
            sourceNumber.setVoucherNo(String.join((CharSequence)",", voucherTypeNos));
            if ("gl_voucher".equals(sourceBillType)) {
                sourceNumber.setBillno(String.join((CharSequence)",", voucherBillNos));
            } else {
                sourceNumber.setBillno(journal.getString("sourcebillnumber"));
            }
            result.put((DynamicObject)journal, sourceNumber);
        });
        return result;
    }

    public Map<Long, DynamicObject> queryVouchers(Map<DynamicObject, Collection<Long>> voucherJournalMap) {
        DynamicObject[] vouchers;
        HashMap<Long, DynamicObject> voucherMap = new HashMap<Long, DynamicObject>(50);
        LinkedList voucherPks = new LinkedList();
        voucherJournalMap.values().forEach(v -> voucherPks.addAll(v));
        if (voucherPks.isEmpty()) {
            return voucherMap;
        }
        Collection<Collection<Long>> values = voucherJournalMap.values();
        QFilter[] filters = null;
        if (null == values) {
            return voucherMap;
        }
        HashSet ids = new HashSet();
        values.stream().filter(t -> null != t && t.size() > 0).forEach(collection -> collection.forEach(t -> ids.add(t)));
        filters = new QFilter("id", "in", ids).toArray();
        for (DynamicObject voucher : vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"vouchertype.name,billno", (QFilter[])filters)) {
            voucherMap.put((Long)voucher.getPkValue(), voucher);
        }
        return voucherMap;
    }

    public Map<Long, DynamicObject> queryVouchers(Map<DynamicObject, Collection<Long>> voucherJournalMap, String fields) {
        DynamicObject[] vouchers;
        HashMap<Long, DynamicObject> voucherMap = new HashMap<Long, DynamicObject>(50);
        LinkedList voucherPks = new LinkedList();
        voucherJournalMap.values().forEach(v -> voucherPks.addAll(v));
        if (voucherPks.isEmpty()) {
            return voucherMap;
        }
        Collection<Collection<Long>> values = voucherJournalMap.values();
        QFilter[] filters = null;
        if (null == values) {
            return voucherMap;
        }
        HashSet ids = new HashSet();
        values.stream().filter(t -> null != t && t.size() > 0).forEach(collection -> collection.forEach(t -> ids.add(t)));
        filters = new QFilter("id", "in", ids).toArray();
        for (DynamicObject voucher : vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)fields, (QFilter[])filters)) {
            voucherMap.put((Long)voucher.getPkValue(), voucher);
        }
        return voucherMap;
    }

    public void setConsistency(boolean consistency) {
        this.isConsistency = consistency;
    }

    private String voucherBookCashAccountExt(boolean isConsistency) {
        PluginProxy pluginProxy = PluginProxy.create(IJournalVoucherBookInterface.class, (String)"kd.sdk.fi.cas.extpoint.journal.IJournalVoucherBookInterface.cashJournalBookExt");
        List resultList = pluginProxy.callReplace(IJournalVoucherBookInterface::cashJournalBookExt);
        if (EmptyUtil.isNoEmpty((Object)resultList) && EmptyUtil.isNoEmpty((String)((String)resultList.get(0)))) {
            String extField = (String)resultList.get(0);
            String isv = ISVService.getISVInfo().getId();
            logger.info("\u51ed\u8bc1\u767b\u8d26 -- \u51ed\u8bc1\u5206\u5f55\u73b0\u91d1\u8d26\u6237id\u4e8c\u5f00\u6269\u5c55\u5b57\u6bb5\u6807\u8bc6:" + extField + " \u5f00\u53d1\u5546\u6807\u8bc6:" + isv);
            if (extField.startsWith(isv)) {
                return isConsistency ? "entries." + extField : extField;
            }
        }
        return "";
    }
}

