/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.util.ComboKey;

public class VoucherMatcher {
    public Map<DynamicObject, Collection<Long>> findRelatedVouchers(Collection<DynamicObject> journals, String journalType) {
        HashMap<DynamicObject, Collection<Long>> journalVoucherMap = new HashMap<DynamicObject, Collection<Long>>(50);
        if (journals == null || journals.isEmpty()) {
            return journalVoucherMap;
        }
        for (DynamicObject dynamicObject : journals) {
            journalVoucherMap.put(dynamicObject, new ArrayList());
        }
        HashMap<ComboKey, Collection<DynamicObject>> sourceBillJournalMap = new HashMap<ComboKey, Collection<DynamicObject>>();
        for (DynamicObject journal : journals) {
            String sourceBillType = journal.getString("sourcebilltype");
            long sourceBillId = journal.getLong("sourcebillid");
            if ("gl_voucher".equals(sourceBillType)) {
                journalVoucherMap.computeIfPresent(journal, (k, v) -> {
                    v.add(sourceBillId);
                    return v;
                });
                continue;
            }
            if (sourceBillId == 0L) {
                Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)journalType, (Long[])new Long[]{journal.getLong("id")});
                HashSet sourcePks2 = sourceBills.getOrDefault(sourceBillType, new HashSet());
                for (Long spk : sourcePks2) {
                    ComboKey key = new ComboKey(new Object[]{sourceBillType, spk});
                    sourceBillJournalMap.computeIfAbsent(key, k -> new ArrayList());
                    sourceBillJournalMap.computeIfPresent(key, (k, v) -> {
                        v.add(journal);
                        return v;
                    });
                }
                continue;
            }
            ComboKey key = new ComboKey(new Object[]{sourceBillType, sourceBillId});
            sourceBillJournalMap.computeIfAbsent(key, k -> new ArrayList());
            sourceBillJournalMap.computeIfPresent(key, (k, v) -> {
                v.add(journal);
                return v;
            });
        }
        Map<String, Collection<Long>> map = this.groupBySourceEntity(sourceBillJournalMap);
        map.forEach((sourceEntityKey, sourcePks) -> {
            DynamicObject[] dapTrackers;
            for (DynamicObject dapTracker : dapTrackers = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"voucherid,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", sourcePks)})) {
                long voucherPk = dapTracker.getLong("voucherid");
                ComboKey key = new ComboKey(new Object[]{sourceEntityKey, dapTracker.getLong("sourcebillid")});
                Collection relatedJournals = sourceBillJournalMap.getOrDefault(key, new ArrayList());
                for (DynamicObject journal : relatedJournals) {
                    journalVoucherMap.computeIfPresent(journal, (k, v) -> {
                        v.add(voucherPk);
                        return v;
                    });
                }
            }
        });
        return journalVoucherMap;
    }

    private Map<String, Collection<Long>> groupBySourceEntity(Map<ComboKey, Collection<DynamicObject>> sourceBillJournalMap) {
        HashMap<String, Collection<Long>> sourceBillPksMap = new HashMap<String, Collection<Long>>();
        sourceBillJournalMap.keySet().forEach(sourceBillInfo -> {
            String sourceEntityKey = (String)sourceBillInfo.getKey(0);
            Long sourcePk = (Long)sourceBillInfo.getKey(1);
            sourceBillPksMap.computeIfAbsent(sourceEntityKey, k -> new ArrayList());
            sourceBillPksMap.computeIfPresent(sourceEntityKey, (k, v) -> {
                v.add(sourcePk);
                return v;
            });
        });
        return sourceBillPksMap;
    }
}

