/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal.book.jourrnalbook.check;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.errorcode.CasErrorCode;
import kd.fi.cas.business.errorcode.JournalErrorCode;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.pojo.book.BookCheckResult;
import kd.fi.cas.pojo.book.BookInfo;
import kd.fi.cas.util.DateUtils;

public class BookCommonCheck {
    public static BookCommonCheck getInstance() {
        return Singleton.instance;
    }

    public List<BookInfo> check(List<BookInfo> bookInfos, List<BookCheckResult> results_out) {
        if (bookInfos == null || bookInfos.size() == 0) {
            return new ArrayList<BookInfo>();
        }
        List<BookInfo> returns = this.checkValidate(bookInfos, results_out);
        return returns;
    }

    private List<BookInfo> checkValidate(List<BookInfo> bookInfos, List<BookCheckResult> results_out) {
        if (bookInfos == null || bookInfos.size() == 0) {
            return new ArrayList<BookInfo>();
        }
        ArrayList<BookInfo> results = new ArrayList<BookInfo>();
        HashSet orgIds = new HashSet(bookInfos.size());
        for (BookInfo bookInfo : bookInfos) {
            orgIds.addAll(bookInfo.getBookObjs().stream().map(o -> DynamicObjectHelper.getPk((DynamicObject)o, (String)"org")).collect(Collectors.toSet()));
        }
        Map isInitEnables = SystemStatusCtrolHelper.isInitEnable(orgIds);
        Map<Object, DynamicObject> accountcashs = this.queryDatas("cas_accountcash", "id,closestatus", "id", this.getAccounts(bookInfos));
        Map systemStatus = SystemStatusCtrolHelper.getCurrentPeriod(orgIds);
        if (isInitEnables != null && isInitEnables.size() > 0) {
            for (BookInfo bookInfo : bookInfos) {
                List bookJs = bookInfo.getBookObjs();
                if (bookJs == null || bookJs.size() == 0) continue;
                BookInfo result = new BookInfo();
                ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>();
                for (DynamicObject bookJ : bookJs) {
                    if (!this.checkisInitEnables(bookInfo, bookJ, isInitEnables, results_out) || !this.checkisLogoff(bookInfo, bookJ, accountcashs, results_out) || !this.checkhasAuthority(bookInfo, bookJ, results_out) || !this.checkBizDate(bookInfo, bookJ, results_out) || !this.checkPeriod(bookInfo, bookJ, systemStatus, results_out)) continue;
                    objs.add(bookJ);
                }
                if (objs.size() <= 0) continue;
                result.setBookObjs(objs);
                result.setBizId(bookInfo.getBizId());
                result.setBizBillNo(bookInfo.getBizBillNo());
                result.setBizBillType(bookInfo.getBizBillType());
                results.add(result);
            }
        }
        return results;
    }

    private boolean checkisInitEnables(BookInfo bookInfo, DynamicObject bookJ, Map<Long, Boolean> isInitEnables, List<BookCheckResult> results_out) {
        Long orgId = DynamicObjectHelper.getPk((DynamicObject)bookJ, (String)"org");
        if (!this.isTrue(isInitEnables, orgId)) {
            results_out.add(this.createResult(bookInfo, SystemStatusCtrolHelper.getNotInitMsg((long)orgId)));
            return false;
        }
        return true;
    }

    private boolean checkisLogoff(BookInfo bookInfo, DynamicObject bookJ, Map<Object, DynamicObject> accountcashs, List<BookCheckResult> results_out) {
        Long accountId;
        String entityName = bookJ.getDynamicObjectType().getName();
        if (!"cas_bankjournal".equals(entityName) && !CasHelper.isEmpty((Object)(accountId = DynamicObjectHelper.getPk((DynamicObject)bookJ, (String)"accountcash"))) && 0 != accountcashs.get(accountId).getInt("closestatus")) {
            results_out.add(this.createResult(bookInfo, new CasErrorCode().ACCT_IS_CLOSE().getMessage()));
            return false;
        }
        return true;
    }

    private boolean checkhasAuthority(BookInfo bookInfo, DynamicObject bookJ, List<BookCheckResult> results_out) {
        Long accountBankId;
        long orgId = DynamicObjectHelper.getPk((DynamicObject)bookJ, (String)"org");
        String entityName = bookJ.getDynamicObjectType().getName();
        if ("cas_bankjournal".equals(entityName) && !CasHelper.isEmpty((Object)(accountBankId = DynamicObjectHelper.getPk((DynamicObject)bookJ, (String)"accountbank"))) && !AccountBankHelper.isEntrustCanUseAccount((long)orgId, (long)accountBankId)) {
            results_out.add(this.createResult(bookInfo, new CasErrorCode().ORG_NOT_ACCTAUTH().getMessage()));
            return false;
        }
        return true;
    }

    private boolean checkBizDate(BookInfo bookInfo, DynamicObject bookJ, List<BookCheckResult> results_out) {
        Date bizDate;
        int CS104 = SystemParameterHelper.getParameterInteger((long)DynamicObjectHelper.getPk((DynamicObject)bookJ, (String)"org"), (String)"cs104");
        if (CS104 == 2 && (bizDate = DateUtils.truncateDate((Date)bookJ.getDate("bizDate"))).compareTo(bookJ.getDate("bookDate")) > 0) {
            results_out.add(this.createResult(bookInfo, new JournalErrorCode().BIZDATE_LARGETHAN_SYSDATE().getMessage()));
            return false;
        }
        return true;
    }

    private boolean checkPeriod(BookInfo bookInfo, DynamicObject bookJ, Map<Long, DynamicObject> systemStatus, List<BookCheckResult> results_out) {
        if (bookJ.get("period") == null) {
            results_out.add(this.createResult(bookInfo, new JournalErrorCode().BEYONDPERIOD_CANNOT_BOOK().getMessage()));
            return false;
        }
        DynamicObject currentPeriod = systemStatus.get(DynamicObjectHelper.getPk((DynamicObject)bookJ, (String)"org"));
        if (currentPeriod != null) {
            DynamicObject curPeriodDy = currentPeriod.getDynamicObject("currentperiod");
            if (curPeriodDy == null) {
                curPeriodDy = currentPeriod.getDynamicObject("startperiod");
            }
            if ((currentPeriod = PeriodHelper.getPeriodById((long)curPeriodDy.getLong("id"))).getBoolean("isadjustperiod")) {
                results_out.add(this.createResult(bookInfo, new JournalErrorCode().ADJUSTPERIOD_CANNOT_BOOK().getMessage()));
                return false;
            }
        }
        return true;
    }

    private boolean isTrue(Map<Long, Boolean> isInitEnables, Long id) {
        return isInitEnables.get(id) != null && isInitEnables.get(id) != false;
    }

    private BookCheckResult createResult(BookInfo bookInfo, String info) {
        BookCheckResult result = new BookCheckResult();
        result.setBizId(bookInfo.getBizId());
        result.setBizBillNo(bookInfo.getBizBillNo());
        result.setInfo(info);
        return result;
    }

    private Set<Long> getAccounts(List<BookInfo> bookInfos) {
        if (bookInfos == null || bookInfos.size() == 0) {
            return new HashSet<Long>();
        }
        HashSet<Long> returns = new HashSet<Long>(bookInfos.size());
        for (BookInfo bookInfo : bookInfos) {
            List bookObjs = bookInfo.getBookObjs();
            if (bookObjs == null || bookObjs.size() <= 0) continue;
            for (DynamicObject bookObj : bookObjs) {
                String entityName = bookObj.getDynamicObjectType().getName();
                if ("cas_bankjournal".equals(entityName)) continue;
                returns.add(DynamicObjectHelper.getPk((DynamicObject)bookObj, (String)"accountcash"));
            }
        }
        return returns;
    }

    private Map<Object, DynamicObject> queryDatas(String formId, String selectFields, String filtField, Set<Long> values) {
        if (values == null || values.size() == 0) {
            return new HashMap<Object, DynamicObject>();
        }
        QFilter filter = new QFilter(filtField, "in", values);
        return BusinessDataServiceHelper.loadFromCache((String)formId, (String)selectFields, (QFilter[])filter.toArray());
    }

    static class Singleton {
        private static BookCommonCheck instance = new BookCommonCheck();

        Singleton() {
        }
    }
}

