/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal.book.jourrnalbook.check.bill;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.journal.CashVerificationBookJournalBuilder;
import kd.fi.cas.business.journal.book.jourrnalbook.check.bill.AbstractBookCheck;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.pojo.book.BookCheckResult;
import kd.fi.cas.pojo.book.BookInfo;

public class BookCheckCashVerification
extends AbstractBookCheck {
    private static final Log log = LogFactory.getLog(BookCheckCashVerification.class);
    private static final Set<String> NEEDBOOKFLAG = Sets.newHashSet((Object[])new String[]{"1", "2"});

    public static BookCheckCashVerification getInstance() {
        return Singleton.instance;
    }

    @Override
    public List<DynamicObject> checkNeedBook(List<DynamicObject> bizBills, List<BookCheckResult> results_out) {
        if (bizBills == null || bizBills.size() == 0) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> returns = new ArrayList<DynamicObject>(bizBills.size());
        Set<Long> orgids = this.getOrgIds(bizBills);
        Map systemParamsMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList<Long>(orgids));
        for (DynamicObject bizBill : bizBills) {
            Long orgId = bizBill.getDynamicObject("org").getLong("id");
            Object sysParam = ((Map)systemParamsMap.get(orgId + "")).get("cs105");
            if (NEEDBOOKFLAG.contains(bizBill.getString("checkresult")) && this.isNeedBookSysParam(sysParam) && (this.notZeroAmount(bizBill.getBigDecimal("inventorysurplus")) || this.notZeroAmount(bizBill.getBigDecimal("inventorydeficit")))) {
                returns.add(bizBill);
                continue;
            }
            log.info("===={}.BookCheckCashVerification.checkNeedBook.neednotbook===", (Object)bizBill.getString("billno"));
        }
        return returns;
    }

    private Set<Long> getOrgIds(List<DynamicObject> bizBills) {
        return bizBills.stream().map(o -> o.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
    }

    @Override
    public List<BookInfo> getBookInfos(List<DynamicObject> bizBills, Map<Long, Exception> results_out) {
        if (bizBills == null || bizBills.size() == 0) {
            return new ArrayList<BookInfo>();
        }
        DynamicObjectCollection bizBillsCols = new DynamicObjectCollection();
        bizBillsCols.addAll(bizBills);
        return this.map2List(new CashVerificationBookJournalBuilder().getJournalList(bizBillsCols, results_out));
    }

    private boolean isNeedBookSysParam(Object sysParam) {
        return "0".equals(sysParam) || "3".equals(sysParam);
    }

    public boolean notZeroAmount(BigDecimal amount) {
        return BigDecimal.ZERO.compareTo(amount) != 0;
    }

    static class Singleton {
        private static BookCheckCashVerification instance = new BookCheckCashVerification();

        Singleton() {
        }
    }
}

