/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.journal.AgentPayBookJournalBuilder;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.pojo.PayEntryStatusInfo;
import kd.fi.cas.business.pojo.PayStatusInfo;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BeBillStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.util.EmptyUtil;

public class AgentPayServiceHelper {
    public static void updateAcutalPayInfo(PayStatusInfo payStatus, DynamicObject agentPayBill) {
        AgentPayServiceHelper.updateAgentPayBill(payStatus, agentPayBill);
        if (BillStatusEnum.PAY.getValue().equals(agentPayBill.getString("billstatus"))) {
            if (AgentPayServiceHelper.isNeedBookJournal(agentPayBill)) {
                AgentPayServiceHelper.bookJournal(agentPayBill);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agentPayBill});
            if (payStatus.isNeedWriteback()) {
                AgentPayServiceHelper.writeBack(agentPayBill);
            }
        } else {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agentPayBill});
        }
    }

    public static void updateAgentPayBill(PayStatusInfo payStatus, DynamicObject agentPayBill) {
        if (PayStatusInfo.PayMode.OffLine == payStatus.getPayMode()) {
            agentPayBill.set("cashier", (Object)Long.valueOf(RequestContext.get().getUserId()));
            AgentPayServiceHelper.updateBillPayInfo(agentPayBill, payStatus.getEntryStatus());
        } else {
            BeBillStatusEnum bankAgentStatus = payStatus.getBankBillStatus();
            if (BeBillStatusEnum.TS == bankAgentStatus || BeBillStatusEnum.TF == bankAgentStatus) {
                if (PayStatusInfo.PayMode.BeSync == payStatus.getPayMode()) {
                    agentPayBill.set("batchseqid", (Object)payStatus.getBatchSeq());
                }
                AgentPayServiceHelper.updateBillPayInfo(agentPayBill, payStatus.getEntryStatus());
            }
            agentPayBill.set("bankagentpaystatus", (Object)bankAgentStatus.getValue());
            if (PayStatusInfo.PayMode.BeSync == payStatus.getPayMode()) {
                agentPayBill.set("bankcheckflag", (Object)CasHelper.subFlag((String)payStatus.getBankCheckFlag()));
                agentPayBill.set("bankcheckflag_tag", (Object)payStatus.getBankCheckFlag());
            }
        }
    }

    private static void updateBillPayInfo(DynamicObject agentPayBill, List<PayEntryStatusInfo> entryStatus) {
        agentPayBill.set("billstatus", (Object)BillStatusEnum.PAY.getValue());
        agentPayBill.set("paytime", (Object)new Date());
        BigDecimal actPayAmount = BigDecimal.ZERO;
        int actPayCount = 0;
        DynamicObjectCollection agentEntry = agentPayBill.getDynamicObjectCollection("entry");
        for (DynamicObject agentRow : agentEntry) {
            for (PayEntryStatusInfo rowStatus : entryStatus) {
                if (rowStatus.getEntryId() != agentRow.getLong("id")) continue;
                agentRow.set("e_issuccess", (Object)rowStatus.isSuccess());
                agentRow.set("bankreturnmsg", (Object)rowStatus.getBankReturnMsg());
                agentRow.set("e_isrefund", (Object)rowStatus.isRefund());
            }
            if (!agentRow.getBoolean("e_issuccess")) continue;
            actPayAmount = actPayAmount.add(agentRow.getBigDecimal("e_amount"));
            ++actPayCount;
        }
        agentPayBill.set("actpayamount", (Object)actPayAmount);
        agentPayBill.set("actcount", (Object)actPayCount);
    }

    public static boolean isNeedBookJournal(DynamicObject agentPayBill) {
        DynamicObject settleType = (DynamicObject)agentPayBill.get("settletype");
        long orgId = DynamicObjectHelper.getPk((DynamicObject)agentPayBill, (String)"org");
        if (CasBankJournalHelper.considerBillBookJournal((long)orgId) && EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
            String settlementtype = settleType.getString("settlementtype");
            return ExtendConfigHelper.bookBySettleType((String)settlementtype);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
            String settlementtype = settleType.getString("settlementtype");
            Set draftTypeList = Stream.of("2", "5", "6").collect(Collectors.toSet());
            if (draftTypeList.contains(settlementtype)) {
                return false;
            }
        }
        DynamicObjectCollection entry = agentPayBill.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            if (!row.getBoolean("e_issuccess") && !row.getBoolean("e_isrefund")) continue;
            return true;
        }
        return false;
    }

    public static void bookJournal(DynamicObject agentPayBill) {
        JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
        journalServiceAdapter.validateBook((IBookJournalBuilder)new AgentPayBookJournalBuilder(), agentPayBill);
        journalServiceAdapter.book(agentPayBill);
    }

    private static void writeBack(DynamicObject agentPayBill) {
        String source = agentPayBill.getString("source");
        if (!"BOTP".equals(source)) {
            return;
        }
        WriteBackTaskHelper.addRealtimeTask(agentPayBill, agentPayBill.getString("sourcebilltype"), WriteBackOperateEnum.PAY, AgentWriteBackConsumer.class);
    }

    public static List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(59);
        lst.add("billstatus");
        lst.add("org");
        lst.add("bizdate");
        lst.add("payeracctbank");
        lst.add("currency");
        lst.add("basecurrency");
        lst.add("payamount");
        lst.add("localamt");
        lst.add("exchangerate");
        lst.add("expectdealtime");
        lst.add("settletype");
        lst.add("count");
        lst.add("billtype");
        lst.add("org");
        lst.add("sourcebillnumber");
        lst.add("accountcash");
        lst.add("openorg");
        lst.add("modifier");
        lst.add("ispersonpay");
        lst.add("payeetype");
        lst.add("e_encryptamount");
        lst.add("e_amount");
        lst.add("paymentterm");
        lst.add("paymentfps");
        lst.add("paymentareacode");
        lst.add("informrecemail");
        lst.add("inforpayment");
        lst.add("payeename");
        lst.add("payeeacctbank");
        lst.add("payeebankname");
        lst.add("e_amount");
        lst.add("e_encryptamount");
        lst.add("payeebanknumber");
        lst.add("e_localamt");
        lst.add("e_encryptlocalamt");
        lst.add("sourcebillid");
        lst.add("isencryption");
        lst.add("e_encryptamount");
        lst.add("e_amount");
        lst.add("paymentchannel");
        lst.add("isdiffcur");
        lst.add("dpcurrency");
        lst.add("dpexchangerate");
        lst.add("dpamt");
        lst.add("dplocalamt");
        lst.add("lossamt");
        lst.add("agreedrate");
        lst.add("iscrosspay");
        lst.add("contractno");
        lst.add("crosstrantype");
        lst.add("paycountry");
        lst.add("reccountry");
        lst.add("payerbank");
        lst.add("recswiftcode");
        lst.add("paymenttype");
        lst.add("description");
        lst.add("delegorg");
        lst.add("feepayer");
        lst.add("feeactbank");
        lst.add("feecurrency");
        lst.add("fee");
        lst.add("actpayamount");
        lst.add("exratedate");
        lst.add("exratetable");
        lst.add("payquotation");
        lst.add("dppayquotation");
        lst.add("agreedquotation");
        lst.add("basecurrency");
        lst.add("e_dpamt");
        lst.add("e_dplocalamt");
        lst.add("matchflag");
        lst.add("matchamount");
        lst.add("unmatchamount");
        lst.add("entrymatchamount");
        lst.add("entryunmatchamount");
        lst.add("entrymatchflag");
        lst.add("businesstype");
        lst.add("recprovince");
        lst.add("reccity");
        lst.add("payeebank");
        return lst;
    }

    public static List<String> getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(70);
        selectors.add("billno");
        selectors.add("billstatus");
        selectors.add("source");
        selectors.add("payeracctbank");
        selectors.add("accountcash");
        selectors.add("org");
        selectors.add("bizdate");
        selectors.add("description");
        selectors.add("currency");
        selectors.add("exchangerate");
        selectors.add("settletype");
        selectors.add("settletnumber");
        selectors.add("localamt");
        selectors.add("payamount");
        selectors.add("sourcebilltype");
        selectors.add("count");
        selectors.add("paytime");
        selectors.add("actpayamount");
        selectors.add("actcount");
        selectors.add("cashier");
        selectors.add("iscommitbe");
        selectors.add("bankcheckflag");
        selectors.add("bankcheckflag_tag");
        selectors.add("delegorg");
        selectors.add("payeename");
        selectors.add("e_amount");
        selectors.add("e_localamt");
        selectors.add("e_encryptamount");
        selectors.add("e_encryptlocalamt");
        selectors.add("e_fundflowitem");
        selectors.add("e_issuccess");
        selectors.add("bankreturnmsg");
        selectors.add("settletnumber");
        selectors.add("batchseqid");
        selectors.add("bankagentpaystatus");
        selectors.add("e_isrefund");
        selectors.add("billtype");
        selectors.add("isencryption");
        selectors.add("sourcebillid");
        selectors.add("sourceentryid");
        selectors.add("paymentchannel");
        selectors.add("isdiffcur");
        selectors.add("dpcurrency");
        selectors.add("dpamt");
        selectors.add("iscrosspay");
        selectors.add("dplocalamt");
        selectors.add("agreedrate");
        selectors.add("dpexchangerate");
        selectors.add("fee");
        selectors.add("feecurrency");
        selectors.add("feeactbank");
        selectors.add("e_bankcheckflag");
        selectors.add("lossamt");
        selectors.add("isagencypersonpay");
        selectors.add("basecurrency");
        selectors.add("e_dpamt");
        selectors.add("e_dplocalamt");
        selectors.add("e_fee");
        selectors.add("payeebankname");
        selectors.add("payeeacctbank");
        selectors.add("e_fee");
        selectors.add("feepayer");
        selectors.add("acttradedate");
        selectors.add("createtime");
        selectors.add("e_paytime");
        selectors.add("payquotation");
        selectors.add("dppayquotation");
        selectors.add("agreedquotation");
        return selectors;
    }

    public static DynamicObject[] getSourceAgentBillList(List<Long> agentIdList) {
        ArrayList agentPaySourceBillIdList = new ArrayList(10);
        Map srcBills = BFTrackerServiceHelper.findSourceBills((String)"cas_agentpaybill", (Long[])agentIdList.toArray(new Long[0]));
        Set entrySet = srcBills.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            HashSet value = (HashSet)entry.getValue();
            if (!"cas_agentpaybill".equals(key)) continue;
            agentPaySourceBillIdList.addAll(value);
        }
        DynamicObject[] agentPaySourceBills = BusinessDataServiceHelper.load((Object[])agentPaySourceBillIdList.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_agentpaybill"));
        return agentPaySourceBills;
    }
}

