/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.opservice.helper.PaymentServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class GenReceivingBillHelper {
    private static Log LOGGER = LogFactory.getLog(GenReceivingBillHelper.class);

    public static void genReceivingBill(DynamicObject[] payBills) {
        if (EmptyUtil.isEmpty((Object[])payBills)) {
            return;
        }
        List<DynamicObject> cashPayBillList = Arrays.stream(payBills).filter(pay -> BaseDataHelper.isSettleTypeCash((DynamicObject)pay.getDynamicObject("settletype"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(cashPayBillList)) {
            return;
        }
        Set<Long> supplierIdSet = cashPayBillList.stream().filter(pay -> StringUtils.equals((CharSequence)pay.getString("payeetype"), (CharSequence)AsstActTypeEnum.SUPPLIER.getValue())).map(pay -> pay.getLong("payee")).collect(Collectors.toSet());
        Set<Long> customerIdSet = cashPayBillList.stream().filter(pay -> StringUtils.equals((CharSequence)pay.getString("payeetype"), (CharSequence)AsstActTypeEnum.CUSTOMER.getValue())).map(pay -> pay.getLong("payee")).collect(Collectors.toSet());
        Map<Object, DynamicObject> suppliers = PaymentServiceHelper.queryDatas(AsstActTypeEnum.SUPPLIER.getValue(), "id,internal_company", "id", supplierIdSet);
        Map<Object, DynamicObject> customers = PaymentServiceHelper.queryDatas(AsstActTypeEnum.CUSTOMER.getValue(), "id,internal_company", "id", customerIdSet);
        HashMap payeeIdAndCompanyId = new HashMap();
        if (EmptyUtil.isEmpty(cashPayBillList = cashPayBillList.stream().filter(pay -> {
            String payeeType = pay.getString("payeetype");
            long payeeId = pay.getLong("payee");
            if (StringUtils.equals((CharSequence)payeeType, (CharSequence)AsstActTypeEnum.COMPANY.getValue())) {
                payeeIdAndCompanyId.put(payeeId, payeeId);
                return true;
            }
            long payerId = pay.getDynamicObject("org").getLong("id");
            if (payeeId == payerId) {
                return false;
            }
            if (StringUtils.equals((CharSequence)payeeType, (CharSequence)AsstActTypeEnum.SUPPLIER.getValue())) {
                boolean internal;
                DynamicObject supplierDO = (DynamicObject)suppliers.get(payeeId);
                boolean bl = internal = EmptyUtil.isNoEmpty((DynamicObject)supplierDO) && EmptyUtil.isNoEmpty((DynamicObject)supplierDO.getDynamicObject("internal_company"));
                if (internal) {
                    payeeIdAndCompanyId.put(payeeId, supplierDO.getDynamicObject("internal_company").getLong("id"));
                }
                return internal;
            }
            if (StringUtils.equals((CharSequence)payeeType, (CharSequence)AsstActTypeEnum.CUSTOMER.getValue())) {
                boolean internal;
                DynamicObject customerDO = (DynamicObject)customers.get(payeeId);
                boolean bl = internal = EmptyUtil.isNoEmpty((DynamicObject)customerDO) && EmptyUtil.isNoEmpty((DynamicObject)customerDO.getDynamicObject("internal_company"));
                if (internal) {
                    payeeIdAndCompanyId.put(payeeId, customerDO.getDynamicObject("internal_company").getLong("id"));
                }
                return internal;
            }
            return false;
        }).collect(Collectors.toList()))) {
            return;
        }
        HashSet acctCashIdSet = new HashSet(10);
        cashPayBillList.forEach(pay -> {
            Long payeeAccountId;
            Long payerAccountId = pay.getLong("payeracctcash.id");
            if (EmptyUtil.isNoEmpty((Long)payerAccountId)) {
                acctCashIdSet.add(payerAccountId);
            }
            if (EmptyUtil.isNoEmpty((Long)(payeeAccountId = Long.valueOf(pay.getLong("payeeacctcash"))))) {
                acctCashIdSet.add(payeeAccountId);
            }
        });
        HashSet<Long> orgIdSet = new HashSet<Long>(payeeIdAndCompanyId.values());
        Map<Long, Boolean> isReceivingRecBillMap = GenReceivingBillHelper.getSystemParamBooleans(orgIdSet, "cs047");
        Map<Long, Boolean> isAllowEndPeriodRecMap = GenReceivingBillHelper.getSystemParamBooleans(orgIdSet, "cs127");
        LOGGER.info("[CashGenReceivingBill]isReceivingRecBillMap\uff1a{}\uff0cisAllowEndPeriodRecMap\uff1a{}", isReceivingRecBillMap, isAllowEndPeriodRecMap);
        Map cashAccountMap = BusinessDataServiceHelper.loadFromCache((String)"cas_accountcash", (QFilter[])new QFilter[]{new QFilter("id", "in", acctCashIdSet)});
        ArrayList<DynamicObject> recBills = new ArrayList<DynamicObject>(10);
        for (DynamicObject payBill : cashPayBillList) {
            long payeeId = payBill.getLong("payee");
            long companyId = payeeIdAndCompanyId.getOrDefault(payeeId, 0L);
            long payerId = payBill.getDynamicObject("org").getLong("id");
            LOGGER.info("[CashGenReceivingBill]\uff1apayeeid:{},payerid:{}", new Object[]{recBills.size(), payeeId, payerId});
            if (payeeId == payerId) continue;
            Date bizDate = payBill.getDate("bizdate");
            DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)companyId);
            LOGGER.info("[CashGenReceivingBill]payee:{}\uff0c\u4e1a\u52a1\u65e5\u671f:{}", (Object)companyId, (Object)bizDate);
            if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((DynamicObject)currentPeriod) && bizDate.before(currentPeriod.getDate("begindate")) && !isAllowEndPeriodRecMap.getOrDefault(companyId, false).booleanValue() || !isReceivingRecBillMap.getOrDefault(companyId, false).booleanValue()) continue;
            recBills.add(GenReceivingBillHelper.pushBill(payBill, cashAccountMap));
        }
        LOGGER.info("[CashGenReceivingBill]recBillsSize\uff1a{}", (Object)recBills.size());
        if (recBills.size() > 0) {
            OperateServiceHelper.execOperate((String)"save", (String)"cas_recbill", (DynamicObject[])recBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }

    public static DynamicObject pushBill(DynamicObject payBill, Map<Object, DynamicObject> cashAccountMap) {
        DynamicObject[] recBills = CasBotpHelper.push((DynamicObject)payBill, (String)"cas_recbill");
        if (recBills == null || recBills.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u4ed8\u534f\u540c\u672a\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PaymentServiceHelper_0", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (recBills.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u4ed8\u534f\u540c\u751f\u6210\u7684\u6536\u6b3e\u5355\u6570\u91cf\u5927\u4e8e1\uff0c\u8bf7\u68c0\u67e5BOTP\u914d\u7f6e\u3002", (String)"PaymentServiceHelper_1", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        DynamicObject recBill = recBills[0];
        Long orgId = DynamicObjectHelper.getPk((DynamicObject)recBill, (String)"org");
        if (!SystemStatusCtrolHelper.isInitEnable((long)orgId)) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org", (String)"name");
            throw new KDBizException(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
        }
        recBill.set("accountcash", (Object)cashAccountMap.get(payBill.getLong("payeeacctcash")));
        DynamicObject payerAccBank = cashAccountMap.get(payBill.getLong("payeracctcash.id"));
        recBill.set("payeracctbank", (Object)payerAccBank);
        recBill.set("payeracctbanknum", (Object)(EmptyUtil.isNoEmpty((DynamicObject)payerAccBank) ? payerAccBank.getString("number") : ""));
        DynamicObjectHelper.setValue((DynamicObject)recBill, (String)"accountbank", null);
        recBill.set("exratetable", (Object)(payBill.getDynamicObject("exratetable") != null ? payBill.getDynamicObject("exratetable") : SystemStatusCtrolHelper.getExrateTable((long)orgId)));
        recBill.set("exratedate", (Object)(payBill.getDate("exratedate") != null ? payBill.getDate("exratedate") : DateUtils.getCurrentDate()));
        DynamicObject currency = recBill.getDynamicObject("currency");
        DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
        BigDecimal exchangeRate = recBill.getBigDecimal("exchangerate");
        if (CasHelper.isEmpty((Object)exchangeRate) || exchangeRate.compareTo(BigDecimal.ONE) == 0) {
            if (currency != null && baseCurrency != null) {
                long destCurrencyId;
                boolean isCurrencyDifferent;
                long srcCurrencyId = currency.getLong("id");
                boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                if (isCurrencyDifferent) {
                    Date exrateDate = recBill.getDate("exratedate");
                    DynamicObject exrateTable = recBill.getDynamicObject("exratetable");
                    if (CasHelper.isNotEmpty((Object)exrateTable)) {
                        exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
                    }
                }
            }
            recBill.set("exchangerate", (Object)exchangeRate);
        }
        return recBill;
    }

    public static Map<Long, Boolean> getSystemParamBooleans(Set<Long> orgIds, String key) {
        HashMap<Long, Boolean> returns = new HashMap<Long, Boolean>(orgIds.size());
        Map sysParams = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList<Long>(orgIds), (String)key);
        for (Map.Entry sysParam : sysParams.entrySet()) {
            returns.put(Long.parseLong((String)sysParam.getKey()), SystemParameterHelper.getBoolean(sysParam.getValue()));
        }
        return returns;
    }
}

