/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.AutoMatchBillTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasHelper;

public class LoadCalResultDataHelper {
    public static void loadCalResultData(String thisOpnumber) {
        String strCloum = "smartmatch,ruleentry,rulename,entryentity,entryentity.org,entryentity.bizdate,entryentity.bankacct,entryentity.acctname,entryentity.acct,entryentity.amount,entryentity.num,entryentity.billstatus,entryentity.rectype,entryentity.settlestyle,entryentity.settlenumber,entryentity.billid,entryentity.description,record,entryentity.payamount,entryentity.paytype,entryentity.billentryid";
        QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
        DynamicObject[] automatchresultsaves = BusinessDataServiceHelper.load((String)"cas_autocalresult", (String)strCloum, (QFilter[])new QFilter[]{numberFilter});
        if (CasHelper.isEmpty((DynamicObject[])automatchresultsaves) || automatchresultsaves.length <= 0) {
            return;
        }
        ArrayList transDetailIds = new ArrayList(automatchresultsaves.length);
        String billEntityFlag = "";
        HashMap<String, ArrayList<Long>> bizBillMap = new HashMap<String, ArrayList<Long>>(2);
        for (DynamicObject automatchresultsave : automatchresultsaves) {
            DynamicObjectCollection col = automatchresultsave.getDynamicObjectCollection("entryentity");
            List<DynamicObject> transDetails = col.stream().filter(o -> o.getString("record").equals("0")).collect(Collectors.toList());
            transDetails.forEach(o -> transDetailIds.add(o.getString("billid")));
            List bizDOs = col.stream().filter(o -> !o.getString("record").equals("0")).collect(Collectors.toList());
            for (DynamicObject bizDO : bizDOs) {
                String payOrRecId = bizDO.getString("billid");
                AutoMatchBillTypeEnum billTypeEnum = AutoMatchBillTypeEnum.getByValue((String)bizDO.getString("record"));
                billEntityFlag = billTypeEnum.getBillEntity();
                ArrayList<Long> bizBillIdS = (ArrayList<Long>)bizBillMap.get(billEntityFlag);
                if (bizBillIdS == null) {
                    bizBillIdS = new ArrayList<Long>(16);
                }
                bizBillIdS.add(Long.valueOf(payOrRecId.trim()));
                bizBillMap.put(billEntityFlag, bizBillIdS);
            }
            DynamicObject smartmatch = automatchresultsave.getDynamicObject("smartmatch");
            Long entryId = automatchresultsave.getLong("ruleentry");
            String ruleName = LoadCalResultDataHelper.getRuleName(smartmatch, entryId);
            automatchresultsave.set("rulename", (Object)ruleName);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas");
        List transDetailIdsNew = transDetailIds.stream().map(o -> Long.valueOf(o.trim())).collect(Collectors.toList());
        DynamicObject[] transdetails = BusinessDataServiceHelper.load((Object[])transDetailIdsNew.toArray(), (DynamicObjectType)type);
        ArrayList<DynamicObject> businessDatas = new ArrayList<DynamicObject>(16);
        for (Map.Entry next : bizBillMap.entrySet()) {
            MainEntityType flagType = EntityMetadataCache.getDataEntityType((String)((String)next.getKey()));
            List bizBIllIdS = (List)next.getValue();
            DynamicObject[] businessDataArr = BusinessDataServiceHelper.load((Object[])bizBIllIdS.toArray(), (DynamicObjectType)flagType);
            businessDatas.addAll(Arrays.asList(businessDataArr));
        }
        for (DynamicObject automatchresultsave : automatchresultsaves) {
            DynamicObject smartmatch = automatchresultsave.getDynamicObject("smartmatch");
            Long entryId = automatchresultsave.getLong("ruleentry");
            DynamicObject ruleEntity = LoadCalResultDataHelper.getRuleEntity(smartmatch, entryId);
            DynamicObjectCollection col = automatchresultsave.getDynamicObjectCollection("entryentity");
            List transDetails = col.stream().filter(o -> o.getString("record").equals("0")).collect(Collectors.toList());
            List bizDOs = col.stream().filter(o -> !o.getString("record").equals("0")).collect(Collectors.toList());
            String direction = smartmatch.getString("direction");
            for (DynamicObject transDetailDO : transDetails) {
                String transDetailId = transDetailDO.getString("billid");
                for (DynamicObject bei_transdetail_cas : transdetails) {
                    if (!transDetailId.equals(bei_transdetail_cas.getPkValue().toString())) continue;
                    transDetailDO.set("org", bei_transdetail_cas.getDynamicObject("company").getPkValue());
                    transDetailDO.set("bizdate", bei_transdetail_cas.get("bizdate"));
                    if (!CasHelper.isEmpty((Object)bei_transdetail_cas.getDynamicObject("accountbank"))) {
                        transDetailDO.set("bankacct", bei_transdetail_cas.getDynamicObject("accountbank").getPkValue());
                    }
                    transDetailDO.set("acctname", (Object)bei_transdetail_cas.getString("oppunit"));
                    transDetailDO.set("acct", (Object)bei_transdetail_cas.getString("oppbanknumber"));
                    transDetailDO.set("num", (Object)bei_transdetail_cas.getString("billno"));
                    transDetailDO.set("billstatus", null);
                    transDetailDO.set("description", (Object)bei_transdetail_cas.getString("description"));
                    if ("rec".equals(direction)) {
                        transDetailDO.set("amount", bei_transdetail_cas.get("creditamount"));
                        continue;
                    }
                    transDetailDO.set("payamount", bei_transdetail_cas.get("debitamount"));
                }
            }
            for (DynamicObject businessData : businessDatas) {
                for (DynamicObject bizDO : bizDOs) {
                    String payOrRecId = bizDO.getString("billid");
                    String record = bizDO.getString("record");
                    if (!payOrRecId.equals(businessData.getPkValue().toString())) continue;
                    if (Stream.of("0", "1", "2", "3", "6").anyMatch(b -> b.equals(record))) {
                        bizDO.set("org", businessData.getDynamicObject("org").getPkValue());
                        bizDO.set("bizdate", businessData.get("bizdate"));
                        bizDO.set("num", (Object)businessData.getString("billno"));
                        if (!CasHelper.isEmpty((Object)businessData.getDynamicObject("settletype"))) {
                            bizDO.set("settlestyle", businessData.getDynamicObject("settletype").getPkValue());
                        }
                        bizDO.set("settlenumber", (Object)businessData.getString("settletnumber"));
                    }
                    if ("1".equals(record)) {
                        bizDO.set("rectype", businessData.getDynamicObject("receivingtype").getPkValue());
                        if (!CasHelper.isEmpty((Object)businessData.getDynamicObject("accountbank"))) {
                            bizDO.set("bankacct", businessData.getDynamicObject("accountbank").getPkValue());
                        }
                        bizDO.set("acctname", (Object)businessData.getString("payername"));
                        bizDO.set("amount", businessData.get("actrecamt"));
                        bizDO.set("acct", (Object)businessData.getString("payeracctbanknum"));
                        bizDO.set("description", (Object)businessData.getString("txt_description"));
                        if ("D".equals(businessData.getString("billstatus"))) {
                            bizDO.set("billstatus", (Object)ResManager.loadKDString((String)"\u5df2\u6536\u6b3e", (String)"LoadCalResultDataHelper_0", (String)"fi-cas-business", (Object[])new Object[0]));
                            continue;
                        }
                        bizDO.set("billstatus", (Object)BillStatusEnum.getName((String)businessData.getString("billstatus")));
                        continue;
                    }
                    if ("2".equals(record)) {
                        String recaccbankname;
                        if (!CasHelper.isEmpty((Object)businessData.getDynamicObject("paymenttype"))) {
                            bizDO.set("paytype", businessData.getDynamicObject("paymenttype").getPkValue());
                        }
                        bizDO.set("payamount", businessData.get("totalpayamt"));
                        if (!CasHelper.isEmpty((Object)businessData.getDynamicObject("payeracctbank"))) {
                            bizDO.set("bankacct", businessData.getDynamicObject("payeracctbank").getPkValue());
                        }
                        if (CasHelper.isEmpty((Object)(recaccbankname = businessData.getString("recaccbankname")))) {
                            bizDO.set("acctname", (Object)businessData.getString("payeenamev"));
                        } else {
                            bizDO.set("acctname", (Object)recaccbankname);
                        }
                        bizDO.set("acct", (Object)businessData.getString("payeebanknum"));
                        bizDO.set("description", (Object)businessData.getString("description"));
                        bizDO.set("billstatus", (Object)BillStatusEnum.getName((String)businessData.getString("billstatus")));
                        continue;
                    }
                    if ("3".equals(record)) {
                        String billEntryId;
                        boolean matchByEntry;
                        AgentPayBillHelper.decodeAmount((DynamicObject)businessData);
                        if (!CasHelper.isEmpty((Object)businessData.getDynamicObject("paymenttype"))) {
                            bizDO.set("paytype", businessData.getDynamicObject("paymenttype").getPkValue());
                        }
                        bizDO.set("payamount", businessData.get("dpamt"));
                        if (!CasHelper.isEmpty((Object)businessData.getDynamicObject("payeracctbank"))) {
                            bizDO.set("bankacct", businessData.getDynamicObject("payeracctbank").getPkValue());
                        }
                        if (ruleEntity != null && (matchByEntry = ruleEntity.getBoolean("e_matchbyentry")) && StringUtils.isNotEmpty((CharSequence)(billEntryId = bizDO.getString("billentryid")))) {
                            DynamicObjectCollection billEntryColl = businessData.getDynamicObjectCollection("entry");
                            billEntryColl.stream().filter(item -> Long.valueOf(billEntryId).equals(item.getLong("id"))).findFirst().ifPresent(item -> {
                                String payeeName = item.getString("payeename");
                                bizDO.set("acctname", (Object)payeeName);
                                bizDO.set("acct", (Object)item.getString("payeeacctbank"));
                                bizDO.set("payamount", item.get("e_amount"));
                            });
                        }
                        bizDO.set("description", (Object)businessData.getString("description"));
                        bizDO.set("billstatus", (Object)BillStatusEnum.getName((String)businessData.getString("billstatus")));
                        continue;
                    }
                    if ("4".equals(record) || "5".equals(record)) {
                        bizDO.set("bizdate", businessData.get("transbilldate"));
                        bizDO.set("num", (Object)businessData.getString("billno"));
                        bizDO.set("org", businessData.getDynamicObject("company").getPkValue());
                        bizDO.set("bankacct", businessData.getDynamicObject("accountbank").getPkValue());
                        if (ruleEntity != null && ruleEntity.getBoolean("e_matchbyentry")) {
                            DynamicObjectCollection billEntryColl = businessData.getDynamicObjectCollection("entrys");
                            billEntryColl.stream().filter(item -> Long.compare(bizDO.getLong("billentryid"), item.getLong("id")) == 0).findFirst().ifPresent(item -> {
                                bizDO.set("acctname", (Object)item.getDynamicObject("subacct_company").getString("name"));
                                bizDO.set("acct", (Object)item.getDynamicObject("subacct").getString("bankaccountnumber"));
                                if ("4".equals(bizDO.getString("record"))) {
                                    bizDO.set("amount", (Object)item.getBigDecimal("transamt"));
                                } else {
                                    bizDO.set("payamount", (Object)item.getBigDecimal("transamt"));
                                }
                                bizDO.set("description", (Object)item.getString("remark"));
                            });
                        }
                        bizDO.set("billstatus", (Object)BillStatusEnum.getName((String)businessData.getString("billstatus")));
                        continue;
                    }
                    if ("6".equals(record)) {
                        String recaccbankname;
                        bizDO.set("org", businessData.getDynamicObject("scorg").getPkValue());
                        if (!CasHelper.isEmpty((Object)businessData.getDynamicObject("paymenttype"))) {
                            bizDO.set("paytype", businessData.getDynamicObject("paymenttype").getPkValue());
                        }
                        bizDO.set("payamount", businessData.get("actpayamt"));
                        if (!CasHelper.isEmpty((Object)businessData.getDynamicObject("agentpayeraccount"))) {
                            bizDO.set("bankacct", businessData.getDynamicObject("agentpayeraccount").getPkValue());
                        }
                        if (CasHelper.isEmpty((Object)(recaccbankname = businessData.getString("recaccbankname")))) {
                            bizDO.set("acctname", (Object)businessData.getString("payeename"));
                        } else {
                            bizDO.set("acctname", (Object)recaccbankname);
                        }
                        bizDO.set("acct", (Object)businessData.getString("payeebanknum"));
                        bizDO.set("description", (Object)businessData.getString("description"));
                        bizDO.set("billstatus", (Object)BillStatusEnum.getName((String)businessData.getString("billstatus")));
                        continue;
                    }
                    if (!"7".equals(record)) continue;
                    bizDO.set("org", businessData.getDynamicObject("org").getPkValue());
                    bizDO.set("bizdate", businessData.get("bizdate"));
                    bizDO.set("num", (Object)businessData.getString("billno"));
                    bizDO.set("rec".equals(direction) ? "amount" : "payamount", businessData.get("rec".equals(direction) ? "buyamount" : "sellamount"));
                    bizDO.set("bankacct", businessData.getDynamicObject("rec".equals(direction) ? "buyingaccount" : "sellingaccount").getPkValue());
                    bizDO.set("billstatus", (Object)("F".equals(businessData.getString("billstatus")) ? ResManager.loadKDString((String)"\u5df2\u5151\u6362", (String)"LoadCalResultDataHelper_1", (String)"fi-cas-business", (Object[])new Object[0]) : BillStatusEnum.getName((String)businessData.getString("billstatus"))));
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])automatchresultsaves);
    }

    private static String getRuleName(DynamicObject smartmatch, Long entryId) {
        String ruleName = "";
        if (CasHelper.isNotEmpty((Object)smartmatch) && CasHelper.isNotEmpty((Object)entryId)) {
            DynamicObjectCollection entryentity = smartmatch.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                if (entryId.compareTo((Long)dynamicObject.getPkValue()) != 0) continue;
                ruleName = dynamicObject.getString("e_rulesname");
            }
        }
        return ruleName;
    }

    private static DynamicObject getRuleEntity(DynamicObject smartMatch, Long entryId) {
        DynamicObject result = null;
        if (CasHelper.isNotEmpty((Object)smartMatch) && CasHelper.isNotEmpty((Object)entryId)) {
            DynamicObjectCollection entryentity = smartMatch.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                if (entryId.compareTo((Long)dynamicObject.getPkValue()) != 0) continue;
                result = dynamicObject;
            }
        }
        return result;
    }

    public static String getBizBillType(DynamicObject bizDO) {
        String billFlag = "";
        String record = bizDO.getString("record");
        if (AutoMatchBillTypeEnum.RECBILL.getValue().equals(record)) {
            billFlag = "cas_recbill";
        } else if (AutoMatchBillTypeEnum.PAYBILL.getValue().equals(record)) {
            billFlag = "cas_paybill";
        } else if (AutoMatchBillTypeEnum.TransDetail.getValue().equals(record)) {
            billFlag = "bei_transdetail_cas";
        } else if (AutoMatchBillTypeEnum.AGENTPAYBILL.getValue().equals(record)) {
            billFlag = "cas_agentpaybill";
        } else if (AutoMatchBillTypeEnum.TRANSUP.getValue().equals(record)) {
            billFlag = "fca_transupbill";
        } else if (AutoMatchBillTypeEnum.TRANSDOWN.getValue().equals(record)) {
            billFlag = "fca_transdownbill";
        }
        return billFlag;
    }
}

