/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class PaymentServiceHelper {
    public static final String KEY_SUPPLIER = "key_Supplier";
    public static final String KEY_CUSTOMER = "key_Customer";
    public static final String KEY_PAYERACCTBANK = "key_payerAcctbank";
    public static final String KEY_PAYEEACCTBANK = "key_payeeAcctbank";
    public static final String KEY_PAYEEBANK = "key_payeeBank";
    public static final String KEY_ALLPAYEE = "key_allpayee";
    private static Log logger = LogFactory.getLog(PaymentServiceHelper.class);

    public static Set<String> getSourceBillType() {
        HashSet<String> set = new HashSet<String>();
        set.add("cas_recbill");
        set.add("fca_transupbill");
        set.add("fca_transdownbill");
        set.add("cas_betransdetail");
        set.add("bei_transdetail");
        set.add("bei_intelpay");
        set.add("cfm_repaymentbill");
        set.add("cfm_interestbill");
        set.add("cfm_preinterestbill");
        return set;
    }

    private static Map<Long, Boolean> checkConditionToRec(DynamicObject[] payBills) {
        if (payBills == null || payBills.length == 0) {
            return new HashMap<Long, Boolean>();
        }
        HashMap<Long, Boolean> returns = new HashMap<Long, Boolean>(payBills.length);
        Set billIds = Arrays.stream(payBills).map(o -> o.getLong("id")).collect(Collectors.toSet());
        String selectFields = "id,paymenttype,inneraccount";
        QFilter filter = new QFilter("id", "in", billIds);
        Map bills = BusinessDataServiceHelper.loadFromCache((String)"cas_paybill", (String)selectFields, (QFilter[])filter.toArray());
        for (DynamicObject payBill : payBills) {
            Long billId = payBill.getLong("id");
            if (PaymentServiceHelper.checkConditionType(payBill)) {
                returns.put(billId, PaymentServiceHelper.checkConditionBizType((DynamicObject)bills.get(billId)));
                continue;
            }
            returns.put(billId, false);
        }
        return returns;
    }

    private static boolean checkConditionBizType(DynamicObject pay) {
        if (EmptyUtil.isNoEmpty((DynamicObject)pay)) {
            DynamicObject payType = pay.getDynamicObject("paymenttype");
            DynamicObject innerAcc = pay.getDynamicObject("inneraccount");
            if (EmptyUtil.isNoEmpty((DynamicObject)payType) && EmptyUtil.isNoEmpty((DynamicObject)innerAcc) && payType.getString("biztype").equals(PayAndRecBizTypeEnum.FUNDS_UP.getValue())) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkConditionType(DynamicObject payBill) {
        DynamicObject billtype = payBill.getDynamicObject("billtype");
        if (billtype != null && (BillTypeConstants.PAYBILL_SYN.equals(billtype.getPkValue()) || BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue()))) {
            return false;
        }
        DynamicObject settleType = payBill.getDynamicObject("settletype");
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            return false;
        }
        return !PaymentServiceHelper.getSourceBillType().contains(payBill.getString("sourcebilltype"));
    }

    private static void doGenReceivingBill(DynamicObject[] payBills) {
        if (payBills == null || payBills.length == 0) {
            return;
        }
        Map<Long, Boolean> checkConds = PaymentServiceHelper.checkConditionToRec(payBills);
        Map<String, Set<Long>> needQueryIds = PaymentServiceHelper.getNeedQueryIds(payBills, checkConds, false);
        Map<Object, DynamicObject> suppliers = PaymentServiceHelper.queryDatas(AsstActTypeEnum.SUPPLIER.getValue(), "id,internal_company", "id", needQueryIds.get(KEY_SUPPLIER));
        Map<Object, DynamicObject> customers = PaymentServiceHelper.queryDatas(AsstActTypeEnum.CUSTOMER.getValue(), "id,internal_company", "id", needQueryIds.get(KEY_CUSTOMER));
        Map<Object, DynamicObject> payeracctbanks = PaymentServiceHelper.queryDatas("bd_accountbanks", "id,company", "id", needQueryIds.get(KEY_PAYERACCTBANK));
        Map<Object, DynamicObject> payeeacctbanks = PaymentServiceHelper.queryDatas("bd_accountbanks", "id,company,bank", "id", needQueryIds.get(KEY_PAYEEACCTBANK));
        PaymentServiceHelper.addIds(needQueryIds, suppliers.values().stream().filter(d -> !CasHelper.isEmpty((Object)d.getDynamicObject("internal_company"))).map(o -> o.getDynamicObject("internal_company").getLong("id")).collect(Collectors.toSet()), KEY_ALLPAYEE);
        PaymentServiceHelper.addIds(needQueryIds, customers.values().stream().filter(d -> !CasHelper.isEmpty((Object)d.getDynamicObject("internal_company"))).map(o -> o.getDynamicObject("internal_company").getLong("id")).collect(Collectors.toSet()), KEY_ALLPAYEE);
        Map<String, DynamicObject> multiFilterbanks = PaymentServiceHelper.queryMultiFilterBanks(payBills, payeeacctbanks, checkConds, false);
        Map<String, Boolean> isReceivingRecbills = PaymentServiceHelper.getSystemParamBooleans(needQueryIds.get(KEY_ALLPAYEE), "cs047");
        ArrayList<DynamicObject> recBills = new ArrayList<DynamicObject>(payBills.length);
        HashMap<Long, DynamicObject> orgId_curPeriod = new HashMap<Long, DynamicObject>(payBills.length);
        for (DynamicObject payBill : payBills) {
            Long payerAccountOrgPk;
            DynamicObject internal_company;
            long payee = payBill.getLong("payee");
            if (!PaymentServiceHelper.isTrue(checkConds.get(payBill.getLong("id"))) || CasHelper.isEmpty((Object)payee)) continue;
            Object companyId = null;
            String payeetype = payBill.getString("payeetype");
            if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeetype)) {
                DynamicObject supplierDO = suppliers.get(payee);
                internal_company = supplierDO.getDynamicObject("internal_company");
                if (CasHelper.isEmpty((Object)internal_company)) {
                    logger.info("====SUPPLIER\u975e\u5185\u90e8\u5ba2\u5546\u3002");
                    continue;
                }
                companyId = internal_company.getPkValue();
            } else if (AsstActTypeEnum.CUSTOMER.getValue().equals(payeetype)) {
                DynamicObject customerDO = customers.get(payee);
                internal_company = customerDO.getDynamicObject("internal_company");
                if (CasHelper.isEmpty((Object)internal_company)) {
                    logger.info("====CUSTOMER\u975e\u5185\u90e8\u5ba2\u5546\u3002");
                    continue;
                }
                companyId = internal_company.getPkValue();
            } else if (AsstActTypeEnum.COMPANY.getValue().equals(payeetype)) {
                companyId = payee;
            } else {
                logger.info("====\u65e0\u903b\u8f91\u5206\u652f\u3002");
                continue;
            }
            if (EmptyUtil.isNoEmpty((Object)companyId)) {
                boolean allow;
                Object allowObj;
                DynamicObject currentPeriod;
                Date bizDate = payBill.getDate("bizdate");
                if (orgId_curPeriod.containsKey((Long)companyId)) {
                    currentPeriod = (DynamicObject)orgId_curPeriod.get((Long)companyId);
                } else {
                    currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)((Long)companyId));
                    orgId_curPeriod.put((Long)companyId, currentPeriod);
                }
                logger.info("==companyId:{} ->bizdate:{} ->currentPeriod:{}", new Object[]{companyId, bizDate, currentPeriod});
                if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((DynamicObject)currentPeriod) && bizDate.before(currentPeriod.getDate("begindate")) && EmptyUtil.isNoEmpty((Object)(allowObj = SystemParameterHelper.getCASParamByOrgIds((Long)((Long)companyId), (String)"cs127"))) && !(allow = ((Boolean)allowObj).booleanValue())) continue;
            }
            DynamicObject payerAccount = payeracctbanks.get(payBill.getLong("payeracctbank.id"));
            DynamicObject payeeAccount = null;
            Long payeeacctbank = payBill.getLong("payeeacctbank");
            if (payeeacctbank != null && payeeacctbank != 0L) {
                payeeAccount = payeeacctbanks.get(payeeacctbank);
            }
            if (payeeAccount == null) {
                payeeAccount = multiFilterbanks.get(companyId + "!" + payBill.getString("payeebanknum"));
            }
            if (payeeAccount == null) {
                logger.info("====\u6536\u6b3e\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            Long payeeAccountOrgPk = (Long)companyId;
            if (payerAccount != null && (payerAccountOrgPk = (Long)payerAccount.getDynamicObject("company").getPkValue()).equals(payeeAccountOrgPk)) {
                logger.info("====\u6536\u4ed8\u6b3e\u8d26\u6237\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u76f8\u540c");
                continue;
            }
            Boolean isReceivingRecbill = PaymentServiceHelper.isTrue(isReceivingRecbills.get(payeeAccountOrgPk.toString()));
            logger.info("==\u5bf9\u65b9\u516c\u53f8\u53c2\u6570\u4e3a\u63a5\u6536\u6536\u6b3e\u56de\u5355\u7684:isReceivingRecbill:{},payeeAccountOrgPk:{}", (Object)isReceivingRecbill, (Object)payeeAccountOrgPk);
            if (!isReceivingRecbill.booleanValue()) continue;
            recBills.add(PaymentServiceHelper.pushBill(payBill, payeeAccountOrgPk, payeeAccount));
        }
        logger.info(String.format("recBills.size():%s", recBills == null ? 0 : recBills.size()));
        if (recBills.size() > 0) {
            OperateServiceHelper.execOperate((String)"save", (String)"cas_recbill", (DynamicObject[])recBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }

    private static DynamicObject pushBill(DynamicObject payBill, Long payeeAccountOrgPk, DynamicObject payeeAccount) {
        DynamicObject payerbank;
        DynamicObject[] recBills = CasBotpHelper.push((DynamicObject)payBill, (String)"cas_recbill");
        if (recBills == null || recBills.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u4ed8\u534f\u540c\u672a\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PaymentServiceHelper_0", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (recBills.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u4ed8\u534f\u540c\u751f\u6210\u7684\u6536\u6b3e\u5355\u6570\u91cf\u5927\u4e8e1\uff0c\u8bf7\u68c0\u67e5BOTP\u914d\u7f6e\u3002", (String)"PaymentServiceHelper_1", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        DynamicObject recBill = recBills[0];
        DynamicObjectHelper.setValueIfAbsent((DynamicObject)recBill, (String)"org", (Object)payeeAccountOrgPk);
        Long orgId = DynamicObjectHelper.getPk((DynamicObject)recBill, (String)"org");
        if (!SystemStatusCtrolHelper.isInitEnable((long)orgId)) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org", (String)"name");
            throw new KDBizException(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
        }
        DynamicObjectHelper.setValueIfAbsent((DynamicObject)recBill, (String)"payeebank", (Object)payeeAccount.get("bank"));
        recBill.set("exratetable", (Object)(payBill.getDynamicObject("exratetable") != null ? payBill.getDynamicObject("exratetable") : SystemStatusCtrolHelper.getExrateTable((long)orgId)));
        recBill.set("exratedate", (Object)(payBill.getDate("exratedate") != null ? payBill.getDate("exratedate") : DateUtils.getCurrentDate()));
        DynamicObject currency = recBill.getDynamicObject("currency");
        DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
        BigDecimal exchangeRate = recBill.getBigDecimal("exchangerate");
        if (CasHelper.isEmpty((Object)exchangeRate) || exchangeRate.compareTo(BigDecimal.ONE) == 0) {
            if (currency != null && baseCurrency != null) {
                long destCurrencyId;
                boolean isCurrencyDifferent;
                long srcCurrencyId = currency.getLong("id");
                boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                if (isCurrencyDifferent) {
                    Date exrateDate = recBill.getDate("exratedate");
                    DynamicObject exrateTable = recBill.getDynamicObject("exratetable");
                    if (CasHelper.isNotEmpty((Object)exrateTable)) {
                        exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
                    }
                }
            }
            recBill.set("exchangerate", (Object)exchangeRate);
        }
        if ((payerbank = payBill.getDynamicObject("payeebank")) != null) {
            DynamicObject finorginfo = BusinessDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("bebank.id", "=", payerbank.getPkValue())});
            recBill.set("payeebank", (Object)finorginfo);
        }
        return recBill;
    }

    private static Map<String, Boolean> getSystemParamBooleans(Set<Long> orgIds, String Key) {
        if (orgIds == null || orgIds.size() == 0) {
            return new HashMap<String, Boolean>();
        }
        HashMap<String, Boolean> returns = new HashMap<String, Boolean>(orgIds.size());
        List orgs = orgIds.stream().map(o -> o).collect(Collectors.toList());
        Map sysParams = SystemParameterHelper.getSystemParamsByOrgIds(orgs, (String)"cs047");
        for (Map.Entry sysParam : sysParams.entrySet()) {
            returns.put((String)sysParam.getKey(), SystemParameterHelper.getBoolean(sysParam.getValue()));
        }
        return returns;
    }

    public static Map<Object, DynamicObject> queryDatas(String formId, String selectFields, String filtField, Set<Long> values) {
        if (values == null || values.size() == 0) {
            return new HashMap<Object, DynamicObject>();
        }
        QFilter filter = new QFilter(filtField, "in", values);
        return BusinessDataServiceHelper.loadFromCache((String)formId, (String)selectFields, (QFilter[])filter.toArray());
    }

    public static Map<String, Set<Long>> getNeedQueryIds(DynamicObject[] payBills, Map<Long, Boolean> checkConds, boolean fromConvert) {
        HashMap<String, Set<Long>> returns = new HashMap<String, Set<Long>>(16);
        if (payBills == null || payBills.length == 0) {
            return returns;
        }
        for (DynamicObject payBill : payBills) {
            long payee;
            if (!fromConvert && !checkConds.get(payBill.getLong("id")).booleanValue() || CasHelper.isEmpty((Object)(payee = payBill.getLong("payee")))) continue;
            String payeetype = payBill.getString("payeetype");
            if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeetype)) {
                PaymentServiceHelper.addIds(returns, payee, KEY_SUPPLIER);
            } else if (AsstActTypeEnum.CUSTOMER.getValue().equals(payeetype)) {
                PaymentServiceHelper.addIds(returns, payee, KEY_CUSTOMER);
            } else {
                if (!AsstActTypeEnum.COMPANY.getValue().equals(payeetype)) continue;
                PaymentServiceHelper.addIds(returns, payee, KEY_ALLPAYEE);
            }
            PaymentServiceHelper.addIds(returns, payBill.getLong("payeebank.id"), KEY_PAYEEBANK);
            PaymentServiceHelper.addIds(returns, payBill.getLong("payeracctbank.id"), KEY_PAYERACCTBANK);
            PaymentServiceHelper.addIds(returns, payBill.getLong("payeeacctbank"), KEY_PAYEEACCTBANK);
        }
        return returns;
    }

    private static void addIds(Map<String, Set<Long>> key_queryIds, Long id, String key) {
        if (id != null && id != 0L) {
            Set id_all = key_queryIds.computeIfAbsent(key, k -> new HashSet(16));
            id_all.add(id);
        }
    }

    public static void addIds(Map<String, Set<Long>> key_queryIds, Set<Long> ids, String key) {
        if (ids != null && ids.size() > 0) {
            Set id_all = key_queryIds.computeIfAbsent(key, k -> new HashSet(16));
            id_all.addAll(ids);
        }
    }

    private static boolean isTrue(Boolean boolValue) {
        return boolValue != null && boolValue != false;
    }

    public static Map<String, DynamicObject> queryMultiFilterBanks(DynamicObject[] payBills, Map<Object, DynamicObject> payeeacctbanks, Map<Long, Boolean> checkConds, boolean fromConvert) {
        if (payBills == null || payBills.length == 0) {
            return new HashMap<String, DynamicObject>();
        }
        HashSet<String> filter_payeebanknum = new HashSet<String>(payBills.length);
        HashSet<Long> orgIds = new HashSet<Long>(payBills.length);
        for (DynamicObject payBill : payBills) {
            Long payeeacctbank;
            Long payee;
            if (!fromConvert && !PaymentServiceHelper.isTrue(checkConds.get(payBill.getLong("id"))) || CasHelper.isEmpty((Object)(payee = Long.valueOf(payBill.getLong("payee")))) || ((payeeacctbank = Long.valueOf(payBill.getLong("payeeacctbank"))) == null || payeeacctbank == 0L || payeeacctbanks.get(payeeacctbank) != null) && payeeacctbank != null && payeeacctbank != 0L) continue;
            filter_payeebanknum.add(payBill.getString("payeebanknum"));
            orgIds.add(fromConvert ? (Long)payBill.getDynamicObject("org").getPkValue() : payee);
        }
        Map queryDatas = new HashMap(filter_payeebanknum.size());
        if (filter_payeebanknum.size() > 0) {
            QFilter banknumFilter = new QFilter("bankaccountnumber", "in", filter_payeebanknum);
            QFilter acctstatusFilter = new QFilter("acctstatus", "=", (Object)"normal");
            QFilter companyFilter = fromConvert ? new QFilter("company", "in", orgIds) : AccountBankHelper.getAccountBankFilterByOrg(orgIds);
            queryDatas = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"company,id,openorg,bankaccountnumber,bank", (QFilter[])new QFilter[]{banknumFilter, acctstatusFilter, companyFilter});
        }
        return queryDatas.values().stream().collect(Collectors.toMap(o -> o.getLong("company.id") + "!" + o.getString("bankaccountnumber"), o -> o));
    }

    public static void genReceivingBill(DynamicObject[] payBills) {
        PaymentServiceHelper.doGenReceivingBill(payBills);
    }

    public static void addFieldKeys(List<String> fieldKeys) {
        fieldKeys.add("bilfieldKeysatus");
        fieldKeys.add("bizdate");
        fieldKeys.add("paymenttype");
        fieldKeys.add("payeetype");
        fieldKeys.add("description");
        fieldKeys.add("issingle");
        fieldKeys.add("org");
        fieldKeys.add("payeracctcash");
        fieldKeys.add("payeracctbank");
        fieldKeys.add("payerbank");
        fieldKeys.add("payee");
        fieldKeys.add("payeeformid");
        fieldKeys.add("payeename");
        fieldKeys.add("payeeaccformid");
        fieldKeys.add("payeeacctbank");
        fieldKeys.add("payeebanknum");
        fieldKeys.add("payeebank");
        fieldKeys.add("payeebankname");
        fieldKeys.add("entrustorg");
        fieldKeys.add("billno");
        fieldKeys.add("inneraccount");
        fieldKeys.add("actpayamt");
        fieldKeys.add("currency");
        fieldKeys.add("exchangerate");
        fieldKeys.add("localamt");
        fieldKeys.add("settletype");
        fieldKeys.add("settletnumber");
        fieldKeys.add("fundflowitem");
        fieldKeys.add("usage");
        fieldKeys.add("expectdate");
        fieldKeys.add("reccountry");
        fieldKeys.add("recprovince");
        fieldKeys.add("reccity");
        fieldKeys.add("recaccbankname");
        fieldKeys.add("recbanknumber");
        fieldKeys.add("sourcetype");
        fieldKeys.add("entrance");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("sourcebillnumber");
        fieldKeys.add("draftbill");
        fieldKeys.add("ispersonpay");
        fieldKeys.add("e_actamt");
        fieldKeys.add("e_localamt");
        fieldKeys.add("e_fundflowitem");
        fieldKeys.add("e_remark");
        fieldKeys.add("e_payableAmt");
        fieldKeys.add("e_lockAmt");
        fieldKeys.add("e_unlockAmt");
        fieldKeys.add("e_sourcebillid");
        fieldKeys.add("e_sourcebillentryid");
        fieldKeys.add("settleorg");
        fieldKeys.add("payeetype");
        fieldKeys.add("payee");
        fieldKeys.add("modifier");
        fieldKeys.add("paymentchannel");
        fieldKeys.add("payee");
        fieldKeys.add("payeename");
        fieldKeys.add("itempayee");
        fieldKeys.add("itempayeetype");
        fieldKeys.add("e_payableamt");
        fieldKeys.add("payeebanknum");
        fieldKeys.add("payeeacctbank");
        fieldKeys.add("isdiffcur");
        fieldKeys.add("dpcurrency");
        fieldKeys.add("dpamt");
        fieldKeys.add("dpexchangerate");
        fieldKeys.add("dplocalamt");
        fieldKeys.add("lossamt");
        fieldKeys.add("iscrosspay");
        fieldKeys.add("contractno");
        fieldKeys.add("recswiftcode");
        fieldKeys.add("recbanknumber");
        fieldKeys.add("crosstrantype");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("payeeacctbank");
        fieldKeys.add("creator");
        fieldKeys.add("billno");
        fieldKeys.add("isheadpush");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("sourceentry");
        fieldKeys.add("entry");
        fieldKeys.add("e_unsettledamt");
        fieldKeys.add("feepayer");
        fieldKeys.add("feeactbank");
        fieldKeys.add("feecurrency");
        fieldKeys.add("fee");
        fieldKeys.add("totalpayamt");
        fieldKeys.add("e_unsettledlocalamt");
        fieldKeys.add("e_payableamt");
        fieldKeys.add("e_payablelocamt");
        fieldKeys.add("e_material");
        fieldKeys.add("e_discountamt");
        fieldKeys.add("e_discountlocamt");
        fieldKeys.add("e_actamt");
        fieldKeys.add("e_localamt");
        fieldKeys.add("e_lockamt");
        fieldKeys.add("e_unlockamt");
        fieldKeys.add("e_settledamt");
        fieldKeys.add("e_unsettledamt");
        fieldKeys.add("e_expenseitem");
        fieldKeys.add("e_fundflowitem");
        fieldKeys.add("e_corebilltype");
        fieldKeys.add("e_scheid");
        fieldKeys.add("e_corebillno");
        fieldKeys.add("e_remark");
        fieldKeys.add("entrustorg");
        fieldKeys.add("e_settleorg");
        fieldKeys.add("payquotation");
        fieldKeys.add("exratedate");
        fieldKeys.add("exratetable");
        fieldKeys.add("exchangerate");
        fieldKeys.add("dpexratedate");
        fieldKeys.add("dpexratetable");
        fieldKeys.add("agreedrate");
        fieldKeys.add("dppayquotation");
        fieldKeys.add("agreedquotation");
        fieldKeys.add("basecurrency");
        fieldKeys.add("settletype");
        fieldKeys.add(String.join((CharSequence)".", "settletype", "settlementtype"));
        fieldKeys.add("settletnumber");
        fieldKeys.add("billtype");
        fieldKeys.add("singlestream");
        fieldKeys.add("paymentterm");
        fieldKeys.add("payernumber");
        fieldKeys.add("paymentidentify");
        fieldKeys.add("inforpayment");
        fieldKeys.add("recemail");
        fieldKeys.add("informrecemail");
        fieldKeys.add("paymentterm");
        fieldKeys.add("paymentfps");
        fieldKeys.add("paymentareacode");
        fieldKeys.add("settlestatus");
        fieldKeys.add("unsettleamount");
        fieldKeys.add("unsettleamountbase");
        fieldKeys.add("settleamount");
        fieldKeys.add("settleamountbase");
        fieldKeys.add("e_settledlocalamt");
        fieldKeys.add("payeenumber");
        fieldKeys.add("relateotherflow");
        fieldKeys.add("matchamountrec");
        fieldKeys.add("unmatchamountrec");
        fieldKeys.add("matchamountpay");
        fieldKeys.add("unmatchamountpay");
        fieldKeys.add("paymentidentify");
        fieldKeys.add("matchflag");
        fieldKeys.add("billstatus");
        fieldKeys.add("entry");
        fieldKeys.add("entry.e_sourcebillid");
        fieldKeys.add("entry.e_sourcebillid");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("entrance");
        fieldKeys.add("entrance");
        fieldKeys.add("entry.e_paymenttype");
        fieldKeys.add("uniformsocialcreditcode");
        fieldKeys.add("businesstype");
        fieldKeys.add("institutioncode");
        fieldKeys.add("institutionname");
        fieldKeys.add("multipaymenttype");
        fieldKeys.add("iswaitsche");
        fieldKeys.add("priority");
        fieldKeys.add("changestatus");
        fieldKeys.add("matchflagmsg");
        fieldKeys.add("istop");
        fieldKeys.add("entrybizdate");
        fieldKeys.add(String.join((CharSequence)".", "entry", "e_sourcebillid"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "transamount"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"));
        fieldKeys.add(String.join((CharSequence)".", "entry", "e_scheid"));
        fieldKeys.add("entry_lk");
        fieldKeys.add("billhead_lk");
        fieldKeys.add("contractnumber");
        fieldKeys.add("paydate");
        fieldKeys.add("payeeacctcash");
        fieldKeys.add("e_corebillid");
    }

    public static void genReceivingBill(DynamicObject payBill) {
        PaymentServiceHelper.genReceivingBill(new DynamicObject[]{payBill});
    }

    public static Boolean isSCM_CQConfig() {
        Object result = null;
        try {
            result = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"isCQConfig", (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.info("===\u672a\u5f00\u542f\u4f9b\u5e94\u5546\u534f\u540c");
        }
        if (CasHelper.isNotEmpty(result) && Boolean.parseBoolean(result.toString())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void delPurPay(DynamicObject[] payBills) {
        Object[] array = Stream.of(payBills).map(DataEntityBase::getPkValue).toArray();
        ArrayList<Object> ids = new ArrayList<Object>();
        for (Object id : array) {
            DynamicObject purPay = PaymentServiceHelper.getTargetBill("cas_paybill", id, "pur_pay");
            if (null == purPay) continue;
            ids.add(purPay.getPkValue());
        }
        if (!CollectionUtils.isEmpty(ids)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ids", ids);
            map.put("entityName", "pur_pay");
            try (TXHandle tx = TX.requiresNew();){
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"unAuditAndDeleteBill", (Object[])new Object[]{map});
                boolean success = (Boolean)result.get("success");
                if (!success) {
                    throw new KDBizException((String)result.get("message"));
                }
            }
        }
    }

    public static DynamicObject getTargetBill(String currEntity, Object currEntityId, String targetEntity) {
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)currEntity, (Long[])new Long[]{(Long)currEntityId});
        return PaymentServiceHelper.getBillFromBotpMap(targetEntity, botpMap);
    }

    private static DynamicObjectCollection getTargetBill(String currEntity, String selectFields, Set<Long> currEntityIds, String targetEntity) {
        if (currEntityIds == null || currEntityIds.size() == 0) {
            return null;
        }
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)currEntity, (Long[])currEntityIds.toArray(new Long[0]));
        return PaymentServiceHelper.getBillFromBotpMapBatch(targetEntity, selectFields, botpMap);
    }

    private static DynamicObject getBillFromBotpMap(String entityName, Map<String, HashSet<Long>> map) {
        DynamicObject sourceBill = null;
        HashSet<Long> sourceIds = map.get(entityName);
        if (!CollectionUtils.isEmpty(sourceIds)) {
            Long id = sourceIds.iterator().next();
            sourceBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
        }
        return sourceBill;
    }

    private static DynamicObjectCollection getBillFromBotpMapBatch(String entityName, String selectFields, Map<String, HashSet<Long>> map) {
        Set sourceIds;
        Set set = sourceIds = map == null ? null : (Set)map.get(entityName);
        if (!CollectionUtils.isEmpty((Collection)sourceIds)) {
            QFilter filter = new QFilter("id", "in", (Object)sourceIds);
            return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filter.toArray());
        }
        return null;
    }

    public static Map<Long, Boolean> isPushPurPay(DynamicObject[] payBills) {
        HashMap<Long, Boolean> returns = new HashMap<Long, Boolean>(payBills.length);
        Set<Long> payBillIds = Arrays.stream(payBills).map(o -> o.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection purPayBills = PaymentServiceHelper.getTargetBill("cas_paybill", "id", payBillIds, "pur_pay");
        Map<Long, DynamicObject> purPayBillsMap = PaymentServiceHelper.dyColToMap(purPayBills);
        DynamicObjectCollection payees = PaymentServiceHelper.queryPayees(payBills, purPayBillsMap);
        Map<Long, DynamicObject> payeesMap = PaymentServiceHelper.dyColToMap(payees);
        for (DynamicObject payBill : payBills) {
            String payeetype;
            boolean needPut = false;
            Long payBillId = payBill.getLong("id");
            if (PaymentServiceHelper.isNeedDo(purPayBillsMap, payBillId) && (payeetype = payBill.getString("payeetype")).equals("bd_supplier")) {
                try {
                    DynamicObject paymenttype;
                    boolean ispartpayment;
                    DynamicObject supplier = payeesMap.get(payBill.getLong("payee"));
                    boolean issuppcolla = Optional.ofNullable(supplier).map(vaule -> supplier.getBoolean("issuppcolla")).orElse(false);
                    if (issuppcolla && (ispartpayment = (paymenttype = payBill.getDynamicObject("paymenttype")).getBoolean("ispartpayment"))) {
                        needPut = true;
                    }
                }
                catch (Exception e) {
                    needPut = false;
                }
            }
            returns.put(payBillId, needPut);
        }
        return returns;
    }

    private static boolean isNeedDo(Map<Long, DynamicObject> purPayBillMaps, Long payBillId) {
        return purPayBillMaps == null || purPayBillMaps.get(payBillId) == null;
    }

    private static DynamicObjectCollection queryPayees(DynamicObject[] payBills, Map<Long, DynamicObject> purPayBillsMap) {
        HashSet<Long> payeeIds = new HashSet<Long>(payBills.length);
        for (DynamicObject payBill : payBills) {
            if (!PaymentServiceHelper.isNeedDo(purPayBillsMap, payBill.getLong("id"))) continue;
            payeeIds.add(payBill.getLong("payee"));
        }
        if (payeeIds.size() > 0) {
            QFilter filter = new QFilter("id", "in", payeeIds);
            return QueryServiceHelper.query((String)"bd_supplier", (String)"id,issuppcolla", (QFilter[])filter.toArray());
        }
        return null;
    }

    private static Map<Long, DynamicObject> dyColToMap(DynamicObjectCollection dyCols) {
        return dyCols == null ? new HashMap<Long, DynamicObject>() : dyCols.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
    }

    public static boolean isNeedLockAmt(String sourceBillType, Long sourceBillId) {
        DynamicObject[] applys;
        return "ap_payapply".equals(sourceBillType) && (applys = BusinessDataServiceHelper.load((String)"ap_payapply", (String)"id,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)})) != null && applys.length > 0 && ("ap_finapbill".equals(applys[0].getString("sourcebilltype")) || "ar_finarbill".equals(applys[0].getString("sourcebilltype")));
    }

    public static Set<Long> getNeedLockAmtSourceIds(String sourceBillType, Set<Long> sourceBillIds) {
        QFilter[] qFilters;
        DynamicObjectCollection apAppBills;
        Set<Long> ids = new HashSet<Long>(0);
        if ("ap_payapply".equals(sourceBillType) && EmptyUtil.isNoEmpty(sourceBillIds) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(apAppBills = QueryServiceHelper.query((String)"ap_payapply", (String)"id,sourcebilltype", (QFilter[])(qFilters = new QFilter[]{new QFilter("id", "in", sourceBillIds)}))))) {
            ids = apAppBills.parallelStream().filter(d -> "ap_finapbill".equals(d.getString("sourcebilltype")) || "ar_finarbill".equals(d.getString("sourcebilltype"))).map(d -> d.getLong("id")).collect(Collectors.toSet());
        }
        return ids;
    }

    public static boolean isEntrustTargetPayBill(DynamicObject payBill) {
        return CasHelper.isNotEmpty((Object)payBill.get("applyorg")) && "cas_paybill".equals(payBill.get("sourcebilltype"));
    }
}

