/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.context.DtxContext;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CoreBillSettingHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RecSaleServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(RecSaleServiceHelper.class);

    public static void convertSaleAndContract(DynamicObject[] infos, boolean isRec) {
        ECSession dtxSession;
        ArrayList<HashMap<String, Object>> saleMapList = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> contractMapList = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> planInMapList = new ArrayList<HashMap<String, Object>>();
        CommonParam saleParam = new CommonParam();
        CommonParam contractParam = new CommonParam();
        CommonParam planInParam = new CommonParam();
        for (DynamicObject info : infos) {
            if ("2".equals(info.getString("hotaccount"))) continue;
            String sourceBillType = info.getString("sourcebilltype");
            DynamicObjectCollection collectionEntry = info.getDynamicObjectCollection("entry");
            for (int i = 0; i < collectionEntry.size(); ++i) {
                DynamicObject entry = (DynamicObject)collectionEntry.get(i);
                HashMap<String, Object> saleMap = new HashMap<String, Object>();
                HashMap<String, Object> contractMap = new HashMap<String, Object>();
                HashMap<String, Object> planInMap = new HashMap<String, Object>();
                String coreBillType = entry.getString("e_corebilltype");
                int entrySeq = i + 1;
                if ("sm_salorder".equals(sourceBillType) || "sm_salorder".equals(coreBillType)) {
                    RecSaleServiceHelper.getDetailMap(info, entry, saleMap, isRec, entrySeq);
                    saleMapList.add(saleMap);
                    RecSaleServiceHelper.getDetailMap(info, entry, contractMap, isRec, entrySeq);
                    contractMap.put("contractID", entry.getLong("conbillid"));
                    contractMap.put("contractEntryID", entry.getLong("conbillentryid"));
                    contractMapList.add(contractMap);
                    continue;
                }
                if ("conm_salcontract".equals(coreBillType)) {
                    RecSaleServiceHelper.getDetailMap(info, entry, contractMap, isRec, entrySeq);
                    contractMap.put("contractID", entry.getLong("conbillid"));
                    contractMap.put("contractEntryID", entry.getLong("conbillentryid"));
                    contractMapList.add(contractMap);
                    continue;
                }
                if (!"mscon_performplanin".equals(coreBillType)) continue;
                RecSaleServiceHelper.getDetailMap(info, entry, planInMap, isRec, entrySeq);
                planInMapList.add(planInMap);
            }
        }
        saleParam.put((Object)"method", (Object)"wbSOAmount");
        saleParam.put((Object)"list", saleMapList);
        contractParam.put((Object)"method", (Object)"wbSalContAmount");
        contractParam.put((Object)"list", contractMapList);
        planInParam.put((Object)"list", planInMapList);
        if (CasHelper.isNotEmpty((Object)saleParam) && saleMapList.size() > 0) {
            dtxSession = (ECSession)DtxContext.getDtxSession();
            if (null == dtxSession) {
                ECGlobalSession.begin((String)"rec_wbsoamount", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
            }
            ECGlobalSession.register((String)"scmc", (String)"sm", (String)"SalWbService", (Param)saleParam, null, (String)"");
        }
        if (CasHelper.isNotEmpty((Object)contractParam) && contractMapList.size() > 0) {
            dtxSession = (ECSession)DtxContext.getDtxSession();
            if (null == dtxSession) {
                ECGlobalSession.begin((String)"rec_wbconamount", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
            }
            ECGlobalSession.register((String)"scmc", (String)"conm", (String)"SalConmService", (Param)contractParam, null, (String)"");
        }
        if (CasHelper.isNotEmpty((Object)planInParam) && planInMapList.size() > 0) {
            dtxSession = (ECSession)DtxContext.getDtxSession();
            if (null == dtxSession) {
                ECGlobalSession.begin((String)"rec_wbperformplanin", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
            }
            ECGlobalSession.register((String)"mpscmm", (String)"mscon", (String)"RecRegisterService", (Param)planInParam, null, (String)"");
        }
        RecSaleServiceHelper.coreBillSettingWriteBack(infos, isRec);
    }

    private static void coreBillSettingWriteBack(DynamicObject[] infos, boolean isRec) {
        List recBills = Arrays.stream(infos).filter(s -> !"2".equals(s.getString("hotaccount"))).collect(Collectors.toList());
        HashSet coreBillTypeSet = new HashSet(16);
        for (DynamicObject recBill : recBills) {
            DynamicObjectCollection entrys = recBill.getDynamicObjectCollection("entry");
            Set collectSet = entrys.stream().map(s -> s.getString("e_corebilltype")).collect(Collectors.toSet());
            coreBillTypeSet.addAll(collectSet);
        }
        HashMap<String, Pair> coreBillTypeMap = new HashMap<String, Pair>(16);
        List writeBackSetting = CoreBillSettingHelper.loadRecWriteBackInfo(coreBillTypeSet);
        Map backCoreBillType = writeBackSetting.stream().collect(Collectors.toMap(s -> s.getString("number"), Function.identity()));
        if (backCoreBillType.size() > 0) {
            for (DynamicObject recBill : recBills) {
                DynamicObjectCollection entrys = recBill.getDynamicObjectCollection("entry");
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    HashMap<String, Object> detailMap = new HashMap<String, Object>();
                    String coreBillType = entry.getString("e_corebilltype");
                    if (backCoreBillType.containsKey(coreBillType) && !coreBillTypeMap.containsKey(coreBillType)) {
                        coreBillTypeMap.put(coreBillType, Pair.of(new ArrayList(), (Object)new CommonParam()));
                    }
                    if (!coreBillTypeMap.containsKey(coreBillType)) continue;
                    Pair pair = (Pair)coreBillTypeMap.get(coreBillType);
                    int entrySeq = i + 1;
                    RecSaleServiceHelper.getDetailMapBySetting(recBill, entry, detailMap, isRec, entrySeq, (DynamicObject)backCoreBillType.get(coreBillType));
                    ((List)pair.getLeft()).add(detailMap);
                }
            }
            for (DynamicObject writeBack : writeBackSetting) {
                ECSession dtxSession;
                String coreNumber = writeBack.getString("number");
                Pair pair = (Pair)coreBillTypeMap.get(coreNumber);
                CommonParam param = (CommonParam)pair.getRight();
                param.put((Object)"list", pair.getLeft());
                String method = writeBack.getString("backmethodname");
                if (CasHelper.isNotEmpty((Object)method)) {
                    param.put((Object)"method", (Object)method);
                }
                if (null == (dtxSession = (ECSession)DtxContext.getDtxSession())) {
                    ECGlobalSession.begin((String)writeBack.getString("backkdtxnumber"), (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
                }
                ECGlobalSession.register((String)writeBack.getString("backcloud"), (String)writeBack.getDynamicObject("backappid").getString("number"), (String)writeBack.getString("backservicename"), (Param)param, null, (String)"");
            }
        }
    }

    private static void getDetailMapBySetting(DynamicObject recBill, DynamicObject entry, Map<String, Object> detailMap, boolean isRec, int entrySeq, DynamicObject setting) {
        long uniquekey = DB.genGlobalLongId();
        detailMap.put("uniquekey", uniquekey);
        detailMap.put("operate", isRec ? "receivingrec" : "cancelrec");
        detailMap.put("entityNumber", recBill.getDynamicObjectType().getName());
        detailMap.put("accessType", "REC");
        CoreBillSettingHelper.setRecWriteBackInfo((DynamicObject)recBill, (DynamicObject)entry, detailMap, (int)entrySeq, (DynamicObject)setting);
    }

    public static void getDetailMap(DynamicObject info, DynamicObject entry, Map<String, Object> detail, boolean isRec, int entrySeq) {
        long payer = info.getLong("payer");
        detail.put("asstactID", payer);
        detail.put("confirmLogo", info.getBoolean("confirmlogo"));
        DynamicObject currency = info.getDynamicObject("currency");
        detail.put("currencyId", currency != null ? currency.getPkValue() : Long.valueOf(0L));
        DynamicObject settleType = info.getDynamicObject("settletype");
        detail.put("settleTypeId", settleType != null ? settleType.getPkValue() : Long.valueOf(0L));
        detail.put("payeeDate", info.getDate("payeedate"));
        detail.put("operate", isRec ? "receivingrec" : "cancelrec");
        detail.put("entityNumber", info.getDynamicObjectType().getName());
        detail.put("pkId", info.getPkValue());
        detail.put("recBillNo", info.getString("billno"));
        String bizType = entry.getDynamicObject("e_receivingtype").getString("biztype");
        detail.put("bizType", bizType);
        detail.put("internalAsst", RecSaleServiceHelper.isExistInternalBusinessUnit(info.getString("payertype"), payer));
        long uniquekey = DB.genGlobalLongId();
        detail.put("uniquekey", uniquekey);
        detail.put("recMainBillEntity", entry.getString("e_corebilltype"));
        String coreBillId = entry.getString("e_corebillid");
        detail.put("recMainBillID", CasHelper.isNotEmpty((Object)coreBillId) ? Long.parseLong(coreBillId) : 0L);
        detail.put("recMainBillEntryID", entry.getLong("e_corebillentryid"));
        DynamicObject settleOrg = entry.getDynamicObject("e_settleorg");
        Long settleOrgID = CasHelper.isNotEmpty((Object)settleOrg) ? settleOrg.getLong("id") : 0L;
        detail.put("settleOrgID", settleOrgID);
        detail.put("accessType", "REC");
        BigDecimal receivableamt = entry.getBigDecimal("e_receivableamt");
        if (isRec) {
            detail.put("amount", receivableamt);
        } else {
            detail.put("amount", receivableamt.negate());
        }
        detail.put("entryPkId", entry.getPkValue());
        detail.put("entrySeq", entrySeq);
        detail.put("recMainBillNo", entry.getString("e_corebillno"));
        detail.put("recMainBillEntrySeq", entry.getInt("e_corebillentryseq"));
    }

    public static Boolean isExistInternalBusinessUnit(String entityName, Long assIds) {
        if (AsstActTypeEnum.EMPLOYEE.getValue().equals(entityName) || AsstActTypeEnum.COMPANY.getValue().equals(entityName) || AsstActTypeEnum.OTHER.getValue().equals(entityName)) {
            return null;
        }
        DynamicObject customerOrSupplier = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,internal_company", (QFilter[])new QFilter[]{new QFilter("internal_company", "=", (Object)assIds)});
        if (CasHelper.isNotEmpty((Object)customerOrSupplier) && CasHelper.isNotEmpty((Object)customerOrSupplier.get("internal_company"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected static <T> T invoke(String cloud, String app, String service, String method, Object ... params) {
        if (!"fi".equals(cloud)) {
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew((String)"recinvokeScmc");){
                Object object = DispatchServiceHelper.invokeBizService((String)cloud, (String)app, (String)service, (String)method, (Object[])params);
                return (T)object;
            }
            catch (Exception e) {
                try {
                    tx.markRollback();
                    LOGGER.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        return (T)DispatchServiceHelper.invokeBizService((String)cloud, (String)app, (String)service, (String)method, (Object[])params);
    }
}

