/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.opservice.helper.PaymentPayeeInfo;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;

public class ReceServiceHelper {
    private static Log logger = LogFactory.getLog(ReceServiceHelper.class);

    public static Set<String> getSourceBillType() {
        HashSet<String> set = new HashSet<String>();
        set.add("cas_paybill");
        set.add("fca_transdownbill");
        set.add("fca_transupbill");
        set.add("bei_transdetail");
        set.add("cas_betransdetail");
        set.add("bei_intelrec");
        set.add("cfm_loanbill");
        set.add("cim_invest_repaybill");
        set.add("cim_invest_interestbill");
        return set;
    }

    public static List<DynamicObject> checkConditionToRecBatch(DynamicObject[] recBills) {
        List payIdList = Arrays.stream(recBills).filter(o -> "cas_paybill".equals(o.getString("sourcebilltype"))).map(o -> o.getLong("sourcebillid")).collect(Collectors.toList());
        DynamicObjectCollection payDts = QueryServiceHelper.query((String)"cas_paybill", (String)"id,paymenttype.biztype,inneraccount.id", (QFilter[])new QFilter[]{new QFilter("id", "in", payIdList)});
        Map payMap = payDts.stream().collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        ArrayList<DynamicObject> recBillList = new ArrayList<DynamicObject>();
        for (DynamicObject recBill : recBills) {
            DynamicObject pay;
            DynamicObject settleType = recBill.getDynamicObject("settletype");
            if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
                logger.info("cash settletype");
                continue;
            }
            if (ReceServiceHelper.getSourceBillType().contains(recBill.getString("sourcebilltype"))) {
                logger.info("sourcebilltype not");
                continue;
            }
            String hotAccount = recBill.getString("hotaccount");
            if ("2".equals(hotAccount)) continue;
            String sourceBillType = recBill.getString("sourcebilltype");
            Long sourceBillId = recBill.getLong("sourcebillid");
            if ("cas_paybill".equals(sourceBillType) && EmptyUtil.isNoEmpty((DynamicObject)(pay = (DynamicObject)payMap.get(sourceBillId)))) {
                String biztype = pay.getString("paymenttype.biztype");
                Object innerAcc = pay.get("inneraccount.id");
                if (EmptyUtil.isNoEmpty((Object)innerAcc) && PayAndRecBizTypeEnum.FUNDS_UP.getValue().equals(biztype)) continue;
            }
            recBillList.add(recBill);
        }
        return recBillList;
    }

    public static void genPayBillBatch(DynamicObject[] recBills) {
        List<DynamicObject> firstFilterBills = ReceServiceHelper.checkConditionToRecBatch(recBills);
        Set payerAcctBankSet = Arrays.stream(recBills).map(o -> o.getLong("payeracctbank")).collect(Collectors.toSet());
        Map acctMap = BusinessDataServiceHelper.loadFromCache((Object[])payerAcctBankSet.stream().filter(Objects::nonNull).toArray(), (String)"bd_accountbanks");
        Set payeeAccountBankSet = Arrays.stream(recBills).map(o -> o.getLong("accountbank.id")).collect(Collectors.toSet());
        Map payeeMap = BusinessDataServiceHelper.loadFromCache((Object[])payeeAccountBankSet.stream().filter(Objects::nonNull).toArray(), (String)"bd_accountbanks");
        ArrayList<DynamicObject> secondFilterBills = new ArrayList<DynamicObject>(10);
        HashSet<Long> payerAcctOrgPkSet = new HashSet<Long>(10);
        HashMap<Long, Long> recPayerOrgIdMap = new HashMap<Long, Long>(10);
        ArrayList<DynamicObject> payBills = new ArrayList<DynamicObject>();
        CasBotpHelper.checkpush((String)"cas_recbill", (String[])new String[]{"cas_paybill"});
        for (DynamicObject recBill : firstFilterBills) {
            Object payeeAcctOrgPk;
            DynamicObject payeeAccountBank;
            DynamicObject payerAccountBank = (DynamicObject)acctMap.get(recBill.getLong("payeracctbank"));
            if (CasHelper.isEmpty((Object)payerAccountBank)) {
                String payeracctbanknum = recBill.getString("payeracctbanknum");
                QFilter banknumFilter = new QFilter("bankaccountnumber", "=", (Object)payeracctbanknum);
                QFilter acctstatusFilter = new QFilter("acctstatus", "=", (Object)"normal");
                payerAccountBank = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"company,bank", (QFilter[])new QFilter[]{banknumFilter, acctstatusFilter});
            }
            if ((payeeAccountBank = (DynamicObject)payeeMap.get(recBill.getLong("accountbank.id"))) == null || payerAccountBank == null) {
                logger.info("genPayBillBatch1");
                continue;
            }
            DynamicObject payerAcctOrg = payerAccountBank.getDynamicObject("company");
            DynamicObject payeeAcctOrg = payeeAccountBank.getDynamicObject("company");
            if (payerAcctOrg == null || payeeAcctOrg == null) {
                logger.info("genPayBillBatch2");
                continue;
            }
            Object payerAcctOrgPk = payerAcctOrg.getPkValue();
            if (org.apache.curator.shaded.com.google.common.base.Objects.equal((Object)payerAcctOrgPk, (Object)(payeeAcctOrgPk = payeeAcctOrg.getPkValue()))) {
                logger.info("genPayBillBatch3");
                continue;
            }
            secondFilterBills.add(recBill);
            payerAcctOrgPkSet.add((Long)payerAcctOrgPk);
            recPayerOrgIdMap.put(recBill.getLong("id"), (Long)payerAcctOrgPk);
        }
        if (EmptyUtil.isNoEmpty(secondFilterBills) && EmptyUtil.isNoEmpty(payerAcctOrgPkSet)) {
            Map<Long, Long> payerCompany = ReceServiceHelper.getPayerCompany(secondFilterBills);
            Set orgIdSet = secondFilterBills.stream().map(o -> o.getLong("org.id")).collect(Collectors.toSet());
            DynamicObjectCollection inits = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"org.id,isfinishinit", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIdSet)});
            HashMap<Long, Boolean> orgInit = null;
            if (inits != null && inits.size() > 0) {
                orgInit = new HashMap<Long, Boolean>();
                for (DynamicObject init : inits) {
                    orgInit.put(init.getLong("org.id"), init.getBoolean("isfinishinit"));
                }
            }
            Map orgParamMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(payerAcctOrgPkSet));
            for (DynamicObject secondFilterBill : secondFilterBills) {
                DynamicObject[] paymentBills;
                DynamicObject payerAccountBank = (DynamicObject)acctMap.get(secondFilterBill.getLong("payeracctbank"));
                if (null == payerAccountBank) {
                    logger.info("genPayBillBatch4");
                    continue;
                }
                String payerAcctOrgPk = String.valueOf(recPayerOrgIdMap.get(secondFilterBill.getLong("id")));
                boolean isAutoGenPayBill = (Boolean)((Map)orgParamMap.get(payerAcctOrgPk)).get("cs048");
                DynamicObject payeeAccountBank = (DynamicObject)payeeMap.get(secondFilterBill.getLong("accountbank.id"));
                if (!isAutoGenPayBill) continue;
                String payeetype = secondFilterBill.getString("payertype");
                Long payer = secondFilterBill.getLong("payer");
                if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeetype) || AsstActTypeEnum.CUSTOMER.getValue().equals(payeetype)) {
                    Long payee = payerCompany.get(payer);
                    if (CasHelper.isEmpty((Object)payee)) {
                        logger.info("genPayBillBatch5");
                        continue;
                    }
                    payer = payee;
                } else if (!AsstActTypeEnum.COMPANY.getValue().equals(payeetype)) {
                    logger.info("genPayBillBatch6");
                    continue;
                }
                if (EmptyUtil.isNoEmpty((Long)payer)) {
                    Object allowObj;
                    Date bizDate = secondFilterBill.getDate("bizdate");
                    DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)payer);
                    if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((DynamicObject)currentPeriod) && bizDate.before(currentPeriod.getDate("begindate")) && EmptyUtil.isNoEmpty((Object)(allowObj = SystemParameterHelper.getCASParamByOrgIds((Long)payer, (String)"cs103")))) {
                        boolean allow = (Boolean)allowObj;
                        logger.info("genPayBillBatch6 allow:{}", (Object)allow);
                        if (!allow) continue;
                    }
                }
                if ((paymentBills = CasBotpHelper.push((DynamicObject)secondFilterBill, (String)"cas_paybill")).length == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6536\u4ed8\u534f\u540c\u672a\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"ReceServiceHelper_0", (String)"fi-cas-business", (Object[])new Object[0]));
                }
                if (paymentBills.length > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6536\u4ed8\u534f\u540c\u751f\u6210\u4ed8\u6b3e\u5355\u6570\u91cf\u5927\u4e8e1\uff0c\u8bf7\u68c0\u67e5BOTP\u914d\u7f6e\u3002", (String)"ReceServiceHelper_1", (String)"fi-cas-business", (Object[])new Object[0]));
                }
                logger.info("genPayBillBatch7");
                DynamicObject paybill = paymentBills[0];
                DynamicObjectHelper.setValueIfAbsent((DynamicObject)paybill, (String)"org", (Object)payerAcctOrgPk);
                Long orgId = DynamicObjectHelper.getPk((DynamicObject)paybill, (String)"org");
                if (null == orgInit || null != orgInit.get(orgId) && !((Boolean)orgInit.get(orgId)).booleanValue()) {
                    DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"name");
                    throw new KDBizException(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
                }
                if (CasHelper.isEmpty((Object)paybill.get("payeebank")) || CasHelper.isEmpty((Object)paybill.getString("payeebankname"))) {
                    PaymentPayeeInfo paymentPayeeInfo = PaymentPayeeInfo.createByAccountBank(payeeAccountBank);
                    DynamicObjectHelper.setValueIfAbsent((DynamicObject)paybill, (String)"recaccbankname", (Object)paymentPayeeInfo.getPayeeRecName());
                    DynamicObjectHelper.setValueIfAbsent((DynamicObject)paybill, (String)"payeebankname", (Object)paymentPayeeInfo.getBankName());
                    DynamicObjectHelper.setValueIfAbsent((DynamicObject)paybill, (String)"recbanknumber", (Object)paymentPayeeInfo.getBankNumber());
                }
                DynamicObjectHelper.setValueIfAbsent((DynamicObject)paybill, (String)"payerbank", (Object)payerAccountBank.get("bank"));
                DynamicObject payerbank = secondFilterBill.getDynamicObject("f7_payerbank");
                if (!CasHelper.isEmpty((Object)payerbank)) {
                    DynamicObject finorginfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_finorginfo", (String)"fid", (QFilter[])new QFilter[]{new QFilter("bebank.id", "=", payerbank.getPkValue())});
                    paybill.set("payerbank", (Object)finorginfo);
                }
                payBills.add(paybill);
            }
        }
        if (payBills.size() > 0) {
            logger.info("genPayBillBatch8");
            OperateServiceHelper.execOperate((String)"save", (String)"cas_paybill", (DynamicObject[])payBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }

    private static Map<Long, Long> getPayerCompany(List<DynamicObject> recbills) {
        HashMap<Long, Long> compayMap = new HashMap<Long, Long>(recbills.size());
        List<String> supplierCustom = Arrays.asList(AsstActTypeEnum.SUPPLIER.getValue(), AsstActTypeEnum.CUSTOMER.getValue());
        Map<String, List<DynamicObject>> listMap = recbills.parallelStream().filter(d -> supplierCustom.contains(d.getString("payertype"))).collect(Collectors.groupingBy(d -> d.getString("payertype")));
        if (EmptyUtil.isNoEmpty(listMap)) {
            for (Map.Entry<String, List<DynamicObject>> map : listMap.entrySet()) {
                String payerType = map.getKey();
                List<DynamicObject> list = listMap.get(payerType);
                Long[] payers = (Long[])list.parallelStream().map(d -> d.getLong("payer")).toArray(Long[]::new);
                DynamicObjectCollection companyList = QueryServiceHelper.query((String)payerType, (String)"id,internal_company.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)payers)});
                Map<Long, Long> subMap = companyList.parallelStream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d.getLong("internal_company.id")));
                compayMap.putAll(subMap);
            }
        }
        return compayMap;
    }

    public static boolean isNeedValidate(DynamicObject info) {
        String entryName = "entryentity";
        if ("cas_recbill".equals(info.getDataEntityType().getName()) || "cas_recbill_change".equals(info.getDataEntityType().getName())) {
            if (info.getBoolean("confirmlogo")) {
                return false;
            }
            entryName = "entry";
        }
        return ReceServiceHelper.isNoClaimBillPush(info, entryName);
    }

    public static boolean isNeedWriteBack(DynamicObject info) {
        return ReceServiceHelper.isNoClaimBillPush(info, "entry");
    }

    private static boolean isNoClaimBillPush(DynamicObject info, String entryKey) {
        String sourcebilltype = info.getString("sourcebilltype");
        if (CasHelper.isNotEmpty((Object)sourcebilltype) && !"cas_claimcenterbill".equals(sourcebilltype)) {
            return false;
        }
        DynamicObjectCollection entrys = info.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : entrys) {
            if ("fr_glreim_paybill".equals(entry.getString("e_corebilltype")) || "fr_glreim_recbill".equals(entry.getString("e_corebilltype"))) {
                return true;
            }
            if ("ar_finarbill".equals(entry.getString("e_corebilltype"))) {
                return true;
            }
            if (!"sm_salorder".equals(entry.getString("e_corebilltype"))) continue;
            return true;
        }
        return false;
    }
}

