/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.errorcode.AgentPayErrorCode;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.WriteBackValidateHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class AgentPayCancelPayImpl
extends AbstractOpService {
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();

    @Override
    public List<String> getSelector() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("billstatus");
        selectors.add("iscommitbe");
        selectors.add("actpayamount");
        selectors.add("actcount");
        selectors.add("cashier");
        selectors.add("billtype");
        selectors.add("source");
        selectors.add("e_issuccess");
        selectors.add("sourcebilltype");
        selectors.add("delegorg");
        selectors.add("e_isrefund");
        selectors.add("fee");
        selectors.add("paymentchannel");
        selectors.add("payeracctbank");
        selectors.add("acctstatus");
        return selectors;
    }

    @Override
    public void validate(DynamicObject agentPayBill) throws KDException {
        DynamicObject otherarbill;
        String status = agentPayBill.getString("billstatus");
        if (!BillStatusEnum.PAY.getValue().equals(status)) {
            throw new KDBizException(new AgentPayErrorCode().STATUS_CANNOT_CANCELPAY(), new Object[0]);
        }
        String paymentchannel = agentPayBill.getString("paymentchannel");
        if (BillStatusEnum.PAY.getValue().equals(status) && "bei".equals(paymentchannel)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u4ed8\u6b3e\u4e14\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\u4e0d\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"AgentPayErrorCode_36", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        boolean isCommitBE = agentPayBill.getBoolean("iscommitbe");
        if (isCommitBE) {
            throw new KDBizException(new AgentPayErrorCode().HASCOMMITBE_CANNOT_CANCELPAY(), new Object[0]);
        }
        if (AgentPayBillHelper.isDelegAgent((DynamicObject)agentPayBill)) {
            throw new KDBizException(new AgentPayErrorCode().DELEG_AGENTCANCELPAY(), new Object[0]);
        }
        if (AgentPayBillHelper.isDelegPush((DynamicObject)agentPayBill) && (otherarbill = this.getPushBill(agentPayBill)) != null && !"A".equals(otherarbill.getString("billstatus"))) {
            throw new KDBizException(new AgentPayErrorCode().DELEG_AGENTTAGCANCELPAY(), new Object[]{agentPayBill.getString("billno"), otherarbill.getString("recorg.name"), otherarbill.getString("billno"), otherarbill.getString("billno")});
        }
        DynamicObjectCollection entry = agentPayBill.getDynamicObjectCollection("entry");
        if (entry.stream().anyMatch(d -> d.getBoolean("e_isrefund"))) {
            throw new KDBizException(new AgentPayErrorCode().REFUND_AGENTCANCELPAY(), new Object[0]);
        }
        this.journalServiceAdapter.validateCancelBook(agentPayBill);
        WriteBackValidateHelper.writeBackValidate(agentPayBill, WriteBackOperateEnum.CANCELPAYVALIDATE, AgentWriteBackConsumer.class);
    }

    @Override
    public void process(DynamicObject agentPayBill) throws KDException {
        this.canclePay(agentPayBill);
        if (AgentPayBillHelper.isDelegPush((DynamicObject)agentPayBill)) {
            DynamicObject otherarbill = this.getPushBill(agentPayBill);
            if (null != otherarbill) {
                OperateOption delOp = OperateOption.create();
                delOp.setVariableValue("app", "cas");
                OperateServiceHelper.execOperate((String)"delete", (String)"ar_finarbill", (Object[])new Long[]{otherarbill.getLong("id")}, (OperateOption)delOp);
            }
            Set setLongs = CasBotpHelper.getSrcBillByDestBill((Long)((Long)agentPayBill.get("id")), (String)"cas_agentpaybill", (String)"cas_agentpaybill");
            for (Long id : setLongs) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)agentPayBill.getDynamicObjectType());
                this.canclePay(object);
            }
        }
    }

    private void canclePay(DynamicObject agentPayBill) {
        DynamicObject payerAcctBank = (DynamicObject)agentPayBill.get("payeracctbank");
        if (EmptyUtil.isNoEmpty((DynamicObject)payerAcctBank) && "closed".equals(payerAcctBank.getString("acctstatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u72b6\u6001\u662f\u5df2\u9500\u6237\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"PaymentCancelPayValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        agentPayBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        agentPayBill.set("actpayamount", null);
        agentPayBill.set("actcount", null);
        agentPayBill.set("cashier", null);
        DynamicObjectCollection entry = agentPayBill.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            row.set("e_issuccess", (Object)"0");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agentPayBill});
        this.writeBack(agentPayBill);
        this.journalServiceAdapter.cancelBook(agentPayBill);
    }

    private void writeBack(DynamicObject agentPayBill) {
        String source = agentPayBill.getString("source");
        if (!"BOTP".equals(source)) {
            return;
        }
        WriteBackTaskHelper.addRealtimeTask(agentPayBill, agentPayBill.getString("sourcebilltype"), WriteBackOperateEnum.CANCELPAY, AgentWriteBackConsumer.class);
    }

    private DynamicObject getPushBill(DynamicObject agentPayBill) {
        QFilter srcBillId = new QFilter("sourcebillid", "=", (Object)agentPayBill.getString("id"));
        QFilter srcbilltype = new QFilter("sourcebilltype", "=", (Object)"cas_agentpaybill");
        DynamicObject otherarbill = BusinessDataServiceHelper.loadSingle((String)"ar_finarbill", (String)"id,recorg.name,billstatus,billno", (QFilter[])new QFilter[]{srcBillId, srcbilltype});
        return otherarbill;
    }
}

