/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.errorcode.AgentPayErrorCode;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.business.opservice.helper.AgentPayServiceHelper;
import kd.fi.cas.business.pojo.PayEntryStatusInfo;
import kd.fi.cas.business.pojo.PayStatusInfo;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackValidateHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.CheckUtils;

public class AgentPayPayImpl
extends AbstractOpService {
    @Override
    public List<String> getSelector() {
        return AgentPayServiceHelper.getSelectors();
    }

    @Override
    public void validate(DynamicObject info) throws KDException {
        if (!BillStatusEnum.AUDIT.getValue().equals(info.getString("billstatus"))) {
            throw new KDBizException(new AgentPayErrorCode().STATUS_CANNOT_PAY(), new Object[0]);
        }
        if ("bei".equals(info.getString("paymentchannel"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u8bf7\u63d0\u4ea4\u94f6\u4f01\u8fdb\u884c\u4ed8\u6b3e\u3002", (String)"PaymentErrorCode_53", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (!SystemStatusCtrolHelper.isInitEnable((long)info.getDynamicObject("org").getLong("id"))) {
            throw new KDBizException(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)info.getDynamicObject("org"), (String)"name")));
        }
        if (AgentPayBillHelper.isDelegAgent((DynamicObject)info)) {
            throw new KDBizException(new AgentPayErrorCode().DELEG_AGENTPAY(), new Object[0]);
        }
        DynamicObject accountBank = info.getDynamicObject("payeracctbank");
        if (null != accountBank && AccountBankHelper.isClosed((long)accountBank.getLong("id"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), accountBank.getString("number")));
        }
        if (info.getBoolean("isencryption")) {
            CheckUtils.checkAmtEqualEAmt((DynamicObject)info, (String)"payamount", (String)"e_encryptamount");
        } else {
            CheckUtils.checkAmtEqualEAmt((DynamicObject)info, (String)"payamount", (String)"e_amount");
        }
        WriteBackValidateHelper.writeBackValidate(info, WriteBackOperateEnum.PAYVALIDATE, AgentWriteBackConsumer.class);
    }

    @Override
    public void process(DynamicObject info) throws KDException {
        this.payUpdate(info);
        info.set("paytime", (Object)new Date());
        if (AgentPayBillHelper.isDelegPush((DynamicObject)info)) {
            boolean CS088 = SystemParameterHelper.getParameterBoolean((long)((Long)info.getDynamicObject("org").getPkValue()), (String)"cs088");
            if (CS088) {
                OperateServiceHelper.execOperate((String)"genotherarbill", (String)"cas_agentpaybill", (Object[])new Long[]{info.getLong("id")}, (OperateOption)OperateOption.create());
            }
            Set setLongs = CasBotpHelper.getSrcBillByDestBill((Long)((Long)info.get("id")), (String)"cas_agentpaybill", (String)"cas_agentpaybill");
            for (Long id : setLongs) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)info.getDynamicObjectType());
                this.payUpdate(object);
            }
        }
    }

    private void payUpdate(DynamicObject info) {
        Map params;
        Object agreeRate;
        if (info.getBoolean("isdiffcur") && (agreeRate = (params = this.param.getParams()).get("agreedrate")) != null) {
            BigDecimal dpAmt = new BigDecimal(params.get("dpamt").toString());
            BigDecimal fee = new BigDecimal(params.get("fee").toString());
            info.set("dpamt", (Object)dpAmt);
            info.set("agreedrate", agreeRate);
            info.set("fee", (Object)fee);
            BigDecimal dpExchangeRate = info.getBigDecimal("dpexchangerate");
            DynamicObject basecurrency = info.getDynamicObject("basecurrency");
            String dppayquotation = info.getString("dppayquotation");
            String agreedquotation = info.getString("agreedquotation");
            BigDecimal dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)basecurrency.getInt("amtprecision"));
            BigDecimal localAmt = info.getBigDecimal("localamt");
            info.set("dplocalamt", (Object)dpLocalAmt);
            info.set("lossamt", (Object)localAmt.subtract(dpLocalAmt));
            BigDecimal payAmount = info.getBigDecimal("payamount");
            BigDecimal agreedrate = info.getBigDecimal("agreedrate");
            DynamicObject dpcurrency = info.getDynamicObject("dpcurrency");
            BigDecimal sumDpamt = BigDecimal.ZERO;
            BigDecimal sumDpLocalamt = BigDecimal.ZERO;
            BigDecimal sumEFee = BigDecimal.ZERO;
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject row = (DynamicObject)entry.get(i);
                BigDecimal edpamt = BigDecimal.ZERO;
                BigDecimal edplocalamt = BigDecimal.ZERO;
                BigDecimal efee = BigDecimal.ZERO;
                if (i == entry.size() - 1) {
                    edpamt = dpAmt.subtract(sumDpamt);
                    edplocalamt = dpLocalAmt.subtract(sumDpLocalamt);
                    efee = fee.subtract(sumEFee);
                } else {
                    String encryptAmt = row.getString("e_encryptamount");
                    BigDecimal eamount = AgentPayBillHelper.decodeAmount((String)encryptAmt);
                    edpamt = dpcurrency != null ? QuotationHelper.callToCurrency((BigDecimal)eamount, (BigDecimal)agreedrate, (String)agreedquotation, (int)dpcurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency((BigDecimal)eamount, (BigDecimal)agreedrate, (String)agreedquotation, (int)10);
                    sumDpamt = sumDpamt.add(edpamt);
                    edplocalamt = QuotationHelper.callToCurrency((BigDecimal)edpamt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)basecurrency.getInt("amtprecision"));
                    sumDpLocalamt = sumDpLocalamt.add(edplocalamt);
                    if (dpcurrency != null) {
                        efee = fee.multiply(eamount.divide(payAmount, 10, 4)).setScale(dpcurrency.getInt("amtprecision"), 4);
                    }
                    sumEFee = sumEFee.add(efee);
                }
                row.set("e_dpamt", (Object)edpamt);
                row.set("e_dplocalamt", (Object)edplocalamt);
                row.set("e_fee", (Object)efee);
                row.set("e_paytime", (Object)new Date());
            }
        }
        PayStatusInfo payStatus = new PayStatusInfo();
        payStatus.setId((Long)info.getPkValue());
        payStatus.setPayMode(PayStatusInfo.PayMode.OffLine);
        ArrayList<PayEntryStatusInfo> entryStatus = new ArrayList<PayEntryStatusInfo>();
        DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            entryStatus.add(new PayEntryStatusInfo((Long)row.getPkValue(), true, null));
        }
        payStatus.setEntryStatus(entryStatus);
        AgentPayBillHelper.decodeAmount((DynamicObject)info);
        AgentPayServiceHelper.updateAcutalPayInfo(payStatus, info);
        boolean isencryption = info.getBoolean("isencryption");
        for (DynamicObject r : entry) {
            if (!isencryption) continue;
            r.set("e_amount", null);
            r.set("e_localamt", null);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
    }
}

