/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.botp.enums.AsstActTypeEnum;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.business.helper.AgentFillPropHelper;
import kd.fi.cas.business.helper.AutoMatchHelper;
import kd.fi.cas.business.helper.MatchAmountDealHelper;
import kd.fi.cas.business.helper.PaymentFillPropHelper;
import kd.fi.cas.business.helper.RecFillPropHelper;
import kd.fi.cas.enums.FeePayerEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CountryHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.CheckUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BillPropertyValueHandle {
    public BillPropertyValueHandle(DynamicObject bill) {
        String formID = bill.getDataEntityType().getName();
        if ("cas_paybill".equals(formID)) {
            DynamicObject payerBank = bill.getDynamicObject("payerbank");
            DynamicObject payeeBank = bill.getDynamicObject("payeebank");
            if (bill.containsProperty("iscrosspay") && null != payerBank && payerBank.containsProperty("country") && null != payeeBank && payeeBank.containsProperty("country")) {
                long orgId;
                boolean autoOpenCrossPay;
                DynamicObject payCountry = payerBank != null ? payerBank.getDynamicObject("country") : null;
                DynamicObject recCountry = payeeBank != null ? payeeBank.getDynamicObject("country") : null;
                DynamicObject org = bill.getDynamicObject("org");
                if (org != null && (autoOpenCrossPay = SystemParameterHelper.getParameterBoolean((long)(orgId = ((Long)org.getPkValue()).longValue()), (String)"autoopencrosspay")) && (payCountry != null && !CountryHelper.isChina((DynamicObject)payCountry) || recCountry != null && !CountryHelper.isChina((DynamicObject)recCountry))) {
                    this.setValue(bill, "iscrosspay", Boolean.TRUE);
                }
            }
            this.setValue(bill, "itempayeetype", bill.get("payeetype"));
            this.setValue(bill, "itempayee", bill.get("payee"));
            this.setValue(bill, "itempayee_id", bill.get("payee"));
            this.setValueIfAbsent(bill, "payernumber", bill.getDynamicObject("org").getString("number"));
            this.setValue(bill, "payeebanknum", CheckUtils.bankNumberCheck((String)bill.getString("payeebanknum")));
            this.setValue(bill, "payeebankname", CheckUtils.removeSpaces((String)bill.getString("payeebankname")));
            this.setValue(bill, "recaccbankname", CheckUtils.removeSpaces((String)bill.getString("recaccbankname")));
            Boolean isDiffCur = bill.getBoolean("isdiffcur");
            if (!isDiffCur.booleanValue()) {
                this.setValue(bill, "dpcurrency", bill.get("currency"));
                this.setValue(bill, "dpexchangerate", bill.get("exchangerate"));
                this.setValue(bill, "dpamt", bill.get("actpayamt"));
                this.setValue(bill, "dplocalamt", bill.get("localamt"));
                this.setValue(bill, "lossamt", BigDecimal.ZERO);
            } else {
                this.setValueIfAbsent(bill, "dpcurrency", bill.get("currency"));
                this.setValueIfAbsent(bill, "dpamt", bill.get("actpayamt"));
                this.setValueIfAbsent(bill, "dplocalamt", bill.get("localamt"));
                this.setValueIfAbsent(bill, "dpexchangerate", bill.get("exchangerate"));
            }
            DynamicObjectHelper.subStringPropMaxLenth((DynamicObject)bill, (String)"description");
            DynamicObjectHelper.subStringPropMaxLenth((DynamicObject)bill, (String)"usage");
            if (!FeePayerEnum.REC.getValue().equals(bill.getString("feepayer"))) {
                DynamicObject feecurrency = null;
                feecurrency = isDiffCur != false ? bill.getDynamicObject("dpcurrency") : bill.getDynamicObject("currency");
                boolean iscrosspay = bill.getBoolean("iscrosspay");
                boolean singlestream = bill.getBoolean("singlestream");
                if (!iscrosspay && !singlestream) {
                    this.setValue(bill, "feeactbank", bill.get("payeracctbank"));
                    this.setValue(bill, "feecurrency", feecurrency);
                } else {
                    this.setValueIfAbsent(bill, "feeactbank", bill.get("payeracctbank"));
                    this.setValueIfAbsent(bill, "feecurrency", feecurrency);
                }
            }
            if (bill.getBoolean("singlestream")) {
                this.setValue(bill, "totalpayamt", bill.getBigDecimal("dpamt"));
            } else {
                this.setValue(bill, "totalpayamt", bill.getBigDecimal("dpamt").add(bill.getBigDecimal("fee")));
            }
            Long orgId = DynamicObjectHelper.getPk((DynamicObject)bill, (String)"org");
            DynamicObject currency = bill.getDynamicObject("currency");
            if (CasHelper.isEmpty((Object)bill.getDynamicObject("basecurrency"))) {
                DynamicObject baseCur = OrgHelper.getBaseCurrency((long)orgId);
                if (baseCur == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u4fdd\u5b58\u5355\u636e\u3002", (String)"PaymentSaveImpl_1", (String)"fi-cas-business", (Object[])new Object[0]));
                }
                this.setValue(bill, "basecurrency", baseCur);
            }
            DynamicObject baseCurrency = bill.getDynamicObject("basecurrency");
            Boolean getRate = Boolean.FALSE;
            getRate = this.getRateAndSet(bill, orgId, "exchangerate", "exratetable", "exratedate", "payquotation", currency, baseCurrency);
            if (isDiffCur.booleanValue()) {
                DynamicObject dpCurrency = bill.getDynamicObject("dpcurrency");
                getRate = this.getRateAndSet(bill, orgId, "dpexchangerate", "dpexratetable", "dpexratedate", "dppayquotation", dpCurrency, baseCurrency);
                getRate = this.getRateAndSet(bill, orgId, "agreedrate", "exratetable", "exratedate", "agreedquotation", currency, dpCurrency);
            }
            if (getRate.booleanValue()) {
                PaymentFillPropHelper.calculateAmt(bill);
            }
            String payeeNumber = BillPropertyValueHandle.getPayeeNumber(bill.get("payee"), bill.getString("payeetype"));
            this.setValue(bill, "payeenumber", payeeNumber);
        } else if ("cas_recbill".equals(formID)) {
            this.setValue(bill, "itempayertype", bill.get("payertype"));
            this.setValue(bill, "itempayer", bill.get("payer"));
            this.setValue(bill, "itempayer_id", bill.get("payer"));
            Long orgId = DynamicObjectHelper.getPk((DynamicObject)bill, (String)"org");
            DynamicObject currency = bill.getDynamicObject("currency");
            DynamicObject baseCurrency = bill.getDynamicObject("basecurrency");
            Boolean getRate = Boolean.FALSE;
            getRate = this.getRateAndSet(bill, orgId, "exchangerate", "exratetable", "exratedate", "quotation", currency, baseCurrency);
            if (getRate.booleanValue()) {
                RecFillPropHelper.fillProp(bill);
            }
        } else if ("cas_agentpaybill".equals(formID)) {
            Long orgId = DynamicObjectHelper.getPk((DynamicObject)bill, (String)"org");
            DynamicObject currency = bill.getDynamicObject("currency");
            DynamicObject baseCurrency = bill.getDynamicObject("basecurrency");
            Boolean getRate = Boolean.FALSE;
            getRate = this.getRateAndSet(bill, orgId, "exchangerate", "exratetable", "exratedate", "payquotation", currency, baseCurrency);
            if (bill.getBoolean("isdiffcur")) {
                DynamicObject dpCurrency = bill.getDynamicObject("dpcurrency");
                getRate = this.getRateAndSet(bill, orgId, "dpexchangerate", "exratetable", "exratedate", "dppayquotation", dpCurrency, baseCurrency);
                getRate = this.getRateAndSet(bill, orgId, "agreedrate", "exratetable", "exratedate", "agreedquotation", currency, dpCurrency);
            }
            if (getRate.booleanValue()) {
                AgentFillPropHelper.calculateAmt(bill);
            }
        } else if ("cas_exchangebill".equals(formID)) {
            Long orgId = DynamicObjectHelper.getPk((DynamicObject)bill, (String)"org");
            DynamicObject buyingcurrency = bill.getDynamicObject("buyingcurrency");
            DynamicObject sellingcurrency = bill.getDynamicObject("sellingcurrency");
            DynamicObject commissioncurrency = bill.getDynamicObject("commissioncurrency");
            DynamicObject baseCurrency = bill.getDynamicObject("basecurrency");
            this.getRateAndSet(bill, orgId, "buyingexchangerate", "exratetable", "exratedate", "quotation", buyingcurrency, baseCurrency);
            this.getRateAndSet(bill, orgId, "sellingexchangerate", "exratetable", "exratedate", "salequotation", sellingcurrency, baseCurrency);
            this.getRateAndSet(bill, orgId, "commissionexchangerate", "exratetable", "exratedate", "otherquotation", commissioncurrency, baseCurrency);
            AutoMatchHelper.initMatchAmount(bill, bill.getBigDecimal("buyamount"), "buymatchamount", "buyunmatchamount", "buymatchflag", "buymatchflagmsg");
            AutoMatchHelper.initMatchAmount(bill, bill.getBigDecimal("sellamount"), "sellmatchamount", "sellunmatchamount", "sellmatchflag", "sellmatchflagmsg");
            AutoMatchHelper.initMatchAmount(bill, bill.getBigDecimal("commissionamount"), "feematchamount", "feeunmatchamount", "feematchflag", "feematchflagmsg");
            MatchAmountDealHelper.updataExchangeBill(bill);
        }
    }

    private void setValue(DynamicObject obj, String prop, Object value) {
        obj.set(prop, value);
    }

    private void setValueIfAbsent(DynamicObject obj, String prop, Object value) {
        if (CasHelper.isEmpty((Object)obj.get(prop))) {
            this.setValue(obj, prop, value);
        }
    }

    private Boolean getRateAndSet(DynamicObject bill, Long orgId, String rateField, String rateTableField, String rateDateField, String quotationField, DynamicObject srcCurrency, DynamicObject destCurrency) {
        Boolean getRate = Boolean.FALSE;
        BigDecimal rate = bill.getBigDecimal(rateField);
        if (CasHelper.isEmpty((Object)rate) || CasHelper.isEmpty((Object)bill.getString(quotationField))) {
            rate = BigDecimal.ONE;
            String quotation = "0";
            if (CasHelper.isNotEmpty((Object)srcCurrency) && CasHelper.isNotEmpty((Object)destCurrency)) {
                long destCurrencyId;
                boolean isCurrencyDifferent;
                long srcCurrencyId = srcCurrency.getLong("id");
                boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = destCurrency.getLong("id"));
                if (isCurrencyDifferent) {
                    Date exrateDate = bill.getDate(rateDateField);
                    DynamicObject exrateTable = bill.getDynamicObject(rateTableField);
                    if (exrateTable == null) {
                        exrateTable = SystemStatusCtrolHelper.getExrateTable((long)orgId);
                        bill.set(rateTableField, (Object)exrateTable);
                    }
                    if (CasHelper.isNotEmpty((Object)exrateTable)) {
                        Pair<String, BigDecimal> exchangeRateByTable = this.getExchangeRateByTable(srcCurrencyId, destCurrencyId, orgId, exrateDate, exrateTable.getLong("id"));
                        rate = (BigDecimal)exchangeRateByTable.getRight();
                        quotation = (String)exchangeRateByTable.getLeft();
                    }
                }
            }
            bill.set(rateField, (Object)rate);
            bill.set(quotationField, (Object)quotation);
            getRate = Boolean.TRUE;
        }
        return getRate;
    }

    private Pair<String, BigDecimal> getExchangeRateByTable(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date exratedate, Long exchangeRateTableId) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        String quteType = "0";
        if (sourceCurrencyId == null || sourceCurrencyId == 0L || targetCurrencyId == null || targetCurrencyId == 0L || sourceCurrencyId.equals(targetCurrencyId)) {
            return Pair.of((Object)quteType, (Object)exchangeRate);
        }
        if (sourceCurrencyId.longValue() == targetCurrencyId.longValue()) {
            return Pair.of((Object)quteType, (Object)exchangeRate);
        }
        if (exchangeRateTableId == 0L || CasHelper.isEmpty((Object)exchangeRateTableId)) {
            exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable((long)orgId).getLong("id");
        }
        Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)sourceCurrencyId, (Long)targetCurrencyId, (Long)exchangeRateTableId, (Date)exratedate);
        Object qt = exchangeRateMap.get("quoteType");
        Object er = exchangeRateMap.get("exchangeRate");
        if (qt != null && ((Boolean)qt).booleanValue()) {
            quteType = "1";
        }
        if (er != null) {
            exchangeRate = (BigDecimal)er;
        }
        return Pair.of((Object)quteType, (Object)exchangeRate);
    }

    private static String getPayeeNumber(Object id, String type) {
        DynamicObject payeeDO;
        Set set = Stream.of("bos_org", "bd_supplier", "bd_customer", "bos_user").collect(Collectors.toSet());
        if (!set.contains(type)) {
            return "";
        }
        if (!(CasHelper.isEmpty((Object)type) || AsstActTypeEnum.OTHER.getValue().equals(type) || CasHelper.isEmpty((Object)id) || CasHelper.isEmpty((Object)(payeeDO = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)type, (String)"number"))))) {
            return payeeDO.getString("number");
        }
        return "";
    }
}

