/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.opservice.AbstractBankVCCheckService;
import kd.fi.cas.business.pojo.BankVCCheckInfo;
import kd.fi.cas.util.DateUtils;

public class One2OneServiceImpl
extends AbstractBankVCCheckService {
    private boolean noSelectedItem;

    public One2OneServiceImpl(boolean noSelectedItem) {
        this.noSelectedItem = noSelectedItem;
    }

    @Override
    public void doCheck(BankVCCheckInfo checkInfo) {
        super.doCheck(checkInfo);
        int totalCount = this.getTotalCount(null);
        if (totalCount > 0) {
            if (totalCount <= this.onceCount) {
                QFilter singleFilter = this.getBaseFilter();
                this.doCheckSingle(singleFilter, singleFilter);
            } else {
                try (DataSet stateSet = QueryServiceHelper.queryDataSet((String)(this.getClass() + " checkSingle"), (String)"cas_bankstatement", (String)"id,creditamount+debitamount as sumamount", (QFilter[])this.getBaseFilter().toArray(), (String)"creditamount+debitamount");){
                    QFilter journalFilter;
                    QFilter stateFilter;
                    Iterator stateRows = stateSet.iterator();
                    BigDecimal tempSumAmount = null;
                    int dataCount = 0;
                    ArrayList<Long> stateIdList = new ArrayList<Long>();
                    Row stateRow = null;
                    BigDecimal beginAmount = null;
                    BigDecimal endAmount = null;
                    while (stateRows.hasNext()) {
                        stateRow = (Row)stateRows.next();
                        stateIdList.add(stateRow.getLong("id"));
                        if (++dataCount == 1) {
                            beginAmount = stateRow.getBigDecimal("sumamount");
                        }
                        tempSumAmount = stateRow.getBigDecimal("sumamount");
                        if (dataCount % this.onceCount != 0) continue;
                        endAmount = tempSumAmount;
                        stateFilter = new QFilter("id", "in", stateIdList);
                        journalFilter = this.getBaseFilter().and("creditamount+debitamount", ">=", (Object)beginAmount).and("creditamount+debitamount", "<=", (Object)endAmount);
                        this.doCheckSingle(stateFilter, journalFilter);
                        stateIdList = new ArrayList();
                        beginAmount = endAmount;
                    }
                    if (stateIdList.size() > 0) {
                        endAmount = tempSumAmount;
                        stateFilter = new QFilter("id", "in", stateIdList);
                        journalFilter = this.getBaseFilter().and("creditamount+debitamount", ">=", (Object)beginAmount).and("creditamount+debitamount", "<=", (Object)endAmount);
                        this.doCheckSingle(stateFilter, journalFilter);
                    }
                }
            }
        }
    }

    protected void doCheckSingle(QFilter stateFilter, QFilter journalFilter) {
        String selector = "id,org,accountbank,currency,bizdate,creditamount,debitamount,settlementtype,settlementnumber,description,oppunit,bankcheckflag,ischeck";
        DynamicObjectCollection stateColl = QueryServiceHelper.query((String)(this.getClass() + " checkSingle"), (String)"cas_bankstatement", (String)selector, (QFilter[])stateFilter.toArray(), (String)"creditamount+debitamount");
        DynamicObjectCollection journalColl = QueryServiceHelper.query((String)(this.getClass() + " checkSingle"), (String)"cas_bankjournal", (String)(selector + ",bankcheckflag_tag,bookdate"), (QFilter[])journalFilter.toArray(), (String)"creditamount+debitamount");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ArrayList<Object[]> entryParamsList = new ArrayList<Object[]>();
        HashSet<Long> stateIdset = new HashSet<Long>();
        HashSet<Long> journalIdset = new HashSet<Long>();
        if (stateColl.size() > 0 && journalColl.size() > 0) {
            int size = stateColl.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject state = (DynamicObject)stateColl.get(i);
                BigDecimal stateCredit = state.getBigDecimal("creditamount");
                BigDecimal stateDebit = state.getBigDecimal("debitamount");
                BigDecimal stateSum = stateCredit.add(stateDebit);
                ArrayList<DynamicObject> matchedJournalList = null;
                int jSize = journalColl.size();
                for (int j = 0; j < jSize; ++j) {
                    BigDecimal journalDebit;
                    DynamicObject journal = (DynamicObject)journalColl.get(j);
                    if (journal.getBoolean("ischeck")) continue;
                    BigDecimal journalCredit = journal.getBigDecimal("creditamount");
                    BigDecimal journalSum = journalCredit.add(journalDebit = journal.getBigDecimal("debitamount"));
                    if (journalSum.compareTo(stateSum) > 0) break;
                    if (stateCredit.compareTo(journalDebit) != 0 || stateDebit.compareTo(journalCredit) != 0) continue;
                    if (matchedJournalList == null) {
                        matchedJournalList = new ArrayList<DynamicObject>();
                    }
                    boolean isMatch = true;
                    if (!this.noSelectedItem) {
                        if (this.checkScheme.getBoolean("isbizdate")) {
                            boolean bl = isMatch = isMatch && state.getDate("bizdate") != null && journal.getDate("bizdate") != null && One2OneServiceImpl.strEqual(DateUtils.formatString((Date)state.getDate("bizdate"), (String)"yyyy-MM-dd"), DateUtils.formatString((Date)journal.getDate("bizdate"), (String)"yyyy-MM-dd"));
                        }
                        if (this.checkScheme.getBoolean("isdatediff") && this.checkScheme.getInt("datediffcount") > 0) {
                            boolean bl = isMatch = isMatch && state.getDate("bizdate") != null && journal.getDate("bizdate") != null && One2OneServiceImpl.dateDiff(state.getDate("bizdate"), journal.getDate("bizdate"), this.checkScheme.getInt("datediffcount"));
                        }
                        if (this.checkScheme.getBoolean("isdescription")) {
                            boolean bl = isMatch = isMatch && state.getString("description") != null && journal.getString("description") != null && One2OneServiceImpl.strEqual(state.getString("description"), journal.getString("description"));
                        }
                        if (this.checkScheme.getBoolean("isoppunit")) {
                            boolean bl = isMatch = isMatch && state.getString("oppunit") != null && journal.getString("oppunit") != null && One2OneServiceImpl.strEqual(state.getString("oppunit"), journal.getString("oppunit"));
                        }
                        if (this.checkScheme.getBoolean("issettlenum4auto")) {
                            boolean bl = isMatch = isMatch && state.getString("settlementnumber") != null && journal.getString("settlementnumber") != null && One2OneServiceImpl.strEqual(state.getString("settlementnumber"), journal.getString("settlementnumber"));
                        }
                        if (this.checkScheme.getBoolean("issettlementtype")) {
                            boolean bl = isMatch = isMatch && state.getLong("settlementtype") != 0L && journal.getLong("settlementtype") != 0L && state.getLong("settlementtype") == journal.getLong("settlementtype");
                        }
                    }
                    if (!isMatch) continue;
                    matchedJournalList.add(journal);
                }
                if (matchedJournalList == null || matchedJournalList.size() <= 0) continue;
                int minDiffIndex = -1;
                long dateDiff = Long.MAX_VALUE;
                for (int j = 0; j < matchedJournalList.size(); ++j) {
                    DynamicObject journal = (DynamicObject)matchedJournalList.get(j);
                    long nextDateDiff = Math.abs(state.getDate("bizdate").getTime() - journal.getDate("bizdate").getTime());
                    if (nextDateDiff >= dateDiff) continue;
                    dateDiff = nextDateDiff;
                    minDiffIndex = j;
                }
                state.set("ischeck", (Object)true);
                ((DynamicObject)matchedJournalList.get(minDiffIndex)).set("ischeck", (Object)true);
                this.addSingleVCResult(paramsList, entryParamsList, state, (DynamicObject)matchedJournalList.get(minDiffIndex), stateIdset, journalIdset);
            }
            this.updateTable(paramsList, entryParamsList, stateIdset, journalIdset);
        }
    }

    private void addSingleVCResult(List<Object[]> paramsList, List<Object[]> entryParamsList, DynamicObject state, DynamicObject journal, Set<Long> stateSet, Set<Long> journalIdset) {
        long id = DB.genLongId((String)"t_cas_checkedresult");
        SqlParameter[] params = new SqlParameter[10];
        params[0] = new SqlParameter(":fid", -5, (Object)id);
        params[1] = new SqlParameter(":faccountbankid", -5, (Object)this.accountBankId);
        params[2] = new SqlParameter(":fcurrencyid", -5, (Object)this.currencyId);
        params[3] = new SqlParameter(":fchecktype", 12, (Object)this.checkType);
        long stateId = state.getLong("id");
        long stateOrgId = state.getLong("org");
        BigDecimal stateAmount = state.getBigDecimal("debitamount").intValue() != 0 ? state.getBigDecimal("debitamount") : state.getBigDecimal("creditamount");
        String stateDirection = state.getBigDecimal("debitamount").intValue() != 0 ? "debit" : "credit";
        this.addEntryResult(state, "cas_bankstatement", stateId, entryParamsList, id, stateOrgId);
        stateSet.add(stateId);
        long journalId = journal.getLong("id");
        long journalOrgId = journal.getLong("org");
        BigDecimal journalAmount = journal.getBigDecimal("debitamount").intValue() != 0 ? journal.getBigDecimal("debitamount") : journal.getBigDecimal("creditamount");
        String journalDirection = journal.getBigDecimal("debitamount").intValue() != 0 ? "debit" : "credit";
        this.addEntryResult(journal, "cas_bankjournal", journalId, entryParamsList, id, journalOrgId);
        journalIdset.add(journalId);
        params[4] = new SqlParameter(":fcompanyid", -5, (Object)stateOrgId);
        params[5] = new SqlParameter(":fstateAmount", 3, (Object)stateAmount);
        params[6] = new SqlParameter(":fjournalAmount", 3, (Object)journalAmount);
        params[7] = new SqlParameter(":fstateDirection", 12, (Object)stateDirection);
        params[8] = new SqlParameter(":fjournalDirection", 12, (Object)journalDirection);
        params[9] = new SqlParameter(":fcheckdate", 91, (Object)this.checkDate);
        paramsList.add(params);
    }

    private static boolean dateDiff(Date date1, Date date2, int dateDiff) {
        int diff = Math.abs((int)((date1.getTime() - date2.getTime()) / 86400000L));
        return diff <= dateDiff;
    }

    private static boolean strEqual(String str1, String str2) {
        if (str1 == null) {
            str1 = "";
        }
        if (str2 == null) {
            str2 = "";
        }
        if (str1.equals("") || str2.equals("")) {
            return false;
        }
        return str1.equals(str2);
    }
}

