/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.helper.LinkagePaymentHelper;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackValidateHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.helper.VoucherBookHelper;
import kd.fi.cas.util.CheckUtils;
import kd.fi.cas.util.EmptyUtil;

public class PaymentPayImpl
extends AbstractOpService {
    private static final Log logger = LogFactory.getLog(PaymentPayImpl.class);

    @Override
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(90);
        lst.add("billno");
        lst.add("id");
        lst.add("billstatus");
        lst.add("bizdate");
        lst.add("billtype");
        lst.add("paymenttype");
        lst.add("payeetype");
        lst.add("description");
        lst.add("issingle");
        lst.add("org");
        lst.add("payeracctcash");
        lst.add("payeracctbank");
        lst.add("payerbank");
        lst.add("payee");
        lst.add("payeeformid");
        lst.add("payeename");
        lst.add("payeeaccformid");
        lst.add("payeeacctbank");
        lst.add("payeebanknum");
        lst.add("payeebank");
        lst.add("payeebankname");
        lst.add("actpayamt");
        lst.add("currency");
        lst.add("exchangerate");
        lst.add("localamt");
        lst.add("settletype");
        lst.add("settletnumber");
        lst.add("fundflowitem");
        lst.add("usage");
        lst.add("expectdate");
        lst.add("reccountry");
        lst.add("recprovince");
        lst.add("reccity");
        lst.add("recaccbankname");
        lst.add("recbanknumber");
        lst.add("sourcetype");
        lst.add("sourcebilltype");
        lst.add("sourcebillid");
        lst.add("cashier");
        lst.add("paydate");
        lst.add("bankcheckflag");
        lst.add("bankcheckflag_tag");
        lst.add("entrance");
        lst.add("entrustorg");
        lst.add("applyorg");
        lst.add("e_actamt");
        lst.add("e_localamt");
        lst.add("e_fundflowitem");
        lst.add("e_remark");
        lst.add("e_payableamt");
        lst.add("e_payablelocamt");
        lst.add("e_discountamt");
        lst.add("e_discountlocamt");
        lst.add("e_sourcebillentryid");
        lst.add("e_unsettledamt");
        lst.add("e_settledamt");
        lst.add("e_unlockamt");
        lst.add("e_material");
        lst.add("e_expenseitem");
        lst.add("e_corebillno");
        lst.add("e_corebillentryseq");
        lst.add("e_sourcebillid");
        lst.add("paymentchannel");
        lst.add("payeetype");
        lst.add("payee");
        lst.add("isvoucher");
        lst.add("isdiffcur");
        lst.add("dpamt");
        lst.add("agreedrate");
        lst.add("fee");
        lst.add("dpcurrency");
        lst.add("iscrosspay");
        lst.add("dplocalamt");
        lst.add("dpexchangerate");
        lst.add("feecurrency");
        lst.add("feeactbank");
        lst.add("lossamt");
        lst.add("draftbill");
        lst.add("exratetable");
        lst.add("exratedate");
        lst.add("inneraccount");
        lst.add("acttradedate");
        lst.add("feepayer");
        lst.add("createtime");
        lst.add("payeeacctcash");
        lst.add("openorg");
        lst.add("totalpayamt");
        lst.add("payquotation");
        lst.add("dppayquotation");
        lst.add("agreedquotation");
        lst.add("settletype");
        lst.add(String.join((CharSequence)".", "settletype", "settlementtype"));
        lst.add("settletnumber");
        lst.add("singlestream");
        lst.add("basecurrency");
        lst.add("paymentidentify");
        lst.add("feepaydate");
        return lst;
    }

    @Override
    public void validate(DynamicObject info) throws KDException {
        DynamicObject accountBank;
        String billStatus = info.getString("billstatus");
        if (!billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            throw new KDBizException(new PaymentErrorCode().STATUS_CANNOT_PAY(), new Object[0]);
        }
        boolean isLinkagePayment = LinkagePaymentHelper.isLinkagePayment(info);
        DynamicObject innerAccount = info.getDynamicObject("inneraccount");
        if (isLinkagePayment && innerAccount != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0e\u7ed3\u7b97\u4e2d\u5fc3\u76f8\u5173\u7684\u8054\u52a8\u652f\u4ed8\uff0c\u8bf7\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentErrorCode_37", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (!(!"bei".equals(info.getString("paymentchannel")) || SettleMentTypeEnum.PROMISSORY.getValue().equals(info.getDynamicObject("settletype").get("settlementtype")) || SettleMentTypeEnum.CHECK.getValue().equals(info.getDynamicObject("settletype").get("settlementtype")) || SettleMentTypeEnum.DRAFT.getValue().equals(info.getDynamicObject("settletype").get("settlementtype")) || SettleMentTypeEnum.BUSINESS.getValue().equals(info.getDynamicObject("settletype").get("settlementtype")) || SettleMentTypeEnum.BANK.getValue().equals(info.getDynamicObject("settletype").get("settlementtype")) || !PaymentBillPluginHelper.paymentIdentify((DynamicObject)info))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u8bf7\u63d0\u4ea4\u94f6\u4f01\u8fdb\u884c\u4ed8\u6b3e\u3002", (String)"PaymentErrorCode_53", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (!CasHelper.isEmpty((Object)info.get("entrustorg"))) {
            throw new KDBizException(new PaymentErrorCode().WT_NOT_PAY(), new Object[0]);
        }
        if (!SystemStatusCtrolHelper.isInitEnable((long)info.getDynamicObject("org").getLong("id"))) {
            throw new KDBizException(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)info.getDynamicObject("org"), (String)"name")));
        }
        boolean isPushArAp = SystemParameterHelper.getParameterBoolean((long)info.getDynamicObject("org").getLong("id"), (String)"cs088");
        if (isPushArAp && !CasHelper.isEmpty((Object)info.get("applyorg")) && "cas_paybill".equals(info.get("sourcebilltype"))) {
            CasBotpHelper.checkPushRule((String)"cas_paybill", (String[])new String[]{"ar_finarbill"});
        }
        boolean selectDraftFlag = SystemParameterHelper.getParameterBoolean((long)info.getDynamicObject("org").getLong("id"), (String)"cs122");
        String key = DraftHelper.getKey((Object)info.get("settletype"));
        logger.info("selectDraftFlag is:" + selectDraftFlag + ",key:" + key);
        if (EmptyUtil.isEmpty((Object)this.param) || !this.param.getParams().containsKey("draftbillno")) {
            String msg = "";
            if (selectDraftFlag && PaymentBillPluginHelper.needSelectedDraft((DynamicObject)info) && this.param != null) {
                if (this.param.get("draftids") == null) {
                    msg = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u4e3a\u6c47\u7968\u6216\u652f\u7968\u6216\u672c\u7968\u7684\u4ed8\u6b3e\u5355\u4e0d\u652f\u6301\u6279\u91cf\u786e\u8ba4\u4ed8\u6b3e\uff0c\u8bf7\u9009\u62e9\u5355\u7b14\u6570\u636e\u8fdb\u884c\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"PaymentErrorCode_49", (String)"fi-cas-business", (Object[])new Object[0]);
                    throw new KDBizException(msg);
                }
            } else if (BigDecimal.ZERO.compareTo(info.getBigDecimal("actpayamt")) <= 0) {
                msg = DraftHelper.getWarnMesg((Long)info.getLong("id"), (String)key, (String)"cas_paybill");
                if (!CasHelper.isEmpty((Object)key) && !CasHelper.isEmpty((Object)msg)) {
                    throw new KDBizException(msg);
                }
            }
        }
        if (null != (accountBank = info.getDynamicObject("payeracctbank")) && AccountBankHelper.isClosed((long)accountBank.getLong("id"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), accountBank.getString("number")));
        }
        if (VoucherBookHelper.checkVoucherNotSubmit((Object)info.getPkValue(), (String)"cas_paybill")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51ed\u8bc1\u51b2\u9500\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"PaymentPayImpl_10", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        DynamicObject billObject = BusinessDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)info.getDataEntityType().getName());
        CheckUtils.checkAmtEqualEAmt((DynamicObject)billObject, (String)"actpayamt", (String)"e_actamt");
        try {
            WriteBackValidateHelper.writeBackValidate(info, WriteBackOperateEnum.PAYVALIDATE, PaymentDisposeConsumer.class);
        }
        catch (Exception e) {
            throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }
}

