/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.push;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BotpLinkCreator {
    private static BotpLinkCreator instance;
    private static final Log logger;

    private BotpLinkCreator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BotpLinkCreator getInstance() {
        Class<BotpLinkCreator> clazz = BotpLinkCreator.class;
        synchronized (BotpLinkCreator.class) {
            if (instance == null) {
                instance = new BotpLinkCreator();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<DynamicObject> push(DynamicObject sourceBill) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceBill.getDataEntityType().getName());
        pushArgs.setTargetEntityNumber("cas_paybill");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        selectedRows.add(new ListSelectedRow(sourceBill.getPkValue()));
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            String errMessage = pushResult.getMessage();
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                String billMessage = billReport.getFailMessage();
                logger.info("=====> BotpLinkCreator,push() billMessage:{}", (Object)billMessage);
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a%s\u3002", (String)"BotpLinkCreator_01", (String)"fi-cas-business", (Object[])new Object[0]), errMessage));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"cas_paybill");
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        return targetBillObjs;
    }

    public void fixRowLink(String targetEntityNumber, String targetEntryKey, String srcBillTypeFld, String srcBillNoFld, String srcEntryFld, String srcRowSeqFld, Object targetBillId) {
        DynamicObject targetBillObj = BusinessDataServiceHelper.loadSingle((Object)targetBillId, (String)targetEntityNumber);
        TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityNumber, (String)targetEntryKey);
        TableDefine srcTableDefine = this.loadSrcTableDefine(targetBillObj, srcBillTypeFld, srcEntryFld);
        if (srcTableDefine == null) {
            return;
        }
        String srcBillNo = targetBillObj.getString(srcBillNoFld);
        DynamicObject[] sourceBillObjs = this.loadSourceBill(srcTableDefine, srcBillNo);
        this.createLinkEntity(targetTableDefine, targetBillObj, srcTableDefine, sourceBillObjs, srcRowSeqFld);
        SaveServiceHelper.saveOperate((String)targetEntityNumber, (DynamicObject[])new DynamicObject[]{targetBillObj}, (OperateOption)OperateOption.create());
    }

    private TableDefine loadSrcTableDefine(DynamicObject targetBillObj, String srcBillTypeFld, String srcEntryFld) {
        Object srcBillTypeFldValue = targetBillObj.get(srcBillTypeFld);
        String srcEntityNumber = "";
        srcEntityNumber = srcBillTypeFldValue instanceof DynamicObject ? (String)((DynamicObject)srcBillTypeFldValue).getPkValue() : (String)srcBillTypeFldValue;
        String srcEntryKey = targetBillObj.getString(srcEntryFld);
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || StringUtils.isBlank((CharSequence)srcEntryKey)) {
            return null;
        }
        TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)srcEntityNumber, (String)srcEntryKey);
        return srcTableDefine;
    }

    private DynamicObject[] loadSourceBill(TableDefine srcTableDefine, String srcBillNo) {
        if (srcTableDefine == null) {
            return null;
        }
        BillEntityType sourceMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)srcTableDefine.getEntityNumber());
        HashSet<String> selectFields = new HashSet<String>();
        selectFields.add("id");
        selectFields.add(sourceMainType.getBillNo());
        selectFields.add(srcTableDefine.getEntityKey() + ".id");
        selectFields.add(srcTableDefine.getEntityKey() + ".seq");
        QFilter filter = new QFilter(sourceMainType.getBillNo(), "=", (Object)srcBillNo);
        DynamicObject[] sourceBillObjs = BusinessDataServiceHelper.load((String)srcTableDefine.getEntityNumber(), (String)StringUtils.join((Object[])selectFields.toArray(), (String)","), (QFilter[])new QFilter[]{filter});
        return sourceBillObjs;
    }

    private void createLinkEntity(TableDefine targetTableDefine, DynamicObject targetBillObj, TableDefine srcTableDefine, DynamicObject[] sourceBillObjs, String srcRowSeqFld) {
        Object[] srcRowId;
        HashMap<Integer, Object[]> srcRowIds = new HashMap<Integer, Object[]>();
        for (DynamicObject srcObj : sourceBillObjs) {
            DynamicObjectCollection srcRows = srcObj.getDynamicObjectCollection(srcTableDefine.getEntityKey());
            for (DynamicObject srcRow : srcRows) {
                Integer srcRowSeq = srcRow.getInt("seq");
                srcRowId = new Object[]{srcObj.getPkValue(), srcRow.getPkValue()};
                srcRowIds.put(srcRowSeq, srcRowId);
            }
        }
        Long srcTableId = srcTableDefine.getTableId();
        String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
        DynamicObjectCollection targetRows = targetBillObj.getDynamicObjectCollection(targetTableDefine.getEntityKey());
        for (DynamicObject targetRow : targetRows) {
            Integer srcRowSeq;
            DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
            if (!linkRows.isEmpty() || !srcRowIds.containsKey(srcRowSeq = Integer.valueOf(targetRow.getInt(srcRowSeqFld)))) continue;
            DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
            linkRows.add((Object)linkRow);
            srcRowId = (Object[])srcRowIds.get(srcRowSeq);
            linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
            linkRow.set(lkEntryKey + "_sbillid", srcRowId[0]);
            linkRow.set(lkEntryKey + "_sid", srcRowId[1]);
        }
    }

    static {
        logger = LogFactory.getLog(BotpLinkCreator.class);
    }
}

