/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.push.action;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.helper.PaymentFillPropHelper;
import kd.fi.cas.business.paysche.bean.PaySchePayInfo;
import kd.fi.cas.business.paysche.bean.PushLinkInfo;
import kd.fi.cas.business.paysche.push.IPushPayBillAction;
import kd.fi.cas.business.paysche.push.PushContext;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.MultiBaseDataHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.sdk.fi.cas.extpoint.paysche.IPayScheSecondaryFieldFill;

public class FillSchePayInfoAction
implements IPushPayBillAction {
    private static final Log logger = LogFactory.getLog(FillSchePayInfoAction.class);
    private static final String SETTLE_TYPE_ARRIVAL = "7";
    private PushContext context;
    private Map<Long, DynamicObject> currencyMap;
    private Map<Long, DynamicObject> fundUsageMap;
    private Map<Long, DynamicObject> settleTypeMap;
    private Map<Long, DynamicObject> acctBankMap;
    private Map<Long, DynamicObject> cashAcctMap;
    private Map<Long, DynamicObject> applyCurrencyMap;
    private Map<Long, DynamicObject> exratetableMap;
    private Map<Long, DynamicObject> drafttableMap;
    private Map<Long, PaySchePayInfo> payEntryIdToScheInfoMap;

    public FillSchePayInfoAction(PushContext context) {
        this.context = context;
    }

    @Override
    public void execute() {
        List<PushLinkInfo> linkedList = this.context.getLinkInfoList();
        HashMap<Long, PaySchePayInfo> scheIdToScheInfoMap = new HashMap<Long, PaySchePayInfo>(this.context.getPayInfoList().size());
        this.payEntryIdToScheInfoMap = new HashMap<Long, PaySchePayInfo>(linkedList.size());
        for (PaySchePayInfo scheInfo : this.context.getPayInfoList()) {
            scheIdToScheInfoMap.put(scheInfo.getScheId(), scheInfo);
        }
        for (PushLinkInfo linkInfo : linkedList) {
            PaySchePayInfo scheInfo = (PaySchePayInfo)scheIdToScheInfoMap.get(linkInfo.getPayScheId());
            this.payEntryIdToScheInfoMap.put(linkInfo.getPayBillEntryId(), scheInfo);
        }
        this.currencyMap = this.batchLoadDataToMap("bd_currency", this.context.getPayInfoList().stream().map(PaySchePayInfo::getCurrencyId).distinct().toArray());
        this.fundUsageMap = this.batchLoadDataToMap("cas_fundflowitem", this.context.getPayInfoList().stream().map(PaySchePayInfo::getFundUsageId).distinct().toArray());
        this.settleTypeMap = this.batchLoadDataToMap("bd_settlementtype", this.context.getPayInfoList().stream().map(o -> Arrays.asList(o.getSettleTypeId(), o.getDraftSettleTypeId())).flatMap(Collection::stream).distinct().toArray());
        Set fundBankAcctIds = this.context.getPayInfoList().stream().map(PaySchePayInfo::getAcctBankId).distinct().collect(Collectors.toSet());
        Set<Long> draftBankAcctIds = this.context.getPayInfoList().stream().map(PaySchePayInfo::getDraftPayAcctId).distinct().collect(Collectors.toSet());
        draftBankAcctIds.addAll(fundBankAcctIds);
        Object[] bankAcctIds = draftBankAcctIds.toArray(new Long[0]);
        this.acctBankMap = this.batchLoadDataToMap("bd_accountbanks", bankAcctIds);
        this.cashAcctMap = this.batchLoadDataToMap("cas_accountcash", this.context.getPayInfoList().stream().map(PaySchePayInfo::getCashAcctId).distinct().toArray());
        this.applyCurrencyMap = this.batchLoadDataToMap("bd_currency", this.context.getPayInfoList().stream().map(PaySchePayInfo::getApplyCurrencyId).distinct().toArray());
        this.exratetableMap = this.batchLoadDataToMap("bd_exratetable", this.context.getPayInfoList().stream().map(PaySchePayInfo::getExratetableId).distinct().toArray());
        this.drafttableMap = this.batchLoadDataToMap("cdm_draftbillf7", this.context.getPayInfoList().stream().map(PaySchePayInfo::getDraftBillIds).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).distinct().toArray());
        boolean paymentTypeBoolean = false;
        List<PaySchePayInfo> payInfoList = this.context.getPayInfoList();
        List PaymentTypeList = payInfoList.stream().map(o -> o.getPaymentType()).distinct().collect(Collectors.toList());
        DynamicObject paymentBillType = null;
        if (null != PaymentTypeList && PaymentTypeList.size() > 1) {
            paymentTypeBoolean = true;
            paymentBillType = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf("1503663013709008896"), (String)"cas_paymentbilltype");
        }
        if (this.context.getFundPayBill() != null) {
            this.fillFundInfo(this.context.getFundPayBill(), paymentTypeBoolean, paymentBillType);
        }
        if (this.context.getBillPayBill() != null) {
            this.fillBillInfo(this.context.getBillPayBill(), paymentTypeBoolean, paymentBillType);
        }
        this.dealSecondaryField();
    }

    private void dealSecondaryField() {
        Long entryId;
        PaySchePayInfo payInfo;
        Map<String, Object> secondaryFields;
        DynamicObject paybill = this.context.getBillPayBill();
        if (EmptyUtil.isEmpty((DynamicObject)paybill)) {
            paybill = this.context.getFundPayBill();
        }
        if (EmptyUtil.isEmpty((DynamicObject)paybill)) {
            logger.error(String.format("\u4ed8\u6b3e\u5904\u7406\u5bf9\u8c61 paybill \u4e3a\u7a7a: %s", paybill));
            return;
        }
        DynamicObjectCollection entryList = paybill.getDynamicObjectCollection("entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryList) && EmptyUtil.isNoEmpty(secondaryFields = (payInfo = this.payEntryIdToScheInfoMap.get(entryId = Long.valueOf(((DynamicObject)entryList.get(0)).getLong("id")))).getSecondaryFields())) {
            logger.info("\u5f00\u59cb\u8fdb\u884c\u4e8c\u5f00\u6269\u5c55\u5b57\u6bb5\u5bf9\u5916\u670d\u52a1\u4e1a\u52a1\u57cb\u70b9 - kd.sdk.fi.cas.extpoint.paysche.interest.IPayScheSecondaryFieldFill");
            PluginProxy pluginProxy = PluginProxy.create(IPayScheSecondaryFieldFill.class, (String)"kd.sdk.fi.cas.extpoint.paysche.interest.IPayScheSecondaryFieldFill");
            DynamicObject finalPaybill = paybill;
            pluginProxy.callReplace(proxy -> {
                proxy.fillSecondaryFields(secondaryFields, finalPaybill);
                return null;
            });
        }
    }

    private void fillFundInfo(DynamicObject payBill, boolean paymentTypeBoolean, DynamicObject paymentBillType) {
        DynamicObjectCollection entryList = payBill.getDynamicObjectCollection("entry");
        if (paymentTypeBoolean) {
            payBill.set("paymenttype", (Object)paymentBillType);
        }
        for (int i = 0; i < entryList.size(); ++i) {
            Map<Long, BigDecimal> draftInfoMap;
            DynamicObject entry = (DynamicObject)entryList.get(i);
            Long entryId = entry.getLong("id");
            PaySchePayInfo payInfo = this.payEntryIdToScheInfoMap.get(entryId);
            if (i == 0) {
                DynamicObject bank;
                if (payInfo.getApplyCurrencyId().compareTo(payInfo.getCurrencyId()) == 0) {
                    payBill.set("isdiffcur", (Object)false);
                }
                payBill.set("currency", (Object)this.applyCurrencyMap.get(payInfo.getApplyCurrencyId()));
                payBill.set("settletype", (Object)this.settleTypeMap.get(payInfo.getSettleTypeId()));
                payBill.set("payeracctbank", (Object)this.acctBankMap.get(payInfo.getAcctBankId()));
                if (!this.settleTypeMap.isEmpty()) {
                    payBill.set("businesstype", (Object)payInfo.getBusinessType());
                }
                if (!this.settleTypeMap.isEmpty()) {
                    payBill.set("businesstype", (Object)payInfo.getBusinessType());
                    if (PayBusinessTypeEnum.WALLETUP.getValue().equals(payInfo.getBusinessType())) {
                        payBill.set("institutioncode", (Object)payInfo.getInstitutionCode());
                        payBill.set("institutionname", (Object)payInfo.getInstitutionName());
                    }
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)(bank = this.acctBankMap.get(payInfo.getAcctBankId())))) {
                    payBill.set("payerbank", (Object)bank.getDynamicObject("bank"));
                }
                payBill.set("payeracctcash", (Object)this.cashAcctMap.get(payInfo.getCashAcctId()));
                payBill.set("expectdate", (Object)payInfo.getExpectDate());
                if (payInfo.getExpectPayDate() != null) {
                    payBill.set("bizdate", (Object)payInfo.getExpectPayDate());
                }
                payBill.set("paymentchannel", (Object)payInfo.getPayChannel());
                payBill.set("usage", (Object)payInfo.getTransferpost());
                if (!payInfo.getApplyCurrencyId().equals(payInfo.getCurrencyId())) {
                    payBill.set("isdiffcur", (Object)"1");
                    payBill.set("dpcurrency", (Object)this.currencyMap.get(payInfo.getCurrencyId()));
                    payBill.set("dpexratetable", (Object)this.exratetableMap.get(payInfo.getExratetableId()));
                    payBill.set("exratetable", (Object)this.exratetableMap.get(payInfo.getExratetableId()));
                    payBill.set("agreedrate", (Object)payInfo.getExchangerate());
                    payBill.set("dpexchangerate", (Object)this.getDpExchangeRate(payBill, this.currencyMap.get(payInfo.getCurrencyId())));
                    PaymentFillPropHelper.calculateAmt(payBill, true, true);
                }
            }
            entry.set("e_fundflowitem", (Object)this.fundUsageMap.get(payInfo.getFundUsageId()));
            entry.set("e_payableamt", (Object)payInfo.getScheAmt());
            entry.set("e_scheid", (Object)payInfo.getScheId());
            if (paymentTypeBoolean && EmptyUtil.isNoEmpty((Long)payInfo.getPaymentType())) {
                DynamicObject paymentType = BusinessDataServiceHelper.loadSingle((Object)payInfo.getPaymentType(), (String)"cas_paymentbilltype");
                entry.set("e_paymenttype", (Object)paymentType);
            }
            if (!EmptyUtil.isEmpty(draftInfoMap = payInfo.getDraftInfoMap()) && draftInfoMap.size() != 0 || !EmptyUtil.isNoEmpty((Object)payBill.get("settletnumber"))) continue;
            payBill.set("settletnumber", null);
            DynamicObjectCollection draftBillInfoDOC = payBill.getDynamicObjectCollection("cas_draftinfo");
            draftBillInfoDOC.clear();
        }
    }

    private void fillBillInfo(DynamicObject payBill, boolean paymentTypeBoolean, DynamicObject paymentBillType) {
        DynamicObjectCollection entryList = payBill.getDynamicObjectCollection("entry");
        if (paymentTypeBoolean) {
            payBill.set("paymenttype", (Object)paymentBillType);
        }
        ArrayList<Long> draftBillIds = new ArrayList<Long>();
        Long draftBankId = null;
        for (int i = 0; i < entryList.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryList.get(i);
            Long entryId = entry.getLong("id");
            PaySchePayInfo payInfo = this.payEntryIdToScheInfoMap.get(entryId);
            if (i == 0) {
                if (payInfo.getApplyCurrencyId().compareTo(payInfo.getCurrencyId()) == 0) {
                    payBill.set("isdiffcur", (Object)false);
                }
                payBill.set("currency", (Object)this.applyCurrencyMap.get(payInfo.getApplyCurrencyId()));
                payBill.set("settletype", (Object)this.settleTypeMap.get(payInfo.getDraftSettleTypeId()));
                if (payInfo.getExpectPayDate() != null) {
                    payBill.set("bizdate", (Object)payInfo.getExpectPayDate());
                }
                payBill.set("expectdate", (Object)payInfo.getExpectDate());
                payBill.set("paymentchannel", (Object)payInfo.getDraftpaychannel());
                payBill.set("payeracctbank", (Object)this.acctBankMap.get(payInfo.getDraftPayAcctId()));
                if (!this.settleTypeMap.isEmpty()) {
                    payBill.set("businesstype", (Object)payInfo.getBusinessType());
                    if (PayBusinessTypeEnum.WALLETUP.getValue().equals(payInfo.getBusinessType())) {
                        payBill.set("institutioncode", (Object)payInfo.getInstitutionCode());
                        payBill.set("institutionname", (Object)payInfo.getInstitutionName());
                    }
                }
                draftBankId = payInfo.getDraftPayAcctId();
                if (!payInfo.getApplyCurrencyId().equals(payInfo.getCurrencyId())) {
                    payBill.set("isdiffcur", (Object)"1");
                    payBill.set("dpcurrency", (Object)this.currencyMap.get(payInfo.getCurrencyId()));
                    payBill.set("dpexratetable", (Object)this.exratetableMap.get(payInfo.getExratetableId()));
                    payBill.set("exratetable", (Object)this.exratetableMap.get(payInfo.getExratetableId()));
                    payBill.set("agreedrate", (Object)payInfo.getExchangerate());
                    payBill.set("dpexchangerate", (Object)this.getDpExchangeRate(payBill, this.currencyMap.get(payInfo.getCurrencyId())));
                    PaymentFillPropHelper.calculateAmt(payBill, true, true);
                }
            }
            payBill.set("isbilldibs", (Object)payInfo.getIsbilldibs());
            payBill.set("receiveid", (Object)payInfo.getReceiveId());
            if (SETTLE_TYPE_ARRIVAL.equals(payInfo.getDraftSettleType())) {
                payBill.set("settletnumber", (Object)payInfo.getLcarrivalNo());
                DynamicObject bank = this.acctBankMap.get(payInfo.getDraftPayAcctId());
                if (EmptyUtil.isNoEmpty((DynamicObject)bank)) {
                    payBill.set("payerbank", (Object)bank.getDynamicObject("bank"));
                }
            }
            BigDecimal draftBillAmt = payInfo.getDraftBillAmt();
            entry.set("e_fundflowitem", (Object)this.fundUsageMap.get(payInfo.getFundUsageId()));
            entry.set("e_payableamt", (Object)draftBillAmt);
            entry.set("e_scheid", (Object)payInfo.getScheId());
            if (paymentTypeBoolean && EmptyUtil.isNoEmpty((Long)payInfo.getPaymentType())) {
                DynamicObject paymentType = BusinessDataServiceHelper.loadSingle((Object)payInfo.getPaymentType(), (String)"cas_paymentbilltype");
                entry.set("e_paymenttype", (Object)paymentType);
            }
            if (!CollectionUtils.isEmpty(payInfo.getDraftBillIds())) {
                draftBillIds.addAll(payInfo.getDraftBillIds());
            }
            Map<Long, BigDecimal> draftInfoMap = payInfo.getDraftInfoMap();
            Map<Long, Long> draftIdLogIdMap = payInfo.getDraftIdLogIdMap();
            if (!EmptyUtil.isNoEmpty(draftInfoMap)) continue;
            DynamicObjectCollection draftBillInfoDOC = payBill.getDynamicObjectCollection("cas_draftinfo");
            draftBillInfoDOC.clear();
            for (Map.Entry<Long, BigDecimal> draftInfoEntry : draftInfoMap.entrySet()) {
                DynamicObject draftInfoDO = draftBillInfoDOC.addNew();
                draftInfoDO.set("draftbillinfo", (Object)this.drafttableMap.get(draftInfoEntry.getKey()));
                draftInfoDO.set("paybillcurrency", (Object)this.applyCurrencyMap.get(payInfo.getApplyCurrencyId()));
                draftInfoDO.set("transamount", (Object)draftInfoEntry.getValue());
                Long logId = draftIdLogIdMap.get(draftInfoEntry.getKey());
                if (!EmptyUtil.isNoEmpty((Long)logId) || logId <= 0L) continue;
                draftInfoDO.set("draftbilllogid", (Object)logId);
            }
        }
        if (!draftBillIds.isEmpty()) {
            DynamicObject bank;
            Object[] draftBills = BusinessDataServiceHelper.load((Object[])draftBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
            payBill.set("draftbill", (Object)MultiBaseDataHelper.generateMultiPropValue((DynamicObject)payBill, (String)"draftbill", (DynamicObject[])draftBills));
            String settlenumberStr = EmptyUtil.isEmpty((Object[])draftBills) ? "" : Arrays.stream(draftBills).map(d -> d.getString("draftbillno")).collect(Collectors.joining(";"));
            payBill.set("settletnumber", (Object)settlenumberStr);
            if (draftBankId != null && EmptyUtil.isNoEmpty((DynamicObject)(bank = this.acctBankMap.get(draftBankId)))) {
                payBill.set("payerbank", (Object)bank.getDynamicObject("bank"));
            }
        }
    }

    private Map<Long, DynamicObject> batchLoadDataToMap(String entityName, Object[] idArr) {
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((Object[])idArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(dataArr.length);
        for (DynamicObject data : dataArr) {
            dataMap.put((Long)data.getPkValue(), data);
        }
        return dataMap;
    }

    private BigDecimal getDpExchangeRate(DynamicObject targetBill, DynamicObject dpCurrency) {
        DynamicObject org = targetBill.getDynamicObject("org");
        Long orgId = org.getLong("id");
        BigDecimal dpExchangeRate = BigDecimal.ONE;
        DynamicObject baseCurrency = targetBill.getDynamicObject("basecurrency");
        if (CasHelper.isEmpty((Object)baseCurrency)) {
            return dpExchangeRate;
        }
        long srcCurrencyId = dpCurrency.getLong("id");
        long destCurrencyId = baseCurrency.getLong("id");
        Date exrateDate = targetBill.getDate("exratedate");
        DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
        if (CasHelper.isEmpty((Object)exrateTable)) {
            return dpExchangeRate;
        }
        dpExchangeRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
        return dpExchangeRate;
    }
}

