/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.push.executor;

import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.paysche.bean.PaySchePayInfo;
import kd.fi.cas.business.paysche.bean.PushLinkInfo;
import kd.fi.cas.business.paysche.push.IPushPayBillAction;
import kd.fi.cas.business.paysche.push.IPushPayBillExecutor;
import kd.fi.cas.business.paysche.push.PushContext;

public abstract class AbstractPushPayBillExecutor
implements IPushPayBillExecutor {
    private static Log logger = LogFactory.getLog(AbstractPushPayBillExecutor.class);
    protected PushContext context = new PushContext();

    public AbstractPushPayBillExecutor(List<PaySchePayInfo> payScheInfoList) {
        this.context.setPayInfoList(payScheInfoList);
    }

    @Override
    public List<DynamicObject> push() {
        List<IPushPayBillAction> actions = this.getPushAction();
        LinkedList<IPushPayBillAction> executedActions = new LinkedList<IPushPayBillAction>();
        try {
            for (IPushPayBillAction action : actions) {
                executedActions.push(action);
                action.execute();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            try {
                this.context.getLinkInfoList().clear();
                for (IPushPayBillAction action : executedActions) {
                    action.rollback();
                }
            }
            catch (Exception e1) {
                logger.error((Throwable)e1);
                throw e1;
            }
            throw e;
        }
        return this.context.getPayBillList();
    }

    @Override
    public List<PushLinkInfo> getPayScheLink() {
        return this.context.getLinkInfoList();
    }

    protected abstract List<IPushPayBillAction> getPushAction();
}

