/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.rpc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.paysche.bean.ChargeBackInfo;
import kd.fi.cas.business.paysche.bean.PayRpcResult;
import kd.fi.cas.business.paysche.bean.PayScheFixInfo;
import kd.fi.cas.business.paysche.bean.PayScheFixResult;
import kd.fi.cas.business.paysche.bean.PaySchePayInfo;
import kd.fi.cas.business.paysche.rpc.IPayScheRpcApi;
import kd.fi.cas.business.paysche.serive.PaySchePushServiceImpl;

public class PayScheRpcApiImpl
implements IPayScheRpcApi {
    private static final Log logger = LogFactory.getLog(PayScheRpcApiImpl.class);

    @Override
    public String pushPayBill(String payInfoListJson) {
        List payInfoList = (List)JSON.parseObject((String)payInfoListJson, (TypeReference)new TypeReference<List<PaySchePayInfo>>(){}, (Feature[])new Feature[0]);
        List schIdList = payInfoList.stream().map(e -> e.getScheId().toString()).collect(Collectors.toList());
        logger.info("\u6392\u7a0b\u5355\u4ed8\u6b3e\uff0c\u6392\u7a0b\u5355id\uff1a{}", (Object)JSON.toJSONString(schIdList));
        PaySchePushServiceImpl service = new PaySchePushServiceImpl();
        List<PayRpcResult> result = service.pushPayBill(payInfoList);
        return JSON.toJSONString(result);
    }

    @Override
    public String fixPayScheBill(String fixInfoListJson) {
        List fixInfoList = (List)JSON.parseObject((String)fixInfoListJson, (TypeReference)new TypeReference<List<PayScheFixInfo>>(){}, (Feature[])new Feature[0]);
        PaySchePushServiceImpl service = new PaySchePushServiceImpl();
        List<PayScheFixResult> result = service.fixPayScheBill(fixInfoList);
        return JSON.toJSONString(result);
    }

    @Override
    public String chargeBack(String chargeBackListJson) {
        List chargeBackInfoList = (List)JSON.parseObject((String)chargeBackListJson, (TypeReference)new TypeReference<List<ChargeBackInfo>>(){}, (Feature[])new Feature[0]);
        PaySchePushServiceImpl service = new PaySchePushServiceImpl();
        PayRpcResult result = service.chargeBack(chargeBackInfoList);
        return JSON.toJSONString((Object)result);
    }

    @Override
    public String deletePayBill(String chargeBackListJson) {
        List chargeBackInfoList = (List)JSON.parseObject((String)chargeBackListJson, (TypeReference)new TypeReference<List<ChargeBackInfo>>(){}, (Feature[])new Feature[0]);
        PaySchePushServiceImpl service = new PaySchePushServiceImpl();
        PayRpcResult result = service.deletePayBill(chargeBackInfoList);
        return JSON.toJSONString((Object)result);
    }

    @Override
    public boolean isPartPaymentBySourceBillNo(String sourceBillNo) {
        DynamicObject resultObj = BusinessDataServiceHelper.loadSingle((String)"cas_payapplybill", (String)"id,billno,ispartpayment", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)sourceBillNo)});
        if (resultObj == null) {
            return true;
        }
        boolean isPartPayment = resultObj.getBoolean("ispartpayment");
        return isPartPayment;
    }

    @Override
    public Map<String, Boolean> isPartPaymentBySourceBillNos(Set<String> sourceBillNo) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(sourceBillNo.size());
        DynamicObject[] resultObjs = BusinessDataServiceHelper.load((String)"cas_payapplybill", (String)"id,billno,ispartpayment", (QFilter[])new QFilter[]{new QFilter("billno", "in", sourceBillNo)});
        if (resultObjs == null || resultObjs.length == 0) {
            return result;
        }
        for (DynamicObject resultObj : resultObjs) {
            boolean isPartPayment = resultObj.getBoolean("ispartpayment");
            String billNo = resultObj.getString("billno");
            result.put(billNo, isPartPayment);
        }
        return result;
    }
}

