/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.serive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.fi.cas.business.paysche.bean.PaySchePayInfo;

public class PayScheDivider {
    private List<PaySchePayInfo> payInfoList;

    public PayScheDivider(List<PaySchePayInfo> payInfoList) {
        this.payInfoList = payInfoList;
    }

    public List<PayGroup> divide(DivideMode mode) {
        Set<DivideItem> divideItemSet = this.createDivideItemSet();
        Map<Object, Object> grpMap = new HashMap();
        if (mode == DivideMode.SRC) {
            grpMap = this.groupAndCombine(DivideMode.SRC, divideItemSet);
        } else if (mode == DivideMode.PAY) {
            grpMap = this.groupAndCombine(DivideMode.PAY, divideItemSet);
        } else if (mode == DivideMode.ALL) {
            grpMap = this.groupAndCombine(DivideMode.PAY, divideItemSet);
            Map divideItemMap = divideItemSet.stream().collect(Collectors.toMap(DivideItem::getKey, Function.identity()));
            HashMap<Long, IdGroup> srcToPayMap = new HashMap<Long, IdGroup>(10);
            HashMap<Long, IdGroup> payToSrcMap = new HashMap<Long, IdGroup>(10);
            for (PaySchePayInfo payInfo : this.payInfoList) {
                DivideItem divideItem = (DivideItem)divideItemMap.get(DivideItem.genKey(payInfo));
                Long srcBillId = payInfo.getSourceBillId();
                IdGroup paySet = srcToPayMap.computeIfAbsent(srcBillId, o -> new IdGroup());
                for (PaySchePayInfo payInfoBatch : divideItem.getPayInfoBatch()) {
                    paySet.getValue().addAll(payInfoBatch.getPayIdList());
                }
                List<Long> payIdList = payInfo.getPayIdList();
                for (Long payId : payIdList) {
                    IdGroup srcSet = payToSrcMap.computeIfAbsent(payId, o -> new IdGroup());
                    srcSet.getValue().add(srcBillId);
                }
            }
            List waitCombineSrcIdSet = payToSrcMap.values().stream().filter(o -> o.getValue().size() > 1).collect(Collectors.toList());
            for (IdGroup srcSet : waitCombineSrcIdSet) {
                this.combine(srcToPayMap, srcSet.getValue());
            }
            for (IdGroup combinePayIdSet : new HashSet(srcToPayMap.values())) {
                this.combine(grpMap, combinePayIdSet.getValue());
            }
        }
        List<PayGroup> grpList = grpMap.values().stream().peek(o -> {
            Iterator<DivideItem> it = o.getDivideSet().iterator();
            if (it.hasNext()) {
                o.setSrcType(it.next().getSrcType());
            }
        }).filter(o -> !o.getDivideSet().isEmpty()).distinct().collect(Collectors.toList());
        return grpList;
    }

    private Map<Long, PayGroup> groupAndCombine(DivideMode mode, Set<DivideItem> divideItemSet) {
        Map divideItemMap = divideItemSet.stream().collect(Collectors.toMap(DivideItem::getKey, Function.identity()));
        HashMap<Long, Set> idToItemMap = new HashMap<Long, Set>(10);
        HashMap<DivideItem, Set> itemToIdMap = new HashMap<DivideItem, Set>(divideItemSet.size());
        for (PaySchePayInfo paySchePayInfo : this.payInfoList) {
            DivideItem divideItem = (DivideItem)divideItemMap.get(DivideItem.genKey(paySchePayInfo));
            if (mode == DivideMode.SRC) {
                Long srcBillId = paySchePayInfo.getSourceBillId();
                Set srcToItemSet = idToItemMap.computeIfAbsent(srcBillId, o -> new HashSet(10));
                srcToItemSet.add(divideItem);
                Set itemToSrcSet = itemToIdMap.computeIfAbsent(divideItem, o -> new HashSet(10));
                itemToSrcSet.add(srcBillId);
            }
            if (mode != DivideMode.PAY) continue;
            List<Long> payIdList = paySchePayInfo.getPayIdList();
            for (Long payId : payIdList) {
                Set payToItemSet = idToItemMap.computeIfAbsent(payId, o -> new HashSet(10));
                payToItemSet.add(divideItem);
                Set itemToPaySet = itemToIdMap.computeIfAbsent(divideItem, o -> new HashSet(10));
                itemToPaySet.add(payId);
            }
        }
        HashMap<Long, PayGroup> grpMap = new HashMap<Long, PayGroup>();
        for (Map.Entry entry : idToItemMap.entrySet()) {
            PayGroup payGroup = grpMap.computeIfAbsent((Long)entry.getKey(), o -> new PayGroup());
            payGroup.getDivideSet().addAll((Collection)entry.getValue());
        }
        List list = itemToIdMap.values().stream().filter(o -> o.size() > 1).collect(Collectors.toList());
        for (Set idSet : list) {
            this.combine(grpMap, idSet);
        }
        Set set = divideItemSet.stream().filter(DivideItem::isBatch).collect(Collectors.toSet());
        for (DivideItem divideItem : set) {
            Set<Long> idSet = divideItem.getPayInfoBatch().stream().map(o -> {
                if (mode == DivideMode.SRC) {
                    return Collections.singletonList(o.getSourceBillId());
                }
                return o.getPayIdList();
            }).flatMap(Collection::stream).collect(Collectors.toSet());
            this.combine(grpMap, idSet);
        }
        return grpMap;
    }

    private <R, T extends Group<R>> void combine(Map<Long, T> grpMap, Set<Long> waitCombineSet) {
        Group waitCombineGrp = null;
        for (Long srcId : waitCombineSet) {
            if (waitCombineGrp == null) {
                waitCombineGrp = (Group)grpMap.get(srcId);
                continue;
            }
            Group grp = (Group)grpMap.get(srcId);
            if (waitCombineGrp == grp) continue;
            waitCombineGrp.combine(grp);
            grpMap.put(srcId, waitCombineGrp);
        }
    }

    private Set<DivideItem> createDivideItemSet() {
        DivideItem item;
        HashMap<String, List> batchMap = new HashMap<String, List>(this.payInfoList.size());
        ArrayList<PaySchePayInfo> singleList = new ArrayList<PaySchePayInfo>(this.payInfoList.size());
        for (PaySchePayInfo payInfo : this.payInfoList) {
            if (payInfo.isMergeFlag()) {
                String string = payInfo.getBatchSeqNo();
                List batchList = batchMap.computeIfAbsent(string, o -> new ArrayList(10));
                batchList.add(payInfo);
                continue;
            }
            singleList.add(payInfo);
        }
        HashSet<DivideItem> divideGroupSet = new HashSet<DivideItem>(batchMap.size() + singleList.size());
        for (PaySchePayInfo paySchePayInfo : singleList) {
            item = new DivideItem();
            item.setBatch(false);
            item.setKey(DivideItem.genKey(paySchePayInfo));
            item.setPayInfoBatch(Collections.singletonList(paySchePayInfo));
            item.setSrcType(paySchePayInfo.getSourceBillType());
            divideGroupSet.add(item);
        }
        for (Map.Entry entry : batchMap.entrySet()) {
            item = new DivideItem();
            item.setBatch(true);
            item.setKey(DivideItem.genKey((String)entry.getKey()));
            item.setPayInfoBatch((List)entry.getValue());
            item.setSrcType(((PaySchePayInfo)((List)entry.getValue()).get(0)).getSourceBillType());
            divideGroupSet.add(item);
        }
        return divideGroupSet;
    }

    public static class DivideItem {
        static String KEY_PREFIX_BATCH = "B_";
        static String KEY_PREFIX_SINGLE = "S_";
        private String key;
        private String srcType;
        private List<PaySchePayInfo> payInfoBatch;
        private boolean batch;

        public static String genKey(PaySchePayInfo payInfo) {
            String key = payInfo.isMergeFlag() ? DivideItem.genKey(payInfo.getBatchSeqNo()) : KEY_PREFIX_SINGLE + payInfo.getScheId();
            return key;
        }

        public static String genKey(String batchSeqNo) {
            return KEY_PREFIX_BATCH + batchSeqNo;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public List<PaySchePayInfo> getPayInfoBatch() {
            return this.payInfoBatch;
        }

        public void setPayInfoBatch(List<PaySchePayInfo> payInfoBatch) {
            this.payInfoBatch = payInfoBatch;
        }

        public boolean isBatch() {
            return this.batch;
        }

        public void setBatch(boolean batch) {
            this.batch = batch;
        }

        public String getSrcType() {
            return this.srcType;
        }

        public void setSrcType(String srcType) {
            this.srcType = srcType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DivideItem that = (DivideItem)o;
            return Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }

    public static class PayGroup
    implements Group<DivideItem> {
        private String srcType;
        private Set<DivideItem> divideSet;

        public PayGroup() {
            this.divideSet = new HashSet<DivideItem>(10);
        }

        public PayGroup(String srcType, Set<DivideItem> divideSet) {
            this.srcType = srcType;
            this.divideSet = divideSet;
        }

        public boolean allSrcIdContains(Set<Long> srcIdSet) {
            List<PaySchePayInfo> paySchePayInfoList = this.getPaySchePayInfoList();
            Set curSrcIdSet = paySchePayInfoList.stream().map(PaySchePayInfo::getSourceBillId).collect(Collectors.toSet());
            boolean allContains = srcIdSet.containsAll(curSrcIdSet);
            return allContains;
        }

        public boolean allPayIdContains(Set<Long> payIdSet) {
            List<PaySchePayInfo> paySchePayInfoList = this.getPaySchePayInfoList();
            Set curPayIdSet = paySchePayInfoList.stream().map(PaySchePayInfo::getPayIdList).flatMap(Collection::stream).collect(Collectors.toSet());
            boolean allContains = payIdSet.containsAll(curPayIdSet);
            return allContains;
        }

        public List<PaySchePayInfo> getPaySchePayInfoList() {
            List<PaySchePayInfo> payScheInfoList = this.divideSet.stream().map(DivideItem::getPayInfoBatch).flatMap(Collection::stream).collect(Collectors.toList());
            return payScheInfoList;
        }

        public String getSrcType() {
            return this.srcType;
        }

        public void setSrcType(String srcType) {
            this.srcType = srcType;
        }

        public Set<DivideItem> getDivideSet() {
            return this.divideSet;
        }

        public void setDivideSet(Set<DivideItem> divideSet) {
            this.divideSet = divideSet;
        }

        @Override
        public void combine(Group<DivideItem> otherGrp) {
            this.divideSet.addAll(otherGrp.getValue());
        }

        @Override
        public Set<DivideItem> getValue() {
            return this.getDivideSet();
        }
    }

    public static class IdGroup
    implements Group<Long> {
        private Set<Long> idSet = new HashSet<Long>(10);

        @Override
        public void combine(Group<Long> otherGrp) {
            this.idSet.addAll(otherGrp.getValue());
        }

        @Override
        public Set<Long> getValue() {
            return this.idSet;
        }
    }

    static interface Group<T> {
        public void combine(Group<T> var1);

        public Set<T> getValue();
    }

    public static enum DivideMode {
        SRC,
        PAY,
        ALL;

    }
}

