/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.serive;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.paysche.bean.ChargeBackInfo;
import kd.fi.cas.business.paysche.bean.PayRpcResult;
import kd.fi.cas.business.paysche.bean.PayScheEntryInfo;
import kd.fi.cas.business.paysche.bean.PayScheFixInfo;
import kd.fi.cas.business.paysche.bean.PayScheFixResult;
import kd.fi.cas.business.paysche.bean.PaySchePayInfo;
import kd.fi.cas.business.paysche.bean.PayScheRpcResult;
import kd.fi.cas.business.paysche.bean.PushLinkInfo;
import kd.fi.cas.business.paysche.bean.ReleaseAmtInfo;
import kd.fi.cas.business.paysche.bean.RpcStatus;
import kd.fi.cas.business.paysche.push.IPushPayBillExecutor;
import kd.fi.cas.business.paysche.push.PushPayBillExecutorFactory;
import kd.fi.cas.business.paysche.serive.IPayScheService;
import kd.fi.cas.business.paysche.serive.PayScheDivider;
import kd.fi.cas.business.paysche.serive.ReleaseAmountService;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayScheOpType;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;

public class PaySchePushServiceImpl
implements IPayScheService {
    private static Log logger = LogFactory.getLog(PaySchePushServiceImpl.class);
    private static final String MUTEX_KEY = "sche_pay";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PayRpcResult> pushPayBill(List<PaySchePayInfo> payInfoList) {
        PayScheDivider divider = new PayScheDivider(payInfoList);
        List<PayScheDivider.PayGroup> groupList = divider.divide(PayScheDivider.DivideMode.ALL);
        ArrayList<PayRpcResult> resultList = new ArrayList<PayRpcResult>(groupList.size());
        Map<String, List<PayScheDivider.PayGroup>> groupBySrcType = groupList.stream().collect(Collectors.groupingBy(PayScheDivider.PayGroup::getSrcType));
        for (Map.Entry<String, List<PayScheDivider.PayGroup>> srcTypeEntry : groupBySrcType.entrySet()) {
            List payScheInfoList = srcTypeEntry.getValue().stream().map(PayScheDivider.PayGroup::getPaySchePayInfoList).flatMap(Collection::stream).collect(Collectors.toList());
            String srcType = srcTypeEntry.getKey();
            Set srcIdSet = payScheInfoList.stream().map(PaySchePayInfo::getSourceBillId).collect(Collectors.toSet());
            Map srcLockResult = MutexServiceHelper.batchRequest(srcIdSet.stream().map(String::valueOf).collect(Collectors.toList()), (String)srcType, (String)MUTEX_KEY);
            List srcLockSuccessIdList = srcLockResult.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            Set payIdSet = payScheInfoList.stream().map(PaySchePayInfo::getPayIdList).flatMap(Collection::stream).collect(Collectors.toSet());
            Map payLockResult = MutexServiceHelper.batchRequest(payIdSet.stream().map(String::valueOf).collect(Collectors.toList()), (String)"cas_paybill", (String)MUTEX_KEY);
            List payLockSuccessIdList = payLockResult.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            try {
                if (srcLockSuccessIdList.size() == 0 || payLockSuccessIdList.size() == 0) {
                    String errMsg = srcLockSuccessIdList.size() == 0 ? ResManager.loadKDString((String)"\u4e1a\u52a1\u6e90\u5355\u4e92\u65a5\u9501\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"PaySchePushServiceImpl_0", (String)"fi-cas-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u83b7\u53d6\u5f85\u6392\u7a0b\u4ed8\u6b3e\u5355\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"PaySchePushServiceImpl_1", (String)"fi-cas-business", (Object[])new Object[0]);
                    List errResultList = srcTypeEntry.getValue().stream().map(o -> this.createErrInfo((PayScheDivider.PayGroup)o, errMsg, RpcStatus.ROLLBACK)).collect(Collectors.toList());
                    resultList.addAll(errResultList);
                    continue;
                }
                Set<Long> srcLockSuccessIdSet = srcLockSuccessIdList.stream().map(Long::valueOf).collect(Collectors.toSet());
                Set<Long> payLockSuccessIdSet = payLockSuccessIdList.stream().map(Long::valueOf).collect(Collectors.toSet());
                for (PayScheDivider.PayGroup payGroup : srcTypeEntry.getValue()) {
                    List<PayRpcResult> payRpcResults;
                    PayRpcResult result;
                    String errMsg;
                    if (!payGroup.allSrcIdContains(srcLockSuccessIdSet)) {
                        errMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6e90\u5355\u4e92\u65a5\u9501\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"PaySchePushServiceImpl_0", (String)"fi-cas-business", (Object[])new Object[0]);
                        result = this.createErrInfo(payGroup, errMsg, RpcStatus.ROLLBACK);
                        resultList.add(result);
                        continue;
                    }
                    if (!payGroup.allPayIdContains(payLockSuccessIdSet)) {
                        errMsg = ResManager.loadKDString((String)"\u83b7\u53d6\u5f85\u6392\u7a0b\u4ed8\u6b3e\u5355\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"PaySchePushServiceImpl_1", (String)"fi-cas-business", (Object[])new Object[0]);
                        result = this.createErrInfo(payGroup, errMsg, RpcStatus.ROLLBACK);
                        resultList.add(result);
                        continue;
                    }
                    Set<PayScheDivider.DivideItem> divideSet = payGroup.getDivideSet();
                    List<PaySchePayInfo> currPayInfoList = divideSet.stream().map(PayScheDivider.DivideItem::getPayInfoBatch).flatMap(Collection::stream).collect(Collectors.toList());
                    try (TXHandle tx = TX.requiresNew();){
                        try {
                            payRpcResults = this.doPay(currPayInfoList);
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            logger.error("PaySchePushServiceImpl pushPayBill error:", (Throwable)e);
                            PayRpcResult rollbackResult = new PayRpcResult();
                            rollbackResult.setStatus(RpcStatus.ROLLBACK);
                            rollbackResult.setErrMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                            List<Long> payScheBillIds = currPayInfoList.stream().map(PaySchePayInfo::getScheId).collect(Collectors.toList());
                            rollbackResult.setErrPayScheIdList(payScheBillIds);
                            payRpcResults = Collections.singletonList(rollbackResult);
                        }
                    }
                    resultList.addAll(payRpcResults);
                }
            }
            finally {
                if (payLockSuccessIdList.size() > 0) {
                    MutexServiceHelper.batchRelease(payLockSuccessIdList, (String)"cas_paybill", (String)MUTEX_KEY);
                }
                if (srcLockSuccessIdList.size() <= 0) continue;
                MutexServiceHelper.batchRelease(srcLockSuccessIdList, (String)srcType, (String)MUTEX_KEY);
            }
        }
        return resultList;
    }

    private List<PayScheFixResult> rePush(List<PayScheFixInfo> fixInfoList) {
        List<PaySchePayInfo> payInfoList = fixInfoList.stream().map(PayScheFixInfo::getPayInfo).collect(Collectors.toList());
        try {
            List<IPushPayBillExecutor> executorList = PushPayBillExecutorFactory.getExecutors(payInfoList);
            List<PayRpcResult> pushResultList = this.doPushAndSave(payInfoList, executorList, null, true);
            ArrayList<PayScheFixResult> fixResultList = new ArrayList<PayScheFixResult>(fixInfoList.size());
            for (PayRpcResult pushResult : pushResultList) {
                if (pushResult.getStatus() == RpcStatus.SUCCESS) {
                    fixResultList.addAll(this.getCurrentLinkInfo(fixInfoList));
                    continue;
                }
                fixResultList.addAll(this.convertErrInfo(payInfoList, pushResult.getStatus(), pushResult.getErrMsg()));
            }
            return fixResultList;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return this.convertErrInfo(payInfoList, RpcStatus.ERROR, e.getMessage());
        }
    }

    private List<PayScheFixResult> convertErrInfo(List<PaySchePayInfo> payInfoList, RpcStatus status, String errMsg) {
        List<PayScheFixResult> fixResultList = payInfoList.stream().map(o -> {
            PayScheFixResult fixResult = new PayScheFixResult();
            fixResult.setPayScheId(o.getScheId());
            fixResult.setStatus(status);
            fixResult.setErrMsg(errMsg);
            return fixResult;
        }).collect(Collectors.toList());
        return fixResultList;
    }

    private PayRpcResult createErrInfo(PayScheDivider.PayGroup group, String errMsg, RpcStatus status) {
        return this.createErrInfo(group.getPaySchePayInfoList(), errMsg, status);
    }

    private PayRpcResult createErrInfo(List<PaySchePayInfo> payInfoList, String errMsg, RpcStatus status) {
        List<Long> payScheIdList = payInfoList.stream().map(PaySchePayInfo::getScheId).distinct().collect(Collectors.toList());
        PayRpcResult payResult = new PayRpcResult();
        payResult.setStatus(status);
        payResult.setErrMsg(errMsg);
        payResult.setErrPayScheIdList(payScheIdList);
        return payResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PayScheFixResult> fixPayScheBill(List<PayScheFixInfo> fixInfoList) {
        ArrayList<PayScheFixResult> resultList = new ArrayList<PayScheFixResult>(fixInfoList.size());
        List<PaySchePayInfo> paySchePayInfoList = fixInfoList.stream().map(PayScheFixInfo::getPayInfo).collect(Collectors.toList());
        PayScheDivider divider = new PayScheDivider(paySchePayInfoList);
        List<PayScheDivider.PayGroup> groupList = divider.divide(PayScheDivider.DivideMode.SRC);
        Map<String, List<PayScheDivider.PayGroup>> groupBySrcType = groupList.stream().collect(Collectors.groupingBy(PayScheDivider.PayGroup::getSrcType));
        for (Map.Entry<String, List<PayScheDivider.PayGroup>> srcTypeEntry : groupBySrcType.entrySet()) {
            List<PaySchePayInfo> payScheInfoList = srcTypeEntry.getValue().stream().map(PayScheDivider.PayGroup::getPaySchePayInfoList).flatMap(Collection::stream).collect(Collectors.toList());
            String srcType = srcTypeEntry.getKey();
            Set srcIdSet = payScheInfoList.stream().map(PaySchePayInfo::getSourceBillId).collect(Collectors.toSet());
            Map srcLockResult = MutexServiceHelper.batchRequest(srcIdSet.stream().map(String::valueOf).collect(Collectors.toList()), (String)srcType, (String)MUTEX_KEY);
            List srcLockSuccessIdList = srcLockResult.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            try {
                if (srcLockSuccessIdList.size() == 0) {
                    String errMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6e90\u5355\u4e92\u65a5\u9501\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"PaySchePushServiceImpl_0", (String)"fi-cas-business", (Object[])new Object[0]);
                    List<PayScheFixResult> curResultList = this.convertErrInfo(payScheInfoList, RpcStatus.ERROR, errMsg);
                    resultList.addAll(curResultList);
                    continue;
                }
                Set<Long> srcLockSuccessIdSet = srcLockSuccessIdList.stream().map(Long::valueOf).collect(Collectors.toSet());
                for (PayScheDivider.PayGroup payGroup : srcTypeEntry.getValue()) {
                    List<PaySchePayInfo> currPayScheInfoList = payGroup.getPaySchePayInfoList();
                    Set currScheIdSet = currPayScheInfoList.stream().map(PaySchePayInfo::getScheId).collect(Collectors.toSet());
                    if (!payGroup.allSrcIdContains(srcLockSuccessIdSet)) {
                        String errMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6e90\u5355\u4e92\u65a5\u9501\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"PaySchePushServiceImpl_0", (String)"fi-cas-business", (Object[])new Object[0]);
                        List<PayScheFixResult> curResultList = this.convertErrInfo(currPayScheInfoList, RpcStatus.ERROR, errMsg);
                        resultList.addAll(curResultList);
                        continue;
                    }
                    List<PayScheFixInfo> currFixInfoList = fixInfoList.stream().filter(o -> currScheIdSet.contains(o.getPayScheId())).collect(Collectors.toList());
                    List<PayScheFixResult> currResultList = this.getCurrentLinkInfo(currFixInfoList);
                    ArrayList<PayScheFixInfo> needRePushList = new ArrayList<PayScheFixInfo>(10);
                    for (PayScheFixInfo fixInfo : currFixInfoList) {
                        PayScheFixResult fixResult = currResultList.stream().filter(o -> Objects.equals(o.getPayScheId(), fixInfo.getPayScheId())).findFirst().orElse(null);
                        if (fixResult != null) continue;
                        needRePushList.add(fixInfo);
                    }
                    if (needRePushList.size() > 0) {
                        resultList.addAll(this.rePush(currFixInfoList));
                        continue;
                    }
                    resultList.addAll(currResultList);
                }
            }
            finally {
                if (srcLockSuccessIdList.size() <= 0) continue;
                MutexServiceHelper.batchRelease(srcLockSuccessIdList, (String)srcType, (String)MUTEX_KEY);
            }
        }
        return resultList;
    }

    private List<PayScheFixResult> getCurrentLinkInfo(List<PayScheFixInfo> fixInfoList) {
        Map payScheIdToFixMap = fixInfoList.stream().collect(Collectors.toMap(PayScheFixInfo::getPayScheId, Function.identity(), (a, b) -> a));
        QFilter scheIdFilter = new QFilter("entry.e_scheid", "in", payScheIdToFixMap.keySet());
        QFilter scheStateFilter = new QFilter("iswaitsche", "=", (Object)"0");
        DynamicObjectCollection queryResByScheId = QueryServiceHelper.query((String)"cas_paybill", (String)String.join((CharSequence)",", "id", "entry.id", "entry.e_scheid"), (QFilter[])new QFilter[]{scheIdFilter, scheStateFilter});
        Map<Long, List<DynamicObject>> payScheIdToEntryListMap = queryResByScheId.stream().collect(Collectors.groupingBy(o -> o.getLong("entry.e_scheid")));
        Set<String> batchPayIdSet = fixInfoList.stream().map(o -> o.getPayInfo().getBatchPayId()).collect(Collectors.toSet());
        Set<String> releasedBatchPayIdSet = this.queryReleasedBatchPayIdSet(batchPayIdSet);
        Set payEntryIdSet = fixInfoList.stream().map(PayScheFixInfo::getEntryInfoList).flatMap(Collection::stream).map(PayScheEntryInfo::getPayEntryId).collect(Collectors.toSet());
        QFilter payIdFilter = new QFilter("entry.id", "in", payEntryIdSet);
        scheStateFilter = new QFilter("iswaitsche", "=", (Object)"1");
        DynamicObjectCollection queryResByPayId = QueryServiceHelper.query((String)"cas_paybill", (String)"entry.id", (QFilter[])new QFilter[]{payIdFilter, scheStateFilter});
        Set waitSchePayEntryIdSet = queryResByPayId.stream().map(o -> o.getLong("entry.id")).collect(Collectors.toSet());
        ArrayList<PayScheFixResult> resultList = new ArrayList<PayScheFixResult>(10);
        for (Map.Entry<Long, List<DynamicObject>> entry : payScheIdToEntryListMap.entrySet()) {
            PayScheFixResult result = new PayScheFixResult();
            result.setPayScheId(entry.getKey());
            List<DynamicObject> queryObjList = entry.getValue();
            result.setEntryList(queryObjList.stream().map(o -> {
                PayScheEntryInfo entryInfo = new PayScheEntryInfo();
                entryInfo.setPayEntryId(o.getLong("entry.id"));
                entryInfo.setPayId(o.getLong("id"));
                entryInfo.setWaitSche(false);
                return entryInfo;
            }).collect(Collectors.toList()));
            PayScheFixInfo fixInfo = (PayScheFixInfo)payScheIdToFixMap.get(entry.getKey());
            List waitScheEntryList = fixInfo.getEntryInfoList().stream().filter(o -> waitSchePayEntryIdSet.contains(o.getPayEntryId())).collect(Collectors.toList());
            result.getEntryList().addAll(waitScheEntryList);
            result.setStatus(RpcStatus.SUCCESS);
            resultList.add(result);
        }
        Set fixedScheIdSet = resultList.stream().map(PayScheFixResult::getPayScheId).collect(Collectors.toSet());
        List notFixedList = fixInfoList.stream().filter(o -> !fixedScheIdSet.contains(o.getPayScheId())).collect(Collectors.toList());
        for (PayScheFixInfo fixInfo : notFixedList) {
            PaySchePayInfo payScheInfo = fixInfo.getPayInfo();
            if (releasedBatchPayIdSet.contains(payScheInfo.getBatchPayId())) continue;
            PayScheFixResult result = new PayScheFixResult();
            result.setPayScheId(fixInfo.getPayScheId());
            List<PayScheEntryInfo> waitScheEntryList = fixInfo.getEntryInfoList().stream().filter(o -> waitSchePayEntryIdSet.contains(o.getPayEntryId())).collect(Collectors.toList());
            result.setEntryList(waitScheEntryList);
            result.setStatus(RpcStatus.ROLLBACK);
            resultList.add(result);
        }
        return resultList;
    }

    private Set<String> queryReleasedBatchPayIdSet(Set<String> batchPayIdSet) {
        QFilter batchPayIdFilter = new QFilter("paybatchid", "in", batchPayIdSet);
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"cas_paysche_record", (String)"paybatchid", (QFilter[])new QFilter[]{batchPayIdFilter});
        Set<String> dbRecordSet = queryResult.stream().map(o -> o.getString("paybatchid")).collect(Collectors.toSet());
        return dbRecordSet;
    }

    private List<PayRpcResult> doPay(List<PaySchePayInfo> payInfoList) {
        Set currPayIdSet = payInfoList.stream().map(PaySchePayInfo::getPayIdList).flatMap(Collection::stream).collect(Collectors.toSet());
        Set currPayEntryIdSet = payInfoList.stream().map(PaySchePayInfo::getPayEntryIdList).flatMap(Collection::stream).collect(Collectors.toSet());
        DynamicObject[] payBillArr = BusinessDataServiceHelper.load((Object[])currPayIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
        if (currPayIdSet.size() != payBillArr.length) {
            Set dbPayIdSet = Arrays.stream(payBillArr).map(o -> o.getLong("id")).collect(Collectors.toSet());
            HashSet dbDismissPayIdSet = new HashSet(currPayIdSet);
            dbDismissPayIdSet.removeAll(dbPayIdSet);
            String dismissIdSetStr = dbDismissPayIdSet.stream().map(String::valueOf).reduce((a, b) -> a + "," + b).orElse(null);
            String errMsg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5931\u8d25\u3002\u6392\u7a0b\u5355\u5206\u5f55\u4e2d\u7684\u5f85\u6392\u7a0b\u4ed8\u6b3e\u5355\u5df2\u4e0d\u5b58\u5728\u3002\u4ed8\u6b3e\u5355ID\uff1a%s\u3002", (String)"PaySchePushServiceImpl_3", (String)"fi-cas-business", (Object[])new Object[0]), dismissIdSetStr);
            return Collections.singletonList(this.createErrInfo(payInfoList, errMsg, RpcStatus.ROLLBACK));
        }
        Set statusErrPayBillIdSet = Arrays.stream(payBillArr).filter(o -> !o.getBoolean("iswaitsche") || !BillStatusEnum.SAVE.getValue().equals(o.getString("billstatus"))).map(o -> o.getLong("id")).collect(Collectors.toSet());
        if (statusErrPayBillIdSet.size() > 0) {
            String statusErrSetStr = statusErrPayBillIdSet.stream().map(String::valueOf).reduce((a, b) -> a + "," + b).orElse(null);
            String errMsg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5931\u8d25\u3002\u6392\u7a0b\u5355\u5206\u5f55\u4e2d\uff0c\u5f85\u6392\u7a0b\u4ed8\u6b3e\u5355\u72b6\u6001\u4e0d\u4e3a\u5f85\u6392\u7a0b\u6216\u6682\u5b58\u3002\u4ed8\u6b3e\u5355ID\uff1a%s\u3002", (String)"PaySchePushServiceImpl_5", (String)"fi-cas-business", (Object[])new Object[0]), statusErrSetStr);
            return Collections.singletonList(this.createErrInfo(payInfoList, errMsg, RpcStatus.ROLLBACK));
        }
        Set dbPayEntrySet = Arrays.stream(payBillArr).map(o -> o.getDynamicObjectCollection("entry")).flatMap(Collection::stream).map(o -> o.getLong("id")).collect(Collectors.toSet());
        HashSet dbDismissPayEntryIdSet = new HashSet(currPayEntryIdSet);
        dbDismissPayEntryIdSet.removeAll(dbPayEntrySet);
        if (dbDismissPayEntryIdSet.size() > 0) {
            String dismissEntryIdSetStr = dbDismissPayEntryIdSet.stream().map(String::valueOf).reduce((a, b) -> a + "," + b).orElse(null);
            String errMsg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5931\u8d25\uff1a\u6392\u7a0b\u5355\u5206\u5f55\u4e2d\uff0c\u5f85\u6392\u7a0b\u4ed8\u6b3e\u5355\u5206\u5f55\u5df2\u4e0d\u5b58\u5728\u3002\u4ed8\u6b3e\u5355\u5206\u5f55ID\uff1a%s\u3002", (String)"PaySchePushServiceImpl_4", (String)"fi-cas-business", (Object[])new Object[0]), dismissEntryIdSetStr);
            return Collections.singletonList(this.createErrInfo(payInfoList, errMsg, RpcStatus.ROLLBACK));
        }
        List<DynamicObject> payBillList = Arrays.stream(payBillArr).collect(Collectors.toList());
        Map payBillMap = payBillList.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        List<ReleaseAmtInfo> releaseInfoList = payInfoList.stream().peek(o -> {
            DynamicObject payBill;
            boolean allPay;
            boolean isNotMerge = !o.isMergeFlag();
            boolean isSinglePush = !o.isMixedPush();
            boolean sourceSingle = o.getPayIdList().size() == 1;
            boolean bl = allPay = BigDecimal.ZERO.compareTo(o.getScheBalance()) == 0;
            if (isNotMerge && isSinglePush && allPay && sourceSingle && (payBill = (DynamicObject)payBillMap.get(o.getPayIdList().get(0))) != null) {
                boolean isAmountMatch = payBill.getBigDecimal("totalpayamt").compareTo(o.getApplyAmt()) == 0;
                o.setStatusConvert(isAmountMatch);
            }
        }).filter(o -> !o.isStatusConvert()).map(o -> {
            ReleaseAmtInfo releaseInfo = new ReleaseAmtInfo();
            releaseInfo.setBatchPayId(o.getBatchPayId());
            releaseInfo.setPayScheId(o.getScheId());
            releaseInfo.setPayBillIdList(o.getPayIdList());
            releaseInfo.setPayEntryIdList(o.getPayEntryIdList());
            releaseInfo.setReleaseAmt(o.getScheAmt().add(o.getDraftBillAmt()));
            return releaseInfo;
        }).collect(Collectors.toList());
        ReleaseAmountService releaseService = null;
        if (releaseInfoList.size() > 0) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    releaseService = new ReleaseAmountService(payBillList, releaseInfoList, PayScheOpType.PAY);
                    releaseService.releaseAmt(true);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    tx.markRollback();
                    PayRpcResult result = this.createErrInfo(payInfoList, e.getMessage(), RpcStatus.ROLLBACK);
                    List<PayRpcResult> list = Collections.singletonList(result);
                    if (tx != null) {
                        if (var12_20 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var12_20.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                    return list;
                }
            }
        }
        List<IPushPayBillExecutor> executorList = PushPayBillExecutorFactory.getExecutors(payInfoList);
        return this.doPushAndSave(payInfoList, executorList, releaseService, false);
    }

    private List<PayRpcResult> doPushAndSave(List<PaySchePayInfo> payInfoList, List<IPushPayBillExecutor> executorList, ReleaseAmountService releaseService, boolean fixPush) {
        boolean isSuccess;
        ArrayList<PayScheRpcResult> successResultList = new ArrayList<PayScheRpcResult>();
        ArrayList<PushLinkInfo> linkList = new ArrayList<PushLinkInfo>();
        ArrayList<DynamicObject> payBillList = new ArrayList<DynamicObject>();
        String errMsg = null;
        TXHandle tx = TX.requiresNew();
        Object object = null;
        try {
            try {
                Object delResult;
                if (releaseService != null && !(isSuccess = (delResult = releaseService.doDelOldPayBills()).isSuccess())) {
                    errMsg = OperateServiceHelper.decodeErrorMsg((OperationResult)delResult);
                    throw new KDBizException(errMsg);
                }
                for (IPushPayBillExecutor pushExecutor : executorList) {
                    payBillList.addAll(pushExecutor.push());
                    linkList.addAll(pushExecutor.getPayScheLink());
                }
                OperateOption saveOption = OperateOption.create();
                saveOption.setVariableValue("ignorewarn", String.valueOf(true));
                saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
                saveOption.setVariableValue("strictvalidation", String.valueOf(true));
                saveOption.setVariableValue("isSchePush", "1");
                saveOption.setVariableValue("linkInfoList", JSON.toJSONString(linkList));
                saveOption.setVariableValue("ispushandsave", String.valueOf(true));
                saveOption.setVariableValue("isStrict", "false");
                OperationResult saveResult = SaveServiceHelper.saveOperate((String)"cas_paybill", (DynamicObject[])payBillList.toArray(new DynamicObject[0]), (OperateOption)saveOption);
                isSuccess = saveResult.isSuccess();
                if (!isSuccess) {
                    errMsg = OperateServiceHelper.decodeErrorMsg((OperationResult)saveResult);
                    throw new KDBizException(errMsg);
                }
            }
            catch (Exception e) {
                isSuccess = false;
                tx.markRollback();
                logger.error((Throwable)e);
                if (errMsg == null) {
                    errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                }
            }
        }
        catch (Throwable e) {
            object = e;
            throw e;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable e) {
                        ((Throwable)object).addSuppressed(e);
                    }
                } else {
                    tx.close();
                }
            }
        }
        if (isSuccess) {
            PayRpcResult result = new PayRpcResult();
            for (PushLinkInfo linkInfo : linkList) {
                PayScheRpcResult successResult = new PayScheRpcResult();
                successResult.setPayScheId(linkInfo.getPayScheId());
                successResult.setPayBillId(linkInfo.getPayBillId());
                successResult.setPayBillEntryId(linkInfo.getPayBillEntryId());
                successResultList.add(successResult);
            }
            if (releaseService != null) {
                result.setDelEntryIdSet(releaseService.getDeletedPayEntryIdSet());
            }
            result.setStatus(RpcStatus.SUCCESS);
            result.setSuccessList(successResultList);
            return Collections.singletonList(result);
        }
        if (releaseService != null) {
            releaseService.rollbackReleaseAmt();
        }
        ArrayList<PayRpcResult> resultList = new ArrayList<PayRpcResult>();
        if (!fixPush) {
            Set payScheIdSet = payInfoList.stream().map(PaySchePayInfo::getScheId).collect(Collectors.toSet());
            PayRpcResult rollbackResult = new PayRpcResult();
            rollbackResult.setStatus(RpcStatus.ROLLBACK);
            rollbackResult.setErrMsg(errMsg);
            rollbackResult.setErrPayScheIdList(new ArrayList<Long>(payScheIdSet));
            resultList.add(rollbackResult);
        } else {
            PayRpcResult errResult = new PayRpcResult();
            errResult.setStatus(RpcStatus.ERROR);
            errResult.setErrMsg(errMsg);
            resultList.add(errResult);
        }
        return resultList;
    }

    @Override
    public PayRpcResult chargeBack(List<ChargeBackInfo> chargeBackInfoList) {
        PayRpcResult result = new PayRpcResult();
        try (TXHandle tx = TX.requiresNew();){
            try {
                List<ReleaseAmtInfo> releaseInfoList = chargeBackInfoList.stream().map(o -> {
                    ReleaseAmtInfo releaseInfo = new ReleaseAmtInfo();
                    releaseInfo.setPayBillIdList(o.getPayIdList());
                    releaseInfo.setPayEntryIdList(o.getPayEntryIdList());
                    releaseInfo.setReleaseAmt(o.getApplyAmt());
                    releaseInfo.setBackReason(o.getBackReason());
                    return releaseInfo;
                }).collect(Collectors.toList());
                Object[] payIdArr = chargeBackInfoList.stream().map(ChargeBackInfo::getPayIdList).flatMap(Collection::stream).toArray();
                DynamicObject[] oayBillArr = BusinessDataServiceHelper.load((Object[])payIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
                List<DynamicObject> payBillList = Arrays.stream(oayBillArr).collect(Collectors.toList());
                ReleaseAmountService releaseService = new ReleaseAmountService(payBillList, releaseInfoList, PayScheOpType.BACK);
                releaseService.releaseAmt();
                result.setDelEntryIdSet(releaseService.getDeletedPayEntryIdSet());
                result.setStatus(RpcStatus.SUCCESS);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                result.setErrMsg(e.getMessage());
                result.setStatus(RpcStatus.ROLLBACK);
                PayRpcResult payRpcResult = result;
                if (tx != null) {
                    if (var4_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return payRpcResult;
            }
        }
        return result;
    }

    @Override
    public PayRpcResult deletePayBill(List<ChargeBackInfo> chargeBackInfoList) {
        PayRpcResult result = new PayRpcResult();
        try (TXHandle tx = TX.requiresNew();){
            try {
                List<ReleaseAmtInfo> releaseInfoList = chargeBackInfoList.stream().map(o -> {
                    ReleaseAmtInfo releaseInfo = new ReleaseAmtInfo();
                    releaseInfo.setPayBillIdList(o.getPayIdList());
                    releaseInfo.setPayEntryIdList(o.getPayEntryIdList());
                    releaseInfo.setReleaseAmt(o.getApplyAmt());
                    releaseInfo.setBackReason(o.getBackReason());
                    return releaseInfo;
                }).collect(Collectors.toList());
                Object[] payIdArr = chargeBackInfoList.stream().map(ChargeBackInfo::getPayIdList).flatMap(Collection::stream).toArray();
                DynamicObject[] oayBillArr = BusinessDataServiceHelper.load((Object[])payIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
                List<DynamicObject> payBillList = Arrays.stream(oayBillArr).collect(Collectors.toList());
                ReleaseAmountService releaseService = new ReleaseAmountService(payBillList, releaseInfoList, PayScheOpType.DELETE);
                releaseService.releaseAmt();
                result.setDelEntryIdSet(releaseService.getDeletedPayEntryIdSet());
                result.setStatus(RpcStatus.SUCCESS);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                result.setErrMsg(e.getMessage());
                result.setStatus(RpcStatus.ROLLBACK);
                PayRpcResult payRpcResult = result;
                if (tx != null) {
                    if (var4_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return payRpcResult;
            }
        }
        return result;
    }
}

