/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.recpayrule.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.builder.FormulaGetHandle;
import kd.fi.cas.builder.ISingleTaskContext;
import kd.fi.cas.builder.SingleTaskContext;
import kd.fi.cas.business.recpayrule.IMatchDataTransfer;
import kd.fi.cas.business.recpayrule.IRecPayRuleService;
import kd.fi.cas.business.recpayrule.bean.MatchBean;
import kd.fi.cas.business.recpayrule.bean.MatchResultBean;
import kd.fi.cas.compare.concurrent.SplitThreadOperationExecutor;
import kd.fi.cas.util.EmptyUtil;

public class RecPayRuleServiceImpl
implements IRecPayRuleService {
    private static final Log LOGGER = LogFactory.getLog(RecPayRuleServiceImpl.class);
    private final IMatchDataTransfer transfer;
    private static final String UP_BILL = "upbill";
    private static final String DOWN_BILL = "downbill";
    private MainEntityType fcaAcctGroupEntityType;
    private MainEntityType beiTransDetailCasEntityType;

    public RecPayRuleServiceImpl(IMatchDataTransfer transfer) {
        this.transfer = transfer;
    }

    @Override
    public List<MatchResultBean> match() {
        LOGGER.info("match begin");
        return this.matchProcess(this.transfer.buildMatchBean());
    }

    private List<MatchResultBean> matchProcess(List<MatchBean> matchBeanList) {
        ArrayList<MatchResultBean> matchResultList = new ArrayList<MatchResultBean>();
        if (CollectionUtils.isEmpty(matchBeanList)) {
            return matchResultList;
        }
        LOGGER.info("matchProcess begin matchBeanList:{}", (Object)matchBeanList.size());
        this.fcaAcctGroupEntityType = EntityMetadataCache.getDataEntityType((String)"fca_acctgroup");
        this.beiTransDetailCasEntityType = MetadataServiceHelper.getDataEntityType((String)"bei_transdetail_cas");
        SplitThreadOperationExecutor splitThreadOperationExecutor = new SplitThreadOperationExecutor();
        Map<String, DynamicProperty> fldProperties = this.transfer.buildFilterProperties(matchBeanList.get(0).getBillList().get(0));
        for (MatchBean bean : matchBeanList) {
            List list = splitThreadOperationExecutor.doBatchOperation(bean.getBillList(), 100, billList -> {
                LOGGER.info("splitThreadOperationExecutor doBatchOperation begin");
                ArrayList resultList = new ArrayList();
                billList.forEach(bill -> {
                    DynamicObject matchRule;
                    String ruleName = bill.getString("rulename");
                    if (StringUtils.isBlank((CharSequence)ruleName)) {
                        ruleName = " ";
                    }
                    MatchResultBean transactionDetailMatchRule = new MatchResultBean(bill.getLong("id"), ruleName);
                    transactionDetailMatchRule.setNewRuleName(" ");
                    if (bean.getMainOrgRule() != null) {
                        DynamicObject matchRule2 = this.getMatchRuleName((DynamicObject)bill, bean.getMainOrgRule(), fldProperties);
                        if (matchRule2 != null) {
                            transactionDetailMatchRule.setRuleId(bean.getMainOrgRule().getPkValue());
                            transactionDetailMatchRule.setEntryRuleId(matchRule2.getPkValue());
                            transactionDetailMatchRule.setNewRuleName(matchRule2.getString("e_rulesname"));
                        }
                    } else if (bean.getCommonRule() != null && (matchRule = this.getMatchRuleName((DynamicObject)bill, bean.getCommonRule(), fldProperties)) != null) {
                        transactionDetailMatchRule.setRuleId(bean.getCommonRule().getPkValue());
                        transactionDetailMatchRule.setEntryRuleId(matchRule.getPkValue());
                        transactionDetailMatchRule.setNewRuleName(matchRule.getString("e_rulesname"));
                    }
                    resultList.add(transactionDetailMatchRule);
                });
                return resultList;
            });
            matchResultList.addAll(list);
        }
        LOGGER.info("matchProcess end result:{}", (Object)matchResultList.size());
        return matchResultList;
    }

    private DynamicObject getMatchRuleName(DynamicObject detailAllDy, DynamicObject recPayRule, Map<String, DynamicProperty> fldProperties) {
        DynamicObjectCollection entryEntity;
        if (recPayRule != null && recPayRule.getBoolean("enable") && !(entryEntity = recPayRule.getDynamicObjectCollection("entryentity")).isEmpty()) {
            for (DynamicObject rule : entryEntity) {
                if (!this.isMatchRule(rule, detailAllDy, fldProperties)) continue;
                return rule;
            }
        }
        return null;
    }

    private boolean isMatchRule(DynamicObject entryrule, DynamicObject detailDy, Map<String, DynamicProperty> fldProperties) {
        String bill;
        boolean isMatchRule = false;
        String filterStr = entryrule.containsProperty("e_datafilter_TAG") && StringUtils.isNotBlank((CharSequence)entryrule.getString("e_datafilter_TAG")) ? entryrule.getString("e_datafilter_TAG") : entryrule.getString("e_datafilter");
        if (StringUtils.isNotBlank((CharSequence)filterStr)) {
            CRCondition filterObj = (CRCondition)JSON.parseObject((String)filterStr, CRCondition.class);
            String baseFilterStr = filterObj.buildFullFormula(this.beiTransDetailCasEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(this.beiTransDetailCasEntityType);
            if (!"".equals(baseFilterStr)) {
                try {
                    FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                    boolean baseBoolean = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, detailDy, null);
                    if (baseBoolean) {
                        isMatchRule = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("match error:", (Throwable)e);
                }
            } else {
                isMatchRule = true;
            }
        } else {
            isMatchRule = true;
        }
        if (isMatchRule && (UP_BILL.equals(bill = entryrule.getString("e_handlebill")) || DOWN_BILL.equals(bill)) && !this.isMatchFcaDefaultRule(detailDy)) {
            return false;
        }
        return isMatchRule;
    }

    private boolean unAcctGroup(Long acctId, String sonAcct) {
        DynamicObject acct = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"createorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)acctId)});
        if (EmptyUtil.isEmpty((DynamicObject)acct)) {
            return false;
        }
        DynamicObjectCollection son = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)sonAcct)});
        if (son == null || son.size() == 0) {
            return false;
        }
        DynamicObjectCollection acctGroup = QueryServiceHelper.query((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("accountbank", "=", (Object)acctId)});
        if (acctGroup == null || acctGroup.size() == 0) {
            return false;
        }
        List ids = acctGroup.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        DynamicObject[] acctGroups = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)this.fcaAcctGroupEntityType);
        boolean flag = false;
        for (DynamicObject dynamicObject2 : acctGroups) {
            DynamicObjectCollection sons = dynamicObject2.getDynamicObjectCollection("entrys");
            List sonIds = sons.stream().map(e -> e.getDynamicObject("bankacct").getLong("id")).collect(Collectors.toList());
            if (!sonIds.contains(((DynamicObject)son.get(0)).getLong("id"))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private boolean isMatchFcaDefaultRule(DynamicObject dynamicObject) {
        if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
            return false;
        }
        Long company = dynamicObject.getLong("company.id");
        Long account = dynamicObject.getLong("accountbank.id");
        String sonAcct = dynamicObject.getString("oppbanknumber");
        if (EmptyUtil.isEmpty((Long)company) || EmptyUtil.isEmpty((Long)account) || EmptyUtil.isEmpty((String)sonAcct)) {
            return false;
        }
        boolean isUnAcctGroup = this.getFcaParameterBoolean(company, "isunacctgroup");
        return isUnAcctGroup ? this.isUnAcctGroup(account, sonAcct) : this.unAcctGroup(account, sonAcct);
    }

    private boolean getFcaParameterBoolean(long orgId, String key) {
        AppParam appParam = new AppParam();
        appParam.setOrgId(Long.valueOf(orgId));
        appParam.setViewType("08");
        appParam.setAppId("/WJL3RFSDXE9");
        Object value = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)key);
        if (value == null) {
            return false;
        }
        return value instanceof Boolean ? ((Boolean)value).booleanValue() : "true".equals(value);
    }

    private boolean isUnAcctGroup(Long acctId, String sonAcct) {
        DynamicObject acct = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"createorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)acctId)});
        if (EmptyUtil.isEmpty((DynamicObject)acct)) {
            return false;
        }
        Long orgId = acct.getLong("createorg");
        DynamicObjectCollection group = QueryServiceHelper.query((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("company", "=", (Object)orgId)});
        if (group == null || group.size() == 0) {
            return false;
        }
        DynamicObjectCollection son = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)sonAcct)});
        if (son == null || son.size() == 0) {
            return false;
        }
        DynamicObjectCollection acctGroup = QueryServiceHelper.query((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("entrys.bankacct", "=", (Object)((DynamicObject)son.get(0)).getLong("id"))});
        return acctGroup != null && acctGroup.size() != 0;
    }
}

