/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.recpayrule.transfer;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.recpayrule.IMatchDataTransfer;
import kd.fi.cas.business.recpayrule.bean.MatchBean;
import kd.fi.cas.enums.ReceredtypeEnum;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public abstract class AbstractMatchDataTransfer
implements IMatchDataTransfer {
    private static final Log LOGGER = LogFactory.getLog(AbstractMatchDataTransfer.class);
    private static final String PROPERTIES = "id,enable,biztype,org_entry.u_org,entryentity.e_rulesname,entryentity.e_datafilterdesc,entryentity.e_datafilter_TAG,entryentity.e_datafilter,entryentity.e_receivingtype,entryentity.e_payertype,entryentity.e_payertype,entryentity.e_paymenttype,entryentity.e_payeetype,entryentity.e_fundflowitem,entryentity.e_remark,entryentity.e_savenotifi,entryentity.e_savenotifi_TAG,entryentity.e_handlescheme,entryentity.e_payer,entryentity.e_payerbasetype,entryentity.e_payerid,entryentity.e_recer,entryentity.e_recerbasetype,entryentity.e_recerid,entryentity.e_handlebill";
    protected String number;
    private List<String> selectPropList;
    protected DynamicObject rule;
    private List<DynamicObject> billList;

    public List<QFilter> getBillQFilterList(Set<Object> diffOrgSet) {
        List<QFilter> billQFilterList = this.getBaseQFilter(this.rule);
        if (CollectionUtils.isEmpty(diffOrgSet)) {
            diffOrgSet = this.getEntryOrg(this.rule);
        }
        if (!CollectionUtils.isEmpty(diffOrgSet)) {
            billQFilterList.add(new QFilter("company", "in", diffOrgSet));
        } else {
            List<Long> orgIdList = this.getMatchingRuleOrg(this.rule.getString("biztype"));
            if (!orgIdList.isEmpty()) {
                billQFilterList.add(new QFilter("company", "not in", orgIdList));
            }
        }
        return billQFilterList;
    }

    protected AbstractMatchDataTransfer(String number, DynamicObject rule, List<DynamicObject> billList) {
        this.number = number;
        this.rule = rule;
        this.billList = billList;
    }

    @Override
    public String getNumber() {
        return this.number;
    }

    @Override
    public List<String> getSelectPropList() {
        LOGGER.info("getSelProps");
        if (this.selectPropList != null) {
            return this.selectPropList;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.number);
        this.selectPropList = new ArrayList<String>();
        DataEntityPropertyCollection propertieList = mainEntityType.getProperties();
        for (IDataEntityProperty property : propertieList) {
            String propName = property.getName();
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || propName.contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias()) || prop.getName().contains("_id")) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias()) || tp.getName().contains("_id")) continue;
                            this.selectPropList.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    this.selectPropList.add(secPropName);
                }
                continue;
            }
            this.selectPropList.add(propName);
        }
        return this.selectPropList;
    }

    @Override
    public List<MatchBean> buildMatchBean() {
        LOGGER.info("buildMatchBean,rule:{}", (Object)this.rule);
        ArrayList<MatchBean> matchBeanList = new ArrayList<MatchBean>(10);
        if (this.rule == null) {
            return matchBeanList;
        }
        this.billList = this.getBillList();
        MatchBean matchBean = new MatchBean();
        matchBean.setBillList(this.billList);
        if (this.rule.getDynamicObjectCollection("org_entry").isEmpty()) {
            matchBean.setCommonRule(this.rule);
        } else {
            matchBean.setMainOrgRule(this.rule);
        }
        matchBeanList.add(matchBean);
        return matchBeanList;
    }

    @Override
    public Map<String, DynamicProperty> buildFilterProperties(DynamicObject bill) {
        List<String> selProps = this.getSelectPropList();
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(16);
        DynamicObjectType dType = bill.getDynamicObjectType();
        for (String prop : selProps) {
            fldProperties.put(prop, dType.getProperty(prop));
        }
        return fldProperties;
    }

    protected List<DynamicObject> getBillList() {
        if (this.billList == null && StringUtils.isNotBlank((CharSequence)this.number)) {
            String selectString = StringUtils.join((Object[])this.getSelectPropList().toArray(new Object[0]), (String)",");
            this.billList = QueryServiceHelper.query((String)this.number, (String)selectString, (QFilter[])this.getBillQFilterList(null).toArray(new QFilter[0]));
        }
        return this.billList;
    }

    protected void setBillList(List<DynamicObject> billList) {
        this.billList = billList;
    }

    protected List<QFilter> getBaseQFilter(DynamicObject recPayRule) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        QFilter receredFilter = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.Pending.getValue());
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -3);
        Date beginDate = DateUtils.getDataFormat((Date)calendar.getTime(), (boolean)true);
        QFilter dateDetailFilter = new QFilter("modifytime", ">=", (Object)beginDate);
        QFilter claimnoticebillfilter = new QFilter("claimnoticebillno", "=", (Object)" ");
        QFilter amountFilter = null;
        if ("rec".equals(recPayRule.getString("biztype"))) {
            amountFilter = new QFilter("creditamount", "!=", (Object)0);
        }
        if ("pay".equals(recPayRule.getString("biztype"))) {
            amountFilter = new QFilter("debitamount", "!=", (Object)0);
        }
        qFilterList.add(receredFilter);
        qFilterList.add(dateDetailFilter);
        qFilterList.add(claimnoticebillfilter);
        qFilterList.add(amountFilter);
        return qFilterList;
    }

    protected Set<Object> getEntryOrg(DynamicObject recPayRule) {
        DynamicObjectCollection entryRows = recPayRule.getDynamicObjectCollection("org_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryRows)) {
            return new HashSet<Object>();
        }
        return entryRows.stream().map(o -> o.getDynamicObject("u_org")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
    }

    protected DynamicObject getCommonRule(String type) {
        return this.getCommonRule(type, false);
    }

    protected DynamicObject getCommonRule(String type, boolean noticeClaim) {
        DynamicObject[] commonRule = this.getMatchingRule(null, type, true, noticeClaim);
        return commonRule.length > 0 ? commonRule[0] : null;
    }

    protected DynamicObject[] getMatchingRule(Set<Object> companyIds, String type, boolean commonRule, boolean noticeClaim) {
        QFilter ruleCommonFilter = new QFilter("biztype", "=", (Object)type).and(new QFilter("enable", "=", (Object)"1"));
        String equalsParameter = "";
        if (noticeClaim) {
            equalsParameter = "recv";
            if ("pay".equals(type)) {
                equalsParameter = "pay";
            }
            ruleCommonFilter.and(new QFilter("entryentity.e_handlescheme", "=", (Object)equalsParameter));
        }
        if (!commonRule) {
            ruleCommonFilter.and(new QFilter("org_entry.u_org", "in", companyIds));
        } else {
            ruleCommonFilter.and(QFilter.isNull((String)"org_entry.u_org").or("org_entry.u_org", "=", null));
        }
        DynamicObject[] matchRules = BusinessDataServiceHelper.load((String)"cas_recpayrule", (String)PROPERTIES, (QFilter[])new QFilter[]{ruleCommonFilter});
        if (noticeClaim) {
            for (DynamicObject matchRule : matchRules) {
                DynamicObjectCollection entries = matchRule.getDynamicObjectCollection("entryentity");
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    DynamicObject entry = (DynamicObject)iterator.next();
                    if (equalsParameter.equals(entry.getString("e_handlescheme"))) continue;
                    iterator.remove();
                }
            }
        }
        return matchRules;
    }

    private List<Long> getMatchingRuleOrg(String type) {
        QFilter ruleCommonFilter = new QFilter("biztype", "=", (Object)type).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection ruleList = QueryServiceHelper.query((String)"cas_recpayrule", (String)"org_entry.u_org", (QFilter[])new QFilter[]{ruleCommonFilter});
        return ruleList.stream().map(r -> r.getLong("org_entry.u_org")).distinct().collect(Collectors.toList());
    }
}

