/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.recpayrule.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.business.recpayrule.bean.MatchBean;
import kd.fi.cas.business.recpayrule.transfer.AbstractMatchDataTransfer;

public class DeleteDisableMatchDataTransfer
extends AbstractMatchDataTransfer {
    public DeleteDisableMatchDataTransfer(DynamicObject rule) {
        super("bei_transdetail_cas", rule, null);
    }

    @Override
    public List<QFilter> getBillQFilterList(Set<Object> diffOrgSet) {
        if (this.rule != null) {
            Set ruleNames = this.rule.getDynamicObjectCollection("entryentity").stream().map(r -> r.getString("e_rulesname")).collect(Collectors.toSet());
            if (this.rule.getDynamicObjectCollection("org_entry").isEmpty()) {
                super.getBillQFilterList(diffOrgSet).add(new QFilter("rulename", "in", ruleNames));
            }
        }
        return super.getBillQFilterList(diffOrgSet);
    }

    @Override
    public List<MatchBean> buildMatchBean() {
        ArrayList<MatchBean> matchBeanList = new ArrayList<MatchBean>(10);
        if (this.rule == null) {
            return matchBeanList;
        }
        if (this.rule.getDynamicObjectCollection("org_entry").isEmpty()) {
            DynamicObject[] matchingRules;
            Map<Object, List<DynamicObject>> billMap = super.getBillList().stream().collect(Collectors.groupingBy(b -> b.getLong("company.id")));
            for (DynamicObject matchingRule : matchingRules = this.getMatchingRule(billMap.keySet(), this.rule.getString("biztype"), false, false)) {
                ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(10);
                DynamicObjectCollection orgEntry = matchingRule.getDynamicObjectCollection("org_entry");
                for (DynamicObject entry : orgEntry) {
                    if (!billMap.containsKey(entry.getDynamicObject("u_org").getPkValue())) continue;
                    billList.addAll((Collection<DynamicObject>)billMap.get(entry.getDynamicObject("u_org").getPkValue()));
                    billMap.remove(entry.getDynamicObject("u_org").getPkValue());
                }
                MatchBean matchBean = new MatchBean();
                matchBean.setBillList(billList);
                matchBean.setMainOrgRule(matchingRule);
                matchBeanList.add(matchBean);
            }
            billMap.forEach((k, v) -> {
                MatchBean matchBean = new MatchBean();
                matchBean.setBillList((List<DynamicObject>)v);
                matchBeanList.add(matchBean);
            });
        } else {
            DynamicObject commonRule = this.getCommonRule(this.rule.getString("biztype"));
            MatchBean matchBean = new MatchBean();
            matchBean.setBillList(super.getBillList());
            matchBean.setCommonRule(commonRule);
            matchBeanList.add(matchBean);
        }
        return matchBeanList;
    }
}

