/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.service.BalanceCountService;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.dao.RpcResult;
import kd.fi.cas.enums.RpcResultStatusCode;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PeriodHelper;

public class AccountAmountService {
    public static final String ORGID = "orgid";
    public static final String ACCOUNTID = "accountid";
    public static final String CURRENCYID = "currencyid";
    public static final String BIZDATE = "bizdate";
    private Map<Long, DynamicObject> initOrgCach = new HashMap<Long, DynamicObject>();

    public BigDecimal getAmountByAccount(Long accountId, Long currencyId, Date endDate) {
        BalanceCountService balanceSerVice = new BalanceCountService();
        return balanceSerVice.getJournalBalanceByAccount(accountId, currencyId, endDate);
    }

    public Map<String, BigDecimal> getBankAccountAmount(List<Map<String, Object>> params) {
        if (params == null || params.size() == 0) {
            return null;
        }
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        this.initOrgCach.clear();
        for (Map<String, Object> paramMap : params) {
            if (!this.isLegal(paramMap)) continue;
            Long orgId = CasHelper.getLong((Object)paramMap.get(ORGID));
            Long accountBankId = CasHelper.getLong((Object)paramMap.get(ACCOUNTID));
            Long currencyId = CasHelper.getLong((Object)paramMap.get(CURRENCYID));
            Date endDate = (Date)paramMap.get(BIZDATE);
            DynamicObject initObj = null;
            initObj = this.initOrgCach.containsKey(orgId) ? this.initOrgCach.get(orgId) : PeriodHelper.getCasInitInfo((long)orgId);
            if (initObj == null) {
                resultMap.put(this.getResultKey(orgId, accountBankId, currencyId), BigDecimal.ZERO);
                continue;
            }
            this.initOrgCach.put(orgId, initObj);
            BalanceCountService balanceSerVice = new BalanceCountService();
            BigDecimal journalbalamt = balanceSerVice.getJournalBalance(initObj, orgId, accountBankId, currencyId, endDate);
            resultMap.put(this.getResultKey(orgId, accountBankId, currencyId), journalbalamt);
        }
        return resultMap;
    }

    private String getResultKey(Long orgId, Long accountBankId, Long currencyId) {
        return String.valueOf(orgId) + String.valueOf(accountBankId) + String.valueOf(currencyId);
    }

    private boolean isLegal(Map<String, Object> map) {
        return CasHelper.isNotEmpty((Object)map.get(ORGID)) && CasHelper.isNotEmpty((Object)map.get(ACCOUNTID)) && CasHelper.isNotEmpty((Object)map.get(CURRENCYID)) && CasHelper.isNotEmpty((Object)map.get(BIZDATE));
    }

    public Map<String, BigDecimal> getCashAccountAmount(List<Map<String, Object>> params) {
        if (params == null || params.size() == 0) {
            return null;
        }
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(params.size());
        for (Map<String, Object> paramMap : params) {
            if (!this.isLegal(paramMap)) continue;
            Long orgId = CasHelper.getLong((Object)paramMap.get(ORGID));
            Long accountBankId = CasHelper.getLong((Object)paramMap.get(ACCOUNTID));
            Long currencyId = CasHelper.getLong((Object)paramMap.get(CURRENCYID));
            Date endDate = (Date)paramMap.get(BIZDATE);
            BalanceCountService balanceSerVice = new BalanceCountService();
            BigDecimal journalbalamt = balanceSerVice.getCashbankBalance(orgId, accountBankId, currencyId, endDate);
            resultMap.put(this.getResultKey(orgId, accountBankId, currencyId), journalbalamt);
        }
        return resultMap;
    }

    public int checkBankAccountCancel(Long orgId, Long accountId) {
        if (CasHelper.isEmpty((Object)orgId) || CasHelper.isEmpty((Object)accountId)) {
            return 0;
        }
        if (this.checkInitFinit(orgId, accountId) != null) {
            return 1;
        }
        if (this.checkPaymentBill(orgId, accountId).booleanValue()) {
            return 2;
        }
        if (this.checkRecevingBill(orgId, accountId).booleanValue()) {
            return 3;
        }
        if (this.checkAgentBill(orgId, accountId).booleanValue()) {
            return 4;
        }
        if (this.checkExchangeBill(orgId, accountId).booleanValue()) {
            return 5;
        }
        return 0;
    }

    public DynamicObject checkInitFinit(Long orgId, Long accountId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("entrybank.bank_accountbank", "=", (Object)accountId));
        DynamicObject init = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (QFilter[])new QFilter[]{filter});
        return init;
    }

    public Boolean checkPaymentBill(Long orgId, Long accountId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("payeracctbank", "=", (Object)accountId));
        QFilter filterPayee = new QFilter("payee", "=", (Object)orgId).and(new QFilter("payeeacctbank", "=", (Object)accountId));
        QFilter statusFiler = new QFilter("billstatus", "not in", (Object)new String[]{"A", "G", "H"});
        return QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{statusFiler.and(filter.or(filterPayee))});
    }

    public Boolean checkRecevingBill(Long orgId, Long accountId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "=", (Object)accountId));
        QFilter filterPayee = new QFilter("payer", "=", (Object)orgId).and(new QFilter("payeracctbank", "=", (Object)accountId));
        QFilter statusFiler = new QFilter("billstatus", "not in", (Object)new String[]{"A", "G"});
        return QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])new QFilter[]{statusFiler.and(filter.or(filterPayee))});
    }

    public Boolean checkAgentBill(Long orgId, Long accountId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("payeracctbank", "=", (Object)accountId).or(new QFilter("feeactbank", "=", (Object)accountId)));
        QFilter statusFiler = new QFilter("billstatus", "not in", (Object)new String[]{"A", "G", "H"});
        return QueryServiceHelper.exists((String)"cas_agentpaybill", (QFilter[])new QFilter[]{statusFiler.and(filter)});
    }

    public Boolean checkExchangeBill(Long orgId, Long accountId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        QFilter bugFilter = new QFilter("buyingaccount", "=", (Object)accountId);
        QFilter sellFilter = new QFilter("sellingaccount", "=", (Object)accountId);
        QFilter payFilter = new QFilter("paycommissionaccount", "=", (Object)accountId);
        QFilter statusFiler = new QFilter("billstatus", "!=", (Object)"A").and(new QFilter("accounttype", "=", (Object)"bd_accountbanks"));
        return QueryServiceHelper.exists((String)"cas_exchangebill", (QFilter[])new QFilter[]{filter.and(statusFiler).and(bugFilter.or(sellFilter)).or(payFilter)});
    }

    public String updateOpenOrg() {
        RpcResult recResult = new RpcResult();
        try {
            DynamicObjectCollection banks;
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
            DynamicObject[] inits = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,entrybank.bank_openorg,entrybank.bank_accountbank", (QFilter[])new QFilter[]{new QFilter("entrybank.bank_openorg", "=", (Object)"0")});
            if (!CasHelper.isEmpty((DynamicObject[])inits)) {
                for (DynamicObject init : inits) {
                    Boolean flag = Boolean.FALSE;
                    banks = init.getDynamicObjectCollection("entrybank");
                    if (banks == null || banks.size() == 0) continue;
                    for (DynamicObject bank : banks) {
                        if (!CasHelper.isEmpty((Object)bank.get("bank_openorg"))) continue;
                        flag = Boolean.TRUE;
                        bank.set("bank_openorg", AccountBankHelper.getAccountBankById((long)bank.getDynamicObject("bank_accountbank").getLong("id")).getDynamicObject("openorg").getPkValue());
                    }
                    if (!flag.booleanValue()) continue;
                    list.add(init);
                }
            }
            if (list.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            }
            list.clear();
            DynamicObject[] balances = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"id,org,bank_entry.bank_org", (QFilter[])new QFilter[]{new QFilter("bank_entry.bank_org", "=", (Object)"0")});
            if (!CasHelper.isEmpty((DynamicObject[])balances)) {
                for (DynamicObject balance : balances) {
                    banks = balance.getDynamicObjectCollection("bank_entry");
                    if (banks == null || banks.size() == 0) continue;
                    Boolean flag = Boolean.FALSE;
                    for (DynamicObject bank : banks) {
                        if (!CasHelper.isEmpty((Object)bank.get("bank_org"))) continue;
                        flag = Boolean.TRUE;
                        bank.set("bank_org", (Object)balance.getDynamicObject("org").getLong("id"));
                    }
                    if (!flag.booleanValue()) continue;
                    list.add(balance);
                }
            }
            if (list.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
        }
        return JSON.toJSONString((Object)recResult);
    }

    public String updateBankJournal() {
        RpcResult recResult = new RpcResult();
        try {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
            DynamicObject[] bankJournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,openorg,accountbank", (QFilter[])new QFilter[]{new QFilter("accountbank", "!=", (Object)0)});
            if (!CasHelper.isEmpty((DynamicObject[])bankJournals)) {
                for (DynamicObject bankJournal : bankJournals) {
                    if (bankJournal.getDynamicObject("accountbank") == null) continue;
                    bankJournal.set("openorg", AccountBankHelper.getAccountBankById((long)bankJournal.getDynamicObject("accountbank").getLong("id")).getDynamicObject("openorg").getPkValue());
                    list.add(bankJournal);
                    if (list.size() != 1000) continue;
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                    list.clear();
                }
                if (list.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                }
            }
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
        }
        return JSON.toJSONString((Object)recResult);
    }

    public String updateBankJournalType() {
        RpcResult recResult = new RpcResult();
        try {
            this.updateType(BillTypeConstants.PAYBILL_SYN, "cas_paybill_synonym");
            this.updateType(BillTypeConstants.PAYBILL_CASH, "cas_paybill_cash");
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
        }
        return JSON.toJSONString((Object)recResult);
    }

    public void updateType(Long billType, String type) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> cashList = new ArrayList<DynamicObject>(10);
        DynamicObject[] paybills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billtype", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType)});
        if (!CasHelper.isEmpty((DynamicObject[])paybills)) {
            List idList = CasHelper.getIdList((DynamicObject[])paybills);
            ArrayList resultIds = new ArrayList(idList.size());
            resultIds.addAll(idList);
            DynamicObject[] banks = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", resultIds)});
            DynamicObject[] cashs = BusinessDataServiceHelper.load((String)"cas_cashjournal", (String)"id,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", resultIds)});
            if (!CasHelper.isEmpty((DynamicObject[])banks)) {
                for (DynamicObject bank : banks) {
                    bank.set("sourcebilltype", (Object)type);
                    list.add(bank);
                    if (list.size() != 1000) continue;
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                    list.clear();
                }
            }
            if (!CasHelper.isEmpty((DynamicObject[])cashs)) {
                for (DynamicObject cash : cashs) {
                    cash.set("sourcebilltype", (Object)type);
                    cashList.add(cash);
                    if (cashList.size() != 1000) continue;
                    SaveServiceHelper.save((DynamicObject[])cashList.toArray(new DynamicObject[0]));
                    cashList.clear();
                }
            }
            if (list.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            }
            if (cashList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])cashList.toArray(new DynamicObject[0]));
            }
        }
    }
}

