/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.check.CheckByHandHelper;
import kd.fi.cas.util.EmptyUtil;

public class CheckByHandService {
    private static final Log logger = LogFactory.getLog(CheckByHandService.class);
    private static final String CHECKED_BILL_IDS = "checkedBillIds";
    private static final String STATE_BILL_IDS = "stateBillIds";
    private static final String JOURNAL_BILL_IDS = "journalBillIds";
    private static final String NULL = "null";

    public List<Map<String, Object>> reverseCheck(List<Map<String, Object>> checkedList) {
        logger.info("-\u624b\u5de5\u5bf9\u8d26\u5fae\u670d\u52a1- \u5373\u5c06\u6267\u884c\u64a4\u9500\u5bf9\u8d26" + checkedList.size() + "\u6761\u3002");
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(checkedList.size());
        for (Map<String, Object> checkMap : checkedList) {
            String resultKey = CheckByHandService.getResultKey(checkMap);
            if (resultKey.contains(NULL)) {
                logger.info("-\u624b\u5de5\u5bf9\u8d26\u5fae\u670d\u52a1- \u64a4\u9500\u5bf9\u8d26\u53c2\u6570\u6709\u8bef\uff0c\u7ec4\u7ec7\u3001\u8d26\u6237\u3001\u5e01\u79cd\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\uff1a" + resultKey);
                continue;
            }
            if (EmptyUtil.isEmpty((Object)checkMap.get(CHECKED_BILL_IDS))) {
                logger.info("-\u624b\u5de5\u5bf9\u8d26\u5fae\u670d\u52a1- \u64a4\u9500\u5bf9\u8d26\u53c2\u6570\u6709\u8bef\uff0c\u5df2\u5bf9\u8d26\u7ed3\u679cID\u96c6\u5408\u4e3a\u7a7a\uff1a" + resultKey);
                continue;
            }
            Set checkedBillIds = (Set)checkMap.get(CHECKED_BILL_IDS);
            Map<String, Set<Long>> unCheckIds = CheckByHandHelper.reverseCheck(checkedBillIds, true, null, checkMap);
            results.add(Collections.singletonMap(resultKey, new HashSet<Set<Long>>(unCheckIds.values())));
        }
        logger.info("-\u624b\u5de5\u5bf9\u8d26\u5fae\u670d\u52a1- \u64a4\u9500\u5bf9\u8d26\u5df2\u6267\u884c\u7ed3\u675f\uff0c\u5171\u8fd4\u56de\u7ed3\u679c" + results.size() + "\u6761\u3002");
        return results;
    }

    public List<Map<String, Object>> checkByHand(List<Map<String, Object>> checkList) {
        logger.info("-\u624b\u5de5\u5bf9\u8d26\u5fae\u670d\u52a1- \u5373\u5c06\u6267\u884c\u6570\u636e\u52fe\u5bf9" + checkList.size() + "\u6761\u3002");
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(checkList.size());
        for (Map<String, Object> checkMap : checkList) {
            String resultKey = CheckByHandService.getResultKey(checkMap);
            if (resultKey.contains(NULL)) {
                logger.info("-\u624b\u5de5\u5bf9\u8d26\u5fae\u670d\u52a1- \u6570\u636e\u52fe\u5bf9\u53c2\u6570\u6709\u8bef\uff0c\u7ec4\u7ec7\u3001\u8d26\u6237\u3001\u5e01\u79cd\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\uff1a" + resultKey);
                continue;
            }
            if (EmptyUtil.isEmpty((Object)checkMap.get(STATE_BILL_IDS)) && EmptyUtil.isEmpty((Object)checkMap.get(JOURNAL_BILL_IDS))) {
                logger.info("-\u624b\u5de5\u5bf9\u8d26\u5fae\u670d\u52a1- \u6570\u636e\u52fe\u5bf9\u53c2\u6570\u6709\u8bef\uff0c\u94f6\u884c\u5bf9\u8d26\u5355ID\u96c6\u5408\u4e0e\u65e5\u8bb0\u8d26ID\u96c6\u5408\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\uff1a" + resultKey);
                continue;
            }
            Set stateBillIds = (Set)checkMap.get(STATE_BILL_IDS);
            Set journalBillIds = (Set)checkMap.get(JOURNAL_BILL_IDS);
            String checkType = (String)checkMap.get("checkType");
            Boolean result = CheckByHandHelper.checkByHand(stateBillIds, journalBillIds, checkType, null, checkMap);
            results.add(Collections.singletonMap(resultKey, result));
        }
        logger.info("-\u624b\u5de5\u5bf9\u8d26\u5fae\u670d\u52a1- \u6570\u636e\u52fe\u5bf9\u5df2\u6267\u884c\u7ed3\u675f\uff0c\u5171\u8fd4\u56de\u7ed3\u679c" + results.size() + "\u6761\u3002");
        return results;
    }

    private static String getResultKey(Map<String, Object> checkMap) {
        Object org = checkMap.get("org");
        Object accountbank = checkMap.get("accountbank");
        Object currency = checkMap.get("currency");
        return (org == null ? NULL : Long.valueOf(((DynamicObject)org).getLong("id"))) + "_" + (accountbank == null ? NULL : Long.valueOf(((DynamicObject)accountbank).getLong("id"))) + "_" + (currency == null ? NULL : Long.valueOf(((DynamicObject)currency).getLong("id")));
    }
}

