/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.service.RecChgDataUpgrade;
import kd.fi.cas.dao.RpcResult;
import kd.fi.cas.enums.RpcResultStatusCode;
import kd.fi.cas.util.EmptyUtil;

public class ClaimBankDetailNoDataUpgrade {
    private static final Log LOGGER = LogFactory.getLog(RecChgDataUpgrade.class);

    public String upgrade() {
        RpcResult result = new RpcResult();
        QFilter businessTypeFilter = new QFilter("businesstype", "in", Arrays.asList("pay", "rec"));
        DynamicObject[] noticeBills = BusinessDataServiceHelper.load((String)"cas_claimannounce", (String)"id,tradedetailno,bankdetailno", (QFilter[])new QFilter[]{businessTypeFilter});
        Map idToTradeDetailNo = Arrays.stream(noticeBills).collect(HashMap::new, (m, v) -> m.put(v.getLong("id"), v.getString("tradedetailno")), HashMap::putAll);
        HashSet tradeDetailNos = new HashSet(2);
        tradeDetailNos.addAll(idToTradeDetailNo.values());
        QFilter billNoFilter = new QFilter("billno", "in", tradeDetailNos);
        DynamicObject[] transDetailBills = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id,billno,bankdetailno", (QFilter[])new QFilter[]{billNoFilter});
        Map billNoToTradeDetailBill = Arrays.stream(transDetailBills).collect(Collectors.toMap(o -> o.getString("billno"), Function.identity(), (a, b) -> a));
        for (DynamicObject noticeBill : noticeBills) {
            String bankDetailNo;
            DynamicObject tradeDetailBill = (DynamicObject)billNoToTradeDetailBill.get(idToTradeDetailNo.get(noticeBill.getLong("id")));
            String string = bankDetailNo = tradeDetailBill != null ? tradeDetailBill.getString("bankdetailno") : null;
            if (EmptyUtil.isBlank((CharSequence)bankDetailNo)) continue;
            noticeBill.set("bankdetailno", (Object)bankDetailNo);
        }
        DynamicObject[] claimBills = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,tradedetailno,bankdetailno", (QFilter[])new QFilter[]{businessTypeFilter});
        Map idToTradeDetailNo2 = Arrays.stream(claimBills).collect(HashMap::new, (m, v) -> m.put(v.getLong("id"), v.getString("tradedetailno")), HashMap::putAll);
        HashSet tradeDetailNos2 = new HashSet(2);
        tradeDetailNos2.addAll(idToTradeDetailNo2.values());
        QFilter billNoFilter2 = new QFilter("billno", "in", tradeDetailNos2);
        DynamicObject[] transDetailBills2 = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id,billno,bankdetailno", (QFilter[])new QFilter[]{billNoFilter2});
        Map billNoToTradeDetailBill2 = Arrays.stream(transDetailBills2).collect(Collectors.toMap(o -> o.getString("billno"), Function.identity(), (a, b) -> a));
        for (DynamicObject claimBill : claimBills) {
            String bankDetailNo;
            DynamicObject tradeDetailBill = (DynamicObject)billNoToTradeDetailBill2.get(idToTradeDetailNo2.get(claimBill.getLong("id")));
            String string = bankDetailNo = tradeDetailBill != null ? tradeDetailBill.getString("bankdetailno") : null;
            if (EmptyUtil.isBlank((CharSequence)bankDetailNo)) continue;
            claimBill.set("bankdetailno", (Object)bankDetailNo);
        }
        try (TXHandle h = TX.requiresNew((String)"ClaimBankDetailNoDataUpgrade.upgrade");){
            try {
                SaveServiceHelper.save((DynamicObject[])noticeBills);
                SaveServiceHelper.save((DynamicObject[])claimBills);
            }
            catch (Exception e) {
                result.setStatusCode(RpcResultStatusCode.ERROR);
                result.setMessage(e.getMessage());
                LOGGER.error((Throwable)e);
                h.markRollback();
            }
        }
        return JSON.toJSONString((Object)result);
    }
}

