/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.dao.RpcResult;
import kd.fi.cas.enums.RpcResultStatusCode;

public class HisPayRecSettleUpService {
    private static final Log logger = LogFactory.getLog(HisPayRecSettleUpService.class);

    public String payRecSettleDataUp() {
        RpcResult recResult = new RpcResult();
        try {
            HisPayRecSettleUpService.upgradePayRec();
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
        }
        return JSON.toJSONString((Object)recResult);
    }

    public static void upgradePayRec() {
        String selectPro = "id,settlestatus,unsettleamount,unsettleamountbase,settleamount,settleamountbase,enrty,entry.e_settledamt,entry.e_settledlocalamt,entry.e_unsettledamt,entry.e_unsettledlocalamt";
        DynamicObject[] recBillDts = BusinessDataServiceHelper.load((String)"cas_recbill", (String)selectPro, (QFilter[])new QFilter[0]);
        DynamicObject[] payBillDts = BusinessDataServiceHelper.load((String)"cas_paybill", (String)selectPro, (QFilter[])new QFilter[0]);
        HisPayRecSettleUpService.updateInfo(recBillDts);
        HisPayRecSettleUpService.updateInfo(payBillDts);
        SaveServiceHelper.save((DynamicObject[])recBillDts);
        SaveServiceHelper.save((DynamicObject[])payBillDts);
    }

    private static void updateInfo(DynamicObject[] BillDts) {
        for (DynamicObject BillDt : BillDts) {
            DynamicObjectCollection entryCol = BillDt.getDynamicObjectCollection("entry");
            BigDecimal settledamt = BigDecimal.ZERO;
            BigDecimal settledlocalamt = BigDecimal.ZERO;
            BigDecimal unsettledamt = BigDecimal.ZERO;
            BigDecimal unsettledlocalamt = BigDecimal.ZERO;
            for (DynamicObject entry : entryCol) {
                settledamt = settledamt.add(entry.getBigDecimal("e_settledamt"));
                settledlocalamt = settledlocalamt.add(entry.getBigDecimal("e_settledlocalamt"));
                unsettledamt = unsettledamt.add(entry.getBigDecimal("e_unsettledamt"));
                unsettledlocalamt = unsettledlocalamt.add(entry.getBigDecimal("e_unsettledlocalamt"));
            }
            BillDt.set("settleamount", (Object)settledamt);
            BillDt.set("settleamountbase", (Object)settledlocalamt);
            BillDt.set("unsettleamount", (Object)unsettledamt);
            BillDt.set("unsettleamountbase", (Object)unsettledlocalamt);
            if (settledamt.compareTo(BigDecimal.ZERO) > 0 && unsettledamt.compareTo(BigDecimal.ZERO) == 0) {
                BillDt.set("settlestatus", (Object)"settled");
            }
            if (settledamt.compareTo(BigDecimal.ZERO) > 0 && unsettledamt.compareTo(BigDecimal.ZERO) > 0) {
                BillDt.set("settlestatus", (Object)"partsettle");
            }
            if (settledamt.compareTo(BigDecimal.ZERO) != 0 || unsettledamt.compareTo(BigDecimal.ZERO) <= 0) continue;
            BillDt.set("settlestatus", (Object)"unsettle");
        }
    }
}

