/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.dao.RpcResult;
import kd.fi.cas.enums.RpcResultStatusCode;

public class PayApplyVoucherUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(PayApplyVoucherUpgradeService.class);

    public String upgrade() {
        RpcResult result = new RpcResult();
        QFilter qFilter = new QFilter("source", "=", (Object)Character.valueOf('4'));
        DynamicObject[] bankJournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,billno,sourcebillnumber,sourcebillid", (QFilter[])new QFilter[]{qFilter});
        if (bankJournals == null || bankJournals.length == 0) {
            return JSON.toJSONString((Object)result);
        }
        List sourceBillIds = Arrays.stream(bankJournals).map(d -> d.getLong("sourcebillid")).collect(Collectors.toList());
        QFilter qFilter1 = new QFilter("id", "in", sourceBillIds);
        DynamicObject[] glVouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,vouchertype,billno", (QFilter[])new QFilter[]{qFilter1});
        Map<Long, String> voucherMap = Arrays.stream(glVouchers).collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getDynamicObject("vouchertype") == null ? null : e.getDynamicObject("vouchertype").getString("name")));
        Map<Long, String> voucherMap2 = Arrays.stream(glVouchers).collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("billno")));
        for (DynamicObject bankJournal : bankJournals) {
            if (voucherMap.get(bankJournal.getLong("sourcebillid")) == null) continue;
            String newBillNumber = voucherMap.get(bankJournal.getLong("sourcebillid")) + " " + voucherMap2.get(bankJournal.getLong("sourcebillid"));
            bankJournal.set("sourcebillnumber", (Object)newBillNumber);
        }
        try (TXHandle h = TX.requiresNew((String)"PayApplyVoucherUpgradeService.upgrade.save");){
            try {
                SaveServiceHelper.update((DynamicObject[])bankJournals);
            }
            catch (Exception e2) {
                result.setStatusCode(RpcResultStatusCode.ERROR);
                result.setMessage(e2.getMessage());
                LOGGER.error("PayApplyVoucherUpgradeService.upgrade.save", (Throwable)e2);
                h.markRollback();
            }
        }
        return JSON.toJSONString((Object)result);
    }
}

