/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.dao.RpcResult;
import kd.fi.cas.enums.RpcResultStatusCode;
import kd.fi.cas.util.EmptyUtil;

public class RecBillDataUpgrade {
    private static final Log LOGGER = LogFactory.getLog(RecBillDataUpgrade.class);

    public String upgrade() {
        LOGGER.info("RecBillDataUpgrade upgrade start...");
        RpcResult result = new RpcResult();
        QFilter filter = new QFilter("logids", "is not null", null);
        QFilter logidsFilter = new QFilter("logids", "!=", (Object)Character.valueOf(' '));
        DynamicObject[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,logids,cas_draftinfo,cas_draftinfo.draftbillinfo,cas_draftinfo.recbillcurrency,cas_draftinfo.transamount,cas_draftinfo.draftbilllogid,cas_draftinfo.srcbilltype,cas_draftinfo.srcbillindex", (QFilter[])new QFilter[]{filter, logidsFilter});
        if (recBills == null || recBills.length == 0) {
            LOGGER.info("RecBillDataUpgrade recBills is empty");
            return JSON.toJSONString((Object)result);
        }
        ArrayList<String> logIdList = new ArrayList<String>(10);
        HashMap recBillsMap = Arrays.stream(recBills).filter(o -> !EmptyUtil.isEmpty((String)o.getString("logids"))).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        for (Map.Entry entry : recBillsMap.entrySet()) {
            DynamicObject recBill = (DynamicObject)entry.getValue();
            String logIds = recBill.getString("logids");
            List<String> list = Arrays.asList(logIds.split(","));
            logIdList.addAll(list);
        }
        Set logIdSet = logIdList.stream().map(o -> Long.parseLong(o)).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", logIdSet);
        Object[] draftBillLogs = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,draftid,sourcebillid,dealamount", (QFilter[])qFilter.toArray());
        Map draftBillLogsMap = Arrays.stream(draftBillLogs).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        Set draftIds = Arrays.stream(draftBillLogs).filter(v -> !EmptyUtil.isEmpty((Long)v.getLong("draftid"))).map(item -> item.getLong("draftid")).collect(Collectors.toSet());
        DynamicObject[] draftBills = BusinessDataServiceHelper.load((Object[])draftIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
        Map draftBillsMap = Arrays.stream(draftBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        if (!EmptyUtil.isEmpty((Object[])draftBillLogs)) {
            for (Map.Entry entry : recBillsMap.entrySet()) {
                DynamicObject recBill = (DynamicObject)entry.getValue();
                String logIds = recBill.getString("logids");
                DynamicObjectCollection draftInfoEntrys = recBill.getDynamicObjectCollection("cas_draftinfo");
                if (!EmptyUtil.isEmpty((DynamicObjectCollection)draftInfoEntrys) && draftInfoEntrys.size() > 0) continue;
                List<String> billLogIdList = Arrays.asList(logIds.split(","));
                for (String billLogId : billLogIdList) {
                    DynamicObject draftBill;
                    DynamicObject draftBillLog = (DynamicObject)draftBillLogsMap.get(Long.parseLong(billLogId));
                    if (EmptyUtil.isEmpty((DynamicObject)draftBillLog) || EmptyUtil.isEmpty((DynamicObject)(draftBill = (DynamicObject)draftBillsMap.get(draftBillLog.getLong("draftid"))))) continue;
                    DynamicObject newEntry = draftInfoEntrys.addNew();
                    newEntry.set("draftbillinfo", (Object)draftBill.getLong("id"));
                    newEntry.set("recbillcurrency", (Object)draftBill.getDynamicObject("currency").getLong("id"));
                    newEntry.set("transamount", (Object)draftBillLog.getBigDecimal("dealamount"));
                    newEntry.set("draftbilllogid", (Object)billLogId);
                    newEntry.set("srcbilltype", (Object)"cas_recbill");
                    newEntry.set("srcbillindex", (Object)1);
                }
            }
        }
        if (!EmptyUtil.isEmpty((Object)recBillsMap) && recBillsMap.size() > 0) {
            try (TXHandle h = TX.requiresNew((String)"RecBillDataUpgrade.upgrade");){
                try {
                    SaveServiceHelper.save((DynamicObject[])recBillsMap.values().toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    result.setStatusCode(RpcResultStatusCode.ERROR);
                    result.setMessage(e.getMessage());
                    LOGGER.error((Throwable)e);
                    h.markRollback();
                }
            }
        }
        LOGGER.info("RecBillDataUpgrade upgrade end...");
        return JSON.toJSONString((Object)result);
    }
}

