/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class ReceiveBillSynUseService {
    private static final Log logger = LogFactory.getLog(ReceiveBillSynUseService.class);

    public void updateReceiveBill(String objectJson) {
        logger.info("ReceiveBillSynUseService\uff1a receive the upstream parameter:{}", (Object)objectJson);
        try (TXHandle tx = TX.requiresNew();){
            try {
                List jsonObjectList = (List)JSON.parseObject((String)objectJson, (TypeReference)new TypeReference<List<JSONObject>>(){}, (Feature[])new Feature[0]);
                this.changePayBill(jsonObjectList, null);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public void lockReceiveBill(String objectJson) {
        logger.info("ReceiveBillSynUseService\uff1a receive the upstream parameter:{}", (Object)objectJson);
        try (TXHandle tx = TX.requiresNew();){
            try {
                List jsonObjectList = (List)JSON.parseObject((String)objectJson, (TypeReference)new TypeReference<List<JSONObject>>(){}, (Feature[])new Feature[0]);
                this.changePayBill(jsonObjectList, false);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public void releaseReceiveBill(String objectJson) {
        logger.info("ReceiveBillSynUseService\uff1a receive the upstream parameter:{}", (Object)objectJson);
        try (TXHandle tx = TX.requiresNew();){
            try {
                List jsonObjectList = (List)JSON.parseObject((String)objectJson, (TypeReference)new TypeReference<List<JSONObject>>(){}, (Feature[])new Feature[0]);
                this.changePayBill(jsonObjectList, true);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePayBill(List<JSONObject> jsonObjectList, Boolean isRelease) {
        int size = jsonObjectList.size();
        HashMap<Long, JSONObject> usedInfo = new HashMap<Long, JSONObject>(size);
        ArrayList<String> lockIds = new ArrayList<String>(size);
        ArrayList<String> sourceBills = new ArrayList<String>(size);
        for (JSONObject jsonObject : jsonObjectList) {
            JSONObject mapValues = new JSONObject();
            Long receiveBillId = jsonObject.getLong("receiveBillId");
            String batchNum = jsonObject.getString("batchNum");
            String sourceBill = jsonObject.getString("usesourcebill");
            mapValues.put("isUsed", (Object)jsonObject.getBoolean("isUsed"));
            mapValues.put("usesourcebill", (Object)sourceBill);
            mapValues.put("batchNum", (Object)batchNum);
            if (EmptyUtil.isNoEmpty((String)batchNum)) {
                sourceBills.add(batchNum);
            } else {
                sourceBills.add(sourceBill);
            }
            usedInfo.put(receiveBillId, mapValues);
            lockIds.add(String.valueOf(receiveBillId));
        }
        try {
            Map request = MutexServiceHelper.batchRequest(lockIds, (String)"cas_recBill_f7", (String)"changeReceiveBillUsed");
            if (request.containsValue(Boolean.FALSE)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5df2\u88ab\u5176\u4ed6\u64cd\u4f5c\u9501\u5b9a\u3002", (String)"ReceiveBillSynUseService_0", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (isRelease.booleanValue()) {
                this.releaseUsed(usedInfo, sourceBills);
            } else {
                this.holdUsed(usedInfo);
            }
        }
        finally {
            MutexServiceHelper.batchRelease(lockIds, (String)"cas_recBill_f7", (String)"changeReceiveBillUsed");
        }
    }

    private void releaseUsed(Map<Long, JSONObject> usedInfo, List<String> sourceBills) {
        DynamicObject[] existReceiveBills;
        if (usedInfo.size() <= 0 || sourceBills.size() <= 0) {
            return;
        }
        Set<Long> ids = usedInfo.keySet();
        QFilter filterIds = new QFilter("id", "in", (Object)ids.toArray());
        QFilter filterIsUsed = new QFilter("isused", "=", (Object)true);
        QFilter filterSourceBill = new QFilter("usesourcebill", "in", sourceBills);
        for (DynamicObject existReceiveBill : existReceiveBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id, isused, usesourcebill", (QFilter[])new QFilter[]{filterIds, filterIsUsed, filterSourceBill})) {
            existReceiveBill.set("isused", (Object)false);
            existReceiveBill.set("usesourcebill", (Object)"");
        }
        if (existReceiveBills.length > 0) {
            SaveServiceHelper.save((DynamicObject[])existReceiveBills);
        }
    }

    private void holdUsed(Map<Long, JSONObject> usedInfo) {
        String info;
        DynamicObject[] receiveBills;
        if (usedInfo.size() <= 0) {
            return;
        }
        Set<Long> ids = usedInfo.keySet();
        ArrayList<String> falseUsedBill = new ArrayList<String>(ids.size());
        ArrayList<String> statusVolatile = new ArrayList<String>(ids.size());
        for (DynamicObject receiveBill : receiveBills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"))) {
            JSONObject mapValues = usedInfo.get(receiveBill.get("id"));
            Boolean getIsUsed = mapValues.getBoolean("isUsed");
            String getUseSourceBillId = mapValues.getString("usesourcebill");
            String batchNum = mapValues.getString("batchNum");
            Boolean queryIsUsed = receiveBill.getBoolean("isused");
            String useSourceBillId = receiveBill.getString("usesourcebill");
            String billStatus = receiveBill.getString("billstatus");
            if (StringUtils.isNotEmpty((String)batchNum)) {
                getUseSourceBillId = batchNum;
            }
            if (!"D".equals(billStatus)) {
                statusVolatile.add(receiveBill.getString("billno"));
            }
            if (getIsUsed.booleanValue() && queryIsUsed.booleanValue() && !getUseSourceBillId.equals(useSourceBillId)) {
                falseUsedBill.add(receiveBill.getString("billno"));
            }
            receiveBill.set("isused", (Object)getIsUsed);
            receiveBill.set("usesourcebill", (Object)getUseSourceBillId);
        }
        if (falseUsedBill.size() > 0) {
            info = String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355%1$s\u5df2\u88ab\u4f7f\u7528\u3002", (String)"ReceiveBillSynUseService_1", (String)"fi-cas-business", (Object[])new Object[0]), falseUsedBill);
            throw new KDBizException(info);
        }
        if (statusVolatile.size() > 0) {
            info = String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\uff1a%1$s\u72b6\u6001\u4e0d\u4e3a\u5df2\u6536\u6b3e\u3002", (String)"ReceiveBillSynUseService_2", (String)"fi-cas-business", (Object[])new Object[0]), statusVolatile);
            throw new KDBizException(info);
        }
        if (receiveBills.length > 0) {
            SaveServiceHelper.save((DynamicObject[])receiveBills);
        }
    }
}

