/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.errorcode.JournalErrorCode;
import kd.fi.cas.business.journal.VoucherBookService;
import kd.fi.cas.helper.MutexServiceHelper;

public class VoucherBookECConsumer
extends EventualConsistencyService {
    private static final Log logger = LogFactory.getLog(VoucherBookECConsumer.class);
    private static final String OP_VOUCHERBOOKECCONSUMER = "VoucherBookECConsumer";

    public DtxResponse execute(Object arg01, Object arg02) throws Exception {
        try {
            CommonParam vbp = (CommonParam)arg01;
            Map params = vbp.getAll();
            logger.info(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u767b\u8d26\u6700\u7ec8\u4e00\u81f4\u6027\u6d88\u8d39\u7aef\u670d\u52a1\u5df2\u6536\u5230\u6d88\u606f\uff1a%s\u3002", (String)"VoucherBookECConsumer_0", (String)"fi-cas-business", (Object[])new Object[0]), JSONObject.toJSONString((Object)params)));
            VoucherBookService voucherBookService = new VoucherBookService();
            String action = (String)params.get("action");
            Long[] voucherPks = (Long[])params.get("voucherPks");
            Object recordPk = params.get("recordPk");
            logger.info(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u767b\u8d26\u6700\u7ec8\u4e00\u81f4\u6027\u6d88\u8d39\u7aef\u670d\u52a1\u3002\u6267\u884c\u52a8\u4f5c\uff1a%s\u3002", (String)"VoucherBookECConsumer_1", (String)"fi-cas-business", (Object[])new Object[0]), action + Arrays.asList(voucherPks)));
            this.dealMessage(recordPk, voucherPks, voucherBookService, action);
        }
        catch (Exception e) {
            logger.error("\u51ed\u8bc1\u767b\u8d26\u6700\u7ec8\u4e00\u81f4\u6027\u6d88\u8d39\u7aef\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealMessage(Object recordPk, Long[] voucherPks, VoucherBookService voucherBookService, String action) throws Exception {
        String recordId = String.valueOf(recordPk);
        logger.info(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u767b\u8d26\u6700\u7ec8\u4e00\u81f4\u6027\u6d88\u8d39\u7aef\u670d\u52a1\u3002\u6d88\u606fID\uff1a%s\u3002", (String)"VoucherBookECConsumer_3", (String)"fi-cas-business", (Object[])new Object[0]), recordId));
        ArrayList<String> requestIds = new ArrayList<String>(voucherPks.length);
        List lockIds = Arrays.stream(voucherPks).map(Object::toString).collect(Collectors.toList());
        Map lockResultMap = MutexServiceHelper.batchRequestWithLostTime(lockIds, (String)"gl_voucher", (String)OP_VOUCHERBOOKECCONSUMER);
        try {
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (!((Boolean)next.getValue()).booleanValue()) continue;
                requestIds.add(key);
            }
            if (requestIds.size() <= 0) {
                throw new KDBizException(new JournalErrorCode().JOURNAL_EC_LOCK_ERROR(), new Object[0]);
            }
            Long[] sucVouvhers = (Long[])requestIds.stream().map(Long::parseLong).toArray(Long[]::new);
            voucherBookService.setConsistency(true);
            if ("book".equals(action)) {
                voucherBookService.book(sucVouvhers);
            } else if ("delete".equals(action)) {
                voucherBookService.delete(sucVouvhers);
            }
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"gl_voucher", (String)OP_VOUCHERBOOKECCONSUMER);
        }
    }
}

