/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service.freeze;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.helper.PaymentFillPropHelper;
import kd.fi.cas.business.paysche.bean.RpcStatus;
import kd.fi.cas.business.service.bean.freeze.FreezeDetailResult;
import kd.fi.cas.business.service.bean.freeze.FreezeInfo;
import kd.fi.cas.business.service.bean.freeze.FreezeResult;
import kd.fi.cas.business.service.freeze.AbstractFreezeService;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PriorityEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;

public class PayBillFreezeFacadeImpl
extends AbstractFreezeService {
    private static final Log logger = LogFactory.getLog(PayBillFreezeFacadeImpl.class);
    private FreezeInfo freezeInfo;

    public PayBillFreezeFacadeImpl(FreezeInfo freezeInfo) {
        this.freezeInfo = freezeInfo;
    }

    @Override
    public FreezeInfo getFreezeInfo() {
        return this.freezeInfo;
    }

    @Override
    public FreezeResult freezeValidate(DynamicObject[] targetBills) {
        FreezeResult result = new FreezeResult(RpcStatus.SUCCESS);
        for (DynamicObject targetBill : targetBills) {
            if (this.isCanFreeze(targetBill)) continue;
            DynamicObjectCollection dynamicObjectCollection = targetBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : dynamicObjectCollection) {
                long sourceBillEntryId = row.getLong(this.getSourceBillIdFieldName());
                if (!this.sourceBillEntryIds.contains(sourceBillEntryId)) continue;
                String errorInfo = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u201c%1$s\u201d\u72b6\u6001\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u5141\u8bb8\u51bb\u7ed3\u3002", (String)"PayBillFreezeFacadeImpl_0", (String)"fi-cas-business", (Object[])new Object[0]), targetBill.getString("billno"), BillStatusEnum.getName((String)targetBill.getString("billstatus")));
                ArrayList<String> errors = (ArrayList<String>)this.sourceBillErrInfoMap.get(sourceBillEntryId);
                if (errors == null) {
                    errors = new ArrayList<String>(10);
                }
                errors.add(errorInfo);
                this.sourceBillErrInfoMap.put(sourceBillEntryId, errors);
            }
        }
        if (this.sourceBillErrInfoMap.size() > 0) {
            HashMap totalErrMsgMap = new HashMap(this.sourceBillNoMap.size());
            ArrayList<FreezeDetailResult> details = new ArrayList<FreezeDetailResult>(this.sourceBillErrInfoMap.size());
            for (Map.Entry entry : this.sourceBillErrInfoMap.entrySet()) {
                Long l = (Long)entry.getKey();
                List errors = (List)entry.getValue();
                Long sourceBillId = (Long)this.sourceBillInfoMap.get(l);
                FreezeDetailResult detail = new FreezeDetailResult();
                detail.setStatus(RpcStatus.ERROR);
                detail.setBillEntryId(l);
                detail.setBillId(sourceBillId);
                detail.setErrMsg(String.join((CharSequence)"", errors));
                details.add(detail);
                HashSet totalErrors = (HashSet)totalErrMsgMap.get(sourceBillId);
                if (totalErrors == null) {
                    totalErrors = new HashSet(10);
                }
                totalErrors.addAll(errors);
                totalErrMsgMap.put(sourceBillId, totalErrors);
            }
            StringBuffer totalErrMsgSb = new StringBuffer();
            for (Map.Entry entry : totalErrMsgMap.entrySet()) {
                Long sourceBillId = (Long)entry.getKey();
                Set errors = (Set)entry.getValue();
                String sourceBillNo = (String)this.sourceBillNoMap.get(sourceBillId);
                totalErrMsgSb.append(String.format(ResManager.loadKDString((String)"[%s]\u5355\u636e\uff1a\u4e0b\u6e38", (String)"PayBillFreezeFacadeImpl_1", (String)"fi-cas-business", (Object[])new Object[0]), sourceBillNo)).append(String.join((CharSequence)"", errors));
            }
            result.setStatus(RpcStatus.ERROR);
            result.setErrMsg(totalErrMsgSb.toString());
            result.setDetails(details);
        }
        return result;
    }

    @Override
    public void freeze(DynamicObject[] targetBills) {
        ArrayList<DynamicObject> newfreezePayBills = new ArrayList<DynamicObject>();
        for (DynamicObject targetBill : targetBills) {
            Object rowIndex;
            Object row2;
            if (PriorityEnum.DEFER.getValue().equals(targetBill.getString("priority")) || !this.isCanFreeze(targetBill)) continue;
            boolean isWholeFreeze = true;
            DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
            HashMap<Object, BigDecimal> rowFreezeAmtMap = new HashMap<Object, BigDecimal>(entry.size());
            for (Object row2 : entry) {
                long sourceBillEntryId = row2.getLong(this.getSourceBillIdFieldName());
                if (!this.sourceBillEntryIds.contains(sourceBillEntryId)) {
                    boolean isFreeze = row2.getBoolean("e_isfreeze");
                    if (isFreeze) continue;
                    isWholeFreeze = false;
                    continue;
                }
                boolean isValidFail = this.sourceBillErrInfoMap.get(sourceBillEntryId) != null;
                BigDecimal freezeLeftAmt = (BigDecimal)this.freezeLeftAmtMap.get(sourceBillEntryId);
                if (isValidFail || freezeLeftAmt.compareTo(BigDecimal.ZERO) == 0) {
                    isWholeFreeze = false;
                    continue;
                }
                BigDecimal payableamt = row2.getBigDecimal("e_payableamt");
                BigDecimal freezeAmt = BigDecimal.ZERO;
                if (freezeLeftAmt.abs().compareTo(payableamt.abs()) < 0) {
                    isWholeFreeze = false;
                    freezeAmt = freezeLeftAmt;
                    freezeLeftAmt = BigDecimal.ZERO;
                } else {
                    freezeAmt = payableamt;
                    freezeLeftAmt = freezeLeftAmt.subtract(payableamt);
                }
                this.freezeLeftAmtMap.put(sourceBillEntryId, freezeLeftAmt);
                rowFreezeAmtMap.put(row2.get("seq"), freezeAmt);
                BigDecimal totalAmt = (BigDecimal)this.sourceBillOpAmtMap.get(sourceBillEntryId);
                totalAmt = totalAmt == null ? freezeAmt : totalAmt.add(freezeAmt);
                this.sourceBillOpAmtMap.put(sourceBillEntryId, totalAmt);
            }
            if (isWholeFreeze) {
                targetBill.set("priority", (Object)PriorityEnum.DEFER.getValue());
                for (Object row2 : entry) {
                    row2.set("e_isfreeze", (Object)true);
                    row2.set("e_freezeamt", (Object)row2.getBigDecimal("e_payableamt"));
                }
                continue;
            }
            if (rowFreezeAmtMap.size() <= 0) continue;
            boolean iswaitsche = targetBill.getBoolean("iswaitsche");
            if (iswaitsche) {
                targetBill.set("priority", (Object)PriorityEnum.DEFER.getValue());
                row2 = entry.iterator();
                while (row2.hasNext()) {
                    DynamicObject row3 = (DynamicObject)row2.next();
                    rowIndex = row3.get("seq");
                    BigDecimal freezeAmt = (BigDecimal)rowFreezeAmtMap.get(rowIndex);
                    if (!CasHelper.isNotEmpty((Object)freezeAmt)) continue;
                    row3.set("e_isfreeze", (Object)true);
                    row3.set("e_freezeamt", (Object)freezeAmt);
                }
                continue;
            }
            row2 = rowFreezeAmtMap.entrySet().iterator();
            while (row2.hasNext()) {
                Map.Entry freezeRowInfo = (Map.Entry)row2.next();
                rowIndex = freezeRowInfo.getKey();
                BigDecimal freezeAmt = (BigDecimal)freezeRowInfo.getValue();
                DynamicObject newfreezePayBill = (DynamicObject)OrmUtils.clone((Object)targetBill, (IDataEntityType)targetBill.getDataEntityType(), (boolean)true, (boolean)true);
                if (BillStatusEnum.SUBMIT.getValue().equals(newfreezePayBill.getString("billstatus"))) {
                    newfreezePayBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                }
                newfreezePayBill.set("priority", (Object)PriorityEnum.DEFER.getValue());
                DynamicObjectCollection collection = newfreezePayBill.getDynamicObjectCollection("entry");
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    DynamicObject row4 = (DynamicObject)iterator.next();
                    if (!rowIndex.equals(row4.get("seq"))) {
                        iterator.remove();
                        continue;
                    }
                    row4.set("e_isfreeze", (Object)true);
                    row4.set("e_payableamt", (Object)freezeAmt);
                    row4.set("e_discountamt", null);
                }
                PaymentFillPropHelper.calculateAmt(newfreezePayBill, true);
                PaymentFillPropHelper.calSettlAmt(newfreezePayBill);
                newfreezePayBills.add(newfreezePayBill);
            }
            Iterator iterator = entry.iterator();
            while (iterator.hasNext()) {
                DynamicObject row5 = (DynamicObject)iterator.next();
                rowIndex = row5.get("seq");
                BigDecimal freezeAmt = (BigDecimal)rowFreezeAmtMap.get(rowIndex);
                if (!CasHelper.isNotEmpty((Object)freezeAmt)) continue;
                BigDecimal payableamt = row5.getBigDecimal("e_payableamt");
                if (freezeAmt.abs().compareTo(payableamt.abs()) < 0) {
                    row5.set("e_payableamt", (Object)payableamt.subtract(freezeAmt));
                    continue;
                }
                iterator.remove();
            }
            PaymentFillPropHelper.calculateAmt(targetBill, true);
            PaymentFillPropHelper.calSettlAmt(targetBill);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                OperateServiceHelper.execOperate((String)"chargebacksave", (String)"cas_paybill", (DynamicObject[])targetBills, (OperateOption)OperateOption.create());
                if (newfreezePayBills.size() > 0) {
                    OperateServiceHelper.execOperate((String)"chargebacksave", (String)"cas_paybill", (DynamicObject[])newfreezePayBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    @Override
    public void unfreeze(DynamicObject[] targetBills) {
        ArrayList<DynamicObject> newUnfreezePayBills = new ArrayList<DynamicObject>();
        for (DynamicObject targetBill : targetBills) {
            boolean isFreeze;
            if (!PriorityEnum.DEFER.getValue().equals(targetBill.getString("priority"))) continue;
            boolean isWholeUnFreeze = true;
            DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
            HashSet<Long> unFreezeRowIds = new HashSet<Long>(entry.size());
            for (DynamicObject row : entry) {
                boolean isValidFail;
                long sourceBillEntryId = row.getLong(this.getSourceBillIdFieldName());
                if (!this.sourceBillEntryIds.contains(sourceBillEntryId)) {
                    isFreeze = row.getBoolean("e_isfreeze");
                    if (!isFreeze) continue;
                    isWholeUnFreeze = false;
                    continue;
                }
                boolean bl = isValidFail = this.sourceBillErrInfoMap.get(sourceBillEntryId) != null;
                if (isValidFail) {
                    isWholeUnFreeze = false;
                    continue;
                }
                unFreezeRowIds.add(sourceBillEntryId);
                BigDecimal payableamt = row.getBigDecimal("e_payableamt");
                BigDecimal totalAmt = (BigDecimal)this.sourceBillOpAmtMap.get(sourceBillEntryId);
                totalAmt = totalAmt == null ? payableamt : totalAmt.add(payableamt);
                this.sourceBillOpAmtMap.put(sourceBillEntryId, totalAmt);
                row.set("e_isfreeze", (Object)false);
                row.set("e_freezeamt", null);
            }
            if (isWholeUnFreeze) {
                targetBill.set("priority", (Object)PriorityEnum.PUBLIC.getValue());
                continue;
            }
            if (unFreezeRowIds.size() <= 0) continue;
            boolean iswaitsche = targetBill.getBoolean("iswaitsche");
            if (iswaitsche) {
                boolean isUnFreeze = true;
                for (DynamicObject row : entry) {
                    isFreeze = row.getBoolean("e_isfreeze");
                    if (!isFreeze) continue;
                    isUnFreeze = false;
                }
                if (!isUnFreeze) continue;
                targetBill.set("priority", (Object)PriorityEnum.PUBLIC.getValue());
                continue;
            }
            for (Long unfreezeRowId : unFreezeRowIds) {
                DynamicObject newUnfreezePayBill = (DynamicObject)OrmUtils.clone((Object)targetBill, (IDataEntityType)targetBill.getDataEntityType(), (boolean)true, (boolean)true);
                newUnfreezePayBill.set("priority", (Object)PriorityEnum.PUBLIC.getValue());
                DynamicObjectCollection collection = newUnfreezePayBill.getDynamicObjectCollection("entry");
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    DynamicObject object = (DynamicObject)iterator.next();
                    long sourceBillEntryId = object.getLong(this.getSourceBillIdFieldName());
                    if (unfreezeRowId == sourceBillEntryId) continue;
                    iterator.remove();
                }
                PaymentFillPropHelper.calculateAmt(newUnfreezePayBill, true);
                PaymentFillPropHelper.calSettlAmt(newUnfreezePayBill);
                newUnfreezePayBills.add(newUnfreezePayBill);
            }
            Iterator iterator = entry.iterator();
            while (iterator.hasNext()) {
                DynamicObject object = (DynamicObject)iterator.next();
                long sourceBillEntryId = object.getLong(this.getSourceBillIdFieldName());
                if (!unFreezeRowIds.contains(sourceBillEntryId)) continue;
                iterator.remove();
            }
            PaymentFillPropHelper.calculateAmt(targetBill, true);
            PaymentFillPropHelper.calSettlAmt(targetBill);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                OperateServiceHelper.execOperate((String)"chargebacksave", (String)"cas_paybill", (DynamicObject[])targetBills, (OperateOption)OperateOption.create());
                if (newUnfreezePayBills.size() > 0) {
                    OperateServiceHelper.execOperate((String)"chargebacksave", (String)"cas_paybill", (DynamicObject[])newUnfreezePayBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    boolean isCanFreeze(DynamicObject targetBill) {
        String billStatus;
        long orgId = (Long)targetBill.getDynamicObject("org").getPkValue();
        Set cs119 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs119");
        return cs119.contains(billStatus = targetBill.getString("billstatus"));
    }

    @Override
    String getEntityName() {
        return "cas_paybill";
    }

    @Override
    String getSourceBillIdFieldName() {
        return "e_sourcebillentryid";
    }

    @Override
    String getSourceBillTypeFieldName() {
        return "sourcebilltype";
    }
}

