/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.sign;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.PayInfoChgHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.info.AdminDivision;
import kd.fi.cas.sign.ISignExecutor;
import kd.fi.cas.util.EmptyUtil;

public class PayChgReviewExecutor
implements ISignExecutor {
    private static Log logger = LogFactory.getLog(PayChgReviewExecutor.class);
    private List<DynamicObject> payChgBillList;
    private StringBuilder errorMessage = new StringBuilder();
    private Map<Long, Long> payChgToPayBillMap;
    private String sourceType;

    public PayChgReviewExecutor(List<DynamicObject> payChgBillList, String sourceType) {
        this.payChgBillList = payChgBillList;
        this.sourceType = sourceType;
    }

    public List<Object> prepareSignData() {
        this.payChgToPayBillMap = new HashMap<Long, Long>(this.payChgBillList.size());
        ArrayList<DynamicObject> bizBillList = new ArrayList<DynamicObject>(this.payChgBillList.size());
        for (DynamicObject chgBill : this.payChgBillList) {
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)chgBill.getLong("sourcebillid"), (String)this.sourceType);
            String billStatus = sourceBill.getString("billstatus");
            DynamicObjectCollection chgBillEntrys = chgBill.getDynamicObjectCollection("entrys");
            String chgtype = chgBill.getString("chgtype");
            if ("paychg".equals(chgtype)) {
                DynamicObject rowData = (DynamicObject)chgBillEntrys.get(0);
                this.payInfoChangeDeal(rowData, sourceBill, this.sourceType);
                bizBillList.add(sourceBill);
            } else if ("recchg".equals(chgtype)) {
                this.recInfoChangeDeal(chgBillEntrys, sourceBill, this.sourceType);
                bizBillList.add(sourceBill);
            }
            this.payChgToPayBillMap.put(chgBill.getLong("id"), sourceBill.getLong("id"));
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])bizBillList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                handle.markRollback();
                throw e;
            }
        }
        return new ArrayList<Object>(this.payChgToPayBillMap.values());
    }

    private void payInfoChangeDeal(DynamicObject rowData, DynamicObject sourceBill, String sourceType) {
        String beforeSettleTypeStr;
        String afterSettleTypeStr;
        Object aftersettletype = rowData.get("aftersettletype");
        Object aftersettletnumber = rowData.get("aftersettletnumber");
        DynamicObject afterpayeracctbank = rowData.getDynamicObject("afterpayeracctbank");
        DynamicObject afterpayeracctcash = rowData.getDynamicObject("afterpayeracctcash");
        DynamicObject afterpayerbank = rowData.getDynamicObject("afterpayerbank");
        Object afterusage = rowData.get("afterusage");
        Object afterpaychannel = rowData.get("afterpaychannel");
        Object afterbizdate = rowData.get("afterbizdate");
        Object afterinstitutioncode = rowData.get("afterinstitutioncode");
        Object afterinstitutionname = rowData.get("afterinstitutionname");
        boolean isBankChangeToCash = false;
        if (EmptyUtil.isNoEmpty((Object)aftersettletype) && EmptyUtil.isNoEmpty((Object)rowData.get("settletype")) && !(afterSettleTypeStr = ((DynamicObject)aftersettletype).getString("settlementtype")).equals(beforeSettleTypeStr = ((DynamicObject)rowData.get("settletype")).getString("settlementtype")) && "0".equals(afterSettleTypeStr)) {
            isBankChangeToCash = true;
        }
        if (CasHelper.isEmpty((Object)aftersettletype)) {
            aftersettletype = rowData.get("settletype");
        }
        if (CasHelper.isEmpty((Object)aftersettletnumber)) {
            aftersettletnumber = rowData.get("settletnumber");
        }
        if (CasHelper.isEmpty((Object)afterpayeracctbank) && !isBankChangeToCash) {
            afterpayeracctbank = rowData.getDynamicObject("payeracctbank");
        }
        if (CasHelper.isEmpty((Object)afterpayeracctcash)) {
            afterpayeracctcash = rowData.getDynamicObject("payeracctcash");
        }
        if (CasHelper.isEmpty((Object)afterpayerbank)) {
            afterpayerbank = rowData.getDynamicObject("payerbank");
        }
        if (CasHelper.isEmpty((Object)afterusage)) {
            afterusage = rowData.get("usage");
        }
        if (CasHelper.isEmpty((Object)afterpaychannel)) {
            afterpaychannel = rowData.get("paychannel");
        }
        if (CasHelper.isEmpty((Object)afterbizdate)) {
            afterbizdate = rowData.get("bizdate");
        }
        sourceBill.set("paymentchannel", afterpaychannel);
        sourceBill.set("settletype", aftersettletype);
        sourceBill.set("settletnumber", aftersettletnumber);
        sourceBill.set("payeracctbank", CasHelper.isEmpty((Object)afterpayeracctbank) ? null : afterpayeracctbank.getPkValue());
        sourceBill.set("payerbank", CasHelper.isEmpty((Object)afterpayerbank) ? null : afterpayerbank.getPkValue());
        if ("cas_paybill".equals(sourceType)) {
            sourceBill.set("usage", afterusage);
            sourceBill.set("payeracctcash", CasHelper.isEmpty((Object)afterpayeracctcash) ? null : afterpayeracctcash.getPkValue());
            if (CasHelper.isNotEmpty((Object)afterinstitutioncode)) {
                sourceBill.set("institutioncode", afterinstitutioncode);
                sourceBill.set("institutionname", afterinstitutionname);
            }
        } else if ("cas_agentpaybill".equals(sourceType)) {
            Object isaftercombinerecord = rowData.get("isaftercombinerecord");
            sourceBill.set("isagencypersonpay", isaftercombinerecord);
        }
        sourceBill.set("bizdate", afterbizdate);
        sourceBill.set("feeactbank", sourceBill.get("payeracctbank"));
    }

    private void recInfoChangeDeal(DynamicObjectCollection chgBillEntrys, DynamicObject sourceBill, String sourceType) {
        if (sourceType.equals("cas_paybill")) {
            DynamicObject payeebank;
            DynamicObject afterrecerbank;
            String afterrecacctbank;
            DynamicObject rowData = (DynamicObject)chgBillEntrys.get(0);
            Object afterrecername = rowData.get("afterrecername");
            Object afterusage = rowData.get("afterusage");
            Object afterinstitutioncode = rowData.get("afterinstitutioncode");
            Object afterinstitutionname = rowData.get("afterinstitutionname");
            if (!CasHelper.isEmpty((Object)afterrecername)) {
                sourceBill.set("recaccbankname", afterrecername);
            }
            if (!CasHelper.isEmpty((Object)afterusage)) {
                sourceBill.set("usage", afterusage);
            }
            if (!CasHelper.isEmpty((Object)(afterrecacctbank = rowData.getString("changerecacctbank")))) {
                sourceBill.set("payeebanknum", (Object)afterrecacctbank);
            }
            if (!CasHelper.isEmpty((Object)(afterrecerbank = rowData.getDynamicObject("afterrecerbank"))) && CasHelper.isNotEmpty((Object)(payeebank = BusinessDataServiceHelper.loadSingleFromCache((Object)afterrecerbank.getPkValue(), (String)"bd_bebank")))) {
                sourceBill.set("payeebank", payeebank.getPkValue());
                sourceBill.set("payeebankname", (Object)payeebank.getLocaleString("name").getLocaleValue());
                AdminDivision adminDivision = BaseDataHelper.getAdminDivision((DynamicObject)payeebank);
                if (adminDivision != null) {
                    sourceBill.set("reccountry", (Object)adminDivision.getCountry());
                    sourceBill.set("recprovince", (Object)adminDivision.getProvince());
                    sourceBill.set("reccity", (Object)adminDivision.getCity());
                }
                sourceBill.set("recbanknumber", (Object)payeebank.getString("union_number"));
                sourceBill.set("recswiftcode", (Object)payeebank.getString("swift_code"));
                sourceBill.set("recroutingnum", (Object)payeebank.getString("routingnum"));
                sourceBill.set("recothercode", (Object)payeebank.getString("other_code"));
                sourceBill.set("recbankaddress", (Object)payeebank.getString("address_eng"));
                sourceBill.set("recprovince", (Object)rowData.getString("afterrecprovince"));
                sourceBill.set("reccity", (Object)rowData.getString("afterreccity"));
                sourceBill.set("recbanknumber", (Object)rowData.getString("afterrecbanknumber"));
            }
            if (CasHelper.isNotEmpty((Object)afterinstitutioncode)) {
                sourceBill.set("institutioncode", afterinstitutioncode);
                sourceBill.set("institutionname", afterinstitutionname);
            }
        } else if (sourceType.equals("cas_agentpaybill")) {
            PayInfoChgHelper.reWriteAgtEntryInfo((DynamicObject)sourceBill, (DynamicObjectCollection)chgBillEntrys);
        }
    }

    public OperationResult doSignOperation(List<Object> idList, OperateOption option) {
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            OperationResult signResult;
            String payEntityName = this.sourceType;
            OperationResult operationResult = signResult = OperateServiceHelper.execOperateWithoutThrow((String)"paychgconfirm", (String)payEntityName, (Object[])idList.toArray(), (OperateOption)option);
            return operationResult;
        }
        catch (Exception e) {
            try {
                txHandle.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void doSignOperateSuccess(List<Object> successIdList) {
        ArrayList<DynamicObject> successPayChgBillList = new ArrayList<DynamicObject>();
        for (Object payBillid : successIdList) {
            for (DynamicObject payChgBill : this.payChgBillList) {
                if (payChgBill.getLong("sourcebillid") != ((Long)payBillid).longValue()) continue;
                successPayChgBillList.add(payChgBill);
            }
        }
        for (DynamicObject payChgBill : successPayChgBillList) {
            payChgBill.set("iscashconfirm", (Object)"1");
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])successPayChgBillList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                handle.markRollback();
                throw e;
            }
        }
    }

    public void doSignOperateFailed(Exception e) {
        ArrayList<DynamicObject> payBillList = new ArrayList<DynamicObject>(this.payChgBillList.size());
        for (DynamicObject chgBill : this.payChgBillList) {
            String sourceName;
            if (!BillStatusEnum.AUDIT.getValue().equals(chgBill.getString("billstatus"))) {
                this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u3010%s\u3011:\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u786e\u8ba4\u3002", (String)"PayChgReviewExecutor_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), chgBill.getString("billno"))).append('\n');
                continue;
            }
            if (chgBill.getBoolean("iscashconfirm")) {
                this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u3010%s\u3011:\u5df2\u786e\u8ba4\uff0c\u65e0\u9700\u91cd\u590d\u786e\u8ba4\u3002", (String)"PayChgReviewExecutor_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), chgBill.getString("billno"))).append('\n');
                continue;
            }
            String sourceType = chgBill.getString("sourcetype");
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)chgBill.getLong("sourcebillid"), (String)sourceType);
            String billStatus = sourceBill.getString("billstatus");
            if (!(SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(sourceType) || SourceBillTypeEnum.PAYBILL.getValue().equals(sourceType) || BillStatusEnum.AUDIT.getValue().equals(billStatus))) {
                sourceName = SourceBillTypeEnum.getName((String)sourceType);
                this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u201c%1$s\u201d\uff1a\u5173\u8054\u7684%2$s\u201c%3$s\u201d\u53ea\u6709\u5df2\u5ba1\u6838\u624d\u80fd\u8fdb\u884c\u652f\u4ed8\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PayChgReviewExecutor_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), chgBill.getString("billno"), sourceName, sourceBill.getString("billno"))).append('\n');
                continue;
            }
            if (SourceBillTypeEnum.PAYBILL.getValue().equals(sourceType)) {
                sourceName = SourceBillTypeEnum.getName((String)sourceType);
                Long orgId = sourceBill.getDynamicObject("org").getLong("id");
                Set cs195 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs195");
                if (!cs195.contains(billStatus)) {
                    this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u3010%1$s\u3011\uff1a\u5173\u8054\u7684%2$s\u3010%3$s\u3011\u53ea\u6709\u5728\u7cfb\u7edf\u53c2\u6570\u5141\u8bb8\u53d1\u8d77\u53d8\u66f4\u7684\u5355\u636e\u72b6\u6001\u624d\u80fd\u8fdb\u884c\u652f\u4ed8\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PayChgReviewExecutor_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), chgBill.getString("billno"), sourceName, sourceBill.getString("billno"))).append('\n');
                    continue;
                }
            }
            DynamicObjectCollection chgBillEntrys = chgBill.getDynamicObjectCollection("entrys");
            DynamicObject rowData = (DynamicObject)chgBillEntrys.get(0);
            if (!sourceType.equals("cas_paybill")) continue;
            if ("paychg".equals(chgBill.getString("chgtype"))) {
                Object settletype = rowData.get("settletype");
                Object settletnumber = rowData.get("settletnumber");
                DynamicObject payeracctbank = rowData.getDynamicObject("payeracctbank");
                DynamicObject payerbank = rowData.getDynamicObject("payerbank");
                Object usage = rowData.get("usage");
                Object paychannel = rowData.get("paychannel");
                Object bizdate = rowData.get("bizdate");
                sourceBill.set("paymentchannel", paychannel);
                sourceBill.set("settletype", settletype);
                sourceBill.set("settletnumber", settletnumber);
                sourceBill.set("payeracctbank", CasHelper.isEmpty((Object)payeracctbank) ? null : payeracctbank.getPkValue());
                sourceBill.set("payerbank", CasHelper.isEmpty((Object)payerbank) ? null : payerbank.getPkValue());
                sourceBill.set("usage", usage);
                sourceBill.set("bizdate", bizdate);
            } else {
                Object recername = rowData.get("recername");
                Object recacctbank = rowData.get("recacctbank");
                DynamicObject recerbank = rowData.getDynamicObject("recerbank");
                Object usage = rowData.get("usage");
                sourceBill.set("recaccbankname", recername);
                sourceBill.set("payeebanknum", recacctbank);
                sourceBill.set("payeebank", CasHelper.isEmpty((Object)recerbank) ? null : recerbank.getPkValue());
                sourceBill.set("payeebankname", CasHelper.isEmpty((Object)recerbank) ? null : recerbank.get("name"));
                sourceBill.set("usage", usage);
            }
            payBillList.add(sourceBill);
        }
        SaveServiceHelper.save((DynamicObject[])payBillList.toArray(new DynamicObject[0]));
    }

    public String getId() {
        return "review";
    }

    public String getErrorMessage() {
        if (this.errorMessage.length() > 0) {
            return this.errorMessage.substring(0, this.errorMessage.length() - 1);
        }
        return null;
    }
}

