/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.task;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.schedule.BankJournalDownloadSchedule;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class BankJournalDownTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BankJournalDownTask.class);
    private static final String ACCOUNT_BANK = "bankaccountnumber";
    private static final String ACCOUNT_BANK_ID = "id";
    private static final int INIT_CAPACITY = 100;
    private static final String EXECUTE_PERIOD = "schedule_cycle";
    private static final String EXECUTE_PERIOD_ZERO = "0";
    private static final String IS_BANK_INTERFACE = "issetbankinterface";
    private static final String BANK_INTERFACE = "1";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String accountBank = (String)map.get(ACCOUNT_BANK);
        JSONObject jsonObject = JSONObject.parseObject((String)accountBank);
        Long accountBankId = jsonObject.getLong(ACCOUNT_BANK_ID);
        List<Long> accountBankIds = new ArrayList<Long>(100);
        String executePeriod = (String)map.get(EXECUTE_PERIOD);
        if (StringUtils.isEmpty((String)executePeriod)) {
            executePeriod = EXECUTE_PERIOD_ZERO;
        }
        logger.info(String.format("BankJournalDownTask::Receive the parameters from schedule requests: accountBank:%s, executePeriod:%s", accountBank, executePeriod));
        if (accountBankId == null) {
            QFilter filter = new QFilter("acctstatus", "=", (Object)"normal");
            DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"am_acctbank_schedule", (String)ACCOUNT_BANK_ID, (QFilter[])new QFilter[]{filter});
            if (accountBanks.length == 0) {
                logger.info("BankJournalDownTask::There is no account in the schedule of bank!!!!");
                return;
            }
            accountBankIds = Arrays.stream(accountBanks).filter(d -> EmptyUtil.isNoEmpty((Object)d.get(ACCOUNT_BANK_ID))).map(ab -> {
                Long bankId = ab.getLong(ACCOUNT_BANK_ID);
                return bankId;
            }).collect(Collectors.toList());
            logger.info(String.format("BankJournalDownTask::Searched account bank ids which size is: %s", accountBankIds.size()));
        } else {
            accountBankIds.add(accountBankId);
        }
        try {
            BankJournalDownloadSchedule.getInstance().download(accountBankIds, Integer.parseInt(executePeriod));
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
    }
}

