/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.business.balancemodel.calculate.service.CalculateBalanceServiceService;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.helper.ExtendConfigHelper;

public class CalculateBalanceTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(CalculateBalanceTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean useBalanceModel = ExtendConfigHelper.useBalanceModel();
        if (!useBalanceModel) {
            return;
        }
        try {
            logger.info("begin calculating balance\u3002\u3002\u3002\u3002\u3002\u3002");
            CalculateBalanceServiceService calculateBalanceService = CalculateBalanceServiceService.getInstance();
            try (TXHandle tx = TX.required();){
                try {
                    calculateBalanceService.doInitOrAntiInit();
                    tx.commit();
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("error:", (Throwable)e);
                    throw e;
                }
            }
            ThreadPools.executeOnceIncludeRequestContext((String)"calculateCashBalanceTask", () -> {
                try {
                    calculateBalanceService.calculateLog(BalanceType.CASH.getValue());
                }
                catch (Exception e) {
                    logger.error("calculateCashBalanceTask tranceId:{} error:{}", (Object)RequestContext.get().getTraceId(), (Object)e);
                }
            });
            ThreadPools.executeOnceIncludeRequestContext((String)"calculateJouranlBalanceTask", () -> {
                try {
                    calculateBalanceService.calculateLog(BalanceType.JOURNAL.getValue());
                }
                catch (Exception e) {
                    logger.error("calculateJouranlBalanceTask tranceId:{} error:{}", (Object)RequestContext.get().getTraceId(), (Object)e);
                }
            });
            ThreadPools.executeOnceIncludeRequestContext((String)"calculateStateBalanceTask", () -> {
                try {
                    calculateBalanceService.calculateLog(BalanceType.STATE.getValue());
                }
                catch (Exception e) {
                    logger.error("calculateStateBalanceTask tranceId:{} error:{}", (Object)RequestContext.get().getTraceId(), (Object)e);
                }
            });
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
            ErrorCode ec = new ErrorCode("CalculateBalance", ResManager.loadKDString((String)"\u5904\u7406\u4f59\u989d\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38!", (String)"CalculateBalanceTask_0", (String)"fi-cas-business", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
    }
}

