/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.task;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.Pair;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class CasAutoMatchTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(CasAutoMatchTask.class);
    private static final String OPERATE_KEY = "autocheck";
    private static final String ORG = "org";
    private static final String ACCOUNTBANK = "accountbank";
    private static final String CURRENCY = "currency";
    private static final String BANKCGSETTING = "bankcgsetting";
    private static final String ID = "id";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        block3: {
            logger.info("\u6267\u884c\u8c03\u5ea6\u4efb\u52a1\u7c7b -- CasAutoMatchTask");
            Map<String, Pair<String, String>> initParamMap = this.initParamMap();
            QFilter qFilter = this.initCustomFilter(map, initParamMap);
            DynamicObjectCollection bankvcchecks = QueryServiceHelper.query((String)"cas_bankvccheck", (String)ID, (QFilter[])qFilter.toArray());
            if (bankvcchecks.size() == 0) {
                return;
            }
            Object[] bankvccheckIds = bankvcchecks.stream().map(dynamicObject -> dynamicObject.getLong(ID)).toArray();
            logger.info("\u5c06\u8981\u6267\u884c\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u5355\u8bb0\u5f55\u6570\u4e3a\uff1a", (Object)bankvccheckIds.length);
            OperateOption operateOption = OperateOption.create();
            OperationResult result = null;
            try {
                result = OperateServiceHelper.execOperateWithoutThrow((String)OPERATE_KEY, (String)"cas_bankvccheck", (Object[])bankvccheckIds, (OperateOption)operateOption);
                this.buildLog(result);
            }
            catch (Exception e) {
                String s = ResManager.loadKDString((String)"\u6682\u65e0\u672a\u5339\u914d\u7684\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u5355\u3002", (String)"CasAutoMatchTask_0", (String)"fi-cas-business", (Object[])new Object[0]);
                logger.error("\u6267\u884c\u8c03\u5ea6\u4efb\u52a1\u7c7b\u7684\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
                if (s.equals(e.getMessage().trim())) break block3;
                throw e;
            }
        }
    }

    private Map<String, Pair<String, String>> initParamMap() {
        HashMap<String, Pair<String, String>> initParamMap = new HashMap<String, Pair<String, String>>();
        initParamMap.put(ORG, new Pair((Object)"bos_org", (Object)"number"));
        initParamMap.put(ACCOUNTBANK, new Pair((Object)"bd_accountbanks", (Object)"bankaccountnumber"));
        initParamMap.put(CURRENCY, new Pair((Object)"bd_currency", (Object)"number"));
        initParamMap.put(BANKCGSETTING, new Pair((Object)"bd_bankcgsetting", (Object)"number"));
        return initParamMap;
    }

    private QFilter initCustomFilter(Map<String, Object> map, Map<String, Pair<String, String>> initParamMap) {
        QFilter qFilter = new QFilter("verifystatus", "=", (Object)"1");
        if (EmptyUtil.isNoEmpty(map)) {
            map.forEach((fieldName, fieldValue) -> {
                if (EmptyUtil.isNoEmpty((Object)fieldValue)) {
                    Object value = fieldValue;
                    if (initParamMap.containsKey(fieldName)) {
                        if (value.toString().contains(ID)) {
                            Map valueMap = (Map)JSON.parseObject((String)((String)fieldValue), Map.class);
                            if (EmptyUtil.isNoEmpty(valueMap.get(ID))) {
                                value = valueMap.get(ID);
                            }
                        } else {
                            Pair paramInfoPair = (Pair)initParamMap.get(fieldName);
                            QFilter queryIdFilter = new QFilter((String)paramInfoPair.getValue(), "=", fieldValue);
                            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)((String)paramInfoPair.getKey()), (String)ID, (QFilter[])queryIdFilter.toArray());
                            if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObject) && EmptyUtil.isNoEmpty((Long)dynamicObject.getLong(ID))) {
                                value = dynamicObject.getLong(ID);
                            }
                        }
                    }
                    qFilter.and(fieldName, "=", value);
                }
            });
        }
        return qFilter;
    }

    private void buildLog(OperationResult result) {
        logger.info("\u64cd\u4f5c\u540d\u79f0\uff1aautocheck");
        logger.info("\u6210\u529f\u6761\u6570" + result.getSuccessPkIds().size());
        logger.info("\u6821\u9a8c\u4fe1\u606f" + result.getValidateResult().getMessage());
        logger.info("\u603b\u4fe1\u606f" + result.getMessage());
        logger.info("\u603b\u4fe1\u606f" + result.getSponsor());
    }
}

