/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;

public class DiffPayHisDataUpService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(DiffPayHisDataUpService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u5f02\u5e01\u79cd\u652f\u4ed8\u5386\u53f2\u6570\u636e\u5347\u7ea7\u3002", (String)"DiffPayHisDataUpService_0", (String)"fi-cas-business", (Object[])new Object[0]));
            ThreadPools.executeOnce((String)DiffPayHisDataUpService.class.getName(), (Runnable)new PaybillDataUp());
            result.setLog(ResManager.loadKDString((String)"\u5f02\u5e01\u79cd\u652f\u4ed8\u5386\u53f2\u6570\u636e\u5df2\u5347\u7ea7\u5b8c\u6210\u3002", (String)"DiffPayHisDataUpService_1", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    static class PaybillDataUp
    implements Runnable {
        PaybillDataUp() {
        }

        @Override
        public void run() {
            this.payBillUp();
            this.agentBillUp();
        }

        private void payBillUp() {
            try {
                DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)String.join((CharSequence)",", "isdiffcur", "dpcurrency", "dpexchangerate", "dpamt", "dplocalamt", "agreedrate", "currency", "exchangerate", "actpayamt", "localamt", "dpexratetable", "dpexratedate", "exratetable", "exratedate"), (QFilter[])new QFilter[]{new QFilter("isdiffcur", "!=", (Object)"1")});
                if (payBills == null || payBills.length == 0) {
                    return;
                }
                ArrayList<DynamicObject> upBills = new ArrayList<DynamicObject>(payBills.length);
                for (DynamicObject payBill : payBills) {
                    DynamicObject upBill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
                    upBill.set("id", payBill.getPkValue());
                    upBill.set("isdiffcur", (Object)"0");
                    upBill.set("agreedrate", (Object)BigDecimal.ONE);
                    DynamicObject currency = payBill.getDynamicObject("currency");
                    if (currency != null) {
                        upBill.set("dpcurrency", currency.getPkValue());
                    }
                    upBill.set("dpexchangerate", (Object)payBill.getBigDecimal("exchangerate"));
                    upBill.set("dpamt", (Object)payBill.getBigDecimal("actpayamt"));
                    upBill.set("dplocalamt", (Object)payBill.getBigDecimal("localamt"));
                    DynamicObject exratetable = payBill.getDynamicObject("exratetable");
                    if (exratetable != null) {
                        upBill.set("dpexratetable", exratetable.getPkValue());
                    }
                    upBill.set("dpexratedate", (Object)payBill.getDate("exratedate"));
                    upBills.add(upBill);
                    if (upBills.size() % 5000 != 0) continue;
                    SaveServiceHelper.update((DynamicObject[])upBills.toArray(new DynamicObject[upBills.size()]));
                    upBills.clear();
                }
                if (upBills.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])upBills.toArray(new DynamicObject[upBills.size()]));
                }
            }
            catch (Exception e) {
                logger.info("PaybillDataUp payBillUp error : " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }

        private void agentBillUp() {
            try {
                DynamicObject[] agentBills = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)String.join((CharSequence)",", "isdiffcur", "dpcurrency", "dpexchangerate", "dpamt", "dplocalamt", "agreedrate", "currency", "exchangerate", "actpayamount", "localamt"), (QFilter[])new QFilter[]{new QFilter("isdiffcur", "!=", (Object)"1")});
                if (agentBills == null || agentBills.length == 0) {
                    return;
                }
                ArrayList<DynamicObject> upBills = new ArrayList<DynamicObject>(agentBills.length);
                for (DynamicObject agentBill : agentBills) {
                    DynamicObject upBill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_agentpaybill"));
                    upBill.set("id", agentBill.getPkValue());
                    upBill.set("isdiffcur", (Object)"0");
                    upBill.set("agreedrate", (Object)BigDecimal.ONE);
                    DynamicObject currency = agentBill.getDynamicObject("currency");
                    if (currency != null) {
                        upBill.set("dpcurrency", currency.getPkValue());
                    }
                    upBill.set("dpexchangerate", (Object)agentBill.getBigDecimal("exchangerate"));
                    upBill.set("dpamt", (Object)agentBill.getBigDecimal("actpayamount"));
                    upBill.set("dplocalamt", (Object)agentBill.getBigDecimal("localamt"));
                    upBills.add(upBill);
                    if (upBills.size() % 5000 != 0) continue;
                    SaveServiceHelper.update((DynamicObject[])upBills.toArray(new DynamicObject[upBills.size()]));
                    upBills.clear();
                }
                if (upBills.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])upBills.toArray(new DynamicObject[upBills.size()]));
                }
            }
            catch (Exception e) {
                logger.info("PaybillDataUp agentBillUp error : " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }
}

