/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.task.check;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.task.check.IFiDataCheckTask;
import kd.fi.cas.business.task.check.PayBillDataCheck;
import kd.fi.cas.business.util.FiDataCheckUtil;
import kd.fi.cas.util.EmptyUtil;

public class AgentpayBillDataCheckTask
implements IFiDataCheckTask {
    private static final Log logger = LogFactory.getLog(PayBillDataCheck.class);

    @Override
    public boolean execute() {
        if (FiDataCheckUtil.isStop()) {
            return false;
        }
        String msg = ResManager.loadKDString((String)"\u51fa\u7eb3\u4ee3\u53d1\u5355\u6570\u636e\u4e00\u81f4\u6027\u68c0\u67e5", (String)"AgentpayBillDataCheck_0", (String)"fi-cas-business", (Object[])new Object[0]);
        FiDataCheckUtil.saveResult("cas_agentpaybilldata_check", "cas", false, msg, "kd.fi.cas.business.task.check.AgentpayBillDataCheckTask");
        AgentpayBillDataCheckTask.checkAgentPayBill();
        AgentpayBillDataCheckTask.checkDownStreamBill();
        return true;
    }

    private static void checkAgentPayBill() {
        String msg;
        String billStr;
        QFilter[] beiFilter = new QFilter[]{new QFilter("sourcebillid", "is not null", null)};
        DynamicObject[] beiBills = BusinessDataServiceHelper.load((String)"bei_bankagentpay", (String)"id,billno,paystate,sourcebillid", (QFilter[])beiFilter, (String)"id desc", (int)-1);
        List lists = Lists.partition(Arrays.asList(beiBills), (int)5000);
        HashSet<String> noSrcbillList = new HashSet<String>();
        HashSet<String> errStatusList = new HashSet<String>();
        for (List subList : lists) {
            Set sourcerIds = subList.parallelStream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("sourcebillid"))).map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
            DynamicObject[] casPaybills = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"id,bankagentpaystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", sourcerIds)});
            Map<Long, String> casPayStatusMap = ((Stream)Arrays.stream(casPaybills).parallel()).collect(Collectors.toMap(d -> d.getLong("id"), d -> d.getString("billstatus")));
            Set<Long> casIds = casPayStatusMap.keySet();
            for (DynamicObject beiPayBill : subList) {
                String billno = beiPayBill.getString("billno");
                long sourcebillid = beiPayBill.getLong("sourcebillid");
                String bankpaystatus = beiPayBill.getString("bankpaystatus");
                if (!casIds.contains(sourcebillid)) {
                    logger.info("checkAgentPayBill(),current billno=[{}], it's sourcebillid[{}] not exist\u2026\u2026", (Object)billno, (Object)sourcebillid);
                    noSrcbillList.add(billno);
                    continue;
                }
                String casBillStatus = casPayStatusMap.get(sourcebillid);
                if (!"TS".equals(bankpaystatus) || "TS".equals(casBillStatus)) continue;
                errStatusList.add(billno);
            }
        }
        if (EmptyUtil.isNoEmpty(noSrcbillList)) {
            billStr = noSrcbillList.parallelStream().collect(Collectors.joining(","));
            msg = String.format(ResManager.loadKDString((String)"\u51fa\u7eb3\u4ee3\u53d1\u5355\u6570\u636e\u4e00\u81f4\u6027\u68c0\u67e5\u5931\u8d25\uff0c\u94f6\u884c\u4ee3\u53d1\u5355\u201c%s\u201d\u5bf9\u5e94\u7684\u4ee3\u53d1\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AgentpayBillDataCheck_1", (String)"fi-cas-business", (Object[])new Object[0]), billStr);
            FiDataCheckUtil.saveResult("cas_agentpaybilldata_check", "cas", false, msg, "kd.fi.cas.business.task.check.AgentpayBillDataCheckTask");
        }
        if (EmptyUtil.isNoEmpty(errStatusList)) {
            billStr = errStatusList.parallelStream().collect(Collectors.joining(","));
            msg = String.format(ResManager.loadKDString((String)"\u51fa\u7eb3\u4ee3\u53d1\u5355\u6570\u636e\u4e00\u81f4\u6027\u68c0\u67e5\u5931\u8d25\uff0c\u94f6\u884c\u4ee3\u53d1\u5355\u201c%s\u201d\u4e0e\u5bf9\u5e94\u7684\u4ee3\u53d1\u5355\u72b6\u6001\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AgentpayBillDataCheck_3", (String)"fi-cas-business", (Object[])new Object[0]), billStr);
            FiDataCheckUtil.saveResult("cas_agentpaybilldata_check", "cas", false, msg, "kd.fi.cas.business.task.check.AgentpayBillDataCheckTask");
        }
    }

    private static void checkDownStreamBill() {
        QFilter[] casFilter = new QFilter[]{new QFilter("bankagentpaystatus", "=", (Object)"OS")};
        DynamicObject[] casPayBills = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"id,billno", (QFilter[])casFilter, (String)"id desc", (int)-1);
        List lists = Lists.partition(Arrays.asList(casPayBills), (int)1000);
        HashSet<String> noDownstreamBillNos = new HashSet<String>();
        for (List subList : lists) {
            Set sourceIds = subList.parallelStream().map(d -> d.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] bankApbills = BusinessDataServiceHelper.load((String)"bei_bankagentpay", (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", sourceIds)});
            Set existSrcIds = Arrays.stream(bankApbills).map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
            for (DynamicObject data : subList) {
                if (!existSrcIds.contains(data.getLong("id"))) continue;
                String billno = data.getString("billno");
                noDownstreamBillNos.add(billno);
                logger.info("checkDownStreamBill(),current billno=[{}] downstream bill not exist\u2026\u2026", (Object)billno);
            }
        }
        if (EmptyUtil.isNoEmpty(noDownstreamBillNos)) {
            String billStr = noDownstreamBillNos.parallelStream().collect(Collectors.joining(","));
            String msg = String.format(ResManager.loadKDString((String)"\u51fa\u7eb3\u4ee3\u53d1\u5355\u6570\u636e\u4e00\u81f4\u6027\u68c0\u67e5\u5931\u8d25\uff0c\u4ee3\u53d1\u5355\u201c%s\u201d\u5bf9\u5e94\u7684\u94f6\u884c\u4ee3\u53d1\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AgentpayBillDataCheck_2", (String)"fi-cas-business", (Object[])new Object[0]), billStr);
            FiDataCheckUtil.saveResult("cas_agentpaybilldata_check", "cas", false, msg, "kd.fi.cas.business.task.check.AgentpayBillDataCheckTask");
        }
    }
}

