/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.data.collect.model.DataCollect;
import kd.bos.data.collect.service.DataCollectServiceHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cas.util.EmptyUtil;

public class FiDataCheckUtil {
    private static final String BD_DATACHECKTASK = "bd_datachecktask";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String PLUGIN = "plugin";
    private static final String CLOUDID = "cloudid";
    private static final String APPID = "appid";
    private static final String PHONE = "phone";
    private static final String BD_DATACHECKRECORD = "bd_datacheckrecord";
    private static final String TASKNO = "datachecktaskno";
    private static final String ISPASS = "ispass";
    private static final String CHECKRESULT = "checkresult";
    private static Log logger = LogFactory.getLog(FiDataCheckUtil.class);

    public static boolean isStop() {
        Date date;
        int nowHour;
        int time = 5;
        HashMap<String, Object> map = FiDataCheckUtil.getParameters();
        if (!map.isEmpty() && StringUtils.isNotBlank((Object)map.get("stoptime"))) {
            time = (Integer)map.get("stoptime");
        }
        return (nowHour = (date = new Date()).getHours()) >= time;
    }

    public static void saveResult(String taskId, String appid, boolean isPass, String checkResult, String plugin) {
        if (!isPass) {
            String phone = null;
            DynamicObject taskObject = FiDataCheckUtil.getTask(taskId);
            if (taskObject != null && StringUtils.isNotBlank((CharSequence)taskObject.getString(PHONE))) {
                phone = taskObject.getString(PHONE);
            } else {
                HashMap<String, Object> map = FiDataCheckUtil.getParameters();
                if (!map.isEmpty() && StringUtils.isNotBlank((Object)map.get(PHONE))) {
                    phone = (String)map.get(PHONE);
                }
            }
            if (StringUtils.isNotBlank(phone) && !"FIDataCheckScheduleTask start".equals(checkResult) && !"FIDataCheckScheduleTask end".equals(checkResult)) {
                FiDataCheckUtil.notice(null, null, phone, checkResult);
                FiDataCheckUtil.writeLog(taskId, appid, checkResult, plugin);
            }
        }
        DynamicObject[] object = new DynamicObject[1];
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)BD_DATACHECKRECORD);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainEntityType);
        dynamicObject.set(TASKNO, (Object)taskId);
        dynamicObject.set(APPID, (Object)appid);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set(ISPASS, (Object)(isPass ? "1" : "0"));
        if (StringUtils.isNotBlank((CharSequence)checkResult)) {
            if (checkResult.length() <= 255) {
                dynamicObject.set("checkresult_tag", (Object)checkResult);
                dynamicObject.set(CHECKRESULT, (Object)checkResult);
            } else {
                dynamicObject.set("checkresult_tag", (Object)checkResult);
                dynamicObject.set(CHECKRESULT, (Object)checkResult.substring(0, 255));
            }
        }
        object[0] = dynamicObject;
        SaveServiceHelper.save((DynamicObject[])object);
        DataCollect data = new DataCollect();
        data.setFormId(BD_DATACHECKTASK);
        data.setProjectId("cosmic");
        data.setStoreId("server_beacon");
        data.setEventName("fi_datacheck");
        data.setCreatTime(new Date());
        HashMap<String, String> cusMap = new HashMap<String, String>(1);
        cusMap.put(TASKNO, taskId);
        DynamicObject taskObject = FiDataCheckUtil.getTask(taskId);
        if (taskObject != null) {
            cusMap.put("datachecktaskname", taskObject.getString(NAME));
        }
        cusMap.put(CHECKRESULT, checkResult);
        cusMap.put(ISPASS, isPass ? "1" : "0");
        cusMap.put(APPID, appid);
        data.setCusData(cusMap);
        if (!"FIDataCheckScheduleTask start".equals(checkResult) && !"FIDataCheckScheduleTask end".equals(checkResult)) {
            DataCollectServiceHelper.addData((DataCollect)data, null);
        }
    }

    public static void notice(String eid, String openid, String phone, String checkResult) {
        DynamicObject object = null;
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            QFilter phonefilter = new QFilter(PHONE, "=", (Object)phone);
            object = QueryServiceHelper.queryOne((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{phonefilter});
        }
        if (object != null) {
            try {
                FiDataCheckUtil.sendSmsMsg(checkResult, object.getLong("id"), "yunzhijia");
                FiDataCheckUtil.sendSmsMsg(checkResult, object.getLong("id"), "sms");
            }
            catch (Exception e) {
                logger.error("FiDataCheckUtil, notice() exception:", (Throwable)e);
            }
        }
    }

    public static void writeLog(String taskId, String appid, String checkResult, String plugin) {
        StringBuilder builder = new StringBuilder();
        builder.append("datacheckfailed:");
        builder.append(checkResult);
        builder.append("\n");
        builder.append("taskId:");
        builder.append(taskId);
        builder.append("\n");
        builder.append("appid:");
        builder.append(appid);
        builder.append("\n");
        builder.append("plugin:");
        builder.append(plugin);
        builder.append("\n");
        logger.error(builder.toString());
    }

    public static List<DynamicObject> sortTask() {
        DynamicObjectCollection list = new ArrayList(16);
        DynamicObject lastRecond = FiDataCheckUtil.getLastRecond();
        DynamicObject lastTask = FiDataCheckUtil.getLastTask();
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        if (lastRecond != null && lastTask != null && StringUtils.isNotBlank((CharSequence)lastRecond.getString(TASKNO)) && StringUtils.isNotBlank((CharSequence)lastTask.getString(NUMBER)) && !lastRecond.getString(TASKNO).equals(lastTask.getString(NUMBER))) {
            QFilter largeNumFilter = new QFilter(NUMBER, ">", (Object)lastRecond.getString(TASKNO));
            QFilter lessEqNumFilter = new QFilter(NUMBER, "<=", (Object)lastRecond.getString(TASKNO));
            DynamicObjectCollection list1 = QueryServiceHelper.query((String)BD_DATACHECKTASK, (String)"number,appid,plugin,name,cloudid", (QFilter[])new QFilter[]{largeNumFilter, statusFilter}, (String)NUMBER);
            DynamicObjectCollection list2 = QueryServiceHelper.query((String)BD_DATACHECKTASK, (String)"number,appid,plugin,name,cloudid", (QFilter[])new QFilter[]{lessEqNumFilter, statusFilter}, (String)NUMBER);
            list.addAll(list1);
            list.addAll(list2);
        } else {
            list = QueryServiceHelper.query((String)BD_DATACHECKTASK, (String)"number,appid,plugin,name,cloudid", (QFilter[])new QFilter[]{statusFilter}, (String)NUMBER);
        }
        return list;
    }

    private static DynamicObject getLastRecond() {
        DynamicObjectCollection list = QueryServiceHelper.query((String)BD_DATACHECKRECORD, (String)TASKNO, null, (String)" createtime desc", (int)1);
        if (EmptyUtil.isNoEmpty((Object)list)) {
            return (DynamicObject)list.get(0);
        }
        return null;
    }

    private static DynamicObject getLastTask() {
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection list = QueryServiceHelper.query((String)BD_DATACHECKTASK, (String)NUMBER, (QFilter[])new QFilter[]{statusFilter}, (String)"number desc", (int)1);
        if (!list.isEmpty() && list.size() > 0) {
            return (DynamicObject)list.get(0);
        }
        return null;
    }

    private static HashMap<String, Object> getParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bd_checkdata_parameter", (String)"phone,stoptime", null, (String)"modifydate desc", (int)1);
        if (!collections.isEmpty()) {
            DynamicObject object = (DynamicObject)collections.get(0);
            map.put(PHONE, object.get(PHONE));
            map.put("stoptime", object.get("stoptime"));
        }
        return map;
    }

    private static void sendSmsMsg(String result, Long userId, String type) {
        MessageInfo info = new MessageInfo();
        info.setTitle(ResManager.loadKDString((String)"\u6570\u636e\u68c0\u67e5\u6709\u95ee\u9898", (String)"FIDataCheckUtil_1", (String)"bos-ext-fi", (Object[])new Object[0]));
        StringBuilder sb = new StringBuilder();
        sb.append(result);
        info.setContent(sb.toString());
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        info.setUserIds(userIds);
        info.setType("message");
        LocaleString messageTag = new LocaleString();
        messageTag.setLocaleValue_en("bec");
        messageTag.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u7d27\u6025", (String)"FIDataCheckUtil_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        info.setMessageTag((ILocaleString)messageTag);
        info.setNotifyType(type);
        MessageCenterServiceHelper.sendMessage((MessageInfo)info);
    }

    private static DynamicObject getTask(String number) {
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)number);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection list = QueryServiceHelper.query((String)BD_DATACHECKTASK, (String)"name,phone", (QFilter[])new QFilter[]{numberFilter, statusFilter});
        if (!list.isEmpty() && list.size() > 0) {
            return (DynamicObject)list.get(0);
        }
        return null;
    }
}

