/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.business.writeback.WriteBackConfigInvoker;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.task.WriteBackTask;
import kd.fi.cas.helper.AgentPayBillHelper;

public class AgentWriteBackConsumer
extends WriteBackConfigInvoker {
    @Override
    protected Object[] getInvokeParams(WriteBackTask task) {
        HashMap<String, Object> disposeParam = new HashMap<String, Object>();
        DynamicObject agentPayBill = AgentPayBillHelper.getById((long)Long.parseLong(task.getBillPk().toString()));
        Map<String, Object> customParams = task.getCustomParams();
        if (customParams != null) {
            List entryPks = (List)customParams.get("entryPks");
            Map refundAInfoMap = (Map)customParams.get("refundAInfoMap");
            if (entryPks != null) {
                DynamicObjectCollection entry = agentPayBill.getDynamicObjectCollection("entry");
                Iterator iterator = entry.iterator();
                while (iterator.hasNext()) {
                    DynamicObject row = (DynamicObject)iterator.next();
                    if (!entryPks.contains(row.getLong("id"))) {
                        iterator.remove();
                        continue;
                    }
                    if (refundAInfoMap == null || refundAInfoMap.size() <= 0) continue;
                    for (Map.Entry etr : refundAInfoMap.entrySet()) {
                        row.set((String)etr.getKey(), etr.getValue());
                    }
                }
            }
            Object billInfo = customParams.get("info");
            if ((WriteBackOperateEnum.SAVEVALIDATE == task.getOperation() || WriteBackOperateEnum.SUBMITVALIDATE == task.getOperation() || agentPayBill == null) && billInfo instanceof DynamicObject) {
                agentPayBill = (DynamicObject)billInfo;
                AgentPayBillHelper.decodeAmount((DynamicObject)agentPayBill);
            }
        }
        if (WriteBackOperateEnum.PAYVALIDATE == task.getOperation() || WriteBackOperateEnum.CANCELPAYVALIDATE == task.getOperation()) {
            DynamicObjectCollection entry = agentPayBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                row.set("e_issuccess", (Object)(WriteBackOperateEnum.PAYVALIDATE == task.getOperation() ? 1 : 0));
            }
        }
        disposeParam.put("info", new Object[]{agentPayBill});
        disposeParam.put("operate", task.getOperation().getValue());
        return new Object[]{disposeParam};
    }

    @Override
    protected Object[] getInvokeParamsList(List<WriteBackTask> taskList) {
        List billPks = taskList.stream().map(o -> o.getBillPk()).collect(Collectors.toList());
        DynamicObject[] agentPayBills = AgentPayBillHelper.load((String)"id,entry,entry.e_issuccess,entry.e_isrefund,entry.e_refundamt", (QFilter[])new QFilter[]{new QFilter("id", "in", billPks)});
        Map agentPayMap = Arrays.stream(agentPayBills).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        ArrayList dispostData = new ArrayList(10);
        for (WriteBackTask task : taskList) {
            HashMap<String, Object> disposeParam = new HashMap<String, Object>();
            DynamicObject agentPayBill = (DynamicObject)agentPayMap.get(task.getBillPk());
            Map<String, Object> customParams = task.getCustomParams();
            if (customParams != null) {
                List entryPks = (List)customParams.get("entryPks");
                Map refundAInfoMap = (Map)customParams.get("refundAInfoMap");
                if (entryPks != null) {
                    DynamicObjectCollection entry = agentPayBill.getDynamicObjectCollection("entry");
                    Iterator iterator = entry.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject row = (DynamicObject)iterator.next();
                        if (!entryPks.contains(row.getLong("id"))) {
                            iterator.remove();
                            continue;
                        }
                        if (refundAInfoMap == null || refundAInfoMap.size() <= 0) continue;
                        for (Map.Entry etr : refundAInfoMap.entrySet()) {
                            row.set((String)etr.getKey(), etr.getValue());
                        }
                    }
                }
            }
            if (WriteBackOperateEnum.PAYVALIDATE == task.getOperation() || WriteBackOperateEnum.CANCELPAYVALIDATE == task.getOperation()) {
                DynamicObjectCollection entry = agentPayBill.getDynamicObjectCollection("entry");
                for (DynamicObject row : entry) {
                    row.set("e_issuccess", (Object)(WriteBackOperateEnum.PAYVALIDATE == task.getOperation() ? 1 : 0));
                }
            }
            disposeParam.put("info", new Object[]{agentPayBill});
            disposeParam.put("operate", task.getOperation().getValue());
            dispostData.add(disposeParam);
        }
        return new Object[]{dispostData};
    }
}

