/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.writeback.WriteBackConfigInvoker;
import kd.fi.cas.business.writeback.task.WriteBackTask;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentSaveOrSubmitWriteBackConsumer
extends WriteBackConfigInvoker {
    private static final Log logger = LogFactory.getLog(PaymentSaveOrSubmitWriteBackConsumer.class);

    @Override
    protected Object[] getInvokeParams(WriteBackTask task) {
        Object[] billPks = task.getBillPks();
        if (EmptyUtil.isEmpty((Object[])billPks)) {
            return PaymentSaveOrSubmitWriteBackConsumer.singleBillProcess(task);
        }
        return PaymentSaveOrSubmitWriteBackConsumer.batchBillProcess(task);
    }

    private static Object[] singleBillProcess(WriteBackTask task) {
        String operate = task.getOperation().getValue();
        ArrayList disposeData = new ArrayList(10);
        HashMap<String, Object> disposeRowInfo = new HashMap<String, Object>();
        Map<String, Object> customParams = task.getCustomParams();
        if (null != customParams) {
            Object backReason;
            Object o_info = customParams.get("info");
            if (o_info != null) {
                DynamicObject info = (DynamicObject)o_info;
                disposeRowInfo.put("info", info);
                logger.info("------\u53cd\u5199\u53c2\u6570\uff1aoperate:" + operate + ",sourceentity:" + info.getString("sourcebilltype") + "\u6e90\u5355ID:" + info.get("sourcebillid"));
            }
            if ((backReason = customParams.get("backReason")) != null) {
                disposeRowInfo.put("backReason", backReason);
            }
        }
        if (customParams != null && customParams.get("payScheRelease") != null) {
            String payScheRelease = (String)customParams.get("payScheRelease");
            disposeRowInfo.put("payScheRelease", payScheRelease);
        }
        if (customParams != null && customParams.get("isPayScheBack") != null) {
            String isPayScheBack = (String)customParams.get("isPayScheBack");
            disposeRowInfo.put("isPayScheBack", isPayScheBack);
        }
        if (customParams != null && customParams.get("payScheOPType") != null) {
            String payScheOPType = (String)customParams.get("payScheOPType");
            disposeRowInfo.put("payScheOPType", payScheOPType);
        }
        if (customParams != null && customParams.get("delPayApplyBillIds") != null) {
            disposeRowInfo.put("delPayApplyBillIds", customParams.get("delPayApplyBillIds"));
        }
        Object pk = task.getBillPk();
        disposeRowInfo.put("targetpk", pk);
        disposeRowInfo.put("targetentity", "cas_paybill");
        disposeRowInfo.put("operate", operate);
        disposeData.add(disposeRowInfo);
        logger.info("------\u53cd\u5199\u53c2\u6570\uff1aoperate:" + operate);
        return new Object[]{disposeData};
    }

    @Override
    protected Object[] getInvokeParamsList(List<WriteBackTask> task) {
        ArrayList listAll = new ArrayList(10);
        for (WriteBackTask writeBackTask : task) {
            String operate = writeBackTask.getOperation().getValue();
            ArrayList disposeData = new ArrayList(10);
            HashMap<String, Object> disposeRowInfo = new HashMap<String, Object>();
            Map<String, Object> customParams = writeBackTask.getCustomParams();
            if (null != customParams) {
                Object o_info = customParams.get("info");
                if (o_info != null) {
                    DynamicObject info = (DynamicObject)o_info;
                    disposeRowInfo.put("info", info);
                    logger.info("------\u53cd\u5199\u53c2\u6570\uff1aoperate:" + operate + ",sourceentity:" + info.getString("sourcebilltype") + "\u6e90\u5355ID:" + info.get("sourcebillid"));
                }
                if (customParams.get("payScheRelease") != null) {
                    String payScheRelease = (String)customParams.get("payScheRelease");
                    disposeRowInfo.put("payScheRelease", payScheRelease);
                }
                if (customParams.get("isPayScheBack") != null) {
                    String isPayScheBack = (String)customParams.get("isPayScheBack");
                    disposeRowInfo.put("isPayScheBack", isPayScheBack);
                }
                if (customParams.get("payScheOPType") != null) {
                    String payScheOPType = (String)customParams.get("payScheOPType");
                    disposeRowInfo.put("payScheOPType", payScheOPType);
                }
                if (customParams.get("delPayApplyBillIds") != null) {
                    String delPayApplyBillIds = (String)customParams.get("delPayApplyBillIds");
                    disposeRowInfo.put("delPayApplyBillIds", delPayApplyBillIds);
                }
            }
            Object pk = writeBackTask.getBillPk();
            disposeRowInfo.put("targetpk", pk);
            disposeRowInfo.put("targetentity", "cas_paybill");
            disposeRowInfo.put("operate", operate);
            disposeData.add(disposeRowInfo);
            listAll.addAll(disposeData);
            logger.info("------\u53cd\u5199\u53c2\u6570\uff1aoperate:" + operate);
        }
        return new Object[]{listAll};
    }

    private static Object[] batchBillProcess(WriteBackTask task) {
        Long[] billPks = task.getBillPks();
        String operate = task.getOperation().getValue();
        int size = billPks.length;
        DynamicObject[] infos = new DynamicObject[]{};
        Map<String, Object> customParams = task.getCustomParams();
        if (CasHelper.isNotEmpty(customParams) && customParams.get("infos") != null) {
            infos = (DynamicObject[])customParams.get("infos");
        }
        ArrayList disposeData = new ArrayList(10);
        for (int i = 0; i < size; ++i) {
            Object backReason;
            DynamicObject info = infos[i];
            HashMap<String, Object> disposeRowInfo = new HashMap<String, Object>();
            disposeRowInfo.put("targetpk", info.getLong("id"));
            disposeRowInfo.put("targetentity", "cas_paybill");
            disposeRowInfo.put("operate", operate);
            disposeRowInfo.put("info", info);
            if (customParams != null && customParams.get("payScheRelease") != null) {
                String payScheRelease = (String)customParams.get("payScheRelease");
                disposeRowInfo.put("payScheRelease", payScheRelease);
            }
            if (customParams != null && customParams.get("isPayScheBack") != null) {
                String isPayScheBack = (String)customParams.get("isPayScheBack");
                disposeRowInfo.put("isPayScheBack", isPayScheBack);
            }
            if (customParams != null && customParams.get("payScheOPType") != null) {
                String payScheOPType = (String)customParams.get("payScheOPType");
                disposeRowInfo.put("payScheOPType", payScheOPType);
            }
            if (customParams != null && customParams.get("delPayApplyBillIds") != null) {
                disposeRowInfo.put("delPayApplyBillIds", customParams.get("delPayApplyBillIds"));
            }
            if (customParams != null && (backReason = customParams.get("backReason")) != null) {
                disposeRowInfo.put("backReason", backReason);
            }
            logger.info("------\u53cd\u5199\u53c2\u6570\uff1aoperate:" + operate + ",sourceentity:" + info.getString("sourcebilltype") + ",\u6e90\u5355ID:" + info.get("sourcebillid"));
            disposeData.add(disposeRowInfo);
        }
        return new Object[]{disposeData};
    }
}

