/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncStatusManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackConfigInvoker;
import kd.fi.cas.business.writeback.WriteBackTaskConsumer;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.task.WriteBackTask;
import kd.fi.cas.helper.SettleRecordQueryHelperForCas;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.util.EmptyUtil;

public class WriteBackTaskHelper {
    private static final Log logger = LogFactory.getLog(WriteBackTaskHelper.class);

    public static <T extends WriteBackTaskConsumer> void addRealtimeTask(DynamicObject bill, String sourceEntity, WriteBackOperateEnum operation) {
        WriteBackTaskHelper.addRealtimeTask(bill, sourceEntity, operation, WriteBackConfigInvoker.class);
    }

    public static <T extends WriteBackTaskConsumer> Object addRealtimeTask(DynamicObject bill, String sourceEntity, WriteBackOperateEnum operation, Class<T> taskConsumer) {
        return WriteBackTaskHelper.addRealtimeTask(bill, sourceEntity, operation, taskConsumer, new HashMap<String, Object>());
    }

    public static <T extends WriteBackTaskConsumer> Object addRealtimeTask(DynamicObject bill, String sourceEntity, WriteBackOperateEnum operation, Class<T> taskConsumer, Map<String, Object> param) {
        ArrayList<WriteBackTask> writeBackTaskList = new ArrayList<WriteBackTask>(10);
        WriteBackTask task = new WriteBackTask();
        task.setBillPk((Long)bill.getPkValue());
        String entityName = bill.getDataEntityType().getName();
        task.setEntityKey(entityName);
        task.setSourceEntityKey(sourceEntity);
        task.setOperation(operation);
        task.setConsumer(taskConsumer);
        param.put("operate", operation.getValue());
        task.setCustomParams(param);
        WriteBackTaskConsumer consumerInstance = null;
        try {
            HashMap<String, List<Long>> sourceBillInfo = new HashMap<String, List<Long>>(8);
            WriteBackTaskHelper.fillSourceInfoMap(sourceBillInfo, entityName, Collections.singletonList(bill));
            WriteBackTaskHelper.fpmCollectSync(sourceBillInfo);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        try {
            consumerInstance = (WriteBackTaskConsumer)taskConsumer.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        try {
            Object result = consumerInstance.consumeTask(task);
            writeBackTaskList.add(task);
            WriteBackTaskHelper.recordSucc(writeBackTaskList, result);
            return result;
        }
        catch (Exception e) {
            ThreadPools.executeOnceIncludeRequestContext((String)"logResponseException", () -> {
                logger.info("\u53cd\u5199\u5931\u8d25" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                WriteBackTaskHelper.recordException(writeBackTaskList, e);
            });
            throw e;
        }
    }

    private static void fillSourceInfoMap(Map<String, List<Long>> sourceBillInfo, String entityName, List<DynamicObject> dataList) {
        for (DynamicObject data : dataList) {
            String sourceTypeProp = WriteBackTaskHelper.getSourceTypeKey(entityName);
            String sourceIdProp = WriteBackTaskHelper.getSourceIdKey(entityName);
            if (sourceTypeProp == null || sourceIdProp == null) continue;
            String sourceBillType = data.getString(sourceTypeProp);
            long sourceId = data.getLong(sourceIdProp);
            if (EmptyUtil.isEmpty((String)sourceBillType) || sourceId == 0L) continue;
            List sourceIdList = sourceBillInfo.computeIfAbsent(sourceBillType, o -> new ArrayList(10));
            sourceIdList.add(sourceId);
        }
    }

    private static String getSourceTypeKey(String entityName) {
        if ("cas_agentpaybill".equals(entityName)) {
            return "sourcebilltype";
        }
        if ("cas_paybill".equals(entityName)) {
            return "sourcebilltype";
        }
        if ("cas_recbill".equals(entityName)) {
            return "sourcebilltype";
        }
        return null;
    }

    private static String getSourceIdKey(String entityName) {
        if ("cas_agentpaybill".equals(entityName)) {
            return "hsourcebillid";
        }
        if ("cas_paybill".equals(entityName)) {
            return "sourcebillid";
        }
        if ("cas_recbill".equals(entityName)) {
            return "sourcebillid";
        }
        return null;
    }

    private static void fpmCollectSync(Map<String, List<Long>> sourceBillInfo) {
        for (Map.Entry<String, List<Long>> entry : sourceBillInfo.entrySet()) {
            String sourceType = entry.getKey();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceType);
            SyncStatusManager syncMgr = SyncStatusManager.getCasWriteBackManager((MainEntityType)mainEntityType);
            if (!syncMgr.hasConfig()) continue;
            syncMgr.writeBack(entry.getValue());
            syncMgr.commit();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends WriteBackTaskConsumer> Object batchAddRealtimeTaskList(List<WriteBackTaskInfo> writeBackTaskInfoList, WriteBackOperateEnum operation, Class<T> taskConsumer) {
        void var7_11;
        if (null == writeBackTaskInfoList || writeBackTaskInfoList.size() == 0) {
            return null;
        }
        ArrayList<Object> writeBackTaskList = new ArrayList<Object>(10);
        for (WriteBackTaskInfo writeBackTaskInfo : writeBackTaskInfoList) {
            WriteBackTask task = new WriteBackTask();
            task.setBillPk(writeBackTaskInfo.getBillId());
            task.setEntityKey(writeBackTaskInfo.getDataEntity());
            task.setSourceEntityKey(writeBackTaskInfo.getSourceEntity());
            task.setOperation(operation);
            task.setConsumerString(taskConsumer.getName());
            task.setCustomParams(writeBackTaskInfo.getParam());
            if (writeBackTaskInfo.getParam() != null) {
                writeBackTaskInfo.getParam().put("payScheRelease", writeBackTaskInfo.getPayScheRelease());
                writeBackTaskInfo.getParam().put("isPayScheBack", writeBackTaskInfo.getIsPayScheBack());
                writeBackTaskInfo.getParam().put("payScheOPType", writeBackTaskInfo.getPayScheOPType());
                writeBackTaskInfo.getParam().put("delPayApplyBillIds", writeBackTaskInfo.getDelPayApplyBillIds());
            }
            writeBackTaskList.add(task);
        }
        try {
            HashMap<String, List<Long>> sourceBillInfo = new HashMap<String, List<Long>>(8);
            Map<String, List<WriteBackTaskInfo>> taskMap = writeBackTaskInfoList.stream().collect(Collectors.groupingBy(WriteBackTaskInfo::getDataEntity));
            for (Map.Entry entry : taskMap.entrySet()) {
                String entityName = (String)entry.getKey();
                String sourceTypeProp = WriteBackTaskHelper.getSourceTypeKey(entityName);
                String sourceIdProp = WriteBackTaskHelper.getSourceIdKey(entityName);
                if (sourceTypeProp == null || sourceIdProp == null) continue;
                List<DynamicObject> currBillList = ((List)entry.getValue()).stream().filter(taskInfo -> !CollectionUtils.isEmpty((Map)taskInfo.getParam())).map(taskInfo -> taskInfo.getParam().get("info")).filter(Objects::nonNull).map(o -> (DynamicObject)o).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(currBillList)) {
                    Object[] idArr = ((List)entry.getValue()).stream().map(WriteBackTaskInfo::getBillId).distinct().toArray();
                    DynamicObject[] sourceList = BusinessDataServiceHelper.load((String)entityName, (String)String.join((CharSequence)",", sourceIdProp, sourceTypeProp), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idArr)});
                    currBillList = Arrays.asList(sourceList);
                }
                WriteBackTaskHelper.fillSourceInfoMap(sourceBillInfo, entityName, currBillList);
            }
            WriteBackTaskHelper.fpmCollectSync(sourceBillInfo);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        QFilter payWriteNumber = new QFilter("number", "=", (Object)"fi.cas.writeback.whitelist");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObject payWriteConfig = BusinessDataServiceHelper.loadSingle((String)"cas_extend_config", (String)"configvalue", (QFilter[])new QFilter[]{payWriteNumber, enable});
        Object var7_9 = null;
        if (null != payWriteConfig) {
            String configvalue = payWriteConfig.getString("configvalue");
            List list = JSON.parseArray((String)configvalue, String.class);
        }
        Map<String, List<WriteBackTask>> taskListMap = writeBackTaskList.stream().collect(Collectors.groupingBy(o -> o.getSourceEntityKey()));
        void finalWhiteList = var7_11;
        taskListMap.forEach((arg_0, arg_1) -> WriteBackTaskHelper.lambda$batchAddRealtimeTaskList$7((List)finalWhiteList, operation, taskConsumer, arg_0, arg_1));
        return null;
    }

    private static DynamicObject processSuccessWriteBackTask(WriteBackTask task, Object result) {
        DynamicObject writeBackTask = task.toDynamicObject();
        writeBackTask.set("lastexecutetime", (Object)new Date());
        writeBackTask.set("result", (Object)"1");
        String message = "";
        try {
            if (result instanceof OperationResult) {
                OperationResult operationResult = (OperationResult)result;
                message = JSONObject.toJSONString((Object)operationResult);
            } else {
                message = JSONObject.toJSONString((Object)result);
            }
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        logger.info("\u53cd\u5199\u8fd4\u56de\u4fe1\u606f" + message);
        TextProp property = (TextProp)writeBackTask.getDataEntityType().getProperties().get((Object)"exception");
        int maxLength = property.getMaxLenth();
        if (message != null && message.length() > maxLength) {
            message = message.substring(0, maxLength);
        }
        writeBackTask.set("exception", (Object)message);
        return writeBackTask;
    }

    private static DynamicObject processErrorWriteBackTask(WriteBackTask task, Exception exc) {
        DynamicObject writeBackTask = task.toDynamicObject();
        writeBackTask.set("lastexecutetime", (Object)new Date());
        writeBackTask.set("result", (Object)"0");
        String message = exc.getMessage();
        logger.info("\u53cd\u5199\u8fd4\u56de\u4fe1\u606f" + message);
        TextProp property = (TextProp)writeBackTask.getDataEntityType().getProperties().get((Object)"exception");
        int maxLength = property.getMaxLenth();
        if (message != null && message.length() > maxLength) {
            message = message.substring(0, maxLength);
        }
        writeBackTask.set("exception", (Object)message);
        writeBackTask.set("exception_tag", (Object)WriteBackTaskHelper.getStackTraceMessage(exc));
        return writeBackTask;
    }

    private static void saveWriteBackTaskList(List<DynamicObject> writeBackTaskList) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (EmptyUtil.isNoEmpty(writeBackTaskList)) {
                    SaveServiceHelper.save((DynamicObject[])writeBackTaskList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.info("WriteBackTaskHelper saveWriteBackTaskList error!", (Object)e);
            }
        }
    }

    public static <T extends WriteBackTaskConsumer> Object batchAddRealtimeTask(DynamicObject[] bills, String sourceEntity, WriteBackOperateEnum operation, Class<T> taskConsumer, Map<String, Object> param) {
        Long[] ids = (Long[])((Stream)Arrays.stream(bills).parallel()).map(d -> d.getLong("id")).toArray(Long[]::new);
        String entityKey = bills[0].getDataEntityType().getName();
        WriteBackTask task = new WriteBackTask();
        task.setBillPks(ids);
        task.setEntityKey(entityKey);
        task.setSourceEntityKey(sourceEntity);
        task.setOperation(operation);
        task.setConsumer(taskConsumer);
        task.setCustomParams(param);
        WriteBackTaskConsumer consumerInstance = null;
        try {
            consumerInstance = (WriteBackTaskConsumer)taskConsumer.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        Object result = consumerInstance.consumeTask(task);
        return result;
    }

    public static Object batchAddWriteBackTask(DynamicObject[] bills, String sourceEntity, WriteBackOperateEnum operation, WriteBackConfigInvoker taskConsumer, Map<String, Object> param) {
        Long[] ids = (Long[])Stream.of(bills).map(d -> d.getLong("id")).toArray(Long[]::new);
        String entityKey = bills[0].getDataEntityType().getName();
        WriteBackTask task = new WriteBackTask();
        task.setBillPks(ids);
        task.setEntityKey(entityKey);
        task.setSourceEntityKey(sourceEntity);
        task.setOperation(operation);
        task.setConsumer(taskConsumer.getClass());
        task.setCustomParams(param);
        try {
            return taskConsumer.consumeTask(task);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void recordException(List<WriteBackTask> taskList, Exception exc) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                ArrayList<DynamicObject> writeBackTaskList = new ArrayList<DynamicObject>(10);
                for (WriteBackTask task : taskList) {
                    DynamicObject writeBackTask = task.toDynamicObject();
                    writeBackTask.set("lastexecutetime", (Object)new Date());
                    writeBackTask.set("result", (Object)"0");
                    String message = exc.getMessage();
                    logger.info("\u53cd\u5199\u8fd4\u56de\u4fe1\u606f" + message);
                    TextProp property = (TextProp)writeBackTask.getDataEntityType().getProperties().get((Object)"exception");
                    int maxLenth = property.getMaxLenth();
                    if (message != null && message.length() > maxLenth) {
                        message = message.substring(0, maxLenth);
                    }
                    writeBackTask.set("exception", (Object)message);
                    writeBackTask.set("exception_tag", (Object)WriteBackTaskHelper.getStackTraceMessage(exc));
                    writeBackTaskList.add(writeBackTask);
                }
                SaveServiceHelper.save((DynamicObject[])writeBackTaskList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                logger.info("WriteBackTaskHelper recordException" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }

    public static void recordException(DynamicObject writeBackTask, Exception exc) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                writeBackTask.set("result", (Object)"0");
                String message = exc.getMessage();
                TextProp property = (TextProp)writeBackTask.getDataEntityType().getProperties().get((Object)"exception");
                int maxLenth = property.getMaxLenth();
                if (message != null && message.length() > maxLenth) {
                    message = message.substring(0, maxLenth);
                }
                writeBackTask.set("exception", (Object)message);
                writeBackTask.set("exception_tag", (Object)WriteBackTaskHelper.getStackTraceMessage(exc));
                writeBackTask.set("lastexecutetime", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{writeBackTask});
            }
            catch (Exception e) {
                tx.markRollback();
                logger.info("WriteBackTaskHelper recordException2" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }

    public static void recordSucc(List<WriteBackTask> taskList, Object result) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                ArrayList<DynamicObject> writeBackTaskList = new ArrayList<DynamicObject>(10);
                for (WriteBackTask task : taskList) {
                    DynamicObject writeBackTask = task.toDynamicObject();
                    writeBackTask.set("lastexecutetime", (Object)new Date());
                    writeBackTask.set("result", (Object)"1");
                    String message = "";
                    try {
                        if (result instanceof OperationResult) {
                            OperationResult operationResult = (OperationResult)result;
                            message = JSONObject.toJSONString((Object)operationResult);
                        } else {
                            message = JSONObject.toJSONString((Object)result);
                        }
                    }
                    catch (Exception e) {
                        message = e.getMessage();
                    }
                    logger.info("\u53cd\u5199\u8fd4\u56de\u4fe1\u606f" + message);
                    TextProp property = (TextProp)writeBackTask.getDataEntityType().getProperties().get((Object)"exception");
                    int maxLenth = property.getMaxLenth();
                    if (message != null && message.length() > maxLenth) {
                        message = message.substring(0, maxLenth);
                    }
                    writeBackTask.set("exception", (Object)message);
                    writeBackTaskList.add(writeBackTask);
                }
                SaveServiceHelper.save((DynamicObject[])writeBackTaskList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                logger.info("WriteBackTaskHelper recordSucc" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }

    private static String getStackTraceMessage(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        logger.info("errorinfo" + writer);
        writer.flush();
        return sw.toString();
    }

    public static <T extends WriteBackTaskConsumer> Object addRealtimeTaskEntry(DynamicObject bill, DynamicObjectCollection entrys, String sourceEntity, String entryName, WriteBackOperateEnum operation, Class<T> taskConsumer, Map<String, Object> param) {
        ArrayList<WriteBackTask> writeBackTaskList = new ArrayList<WriteBackTask>(10);
        WriteBackTask task = new WriteBackTask();
        task.setBillPk((Long)bill.getPkValue());
        task.setEntityKey(bill.getDataEntityType().getName());
        task.setSourceEntityKey(sourceEntity);
        task.setOperation(operation);
        task.setConsumer(taskConsumer);
        task.setCustomParams(param);
        task.setEntrys(entrys);
        WriteBackTaskConsumer consumerInstance = null;
        try {
            consumerInstance = (WriteBackTaskConsumer)taskConsumer.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        try {
            Object result = consumerInstance.consumeTask(task);
            writeBackTaskList.add(task);
            WriteBackTaskHelper.recordSucc(writeBackTaskList, result);
            return result;
        }
        catch (Exception e) {
            ThreadPools.executeOnceIncludeRequestContext((String)"logResponseException", () -> {
                logger.info("\u53cd\u5199\u5931\u8d25" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                WriteBackTaskHelper.recordException(writeBackTaskList, e);
            });
            throw e;
        }
    }

    public static void cancelSettle(DynamicObject payBill, WriteBackOperateEnum writeBackOperate) {
        WriteBackTaskHelper.cancelSettle(payBill, writeBackOperate, new HashMap<String, Object>());
    }

    public static void cancelSettle(DynamicObject payBill, WriteBackOperateEnum writeBackOperate, Map<String, Object> param) {
        DynamicObject payType = payBill.getDynamicObject("paymenttype");
        if (payType != null && payType.getBoolean("ispartpayment")) {
            boolean exists = SettleRecordQueryHelperForCas.isExistsSettlesByMain((String)"ap_settlerecord", (String)"cas_paybill", (Object[])new Object[]{payBill.getPkValue()}, null);
            boolean exists2 = SettleRecordQueryHelperForCas.isExistsSettlesByAsst((String)"ap_settlerecord", (String)"cas_paybill", (Object[])new Object[]{payBill.getPkValue()}, null);
            if (exists || exists2) {
                WriteBackTaskHelper.addRealtimeTask(payBill, "ap_settle", writeBackOperate, PaymentDisposeConsumer.class, param);
            }
        }
    }
}

