/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback.ar;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cas.business.writeback.ar.bean.ApPaySettleParam;
import kd.fi.cas.business.writeback.ar.bean.ApPayUnSettleParam;
import kd.fi.cas.business.writeback.ar.bean.DisposeValidateParam;
import kd.fi.cas.business.writeback.ar.bean.PayInfo;
import kd.fi.cas.business.writeback.ar.bean.PayRecSettleParam;
import kd.fi.cas.business.writeback.ar.bean.PayRefundEntryInfo;
import kd.fi.cas.business.writeback.ar.bean.RefundAndRenoteOrCancelParam;
import kd.fi.cas.business.writeback.ar.bean.Result;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.refund.CancelRefundWriteBackConsumer;
import kd.fi.cas.business.writeback.refund.RefundWriteBackConsumer;
import kd.fi.cas.helper.SettleRecordQueryHelperForCas;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;

public class ArWriteBackHelper {
    private static final Log logger = LogFactory.getLog(ArWriteBackHelper.class);

    public static Result cancelSettle(DynamicObject payBill) {
        boolean exists = SettleRecordQueryHelperForCas.isExistsSettlesByMain((String)"ap_settlerecord", (String)"cas_paybill", (Object[])new Object[]{payBill.getPkValue()}, null);
        boolean exists2 = SettleRecordQueryHelperForCas.isExistsSettlesByAsst((String)"ap_settlerecord", (String)"cas_paybill", (Object[])new Object[]{payBill.getPkValue()}, null);
        if (exists || exists2) {
            ApPayUnSettleParam param = new ApPayUnSettleParam();
            param.setRefund(true);
            param.setPayIds(Collections.singletonList(payBill.getLong("id")));
            logger.info("rec refund cancelSettle param:" + SerializationUtils.toJsonString((Object)param));
            Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"apPaySettleApi", (String)"unSettleByPayId", (Object[])new Object[]{SerializationUtils.toJsonString((Object)param)});
            logger.info("rec refund cancelSettle result:" + SerializationUtils.toJsonString((Object)result));
            Result apPayUnSettleResult = (Result)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), Result.class);
            return apPayUnSettleResult;
        }
        return new Result();
    }

    @Deprecated
    public static void writerBackAP(RefundAndRenoteOrCancelParam params, String serviceName) {
        logger.info("rec refund writerBackAP param:" + SerializationUtils.toJsonString((Object)params));
        List<PayRefundEntryInfo> payInfos = params.getPayInfos();
        Set payIds = payInfos.stream().map(p -> String.valueOf(p.getPayId())).collect(Collectors.toSet());
        CommonParam commonParam = new CommonParam();
        commonParam.put((Object)"paramJson", (Object)SerializationUtils.toJsonString((Object)params));
        commonParam.put((Object)"uniquekey", (Object)DB.genGlobalLongId());
        ECGlobalSession.begin((String)"cas_recbillrefund", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
        ECGlobalSession.setBusinessType((String)"cas_recbillrefund");
        ArrayList<Object> businessList = new ArrayList<Object>(payIds.size() + 1);
        businessList.addAll(payIds);
        businessList.add(String.valueOf(params.getRecId()));
        ECGlobalSession.setBusinessInfo(businessList);
        ECGlobalSession.setAsync((boolean)true);
        ECGlobalSession.register((String)"fi", (String)"ap", (String)serviceName, (Param)commonParam, null, (String)"");
    }

    public static void writerBackAP(Long revId, WriteBackOperateEnum operate, List<RefundRenoteOrCancelParam> refundParams, String serviceName) {
        logger.info("new rec refund writerBackAP param List:" + SerializationUtils.toJsonString(refundParams));
        RefundRenoteOrCancelParam arParam = new RefundRenoteOrCancelParam();
        arParam.setRecId(revId);
        arParam.setOperate(operate.getValue());
        for (RefundRenoteOrCancelParam refundParam : refundParams) {
            arParam.getRefundPayInfos().addAll(refundParam.getRefundPayInfos());
        }
        logger.info("new rec refund writerBackAP param:" + SerializationUtils.toJsonString((Object)arParam));
        List refundPayInfos = arParam.getRefundPayInfos();
        Set payIds = refundPayInfos.stream().map(p -> String.valueOf(p.getTargetPk())).collect(Collectors.toSet());
        ArrayList<Object> businessList = new ArrayList<Object>(payIds.size() + 1);
        businessList.addAll(payIds);
        businessList.add(String.valueOf(revId));
        CommonParam commonParam = new CommonParam();
        commonParam.put((Object)"paramJson", (Object)SerializationUtils.toJsonString((Object)arParam));
        commonParam.put((Object)"uniquekey", (Object)DB.genGlobalLongId());
        ECGlobalSession.begin((String)"cas_recbillrefund", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
        ECGlobalSession.setBusinessType((String)"cas_recbillrefund");
        ECGlobalSession.setBusinessInfo(businessList);
        ECGlobalSession.setAsync((boolean)true);
        ECGlobalSession.register((String)"fi", (String)"ap", (String)serviceName, (Param)commonParam, null, (String)"");
    }

    public static Result payRecSettle(DynamicObject payBill, DynamicObject recBill) {
        PayRecSettleParam param = new PayRecSettleParam();
        param.setRecId(recBill.getLong("id"));
        ArrayList<PayInfo> payInfos = new ArrayList<PayInfo>();
        DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            PayInfo payInfo = new PayInfo();
            payInfo.setPayId(payBill.getLong("id"));
            payInfo.setEntryId(entry.getLong("id"));
            payInfo.setEntryRefundAmt(entry.getBigDecimal("e_refundamt"));
            payInfos.add(payInfo);
        }
        param.setPayInfos(payInfos);
        logger.info("rec refund payRecSettle param:" + SerializationUtils.toJsonString((Object)param));
        Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"payRecSettleApi", (String)"settleByEntryId", (Object[])new Object[]{SerializationUtils.toJsonString(Collections.singletonList(param))});
        logger.info("rec refund payRecSettle result:" + SerializationUtils.toJsonString((Object)result));
        Result payRecSettleResult = (Result)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), Result.class);
        return payRecSettleResult;
    }

    public static Result apPaySettle(DynamicObject payBill) {
        ApPaySettleParam param = new ApPaySettleParam();
        param.setIsRefund(true);
        ArrayList<PayInfo> payInfos = new ArrayList<PayInfo>();
        DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            PayInfo payInfo = new PayInfo();
            payInfo.setPayId(payBill.getLong("id"));
            payInfo.setEntryId(entry.getLong("id"));
            payInfo.setEntryRefundAmt(entry.getBigDecimal("e_refundamt"));
            payInfo.setEntryNeedAmt(entry.getBigDecimal("e_payableamt").subtract(entry.getBigDecimal("e_refundamt")));
            payInfos.add(payInfo);
        }
        param.setPayInfos(payInfos);
        logger.info("rec refund apPaySettle param:" + SerializationUtils.toJsonString((Object)param));
        Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"apPaySettleApi", (String)"settleByPayEntryId", (Object[])new Object[]{SerializationUtils.toJsonString((Object)param)});
        logger.info("rec refund apPaySettle result:" + SerializationUtils.toJsonString((Object)result));
        Result apPaySettleResult = (Result)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), Result.class);
        return apPaySettleResult;
    }

    public static Result cancelRefundValidate(DynamicObject payBill) {
        ArrayList<DisposeValidateParam> payEntryInfos = new ArrayList<DisposeValidateParam>();
        String sourcebilltype = payBill.getString("sourcebilltype");
        DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
        for (DynamicObject row : entrys) {
            DisposeValidateParam param = new DisposeValidateParam();
            param.setSourceType(sourcebilltype);
            param.setSourceId(row.getLong("e_sourcebillid"));
            param.setSourceEntryId(row.getLong("e_sourcebillentryid"));
            param.setEntryRefundAmt(row.getBigDecimal("e_refundamt"));
            payEntryInfos.add(param);
        }
        logger.info("rec refund cancelRefundValidate param:" + SerializationUtils.toJsonString(payEntryInfos));
        Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"disposeValidateApi", (String)"validate", (Object[])new Object[]{SerializationUtils.toJsonString(payEntryInfos)});
        logger.info("rec refund cancelRefundValidate result:" + SerializationUtils.toJsonString((Object)result));
        Result validateResult = (Result)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), Result.class);
        return validateResult;
    }

    public static RefundAndRenoteOrCancelParam buildRefundRenoteParam(DynamicObject payBill, Long revId, WriteBackOperateEnum writeBackOperate) {
        RefundAndRenoteOrCancelParam refundAndRenoteParam = new RefundAndRenoteOrCancelParam();
        refundAndRenoteParam.setOperateKey(writeBackOperate.getValue());
        refundAndRenoteParam.setRecId(revId);
        ArrayList<PayRefundEntryInfo> payEntryInfos = new ArrayList<PayRefundEntryInfo>();
        long payBillId = payBill.getLong("id");
        DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            PayRefundEntryInfo entryInfo = new PayRefundEntryInfo();
            entryInfo.setPayId(payBillId);
            entryInfo.setEntryId(entry.getLong("id"));
            entryInfo.setEntryRefundAmt(entry.getBigDecimal("e_refundamt"));
            payEntryInfos.add(entryInfo);
        }
        refundAndRenoteParam.setPayInfos(payEntryInfos);
        return refundAndRenoteParam;
    }

    public static boolean isArApSourceType(String billSourceType) {
        return "ap_finapbill".equals(billSourceType) || "ar_finarbill".equals(billSourceType) || "ap_payapply".equals(billSourceType);
    }

    public static void arApValidate(Long revid, WriteBackOperateEnum operate, List<RefundRenoteOrCancelParam> refundParams, String serviceName) {
        try {
            RefundRenoteOrCancelParam arParam = new RefundRenoteOrCancelParam();
            arParam.setRecId(revid);
            arParam.setOperate(operate.getValue());
            for (RefundRenoteOrCancelParam refundParam : refundParams) {
                arParam.getRefundPayInfos().addAll(refundParam.getRefundPayInfos());
            }
            logger.info("arApValidate params:", (Object)SerializationUtils.toJsonString((Object)arParam));
            Object res = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)serviceName, (String)"validate", (Object[])new Object[]{JSONObject.toJSONString((Object)arParam)});
            Result re = (Result)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)res), Result.class);
            if (re != null && !"0".equals(re.getCode())) {
                throw new KDBizException(re.getErrorInfo());
            }
        }
        catch (Exception e) {
            logger.error("rev refund renote arap validator error", (Throwable)e);
            throw new KDBizException(String.valueOf(e.getMessage()));
        }
    }

    public static RefundRenoteOrCancelParam buildApRefundParam(DynamicObject[] bills, Map<Long, DynamicObject> entrustSourceBills, Map<String, Object> param, WriteBackOperateEnum operate) {
        List<DynamicObject> apParamBills = ArWriteBackHelper.getParamBills(bills, entrustSourceBills);
        HashMap<String, Object> params = new HashMap<String, Object>(param);
        params.put("bills", apParamBills.toArray(new DynamicObject[0]));
        RefundWriteBackConsumer writeBackConsumer = new RefundWriteBackConsumer();
        return writeBackConsumer.initInvokeParams(params, (String)params.get("releBillType"), null, operate);
    }

    public static RefundRenoteOrCancelParam buildApCancelRefundParam(Long revId, List<DynamicObject> bills, Map<Long, DynamicObject> entrustSourceBills, WriteBackOperateEnum operate) {
        List<DynamicObject> apParamBills = ArWriteBackHelper.getParamBills(bills.toArray(new DynamicObject[0]), entrustSourceBills);
        CancelRefundWriteBackConsumer cancelConsumer = new CancelRefundWriteBackConsumer(revId, apParamBills);
        return cancelConsumer.initInvokeParams("cas_paybill", null, operate);
    }

    private static List<DynamicObject> getParamBills(DynamicObject[] bills, Map<Long, DynamicObject> entrustSourceBills) {
        ArrayList<DynamicObject> apParamBills = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            DynamicObject sourceBill = entrustSourceBills.get((Long)bill.getPkValue());
            if (sourceBill == null) {
                apParamBills.add(bill);
                continue;
            }
            Predicate<DynamicObject> matchFun = en -> {
                DynamicObject paymentType = en.getDynamicObject("e_paymenttype");
                if (paymentType != null) {
                    return paymentType.getBoolean("ispartpayment");
                }
                return false;
            };
            if (!bill.getDynamicObjectCollection("entry").stream().noneMatch(matchFun) || !sourceBill.getDynamicObjectCollection("entry").stream().noneMatch(matchFun)) continue;
            apParamBills.add(sourceBill);
        }
        return apParamBills;
    }
}

