/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback.payapply.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cas.business.helper.PayApplyBillHelper;
import kd.fi.cas.enums.PayApplyPayStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.enums.message.MessageSceneEnum;
import kd.fi.cas.payment.PaymentPayHelper;
import kd.fi.cas.result.PayApplyStatusResult;

public abstract class AbstractPayWriteBackPayApplyService {
    private static final Log LOGGER = LogFactory.getLog(AbstractPayWriteBackPayApplyService.class);

    public void writeBack() {
    }

    public void setHeadStatus(DynamicObject payApplyData) {
        PayApplyStatusResult headStatus = PayApplyBillHelper.getHeadStatus(payApplyData.getDynamicObjectCollection("cas_payinfo"));
        PayApplyPayStatusEnum payHeadStatus = headStatus.getPayStatus();
        payApplyData.set("paidstatus", (Object)payHeadStatus.getValue());
        payApplyData.set("backbillflag", (Object)(headStatus.getBackBillFlag() != false ? "1" : "0"));
        payApplyData.set("partpaysche", (Object)(headStatus.getPartPaySchFlag() != false ? "1" : "0"));
        payApplyData.set("partpay", (Object)(headStatus.getPartPayFlag() != false ? "1" : "0"));
    }

    public void setPartPay(DynamicObject payApplyData) {
        boolean isPartPayment = payApplyData.getBoolean("ispartpayment");
        if (!isPartPayment) {
            return;
        }
        DynamicObjectCollection payInfoEntry = payApplyData.getDynamicObjectCollection("cas_payinfo");
        boolean isPartPay = false;
        HashSet<String> status = new HashSet<String>(16);
        HashSet<String> paidStatus = new HashSet<String>(16);
        boolean existReject = false;
        boolean isPayInfoAllPaid = PayApplyBillHelper.isPayInfoAllPaid(payInfoEntry);
        for (DynamicObject payInfo : payInfoEntry) {
            boolean isValid;
            BigDecimal entryPaid = payInfo.getBigDecimal("entry_paidamount");
            String entryPayStatus = payInfo.getString("entry_paystatus");
            if (PayStatusEnum.PAYMENTSUCCESS.getValue().equals(entryPayStatus) || isPayInfoAllPaid) {
                entryPayStatus = PayApplyPayStatusEnum.SUCCESS.getValue();
            } else if (PayStatusEnum.NOTPAYING.getValue().equals(entryPayStatus)) {
                entryPayStatus = PayApplyPayStatusEnum.NOTPAYING.getValue();
            }
            if (BigDecimal.ZERO.compareTo(entryPaid) != 0) {
                isPartPay = true;
            }
            if (!(isValid = payInfo.getBoolean("entry_invalid"))) {
                paidStatus.add(entryPayStatus);
            } else {
                existReject = true;
            }
            status.add(entryPayStatus);
        }
        PaymentPayHelper.setPartPay((DynamicObject)payApplyData, status, (boolean)isPartPay, (boolean)existReject);
        PaymentPayHelper.setPaidStatus((DynamicObject)payApplyData, paidStatus);
    }

    public void msgNotice(DynamicObject payApplyData) {
        Object payStatus = payApplyData.get("paidstatus");
        ArrayList<Long> recIdList = new ArrayList<Long>(1);
        recIdList.add((Long)payApplyData.getDynamicObject("creator").getPkValue());
        if (PayApplyPayStatusEnum.SUCCESS.getValue().equals(payStatus)) {
            LOGGER.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u4ed8\u6b3e\u6210\u529f-\u6d88\u606f\u63a8\u9001");
            MessageInfo message = new MessageInfo();
            message.setTitle(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u4ed8\u6b3e\u6210\u529f", (String)"AbstractPayWriteBackPayApplyService_0", (String)"fi-cas-business", (Object[])new Object[0]));
            message.setContent(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\uff1a{0}\u5df2\u5b8c\u6210\u4ed8\u6b3e\uff0c\u8bf7\u77e5\u6089\u3002", (String)"AbstractPayWriteBackPayApplyService_1", (String)"fi-cas-business", (Object[])new Object[]{payApplyData.get("billno")}));
            message.setTplScene(MessageSceneEnum.CAS_PAYAPPLY_PAYSUCCESS.getValue());
            message.setUserIds(recIdList);
            message.setType("message");
            message.setEntityNumber("cas_payapplybill");
            message.setBizDataId((Long)payApplyData.getPkValue());
            message.setNotifyType(MessageCenterServiceHelper.getChannelsOfMsgType((String)"message"));
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        }
    }
}

