/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback.payapply.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.base.WriteBackParam;
import kd.fi.cas.business.writeback.ar.bean.Result;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.payapply.factory.PayWriteBackApplyServiceFactory;
import kd.fi.cas.business.writeback.payapply.service.AbstractPayWriteBackPayApplyService;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.refund.RefundEntryInfo;
import kd.fi.cas.refund.RefundPayBillInfo;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;
import kd.fi.cas.util.EmptyUtil;

public class PayWriteBackPayApplyService {
    private static final Log LOGGER = LogFactory.getLog(PayWriteBackPayApplyService.class);
    private static final Set<String> VALIDATE_OPS = new HashSet<String>(){
        {
            this.add(WriteBackOperateEnum.REFUNDVALIDATE.getValue());
            this.add(WriteBackOperateEnum.RENOTEVALIDATE.getValue());
        }
    };

    public Result validate(RefundRenoteOrCancelParam param) {
        if (!VALIDATE_OPS.contains(param.getOperate())) {
            return new Result();
        }
        List refundPayInfos = param.getRefundPayInfos();
        if (CollectionUtils.isEmpty((Collection)refundPayInfos)) {
            return new Result();
        }
        Set payIds = refundPayInfos.stream().map(RefundPayBillInfo::getTargetPk).collect(Collectors.toSet());
        Map payEntryIdAndPayApplyEntryMap = RefundHelper.getPayEntryIdAndPayApplyEntryMap(payIds, (String)((RefundPayBillInfo)refundPayInfos.get(0)).getTargetBillType());
        for (RefundPayBillInfo refundPayInfo : refundPayInfos) {
            List entryInfos = refundPayInfo.getEntryInfos();
            if (CollectionUtils.isEmpty((Collection)entryInfos)) continue;
            for (RefundEntryInfo entryInfo : entryInfos) {
                DynamicObject payApplyEntry = (DynamicObject)payEntryIdAndPayApplyEntryMap.get(entryInfo.getTargetEntryPk());
                if (!EmptyUtil.isNoEmpty((DynamicObject)payApplyEntry)) continue;
                BigDecimal remainRefundAmount = payApplyEntry.getBigDecimal("entry_remainrfamount");
                remainRefundAmount = EmptyUtil.isEmpty((BigDecimal)remainRefundAmount) ? BigDecimal.ZERO : remainRefundAmount;
                BigDecimal curRefundAmt = entryInfo.getRefundAmt();
                if (curRefundAmt.compareTo(BigDecimal.ZERO) > 0 && remainRefundAmount.compareTo(BigDecimal.ZERO) < 0 || curRefundAmt.compareTo(BigDecimal.ZERO) < 0 && remainRefundAmount.compareTo(BigDecimal.ZERO) > 0) {
                    String msg = ResManager.loadKDString((String)"\u672c\u6b21\u9000\u91d1\u989d\u5fc5\u987b\u4e0e\u5176\u5bf9\u5e94\u5355\u636e\u6216\u5bf9\u5e94\u660e\u7ec6\u884c\u5269\u4f59\u53ef\u9000\u91d1\u989d\u65b9\u5411\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"PayWriteBackPayApplyService_1", (String)"fi-cas-business", (Object[])new Object[0]);
                    return new Result("1", msg);
                }
                if (curRefundAmt.abs().compareTo(remainRefundAmount) <= 0) continue;
                String msg = ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u5355\u636e\u5173\u8054\u7684\u4ed8\u6b3e\u7533\u8bf7\u00b7\u4ed8\u6b3e\u660e\u7ec6\u201c\u5269\u4f59\u53ef\u9000\u91d1\u989d\u201d\u5c0f\u4e8e\u672c\u6b21\u9000\u6b3e\u91d1\u989d\u201d\u3002", (String)"PayWriteBackPayApplyService_2", (String)"fi-cas-business", (Object[])new Object[0]);
                return new Result("1", msg);
            }
        }
        return new Result();
    }

    public void writeBack(WriteBackParam param) {
        LOGGER.info("[PayWriteBackPayApplyService] \u53cd\u5199\u903b\u8f91\u5f00\u59cb\uff0c\u53cd\u5199\u64cd\u4f5c\uff1a{}", (Object)param.getOperate());
        long start = System.currentTimeMillis();
        AbstractPayWriteBackPayApplyService service = PayWriteBackApplyServiceFactory.getInstance(param);
        if (service == null) {
            LOGGER.info("[PayWriteBackPayApplyService]\u65e0\u6cd5\u627e\u5230\u53cd\u5199\u64cd\u4f5c\u5b9e\u4f8b\uff0c\u64cd\u4f5c\uff1a{}", (Object)param.getOperate());
            return;
        }
        service.writeBack();
        LOGGER.info("[PayWriteBackPayApplyService] \u53cd\u5199\u903b\u8f91\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
    }
}

