/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.writeback.WriteBackTaskConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.task.WriteBackTask;
import kd.fi.cas.helper.MutexLockerHelper;

public class WriteBackExecuteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(WriteBackExecuteOp.class);
    private List<Object> failedPks = new ArrayList<Object>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("result");
        fieldKeys.add("lastexecutetime");
        fieldKeys.add("exception");
        fieldKeys.add("exception_tag");
        fieldKeys.add("taskexecuteclass");
        fieldKeys.add("param");
        fieldKeys.add("entitykey");
        fieldKeys.add("sourceentitykey");
        fieldKeys.add("billpk");
        fieldKeys.add("operation");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        AbstractValidator validator = new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject info = dataEntity.getDataEntity();
                    if (!"1".equals(info.getString("result"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u6210\u529f\u5b8c\u6210\uff0c\u65e0\u6cd5\u91cd\u590d\u6267\u884c\u3002", (String)"WriteBackExecuteOp_0", (String)"fi-cas-business", (Object[])new Object[0]));
                }
            }
        };
        validator.setEntityKey("cas_writebacktask");
        validator.setOperationName(ResManager.loadKDString((String)"\u5904\u7406\u53cd\u5199\u4efb\u52a1", (String)"WriteBackExecuteOp_1", (String)"fi-cas-business", (Object[])new Object[0]));
        e.addValidator(validator);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] writeBackTasks = e.getDataEntities();
        try (MutexLockerHelper mutexLockerHelper = new MutexLockerHelper("cas_writebacktask", "writeback");){
            DynamicObject[] billsForCheck;
            List<String> idList = Arrays.stream(writeBackTasks).map(o -> o.getPkValue() == null ? "" : o.getPkValue().toString()).collect(Collectors.toList());
            ArrayList resultIds = new ArrayList(idList.size());
            idList.forEach(o -> resultIds.add(Long.parseLong(o)));
            Map batchRequire = mutexLockerHelper.batchRequire(idList);
            HashSet<DynamicObject> satisfiableBillPks = new HashSet<DynamicObject>();
            for (DynamicObject bill : billsForCheck = BusinessDataServiceHelper.load((String)"cas_writebacktask", (String)"result", (QFilter[])new QFilter[]{new QFilter("id", "in", resultIds)})) {
                if ("1".equals(bill.getString("result"))) continue;
                satisfiableBillPks.add(bill);
            }
            for (DynamicObject task : writeBackTasks) {
                try {
                    Boolean isLocked = (Boolean)batchRequire.get(task.getPkValue().toString()) == false;
                    if (isLocked.booleanValue()) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u88ab\u9501\u5b9a\u3002", (String)"WriteBackExecuteOp_2", (String)"fi-cas-business", (Object[])new Object[0]));
                    }
                    if (!satisfiableBillPks.contains(task.getPkValue())) {
                        new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ecf\u5728\u8fd0\u884c\u4e2d\u3002", (String)"WriteBackExecuteOp_3", (String)"fi-cas-business", (Object[])new Object[0]));
                    }
                    this.dispatchTask(task);
                }
                catch (Exception excption) {
                    OperateErrorInfo err = new OperateErrorInfo();
                    err.setPkValue(task.getPkValue());
                    err.setLevel(ErrorLevel.FatalError);
                    err.setMessage(excption.getMessage());
                    this.getOperationResult().addErrorInfo(err);
                    this.failedPks.add(task.getPkValue());
                }
            }
        }
    }

    private void dispatchTask(DynamicObject task) throws Exception {
        task.set("result", (Object)"unknown");
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        }
        try {
            WriteBackTask writeBackTask = new WriteBackTask(task);
            WriteBackTaskConsumer taskExecutor = writeBackTask.getConsumer().newInstance();
            taskExecutor.consumeTask(writeBackTask);
        }
        catch (Exception exc) {
            logger.info("\u53cd\u5199\u5f02\u5e38\uff1a" + exc);
            try (TXHandle tx = TX.requiresNew();){
                WriteBackTaskHelper.recordException(task, exc);
            }
            throw exc;
        }
        task.set("result", (Object)"1");
        tx = TX.requiresNew();
        var3_4 = null;
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        }
        catch (Throwable throwable) {
            var3_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        List successPkIds = this.getOperationResult().getSuccessPkIds();
        successPkIds.removeAll(this.failedPks);
    }
}

