/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.BeBillStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.message.MessageTemplateEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;

public class AgentPayBillBitBackOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AgentPayBillBitBackOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("iscommitbe");
        fieldKeys.add("commitbetime");
        fieldKeys.add("isrepulsed");
        fieldKeys.add("cashier");
        fieldKeys.add("settletnumber");
        fieldKeys.add("bankcheckflag");
        fieldKeys.add("batchseqid");
        fieldKeys.add("bankagentpaystatus");
        fieldKeys.add("entry");
        fieldKeys.add("e_issuccess");
        fieldKeys.add("entrymatchflag");
        fieldKeys.add("actcount");
        fieldKeys.add("importpayeetype");
        fieldKeys.add("e_paytime");
        fieldKeys.add("entry.e_paytime");
        fieldKeys.add("paytime");
        fieldKeys.add("acttradedate");
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_agentpaybill", (String)"entry"));
        fieldKeys.add("isrepulsed");
        fieldKeys.add("repulsedreason");
        fieldKeys.add("creator");
        fieldKeys.add("applyorg");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("sourcebillnumber");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        logger.info("--------\u4ed8\u6b3e\u5355\u6253\u56de\u64cd\u4f5c\uff0cbegin --------");
        DynamicObject[] dataEntities = e.getDataEntities();
        String isbitback = this.getOption().getVariableValue("isbitback");
        String bitbackopinion = this.getOption().getVariableValue("bitbackopinion");
        logger.info("isrepulsed \u662f\uff1a" + isbitback + ";repulsedreason \u662f\uff1a" + bitbackopinion + "");
        ArrayList<DynamicObject> sourceBills = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject agentPayBill : dataEntities) {
            DynamicObject sourceBill;
            String bankAgentStatus = (String)agentPayBill.get("bankagentpaystatus");
            agentPayBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            agentPayBill.set("isrepulsed", (Object)isbitback);
            agentPayBill.set("repulsedreason", (Object)bitbackopinion);
            if (agentPayBill.getInt("actcount") == 0) {
                agentPayBill.set("iscommitbe", (Object)false);
            } else if (bankAgentStatus.equals(BeBillStatusEnum.TF.getValue()) || bankAgentStatus.equals(BeBillStatusEnum.OF.getValue())) {
                agentPayBill.set("iscommitbe", (Object)false);
            }
            agentPayBill.set("isrepulsed", (Object)true);
            agentPayBill.set("settletnumber", null);
            agentPayBill.set("bankcheckflag", null);
            agentPayBill.set("batchseqid", null);
            if (!"PS".equals(bankAgentStatus)) {
                agentPayBill.set("bankagentpaystatus", null);
                agentPayBill.set("cashier", null);
            }
            List bitbackEntryIds = null;
            if (this.getOption().containsVariable("bitbackentryids")) {
                String bitbackEntryIdStr = this.getOption().getVariableValue("bitbackentryids");
                bitbackEntryIds = (List)JSON.parseObject((String)bitbackEntryIdStr, List.class);
            }
            DynamicObjectCollection agentPayEntrys = agentPayBill.getDynamicObjectCollection("entry");
            if (null != bitbackEntryIds) {
                List agentPayEntryIds = agentPayEntrys.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
                if (!bitbackEntryIds.containsAll(agentPayEntryIds)) {
                    agentPayBill.set("billstatus", (Object)BillStatusEnum.PAY.getValue());
                    agentPayBill.set("iscommitbe", (Object)true);
                    if (agentPayEntrys.size() > 0) {
                        Date date = agentPayEntrys.stream().map(o -> o.getDate("e_paytime")).filter(o -> CasHelper.isNotEmpty((Object)o)).reduce((a, b) -> a.compareTo((Date)b) > 0 ? a : b).orElseGet(() -> null);
                        agentPayBill.set("acttradedate", (Object)date);
                        agentPayBill.set("paytime", (Object)date);
                    }
                } else {
                    agentPayBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                }
                for (DynamicObject agentPayEntry : agentPayEntrys) {
                    if (!this.containsLongList(bitbackEntryIds, agentPayEntry.getLong("id"))) continue;
                    agentPayEntry.set("e_issuccess", (Object)false);
                    agentPayEntry.set("entrymatchflag", (Object)AutoMatchFlagEnum.NONEED.getValue());
                }
            }
            if ((sourceBill = this.updateEntrustSourceBill(agentPayBill)) == null) continue;
            sourceBills.add(sourceBill);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        if (!sourceBills.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])sourceBills.toArray(new DynamicObject[0]));
        }
        for (DynamicObject agentPayBill : dataEntities) {
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setMessageTag((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u4ee3\u53d1\u5355\u6253\u56de", (String)"AgentPayBillBitBackOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0])));
            messageInfo.setTemplateNumber(MessageTemplateEnum.CAS_AGENTPAYBILL_BITBACK.getValue());
            messageInfo.setEntityNumber("cas_agentpaybill");
            messageInfo.setType("message");
            long bizBillId = agentPayBill.getLong("id");
            messageInfo.setBizDataId(Long.valueOf(bizBillId));
            messageInfo.setUserIds(Collections.singletonList(agentPayBill.getDynamicObject("creator").getLong("id")));
            messageInfo.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=cas_agentpaybill&pkId=" + bizBillId);
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }

    private DynamicObject updateEntrustSourceBill(DynamicObject agentPayBill) {
        QFilter qFilter;
        DynamicObject sourceAgentBill;
        String sourceBillNo;
        if (AgentPayBillHelper.isEntrustPush((DynamicObject)agentPayBill) && StringUtils.isNotEmpty((String)(sourceBillNo = agentPayBill.getString("sourcebillnumber"))) && (sourceAgentBill = BusinessDataServiceHelper.loadSingle((String)"cas_agentpaybill", (String)"id,billstatus", (QFilter[])(qFilter = new QFilter("billno", "=", (Object)sourceBillNo)).toArray())) != null) {
            sourceAgentBill.set("billstatus", agentPayBill.get("billstatus"));
            return sourceAgentBill;
        }
        return null;
    }

    private boolean containsLongList(List bitbackEntryIds, long id) {
        if (null == bitbackEntryIds) {
            return false;
        }
        for (Object object : bitbackEntryIds) {
            if ((Long)object != id) continue;
            return true;
        }
        return false;
    }
}

