/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.ebservice.api.EBServiceFacadeFactory;
import kd.fi.cas.business.ebservice.bean.EBResultStatusCode;
import kd.fi.cas.business.ebservice.bean.SyncStatusInfo;
import kd.fi.cas.business.ebservice.bean.SyncStatusResult;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.validator.SyncBankBillStatusValidator;

public class AgentPaySyncBankBillStatusOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AgentPaySyncBankBillStatusOp.class);
    private List<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("iscommitbe");
        e.getFieldKeys().add("commitbetime");
        e.getFieldKeys().add("bankagentpaystatus");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("cashier");
        e.getFieldKeys().add("isrepulsed");
        e.getFieldKeys().add("repulsedreason");
        e.getFieldKeys().add("payeracctbank");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SyncBankBillStatusValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject payBill;
        DynamicObject[] payBillArr = e.getDataEntities();
        Map<Long, DynamicObject> agentBillMap = Arrays.stream(payBillArr).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"ebService", (String)"sync", (Object[])new Object[]{"bei_bankagentpay", SerializationUtils.toJsonString(agentBillMap.keySet())});
        List syncInfoList = (List)JSON.parseObject((String)resultStr, (TypeReference)new TypeReference<List<SyncStatusInfo>>(){}, (Feature[])new Feature[0]);
        ArrayList<SyncStatusInfo> successList = new ArrayList<SyncStatusInfo>(10);
        ArrayList<SyncStatusInfo> errorList = new ArrayList<SyncStatusInfo>(10);
        ArrayList<SyncStatusInfo> rollbackList = new ArrayList<SyncStatusInfo>(10);
        for (SyncStatusInfo syncInfo : syncInfoList) {
            EBResultStatusCode statusCode = syncInfo.getStatusCode();
            if (EBResultStatusCode.SUCCESS == statusCode) {
                successList.add(syncInfo);
                continue;
            }
            if (EBResultStatusCode.ROLLBACK == statusCode) {
                rollbackList.add(syncInfo);
                continue;
            }
            errorList.add(syncInfo);
        }
        for (SyncStatusInfo syncStatusInfo : successList) {
            SyncStatusResult syncResult = EBServiceFacadeFactory.getBankService().syncPayBillStatus("cas_agentpaybill", syncStatusInfo);
            if (EBResultStatusCode.ROLLBACK != syncResult.getStatusCode() && EBResultStatusCode.ERROR != syncResult.getStatusCode() || (payBill = agentBillMap.get(syncStatusInfo.getPayBillId())) == null) continue;
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, payBill.getPkValue(), (Object)payBill.getDynamicObjectType().getName());
            operateErrorInfo.setMessage(payBill.get("billno") + ":" + syncResult.getErrMsg());
            this.errorInfoList.add(operateErrorInfo);
        }
        ArrayList<DynamicObject> rollbackPayBillList = new ArrayList<DynamicObject>(rollbackList.size());
        for (SyncStatusInfo syncStatusInfo : rollbackList) {
            payBill = agentBillMap.get(syncStatusInfo.getPayBillId());
            boolean bitBack = syncStatusInfo.isBitBack();
            String bitbackopinion = syncStatusInfo.getBitbackopinion();
            if (payBill == null) continue;
            payBill.set("iscommitbe", (Object)"0");
            payBill.set("commitbetime", null);
            payBill.set("bankagentpaystatus", null);
            payBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            payBill.set("cashier", null);
            payBill.set("isrepulsed", (Object)bitBack);
            payBill.set("repulsedreason", (Object)bitbackopinion);
            logger.info("isrepulsed \u662f\uff1a" + bitBack + ";repulsedreason \u662f\uff1a" + bitbackopinion + "");
            rollbackPayBillList.add(payBill);
        }
        if (rollbackList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])rollbackPayBillList.toArray(new DynamicObject[0]));
        }
        for (SyncStatusInfo syncStatusInfo : errorList) {
            payBill = agentBillMap.get(syncStatusInfo.getPayBillId());
            if (payBill == null) {
                payBill = e.getDataEntities()[0];
            }
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, payBill.getPkValue(), (Object)payBill.getDynamicObjectType().getName());
            operateErrorInfo.setMessage(payBill.get("billno") + ":" + syncStatusInfo.getErrMsg());
            this.errorInfoList.add(operateErrorInfo);
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        for (OperateErrorInfo operateErrorInfo : this.errorInfoList) {
            e.getOperationResult().addErrorInfo(operateErrorInfo);
        }
    }
}

